/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows you to set audio channel definitions and post-call analytics settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ConfigurationEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationEvent.Builder, ConfigurationEvent>, AudioStream {
    private static final SdkField<List<ChannelDefinition>> CHANNEL_DEFINITIONS_FIELD = SdkField
            .<List<ChannelDefinition>> builder(MarshallingType.LIST)
            .memberName("ChannelDefinitions")
            .getter(getter(ConfigurationEvent::channelDefinitions))
            .setter(setter(Builder::channelDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChannelDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChannelDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PostCallAnalyticsSettings> POST_CALL_ANALYTICS_SETTINGS_FIELD = SdkField
            .<PostCallAnalyticsSettings> builder(MarshallingType.SDK_POJO).memberName("PostCallAnalyticsSettings")
            .getter(getter(ConfigurationEvent::postCallAnalyticsSettings)).setter(setter(Builder::postCallAnalyticsSettings))
            .constructor(PostCallAnalyticsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostCallAnalyticsSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_DEFINITIONS_FIELD,
            POST_CALL_ANALYTICS_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ChannelDefinition> channelDefinitions;

    private final PostCallAnalyticsSettings postCallAnalyticsSettings;

    protected ConfigurationEvent(BuilderImpl builder) {
        this.channelDefinitions = builder.channelDefinitions;
        this.postCallAnalyticsSettings = builder.postCallAnalyticsSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelDefinitions() {
        return channelDefinitions != null && !(channelDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates which speaker is on which audio channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelDefinitions} method.
     * </p>
     * 
     * @return Indicates which speaker is on which audio channel.
     */
    public final List<ChannelDefinition> channelDefinitions() {
        return channelDefinitions;
    }

    /**
     * <p>
     * Provides additional optional settings for your Call Analytics post-call request, including encryption and output
     * locations for your redacted transcript.
     * </p>
     * <p>
     * <code>PostCallAnalyticsSettings</code> provides you with the same insights as a Call Analytics post-call
     * transcription. Refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-post-call.html">Post-call
     * analytics</a> for more information on this feature.
     * </p>
     * 
     * @return Provides additional optional settings for your Call Analytics post-call request, including encryption and
     *         output locations for your redacted transcript.</p>
     *         <p>
     *         <code>PostCallAnalyticsSettings</code> provides you with the same insights as a Call Analytics post-call
     *         transcription. Refer to <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-post-call.html">Post-call analytics</a> for
     *         more information on this feature.
     */
    public final PostCallAnalyticsSettings postCallAnalyticsSettings() {
        return postCallAnalyticsSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelDefinitions() ? channelDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(postCallAnalyticsSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationEvent)) {
            return false;
        }
        ConfigurationEvent other = (ConfigurationEvent) obj;
        return hasChannelDefinitions() == other.hasChannelDefinitions()
                && Objects.equals(channelDefinitions(), other.channelDefinitions())
                && Objects.equals(postCallAnalyticsSettings(), other.postCallAnalyticsSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationEvent")
                .add("ChannelDefinitions", hasChannelDefinitions() ? channelDefinitions() : null)
                .add("PostCallAnalyticsSettings", postCallAnalyticsSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelDefinitions":
            return Optional.ofNullable(clazz.cast(channelDefinitions()));
        case "PostCallAnalyticsSettings":
            return Optional.ofNullable(clazz.cast(postCallAnalyticsSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final ConfigurationEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelDefinitions", CHANNEL_DEFINITIONS_FIELD);
        map.put("PostCallAnalyticsSettings", POST_CALL_ANALYTICS_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationEvent, T> g) {
        return obj -> g.apply((ConfigurationEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationEvent> {
        /**
         * <p>
         * Indicates which speaker is on which audio channel.
         * </p>
         * 
         * @param channelDefinitions
         *        Indicates which speaker is on which audio channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDefinitions(Collection<ChannelDefinition> channelDefinitions);

        /**
         * <p>
         * Indicates which speaker is on which audio channel.
         * </p>
         * 
         * @param channelDefinitions
         *        Indicates which speaker is on which audio channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDefinitions(ChannelDefinition... channelDefinitions);

        /**
         * <p>
         * Indicates which speaker is on which audio channel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribestreaming.model.ChannelDefinition.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.transcribestreaming.model.ChannelDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribestreaming.model.ChannelDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #channelDefinitions(List<ChannelDefinition>)}.
         * 
         * @param channelDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribestreaming.model.ChannelDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelDefinitions(java.util.Collection<ChannelDefinition>)
         */
        Builder channelDefinitions(Consumer<ChannelDefinition.Builder>... channelDefinitions);

        /**
         * <p>
         * Provides additional optional settings for your Call Analytics post-call request, including encryption and
         * output locations for your redacted transcript.
         * </p>
         * <p>
         * <code>PostCallAnalyticsSettings</code> provides you with the same insights as a Call Analytics post-call
         * transcription. Refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-post-call.html">Post-call analytics</a> for more
         * information on this feature.
         * </p>
         * 
         * @param postCallAnalyticsSettings
         *        Provides additional optional settings for your Call Analytics post-call request, including encryption
         *        and output locations for your redacted transcript.</p>
         *        <p>
         *        <code>PostCallAnalyticsSettings</code> provides you with the same insights as a Call Analytics
         *        post-call transcription. Refer to <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-post-call.html">Post-call analytics</a> for
         *        more information on this feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postCallAnalyticsSettings(PostCallAnalyticsSettings postCallAnalyticsSettings);

        /**
         * <p>
         * Provides additional optional settings for your Call Analytics post-call request, including encryption and
         * output locations for your redacted transcript.
         * </p>
         * <p>
         * <code>PostCallAnalyticsSettings</code> provides you with the same insights as a Call Analytics post-call
         * transcription. Refer to <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-post-call.html">Post-call analytics</a> for more
         * information on this feature.
         * </p>
         * This is a convenience method that creates an instance of the {@link PostCallAnalyticsSettings.Builder}
         * avoiding the need to create one manually via {@link PostCallAnalyticsSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PostCallAnalyticsSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #postCallAnalyticsSettings(PostCallAnalyticsSettings)}.
         * 
         * @param postCallAnalyticsSettings
         *        a consumer that will call methods on {@link PostCallAnalyticsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postCallAnalyticsSettings(PostCallAnalyticsSettings)
         */
        default Builder postCallAnalyticsSettings(Consumer<PostCallAnalyticsSettings.Builder> postCallAnalyticsSettings) {
            return postCallAnalyticsSettings(PostCallAnalyticsSettings.builder().applyMutation(postCallAnalyticsSettings).build());
        }
    }

    protected static class BuilderImpl implements Builder {
        private List<ChannelDefinition> channelDefinitions = DefaultSdkAutoConstructList.getInstance();

        private PostCallAnalyticsSettings postCallAnalyticsSettings;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ConfigurationEvent model) {
            channelDefinitions(model.channelDefinitions);
            postCallAnalyticsSettings(model.postCallAnalyticsSettings);
        }

        public final List<ChannelDefinition.Builder> getChannelDefinitions() {
            List<ChannelDefinition.Builder> result = ChannelDefinitionsCopier.copyToBuilder(this.channelDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelDefinitions(Collection<ChannelDefinition.BuilderImpl> channelDefinitions) {
            this.channelDefinitions = ChannelDefinitionsCopier.copyFromBuilder(channelDefinitions);
        }

        @Override
        public final Builder channelDefinitions(Collection<ChannelDefinition> channelDefinitions) {
            this.channelDefinitions = ChannelDefinitionsCopier.copy(channelDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(ChannelDefinition... channelDefinitions) {
            channelDefinitions(Arrays.asList(channelDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(Consumer<ChannelDefinition.Builder>... channelDefinitions) {
            channelDefinitions(Stream.of(channelDefinitions).map(c -> ChannelDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final PostCallAnalyticsSettings.Builder getPostCallAnalyticsSettings() {
            return postCallAnalyticsSettings != null ? postCallAnalyticsSettings.toBuilder() : null;
        }

        public final void setPostCallAnalyticsSettings(PostCallAnalyticsSettings.BuilderImpl postCallAnalyticsSettings) {
            this.postCallAnalyticsSettings = postCallAnalyticsSettings != null ? postCallAnalyticsSettings.build() : null;
        }

        @Override
        public final Builder postCallAnalyticsSettings(PostCallAnalyticsSettings postCallAnalyticsSettings) {
            this.postCallAnalyticsSettings = postCallAnalyticsSettings;
            return this;
        }

        @Override
        public ConfigurationEvent build() {
            return new ConfigurationEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
