/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for the result of post-stream analytics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalScribePostStreamAnalyticsResult implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalScribePostStreamAnalyticsResult.Builder, MedicalScribePostStreamAnalyticsResult> {
    private static final SdkField<ClinicalNoteGenerationResult> CLINICAL_NOTE_GENERATION_RESULT_FIELD = SdkField
            .<ClinicalNoteGenerationResult> builder(MarshallingType.SDK_POJO)
            .memberName("ClinicalNoteGenerationResult")
            .getter(getter(MedicalScribePostStreamAnalyticsResult::clinicalNoteGenerationResult))
            .setter(setter(Builder::clinicalNoteGenerationResult))
            .constructor(ClinicalNoteGenerationResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClinicalNoteGenerationResult")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CLINICAL_NOTE_GENERATION_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ClinicalNoteGenerationResult clinicalNoteGenerationResult;

    private MedicalScribePostStreamAnalyticsResult(BuilderImpl builder) {
        this.clinicalNoteGenerationResult = builder.clinicalNoteGenerationResult;
    }

    /**
     * <p>
     * Provides the Clinical Note Generation result for post-stream analytics.
     * </p>
     * 
     * @return Provides the Clinical Note Generation result for post-stream analytics.
     */
    public final ClinicalNoteGenerationResult clinicalNoteGenerationResult() {
        return clinicalNoteGenerationResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clinicalNoteGenerationResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribePostStreamAnalyticsResult)) {
            return false;
        }
        MedicalScribePostStreamAnalyticsResult other = (MedicalScribePostStreamAnalyticsResult) obj;
        return Objects.equals(clinicalNoteGenerationResult(), other.clinicalNoteGenerationResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalScribePostStreamAnalyticsResult")
                .add("ClinicalNoteGenerationResult", clinicalNoteGenerationResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClinicalNoteGenerationResult":
            return Optional.ofNullable(clazz.cast(clinicalNoteGenerationResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClinicalNoteGenerationResult", CLINICAL_NOTE_GENERATION_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribePostStreamAnalyticsResult, T> g) {
        return obj -> g.apply((MedicalScribePostStreamAnalyticsResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalScribePostStreamAnalyticsResult> {
        /**
         * <p>
         * Provides the Clinical Note Generation result for post-stream analytics.
         * </p>
         * 
         * @param clinicalNoteGenerationResult
         *        Provides the Clinical Note Generation result for post-stream analytics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clinicalNoteGenerationResult(ClinicalNoteGenerationResult clinicalNoteGenerationResult);

        /**
         * <p>
         * Provides the Clinical Note Generation result for post-stream analytics.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClinicalNoteGenerationResult.Builder}
         * avoiding the need to create one manually via {@link ClinicalNoteGenerationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClinicalNoteGenerationResult.Builder#build()} is called
         * immediately and its result is passed to {@link #clinicalNoteGenerationResult(ClinicalNoteGenerationResult)}.
         * 
         * @param clinicalNoteGenerationResult
         *        a consumer that will call methods on {@link ClinicalNoteGenerationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clinicalNoteGenerationResult(ClinicalNoteGenerationResult)
         */
        default Builder clinicalNoteGenerationResult(Consumer<ClinicalNoteGenerationResult.Builder> clinicalNoteGenerationResult) {
            return clinicalNoteGenerationResult(ClinicalNoteGenerationResult.builder()
                    .applyMutation(clinicalNoteGenerationResult).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ClinicalNoteGenerationResult clinicalNoteGenerationResult;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribePostStreamAnalyticsResult model) {
            clinicalNoteGenerationResult(model.clinicalNoteGenerationResult);
        }

        public final ClinicalNoteGenerationResult.Builder getClinicalNoteGenerationResult() {
            return clinicalNoteGenerationResult != null ? clinicalNoteGenerationResult.toBuilder() : null;
        }

        public final void setClinicalNoteGenerationResult(ClinicalNoteGenerationResult.BuilderImpl clinicalNoteGenerationResult) {
            this.clinicalNoteGenerationResult = clinicalNoteGenerationResult != null ? clinicalNoteGenerationResult.build()
                    : null;
        }

        @Override
        public final Builder clinicalNoteGenerationResult(ClinicalNoteGenerationResult clinicalNoteGenerationResult) {
            this.clinicalNoteGenerationResult = clinicalNoteGenerationResult;
            return this;
        }

        @Override
        public MedicalScribePostStreamAnalyticsResult build() {
            return new MedicalScribePostStreamAnalyticsResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
