/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A word, phrase, or punctuation mark in your transcription output, along with various associated attributes, such as
 * confidence score, type, and start and end times.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MedicalScribeTranscriptItem implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalScribeTranscriptItem.Builder, MedicalScribeTranscriptItem> {
    private static final SdkField<Double> BEGIN_AUDIO_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("BeginAudioTime").getter(getter(MedicalScribeTranscriptItem::beginAudioTime))
            .setter(setter(Builder::beginAudioTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginAudioTime").build()).build();

    private static final SdkField<Double> END_AUDIO_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("EndAudioTime").getter(getter(MedicalScribeTranscriptItem::endAudioTime))
            .setter(setter(Builder::endAudioTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndAudioTime").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(MedicalScribeTranscriptItem::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Double> CONFIDENCE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Confidence").getter(getter(MedicalScribeTranscriptItem::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(MedicalScribeTranscriptItem::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<Boolean> VOCABULARY_FILTER_MATCH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("VocabularyFilterMatch").getter(getter(MedicalScribeTranscriptItem::vocabularyFilterMatch))
            .setter(setter(Builder::vocabularyFilterMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMatch").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_AUDIO_TIME_FIELD,
            END_AUDIO_TIME_FIELD, TYPE_FIELD, CONFIDENCE_FIELD, CONTENT_FIELD, VOCABULARY_FILTER_MATCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double beginAudioTime;

    private final Double endAudioTime;

    private final String type;

    private final Double confidence;

    private final String content;

    private final Boolean vocabularyFilterMatch;

    private MedicalScribeTranscriptItem(BuilderImpl builder) {
        this.beginAudioTime = builder.beginAudioTime;
        this.endAudioTime = builder.endAudioTime;
        this.type = builder.type;
        this.confidence = builder.confidence;
        this.content = builder.content;
        this.vocabularyFilterMatch = builder.vocabularyFilterMatch;
    }

    /**
     * <p>
     * The start time, in milliseconds, of the transcribed item.
     * </p>
     * 
     * @return The start time, in milliseconds, of the transcribed item.
     */
    public final Double beginAudioTime() {
        return beginAudioTime;
    }

    /**
     * <p>
     * The end time, in milliseconds, of the transcribed item.
     * </p>
     * 
     * @return The end time, in milliseconds, of the transcribed item.
     */
    public final Double endAudioTime() {
        return endAudioTime;
    }

    /**
     * <p>
     * The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MedicalScribeTranscriptItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
     *         <code>PUNCTUATION</code>.
     * @see MedicalScribeTranscriptItemType
     */
    public final MedicalScribeTranscriptItemType type() {
        return MedicalScribeTranscriptItemType.fromValue(type);
    }

    /**
     * <p>
     * The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MedicalScribeTranscriptItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
     *         <code>PUNCTUATION</code>.
     * @see MedicalScribeTranscriptItemType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The confidence score associated with a word or phrase in your transcript.
     * </p>
     * <p>
     * Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified
     * item correctly matches the item spoken in your media.
     * </p>
     * 
     * @return The confidence score associated with a word or phrase in your transcript.</p>
     *         <p>
     *         Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the
     *         identified item correctly matches the item spoken in your media.
     */
    public final Double confidence() {
        return confidence;
    }

    /**
     * <p>
     * The word, phrase or punctuation mark that was transcribed.
     * </p>
     * 
     * @return The word, phrase or punctuation mark that was transcribed.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * Indicates whether the specified item matches a word in the vocabulary filter included in your configuration
     * event. If <code>true</code>, there is a vocabulary filter match.
     * </p>
     * 
     * @return Indicates whether the specified item matches a word in the vocabulary filter included in your
     *         configuration event. If <code>true</code>, there is a vocabulary filter match.
     */
    public final Boolean vocabularyFilterMatch() {
        return vocabularyFilterMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(beginAudioTime());
        hashCode = 31 * hashCode + Objects.hashCode(endAudioTime());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterMatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeTranscriptItem)) {
            return false;
        }
        MedicalScribeTranscriptItem other = (MedicalScribeTranscriptItem) obj;
        return Objects.equals(beginAudioTime(), other.beginAudioTime()) && Objects.equals(endAudioTime(), other.endAudioTime())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(confidence(), other.confidence())
                && Objects.equals(content(), other.content())
                && Objects.equals(vocabularyFilterMatch(), other.vocabularyFilterMatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalScribeTranscriptItem").add("BeginAudioTime", beginAudioTime())
                .add("EndAudioTime", endAudioTime()).add("Type", typeAsString()).add("Confidence", confidence())
                .add("Content", content()).add("VocabularyFilterMatch", vocabularyFilterMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BeginAudioTime":
            return Optional.ofNullable(clazz.cast(beginAudioTime()));
        case "EndAudioTime":
            return Optional.ofNullable(clazz.cast(endAudioTime()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "VocabularyFilterMatch":
            return Optional.ofNullable(clazz.cast(vocabularyFilterMatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BeginAudioTime", BEGIN_AUDIO_TIME_FIELD);
        map.put("EndAudioTime", END_AUDIO_TIME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("VocabularyFilterMatch", VOCABULARY_FILTER_MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeTranscriptItem, T> g) {
        return obj -> g.apply((MedicalScribeTranscriptItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalScribeTranscriptItem> {
        /**
         * <p>
         * The start time, in milliseconds, of the transcribed item.
         * </p>
         * 
         * @param beginAudioTime
         *        The start time, in milliseconds, of the transcribed item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginAudioTime(Double beginAudioTime);

        /**
         * <p>
         * The end time, in milliseconds, of the transcribed item.
         * </p>
         * 
         * @param endAudioTime
         *        The end time, in milliseconds, of the transcribed item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endAudioTime(Double endAudioTime);

        /**
         * <p>
         * The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
         * <code>PUNCTUATION</code>.
         * </p>
         * 
         * @param type
         *        The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
         *        <code>PUNCTUATION</code>.
         * @see MedicalScribeTranscriptItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeTranscriptItemType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
         * <code>PUNCTUATION</code>.
         * </p>
         * 
         * @param type
         *        The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
         *        <code>PUNCTUATION</code>.
         * @see MedicalScribeTranscriptItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeTranscriptItemType
         */
        Builder type(MedicalScribeTranscriptItemType type);

        /**
         * <p>
         * The confidence score associated with a word or phrase in your transcript.
         * </p>
         * <p>
         * Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the
         * identified item correctly matches the item spoken in your media.
         * </p>
         * 
         * @param confidence
         *        The confidence score associated with a word or phrase in your transcript.</p>
         *        <p>
         *        Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the
         *        identified item correctly matches the item spoken in your media.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Double confidence);

        /**
         * <p>
         * The word, phrase or punctuation mark that was transcribed.
         * </p>
         * 
         * @param content
         *        The word, phrase or punctuation mark that was transcribed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * Indicates whether the specified item matches a word in the vocabulary filter included in your configuration
         * event. If <code>true</code>, there is a vocabulary filter match.
         * </p>
         * 
         * @param vocabularyFilterMatch
         *        Indicates whether the specified item matches a word in the vocabulary filter included in your
         *        configuration event. If <code>true</code>, there is a vocabulary filter match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterMatch(Boolean vocabularyFilterMatch);
    }

    static final class BuilderImpl implements Builder {
        private Double beginAudioTime;

        private Double endAudioTime;

        private String type;

        private Double confidence;

        private String content;

        private Boolean vocabularyFilterMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalScribeTranscriptItem model) {
            beginAudioTime(model.beginAudioTime);
            endAudioTime(model.endAudioTime);
            type(model.type);
            confidence(model.confidence);
            content(model.content);
            vocabularyFilterMatch(model.vocabularyFilterMatch);
        }

        public final Double getBeginAudioTime() {
            return beginAudioTime;
        }

        public final void setBeginAudioTime(Double beginAudioTime) {
            this.beginAudioTime = beginAudioTime;
        }

        @Override
        public final Builder beginAudioTime(Double beginAudioTime) {
            this.beginAudioTime = beginAudioTime;
            return this;
        }

        public final Double getEndAudioTime() {
            return endAudioTime;
        }

        public final void setEndAudioTime(Double endAudioTime) {
            this.endAudioTime = endAudioTime;
        }

        @Override
        public final Builder endAudioTime(Double endAudioTime) {
            this.endAudioTime = endAudioTime;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MedicalScribeTranscriptItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getConfidence() {
            return confidence;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Boolean getVocabularyFilterMatch() {
            return vocabularyFilterMatch;
        }

        public final void setVocabularyFilterMatch(Boolean vocabularyFilterMatch) {
            this.vocabularyFilterMatch = vocabularyFilterMatch;
        }

        @Override
        public final Builder vocabularyFilterMatch(Boolean vocabularyFilterMatch) {
            this.vocabularyFilterMatch = vocabularyFilterMatch;
            return this;
        }

        @Override
        public MedicalScribeTranscriptItem build() {
            return new MedicalScribeTranscriptItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
