/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model.medicalscribeinputstream;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeInputStream;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeSessionControlEvent;

/**
 * A specialization of
 * {@code software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeSessionControlEvent} that represents
 * the {@code MedicalScribeInputStream$SessionControlEvent} event. Do not use this class directly. Instead, use the
 * static builder methods on {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeInputStream}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultSessionControlEvent extends MedicalScribeSessionControlEvent {
    private static final long serialVersionUID = 1L;

    DefaultSessionControlEvent(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public MedicalScribeInputStream.EventType sdkEventType() {
        return MedicalScribeInputStream.EventType.SESSION_CONTROL_EVENT;
    }

    public interface Builder extends MedicalScribeSessionControlEvent.Builder {
        @Override
        DefaultSessionControlEvent build();
    }

    private static final class BuilderImpl extends MedicalScribeSessionControlEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultSessionControlEvent event) {
            super(event);
        }

        @Override
        public DefaultSessionControlEvent build() {
            return new DefaultSessionControlEvent(this);
        }
    }
}
