/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specify details to configure the streaming session, including channel definitions, encryption settings, post-stream
 * analytics settings, resource access role ARN and vocabulary settings.
 * </p>
 * <p>
 * Whether you are starting a new session or resuming an existing session, your first event must be a
 * <code>MedicalScribeConfigurationEvent</code>. If you are resuming a session, then this event must have the same
 * configurations that you provided to start the session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MedicalScribeConfigurationEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<MedicalScribeConfigurationEvent.Builder, MedicalScribeConfigurationEvent>, MedicalScribeInputStream {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyName").getter(getter(MedicalScribeConfigurationEvent::vocabularyName))
            .setter(setter(Builder::vocabularyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()).build();

    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterName").getter(getter(MedicalScribeConfigurationEvent::vocabularyFilterName))
            .setter(setter(Builder::vocabularyFilterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build())
            .build();

    private static final SdkField<String> VOCABULARY_FILTER_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyFilterMethod").getter(getter(MedicalScribeConfigurationEvent::vocabularyFilterMethodAsString))
            .setter(setter(Builder::vocabularyFilterMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMethod").build())
            .build();

    private static final SdkField<String> RESOURCE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceAccessRoleArn").getter(getter(MedicalScribeConfigurationEvent::resourceAccessRoleArn))
            .setter(setter(Builder::resourceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAccessRoleArn").build())
            .build();

    private static final SdkField<List<MedicalScribeChannelDefinition>> CHANNEL_DEFINITIONS_FIELD = SdkField
            .<List<MedicalScribeChannelDefinition>> builder(MarshallingType.LIST)
            .memberName("ChannelDefinitions")
            .getter(getter(MedicalScribeConfigurationEvent::channelDefinitions))
            .setter(setter(Builder::channelDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MedicalScribeChannelDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(MedicalScribeChannelDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MedicalScribeEncryptionSettings> ENCRYPTION_SETTINGS_FIELD = SdkField
            .<MedicalScribeEncryptionSettings> builder(MarshallingType.SDK_POJO).memberName("EncryptionSettings")
            .getter(getter(MedicalScribeConfigurationEvent::encryptionSettings)).setter(setter(Builder::encryptionSettings))
            .constructor(MedicalScribeEncryptionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionSettings").build())
            .build();

    private static final SdkField<MedicalScribePostStreamAnalyticsSettings> POST_STREAM_ANALYTICS_SETTINGS_FIELD = SdkField
            .<MedicalScribePostStreamAnalyticsSettings> builder(MarshallingType.SDK_POJO)
            .memberName("PostStreamAnalyticsSettings")
            .getter(getter(MedicalScribeConfigurationEvent::postStreamAnalyticsSettings))
            .setter(setter(Builder::postStreamAnalyticsSettings))
            .constructor(MedicalScribePostStreamAnalyticsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostStreamAnalyticsSettings")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD,
            VOCABULARY_FILTER_NAME_FIELD, VOCABULARY_FILTER_METHOD_FIELD, RESOURCE_ACCESS_ROLE_ARN_FIELD,
            CHANNEL_DEFINITIONS_FIELD, ENCRYPTION_SETTINGS_FIELD, POST_STREAM_ANALYTICS_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vocabularyName;

    private final String vocabularyFilterName;

    private final String vocabularyFilterMethod;

    private final String resourceAccessRoleArn;

    private final List<MedicalScribeChannelDefinition> channelDefinitions;

    private final MedicalScribeEncryptionSettings encryptionSettings;

    private final MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings;

    protected MedicalScribeConfigurationEvent(BuilderImpl builder) {
        this.vocabularyName = builder.vocabularyName;
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.vocabularyFilterMethod = builder.vocabularyFilterMethod;
        this.resourceAccessRoleArn = builder.resourceAccessRoleArn;
        this.channelDefinitions = builder.channelDefinitions;
        this.encryptionSettings = builder.encryptionSettings;
        this.postStreamAnalyticsSettings = builder.postStreamAnalyticsSettings;
    }

    /**
     * <p>
     * Specify the name of the custom vocabulary you want to use for your streaming session. Custom vocabulary names are
     * case-sensitive.
     * </p>
     * 
     * @return Specify the name of the custom vocabulary you want to use for your streaming session. Custom vocabulary
     *         names are case-sensitive.
     */
    public final String vocabularyName() {
        return vocabularyName;
    }

    /**
     * <p>
     * Specify the name of the custom vocabulary filter you want to include in your streaming session. Custom vocabulary
     * filter names are case-sensitive.
     * </p>
     * <p>
     * If you include <code>VocabularyFilterName</code> in the <code>MedicalScribeConfigurationEvent</code>, you must
     * also include <code>VocabularyFilterMethod</code>.
     * </p>
     * 
     * @return Specify the name of the custom vocabulary filter you want to include in your streaming session. Custom
     *         vocabulary filter names are case-sensitive. </p>
     *         <p>
     *         If you include <code>VocabularyFilterName</code> in the <code>MedicalScribeConfigurationEvent</code>, you
     *         must also include <code>VocabularyFilterMethod</code>.
     */
    public final String vocabularyFilterName() {
        return vocabularyFilterName;
    }

    /**
     * <p>
     * Specify how you want your custom vocabulary filter applied to the streaming session.
     * </p>
     * <p>
     * To replace words with <code>***</code>, specify <code>mask</code>.
     * </p>
     * <p>
     * To delete words, specify <code>remove</code>.
     * </p>
     * <p>
     * To flag words without changing them, specify <code>tag</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link MedicalScribeVocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return Specify how you want your custom vocabulary filter applied to the streaming session.</p>
     *         <p>
     *         To replace words with <code>***</code>, specify <code>mask</code>.
     *         </p>
     *         <p>
     *         To delete words, specify <code>remove</code>.
     *         </p>
     *         <p>
     *         To flag words without changing them, specify <code>tag</code>.
     * @see MedicalScribeVocabularyFilterMethod
     */
    public final MedicalScribeVocabularyFilterMethod vocabularyFilterMethod() {
        return MedicalScribeVocabularyFilterMethod.fromValue(vocabularyFilterMethod);
    }

    /**
     * <p>
     * Specify how you want your custom vocabulary filter applied to the streaming session.
     * </p>
     * <p>
     * To replace words with <code>***</code>, specify <code>mask</code>.
     * </p>
     * <p>
     * To delete words, specify <code>remove</code>.
     * </p>
     * <p>
     * To flag words without changing them, specify <code>tag</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vocabularyFilterMethod} will return {@link MedicalScribeVocabularyFilterMethod#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #vocabularyFilterMethodAsString}.
     * </p>
     * 
     * @return Specify how you want your custom vocabulary filter applied to the streaming session.</p>
     *         <p>
     *         To replace words with <code>***</code>, specify <code>mask</code>.
     *         </p>
     *         <p>
     *         To delete words, specify <code>remove</code>.
     *         </p>
     *         <p>
     *         To flag words without changing them, specify <code>tag</code>.
     * @see MedicalScribeVocabularyFilterMethod
     */
    public final String vocabularyFilterMethodAsString() {
        return vocabularyFilterMethod;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 output bucket you
     * specified, and use your KMS key if supplied. If the role that you specify doesn’t have the appropriate
     * permissions, your request fails.
     * </p>
     * <p>
     * IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example:
     * <code>arn:aws:iam::111122223333:role/Admin</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/health-scribe-streaming.html">Amazon Web Services
     * HealthScribe</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 output bucket
     *         you specified, and use your KMS key if supplied. If the role that you specify doesn’t have the
     *         appropriate permissions, your request fails. </p>
     *         <p>
     *         IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For
     *         example: <code>arn:aws:iam::111122223333:role/Admin</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/health-scribe-streaming.html">Amazon Web Services
     *         HealthScribe</a>.
     */
    public final String resourceAccessRoleArn() {
        return resourceAccessRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelDefinitions() {
        return channelDefinitions != null && !(channelDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify which speaker is on which audio channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelDefinitions} method.
     * </p>
     * 
     * @return Specify which speaker is on which audio channel.
     */
    public final List<MedicalScribeChannelDefinition> channelDefinitions() {
        return channelDefinitions;
    }

    /**
     * <p>
     * Specify the encryption settings for your streaming session.
     * </p>
     * 
     * @return Specify the encryption settings for your streaming session.
     */
    public final MedicalScribeEncryptionSettings encryptionSettings() {
        return encryptionSettings;
    }

    /**
     * <p>
     * Specify settings for post-stream analytics.
     * </p>
     * 
     * @return Specify settings for post-stream analytics.
     */
    public final MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings() {
        return postStreamAnalyticsSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelDefinitions() ? channelDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encryptionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(postStreamAnalyticsSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalScribeConfigurationEvent)) {
            return false;
        }
        MedicalScribeConfigurationEvent other = (MedicalScribeConfigurationEvent) obj;
        return Objects.equals(vocabularyName(), other.vocabularyName())
                && Objects.equals(vocabularyFilterName(), other.vocabularyFilterName())
                && Objects.equals(vocabularyFilterMethodAsString(), other.vocabularyFilterMethodAsString())
                && Objects.equals(resourceAccessRoleArn(), other.resourceAccessRoleArn())
                && hasChannelDefinitions() == other.hasChannelDefinitions()
                && Objects.equals(channelDefinitions(), other.channelDefinitions())
                && Objects.equals(encryptionSettings(), other.encryptionSettings())
                && Objects.equals(postStreamAnalyticsSettings(), other.postStreamAnalyticsSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MedicalScribeConfigurationEvent").add("VocabularyName", vocabularyName())
                .add("VocabularyFilterName", vocabularyFilterName())
                .add("VocabularyFilterMethod", vocabularyFilterMethodAsString())
                .add("ResourceAccessRoleArn", resourceAccessRoleArn())
                .add("ChannelDefinitions", hasChannelDefinitions() ? channelDefinitions() : null)
                .add("EncryptionSettings", encryptionSettings())
                .add("PostStreamAnalyticsSettings", postStreamAnalyticsSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VocabularyName":
            return Optional.ofNullable(clazz.cast(vocabularyName()));
        case "VocabularyFilterName":
            return Optional.ofNullable(clazz.cast(vocabularyFilterName()));
        case "VocabularyFilterMethod":
            return Optional.ofNullable(clazz.cast(vocabularyFilterMethodAsString()));
        case "ResourceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(resourceAccessRoleArn()));
        case "ChannelDefinitions":
            return Optional.ofNullable(clazz.cast(channelDefinitions()));
        case "EncryptionSettings":
            return Optional.ofNullable(clazz.cast(encryptionSettings()));
        case "PostStreamAnalyticsSettings":
            return Optional.ofNullable(clazz.cast(postStreamAnalyticsSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final MedicalScribeConfigurationEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VocabularyName", VOCABULARY_NAME_FIELD);
        map.put("VocabularyFilterName", VOCABULARY_FILTER_NAME_FIELD);
        map.put("VocabularyFilterMethod", VOCABULARY_FILTER_METHOD_FIELD);
        map.put("ResourceAccessRoleArn", RESOURCE_ACCESS_ROLE_ARN_FIELD);
        map.put("ChannelDefinitions", CHANNEL_DEFINITIONS_FIELD);
        map.put("EncryptionSettings", ENCRYPTION_SETTINGS_FIELD);
        map.put("PostStreamAnalyticsSettings", POST_STREAM_ANALYTICS_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MedicalScribeConfigurationEvent, T> g) {
        return obj -> g.apply((MedicalScribeConfigurationEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MedicalScribeConfigurationEvent> {
        /**
         * <p>
         * Specify the name of the custom vocabulary you want to use for your streaming session. Custom vocabulary names
         * are case-sensitive.
         * </p>
         * 
         * @param vocabularyName
         *        Specify the name of the custom vocabulary you want to use for your streaming session. Custom
         *        vocabulary names are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyName(String vocabularyName);

        /**
         * <p>
         * Specify the name of the custom vocabulary filter you want to include in your streaming session. Custom
         * vocabulary filter names are case-sensitive.
         * </p>
         * <p>
         * If you include <code>VocabularyFilterName</code> in the <code>MedicalScribeConfigurationEvent</code>, you
         * must also include <code>VocabularyFilterMethod</code>.
         * </p>
         * 
         * @param vocabularyFilterName
         *        Specify the name of the custom vocabulary filter you want to include in your streaming session. Custom
         *        vocabulary filter names are case-sensitive. </p>
         *        <p>
         *        If you include <code>VocabularyFilterName</code> in the <code>MedicalScribeConfigurationEvent</code>,
         *        you must also include <code>VocabularyFilterMethod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterName(String vocabularyFilterName);

        /**
         * <p>
         * Specify how you want your custom vocabulary filter applied to the streaming session.
         * </p>
         * <p>
         * To replace words with <code>***</code>, specify <code>mask</code>.
         * </p>
         * <p>
         * To delete words, specify <code>remove</code>.
         * </p>
         * <p>
         * To flag words without changing them, specify <code>tag</code>.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        Specify how you want your custom vocabulary filter applied to the streaming session.</p>
         *        <p>
         *        To replace words with <code>***</code>, specify <code>mask</code>.
         *        </p>
         *        <p>
         *        To delete words, specify <code>remove</code>.
         *        </p>
         *        <p>
         *        To flag words without changing them, specify <code>tag</code>.
         * @see MedicalScribeVocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeVocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(String vocabularyFilterMethod);

        /**
         * <p>
         * Specify how you want your custom vocabulary filter applied to the streaming session.
         * </p>
         * <p>
         * To replace words with <code>***</code>, specify <code>mask</code>.
         * </p>
         * <p>
         * To delete words, specify <code>remove</code>.
         * </p>
         * <p>
         * To flag words without changing them, specify <code>tag</code>.
         * </p>
         * 
         * @param vocabularyFilterMethod
         *        Specify how you want your custom vocabulary filter applied to the streaming session.</p>
         *        <p>
         *        To replace words with <code>***</code>, specify <code>mask</code>.
         *        </p>
         *        <p>
         *        To delete words, specify <code>remove</code>.
         *        </p>
         *        <p>
         *        To flag words without changing them, specify <code>tag</code>.
         * @see MedicalScribeVocabularyFilterMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MedicalScribeVocabularyFilterMethod
         */
        Builder vocabularyFilterMethod(MedicalScribeVocabularyFilterMethod vocabularyFilterMethod);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 output bucket you
         * specified, and use your KMS key if supplied. If the role that you specify doesn’t have the appropriate
         * permissions, your request fails.
         * </p>
         * <p>
         * IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example:
         * <code>arn:aws:iam::111122223333:role/Admin</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/transcribe/latest/dg/health-scribe-streaming.html">Amazon Web Services
         * HealthScribe</a>.
         * </p>
         * 
         * @param resourceAccessRoleArn
         *        The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 output
         *        bucket you specified, and use your KMS key if supplied. If the role that you specify doesn’t have the
         *        appropriate permissions, your request fails. </p>
         *        <p>
         *        IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For
         *        example: <code>arn:aws:iam::111122223333:role/Admin</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/transcribe/latest/dg/health-scribe-streaming.html">Amazon Web
         *        Services HealthScribe</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAccessRoleArn(String resourceAccessRoleArn);

        /**
         * <p>
         * Specify which speaker is on which audio channel.
         * </p>
         * 
         * @param channelDefinitions
         *        Specify which speaker is on which audio channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDefinitions(Collection<MedicalScribeChannelDefinition> channelDefinitions);

        /**
         * <p>
         * Specify which speaker is on which audio channel.
         * </p>
         * 
         * @param channelDefinitions
         *        Specify which speaker is on which audio channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDefinitions(MedicalScribeChannelDefinition... channelDefinitions);

        /**
         * <p>
         * Specify which speaker is on which audio channel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeChannelDefinition.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeChannelDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeChannelDefinition.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #channelDefinitions(List<MedicalScribeChannelDefinition>)}.
         * 
         * @param channelDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeChannelDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelDefinitions(java.util.Collection<MedicalScribeChannelDefinition>)
         */
        Builder channelDefinitions(Consumer<MedicalScribeChannelDefinition.Builder>... channelDefinitions);

        /**
         * <p>
         * Specify the encryption settings for your streaming session.
         * </p>
         * 
         * @param encryptionSettings
         *        Specify the encryption settings for your streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionSettings(MedicalScribeEncryptionSettings encryptionSettings);

        /**
         * <p>
         * Specify the encryption settings for your streaming session.
         * </p>
         * This is a convenience method that creates an instance of the {@link MedicalScribeEncryptionSettings.Builder}
         * avoiding the need to create one manually via {@link MedicalScribeEncryptionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MedicalScribeEncryptionSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #encryptionSettings(MedicalScribeEncryptionSettings)}.
         * 
         * @param encryptionSettings
         *        a consumer that will call methods on {@link MedicalScribeEncryptionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionSettings(MedicalScribeEncryptionSettings)
         */
        default Builder encryptionSettings(Consumer<MedicalScribeEncryptionSettings.Builder> encryptionSettings) {
            return encryptionSettings(MedicalScribeEncryptionSettings.builder().applyMutation(encryptionSettings).build());
        }

        /**
         * <p>
         * Specify settings for post-stream analytics.
         * </p>
         * 
         * @param postStreamAnalyticsSettings
         *        Specify settings for post-stream analytics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings);

        /**
         * <p>
         * Specify settings for post-stream analytics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MedicalScribePostStreamAnalyticsSettings.Builder} avoiding the need to create one manually via
         * {@link MedicalScribePostStreamAnalyticsSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MedicalScribePostStreamAnalyticsSettings.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #postStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings)}.
         * 
         * @param postStreamAnalyticsSettings
         *        a consumer that will call methods on {@link MedicalScribePostStreamAnalyticsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings)
         */
        default Builder postStreamAnalyticsSettings(
                Consumer<MedicalScribePostStreamAnalyticsSettings.Builder> postStreamAnalyticsSettings) {
            return postStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings.builder()
                    .applyMutation(postStreamAnalyticsSettings).build());
        }
    }

    protected static class BuilderImpl implements Builder {
        private String vocabularyName;

        private String vocabularyFilterName;

        private String vocabularyFilterMethod;

        private String resourceAccessRoleArn;

        private List<MedicalScribeChannelDefinition> channelDefinitions = DefaultSdkAutoConstructList.getInstance();

        private MedicalScribeEncryptionSettings encryptionSettings;

        private MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings;

        protected BuilderImpl() {
        }

        protected BuilderImpl(MedicalScribeConfigurationEvent model) {
            vocabularyName(model.vocabularyName);
            vocabularyFilterName(model.vocabularyFilterName);
            vocabularyFilterMethod(model.vocabularyFilterMethod);
            resourceAccessRoleArn(model.resourceAccessRoleArn);
            channelDefinitions(model.channelDefinitions);
            encryptionSettings(model.encryptionSettings);
            postStreamAnalyticsSettings(model.postStreamAnalyticsSettings);
        }

        public final String getVocabularyName() {
            return vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getVocabularyFilterName() {
            return vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getVocabularyFilterMethod() {
            return vocabularyFilterMethod;
        }

        public final void setVocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
        }

        @Override
        public final Builder vocabularyFilterMethod(String vocabularyFilterMethod) {
            this.vocabularyFilterMethod = vocabularyFilterMethod;
            return this;
        }

        @Override
        public final Builder vocabularyFilterMethod(MedicalScribeVocabularyFilterMethod vocabularyFilterMethod) {
            this.vocabularyFilterMethod(vocabularyFilterMethod == null ? null : vocabularyFilterMethod.toString());
            return this;
        }

        public final String getResourceAccessRoleArn() {
            return resourceAccessRoleArn;
        }

        public final void setResourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
        }

        @Override
        public final Builder resourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
            return this;
        }

        public final List<MedicalScribeChannelDefinition.Builder> getChannelDefinitions() {
            List<MedicalScribeChannelDefinition.Builder> result = MedicalScribeChannelDefinitionsCopier
                    .copyToBuilder(this.channelDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelDefinitions(Collection<MedicalScribeChannelDefinition.BuilderImpl> channelDefinitions) {
            this.channelDefinitions = MedicalScribeChannelDefinitionsCopier.copyFromBuilder(channelDefinitions);
        }

        @Override
        public final Builder channelDefinitions(Collection<MedicalScribeChannelDefinition> channelDefinitions) {
            this.channelDefinitions = MedicalScribeChannelDefinitionsCopier.copy(channelDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(MedicalScribeChannelDefinition... channelDefinitions) {
            channelDefinitions(Arrays.asList(channelDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(Consumer<MedicalScribeChannelDefinition.Builder>... channelDefinitions) {
            channelDefinitions(Stream.of(channelDefinitions)
                    .map(c -> MedicalScribeChannelDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final MedicalScribeEncryptionSettings.Builder getEncryptionSettings() {
            return encryptionSettings != null ? encryptionSettings.toBuilder() : null;
        }

        public final void setEncryptionSettings(MedicalScribeEncryptionSettings.BuilderImpl encryptionSettings) {
            this.encryptionSettings = encryptionSettings != null ? encryptionSettings.build() : null;
        }

        @Override
        public final Builder encryptionSettings(MedicalScribeEncryptionSettings encryptionSettings) {
            this.encryptionSettings = encryptionSettings;
            return this;
        }

        public final MedicalScribePostStreamAnalyticsSettings.Builder getPostStreamAnalyticsSettings() {
            return postStreamAnalyticsSettings != null ? postStreamAnalyticsSettings.toBuilder() : null;
        }

        public final void setPostStreamAnalyticsSettings(
                MedicalScribePostStreamAnalyticsSettings.BuilderImpl postStreamAnalyticsSettings) {
            this.postStreamAnalyticsSettings = postStreamAnalyticsSettings != null ? postStreamAnalyticsSettings.build() : null;
        }

        @Override
        public final Builder postStreamAnalyticsSettings(MedicalScribePostStreamAnalyticsSettings postStreamAnalyticsSettings) {
            this.postStreamAnalyticsSettings = postStreamAnalyticsSettings;
            return this;
        }

        @Override
        public MedicalScribeConfigurationEvent build() {
            return new MedicalScribeConfigurationEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
