/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeAudioEvent;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeConfigurationEvent;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeSessionControlEvent;
import software.amazon.awssdk.services.transcribestreaming.model.medicalscribeinputstream.DefaultAudioEvent;
import software.amazon.awssdk.services.transcribestreaming.model.medicalscribeinputstream.DefaultConfigurationEvent;
import software.amazon.awssdk.services.transcribestreaming.model.medicalscribeinputstream.DefaultSessionControlEvent;
import software.amazon.awssdk.utils.internal.EnumUtils;

@SdkPublicApi
public interface MedicalScribeInputStream {
    public static MedicalScribeAudioEvent.Builder audioEventBuilder() {
        return DefaultAudioEvent.builder();
    }

    public static MedicalScribeSessionControlEvent.Builder sessionControlEventBuilder() {
        return DefaultSessionControlEvent.builder();
    }

    public static MedicalScribeConfigurationEvent.Builder configurationEventBuilder() {
        return DefaultConfigurationEvent.builder();
    }

    default public EventType sdkEventType() {
        return EventType.UNKNOWN_TO_SDK_VERSION;
    }

    public static enum EventType {
        AUDIO_EVENT("AudioEvent"),
        SESSION_CONTROL_EVENT("SessionControlEvent"),
        CONFIGURATION_EVENT("ConfigurationEvent"),
        UNKNOWN_TO_SDK_VERSION(null);

        private static final Map<String, EventType> VALUE_MAP;
        private final String value;

        private EventType(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventType fromValue(String value) {
            if (value == null) {
                return null;
            }
            return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
        }

        public static Set<EventType> knownValues() {
            EnumSet<EventType> knownValues = EnumSet.allOf(EventType.class);
            knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
            return knownValues;
        }

        static {
            VALUE_MAP = EnumUtils.uniqueIndex(EventType.class, EventType::toString);
        }
    }
}

