/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.IdentityProviderDetails;
import software.amazon.awssdk.services.transfer.model.IdentityProviderType;
import software.amazon.awssdk.services.transfer.model.Tag;
import software.amazon.awssdk.services.transfer.model.TagsCopier;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServerRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, CreateServerRequest> {
    private static final SdkField<IdentityProviderDetails> IDENTITY_PROVIDER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateServerRequest.getter(CreateServerRequest::identityProviderDetails)).setter(CreateServerRequest.setter(Builder::identityProviderDetails)).constructor(IdentityProviderDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderDetails").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateServerRequest.getter(CreateServerRequest::identityProviderTypeAsString)).setter(CreateServerRequest.setter(Builder::identityProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderType").build()}).build();
    private static final SdkField<String> LOGGING_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateServerRequest.getter(CreateServerRequest::loggingRole)).setter(CreateServerRequest.setter(Builder::loggingRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingRole").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateServerRequest.getter(CreateServerRequest::tags)).setter(CreateServerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_DETAILS_FIELD, IDENTITY_PROVIDER_TYPE_FIELD, LOGGING_ROLE_FIELD, TAGS_FIELD));
    private final IdentityProviderDetails identityProviderDetails;
    private final String identityProviderType;
    private final String loggingRole;
    private final List<Tag> tags;

    private CreateServerRequest(BuilderImpl builder) {
        super(builder);
        this.identityProviderDetails = builder.identityProviderDetails;
        this.identityProviderType = builder.identityProviderType;
        this.loggingRole = builder.loggingRole;
        this.tags = builder.tags;
    }

    public IdentityProviderDetails identityProviderDetails() {
        return this.identityProviderDetails;
    }

    public IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(this.identityProviderType);
    }

    public String identityProviderTypeAsString() {
        return this.identityProviderType;
    }

    public String loggingRole() {
        return this.loggingRole;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServerRequest)) {
            return false;
        }
        CreateServerRequest other = (CreateServerRequest)((Object)obj);
        return Objects.equals(this.identityProviderDetails(), other.identityProviderDetails()) && Objects.equals(this.identityProviderTypeAsString(), other.identityProviderTypeAsString()) && Objects.equals(this.loggingRole(), other.loggingRole()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateServerRequest").add("IdentityProviderDetails", (Object)this.identityProviderDetails()).add("IdentityProviderType", (Object)this.identityProviderTypeAsString()).add("LoggingRole", (Object)this.loggingRole()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityProviderDetails": {
                return Optional.ofNullable(clazz.cast(this.identityProviderDetails()));
            }
            case "IdentityProviderType": {
                return Optional.ofNullable(clazz.cast(this.identityProviderTypeAsString()));
            }
            case "LoggingRole": {
                return Optional.ofNullable(clazz.cast(this.loggingRole()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServerRequest, T> g) {
        return obj -> g.apply((CreateServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private IdentityProviderDetails identityProviderDetails;
        private String identityProviderType;
        private String loggingRole;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServerRequest model) {
            super(model);
            this.identityProviderDetails(model.identityProviderDetails);
            this.identityProviderType(model.identityProviderType);
            this.loggingRole(model.loggingRole);
            this.tags(model.tags);
        }

        public final IdentityProviderDetails.Builder getIdentityProviderDetails() {
            return this.identityProviderDetails != null ? this.identityProviderDetails.toBuilder() : null;
        }

        @Override
        public final Builder identityProviderDetails(IdentityProviderDetails identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        public final void setIdentityProviderDetails(IdentityProviderDetails.BuilderImpl identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails != null ? identityProviderDetails.build() : null;
        }

        public final String getIdentityProviderType() {
            return this.identityProviderType;
        }

        @Override
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType.toString());
            return this;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        public final String getLoggingRole() {
            return this.loggingRole;
        }

        @Override
        public final Builder loggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        public final void setLoggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServerRequest build() {
            return new CreateServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServerRequest> {
        public Builder identityProviderDetails(IdentityProviderDetails var1);

        default public Builder identityProviderDetails(Consumer<IdentityProviderDetails.Builder> identityProviderDetails) {
            return this.identityProviderDetails((IdentityProviderDetails)((IdentityProviderDetails.Builder)IdentityProviderDetails.builder().applyMutation(identityProviderDetails)).build());
        }

        public Builder identityProviderType(String var1);

        public Builder identityProviderType(IdentityProviderType var1);

        public Builder loggingRole(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

