/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.HomeDirectoryMapEntry;
import software.amazon.awssdk.services.transfer.model.HomeDirectoryMappingsCopier;
import software.amazon.awssdk.services.transfer.model.HomeDirectoryType;
import software.amazon.awssdk.services.transfer.model.SshPublicKey;
import software.amazon.awssdk.services.transfer.model.SshPublicKeysCopier;
import software.amazon.awssdk.services.transfer.model.Tag;
import software.amazon.awssdk.services.transfer.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribedUser
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribedUser> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribedUser.getter(DescribedUser::arn)).setter(DescribedUser.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> HOME_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribedUser.getter(DescribedUser::homeDirectory)).setter(DescribedUser.setter(Builder::homeDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectory").build()}).build();
    private static final SdkField<List<HomeDirectoryMapEntry>> HOME_DIRECTORY_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribedUser.getter(DescribedUser::homeDirectoryMappings)).setter(DescribedUser.setter(Builder::homeDirectoryMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectoryMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HomeDirectoryMapEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HOME_DIRECTORY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribedUser.getter(DescribedUser::homeDirectoryTypeAsString)).setter(DescribedUser.setter(Builder::homeDirectoryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectoryType").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribedUser.getter(DescribedUser::policy)).setter(DescribedUser.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribedUser.getter(DescribedUser::role)).setter(DescribedUser.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<List<SshPublicKey>> SSH_PUBLIC_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribedUser.getter(DescribedUser::sshPublicKeys)).setter(DescribedUser.setter(Builder::sshPublicKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SshPublicKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribedUser.getter(DescribedUser::tags)).setter(DescribedUser.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribedUser.getter(DescribedUser::userName)).setter(DescribedUser.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, HOME_DIRECTORY_FIELD, HOME_DIRECTORY_MAPPINGS_FIELD, HOME_DIRECTORY_TYPE_FIELD, POLICY_FIELD, ROLE_FIELD, SSH_PUBLIC_KEYS_FIELD, TAGS_FIELD, USER_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String homeDirectory;
    private final List<HomeDirectoryMapEntry> homeDirectoryMappings;
    private final String homeDirectoryType;
    private final String policy;
    private final String role;
    private final List<SshPublicKey> sshPublicKeys;
    private final List<Tag> tags;
    private final String userName;

    private DescribedUser(BuilderImpl builder) {
        this.arn = builder.arn;
        this.homeDirectory = builder.homeDirectory;
        this.homeDirectoryMappings = builder.homeDirectoryMappings;
        this.homeDirectoryType = builder.homeDirectoryType;
        this.policy = builder.policy;
        this.role = builder.role;
        this.sshPublicKeys = builder.sshPublicKeys;
        this.tags = builder.tags;
        this.userName = builder.userName;
    }

    public String arn() {
        return this.arn;
    }

    public String homeDirectory() {
        return this.homeDirectory;
    }

    public boolean hasHomeDirectoryMappings() {
        return this.homeDirectoryMappings != null && !(this.homeDirectoryMappings instanceof SdkAutoConstructList);
    }

    public List<HomeDirectoryMapEntry> homeDirectoryMappings() {
        return this.homeDirectoryMappings;
    }

    public HomeDirectoryType homeDirectoryType() {
        return HomeDirectoryType.fromValue(this.homeDirectoryType);
    }

    public String homeDirectoryTypeAsString() {
        return this.homeDirectoryType;
    }

    public String policy() {
        return this.policy;
    }

    public String role() {
        return this.role;
    }

    public boolean hasSshPublicKeys() {
        return this.sshPublicKeys != null && !(this.sshPublicKeys instanceof SdkAutoConstructList);
    }

    public List<SshPublicKey> sshPublicKeys() {
        return this.sshPublicKeys;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String userName() {
        return this.userName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeDirectoryMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeDirectoryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedUser)) {
            return false;
        }
        DescribedUser other = (DescribedUser)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.homeDirectory(), other.homeDirectory()) && Objects.equals(this.homeDirectoryMappings(), other.homeDirectoryMappings()) && Objects.equals(this.homeDirectoryTypeAsString(), other.homeDirectoryTypeAsString()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.sshPublicKeys(), other.sshPublicKeys()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.userName(), other.userName());
    }

    public String toString() {
        return ToString.builder((String)"DescribedUser").add("Arn", (Object)this.arn()).add("HomeDirectory", (Object)this.homeDirectory()).add("HomeDirectoryMappings", this.homeDirectoryMappings()).add("HomeDirectoryType", (Object)this.homeDirectoryTypeAsString()).add("Policy", (Object)this.policy()).add("Role", (Object)this.role()).add("SshPublicKeys", this.sshPublicKeys()).add("Tags", this.tags()).add("UserName", (Object)this.userName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "HomeDirectory": {
                return Optional.ofNullable(clazz.cast(this.homeDirectory()));
            }
            case "HomeDirectoryMappings": {
                return Optional.ofNullable(clazz.cast(this.homeDirectoryMappings()));
            }
            case "HomeDirectoryType": {
                return Optional.ofNullable(clazz.cast(this.homeDirectoryTypeAsString()));
            }
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "SshPublicKeys": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKeys()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribedUser, T> g) {
        return obj -> g.apply((DescribedUser)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String homeDirectory;
        private List<HomeDirectoryMapEntry> homeDirectoryMappings = DefaultSdkAutoConstructList.getInstance();
        private String homeDirectoryType;
        private String policy;
        private String role;
        private List<SshPublicKey> sshPublicKeys = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedUser model) {
            this.arn(model.arn);
            this.homeDirectory(model.homeDirectory);
            this.homeDirectoryMappings(model.homeDirectoryMappings);
            this.homeDirectoryType(model.homeDirectoryType);
            this.policy(model.policy);
            this.role(model.role);
            this.sshPublicKeys(model.sshPublicKeys);
            this.tags(model.tags);
            this.userName(model.userName);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getHomeDirectory() {
            return this.homeDirectory;
        }

        @Override
        public final Builder homeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
            return this;
        }

        public final void setHomeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
        }

        public final Collection<HomeDirectoryMapEntry.Builder> getHomeDirectoryMappings() {
            return this.homeDirectoryMappings != null ? (Collection)this.homeDirectoryMappings.stream().map(HomeDirectoryMapEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder homeDirectoryMappings(Collection<HomeDirectoryMapEntry> homeDirectoryMappings) {
            this.homeDirectoryMappings = HomeDirectoryMappingsCopier.copy(homeDirectoryMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder homeDirectoryMappings(HomeDirectoryMapEntry ... homeDirectoryMappings) {
            this.homeDirectoryMappings(Arrays.asList(homeDirectoryMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder homeDirectoryMappings(Consumer<HomeDirectoryMapEntry.Builder> ... homeDirectoryMappings) {
            this.homeDirectoryMappings(Stream.of(homeDirectoryMappings).map(c -> (HomeDirectoryMapEntry)((HomeDirectoryMapEntry.Builder)HomeDirectoryMapEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHomeDirectoryMappings(Collection<HomeDirectoryMapEntry.BuilderImpl> homeDirectoryMappings) {
            this.homeDirectoryMappings = HomeDirectoryMappingsCopier.copyFromBuilder(homeDirectoryMappings);
        }

        public final String getHomeDirectoryTypeAsString() {
            return this.homeDirectoryType;
        }

        @Override
        public final Builder homeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
            return this;
        }

        @Override
        public final Builder homeDirectoryType(HomeDirectoryType homeDirectoryType) {
            this.homeDirectoryType(homeDirectoryType == null ? null : homeDirectoryType.toString());
            return this;
        }

        public final void setHomeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final Collection<SshPublicKey.Builder> getSshPublicKeys() {
            return this.sshPublicKeys != null ? (Collection)this.sshPublicKeys.stream().map(SshPublicKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sshPublicKeys(Collection<SshPublicKey> sshPublicKeys) {
            this.sshPublicKeys = SshPublicKeysCopier.copy(sshPublicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshPublicKeys(SshPublicKey ... sshPublicKeys) {
            this.sshPublicKeys(Arrays.asList(sshPublicKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshPublicKeys(Consumer<SshPublicKey.Builder> ... sshPublicKeys) {
            this.sshPublicKeys(Stream.of(sshPublicKeys).map(c -> (SshPublicKey)((SshPublicKey.Builder)SshPublicKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSshPublicKeys(Collection<SshPublicKey.BuilderImpl> sshPublicKeys) {
            this.sshPublicKeys = SshPublicKeysCopier.copyFromBuilder(sshPublicKeys);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public DescribedUser build() {
            return new DescribedUser(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribedUser> {
        public Builder arn(String var1);

        public Builder homeDirectory(String var1);

        public Builder homeDirectoryMappings(Collection<HomeDirectoryMapEntry> var1);

        public Builder homeDirectoryMappings(HomeDirectoryMapEntry ... var1);

        public Builder homeDirectoryMappings(Consumer<HomeDirectoryMapEntry.Builder> ... var1);

        public Builder homeDirectoryType(String var1);

        public Builder homeDirectoryType(HomeDirectoryType var1);

        public Builder policy(String var1);

        public Builder role(String var1);

        public Builder sshPublicKeys(Collection<SshPublicKey> var1);

        public Builder sshPublicKeys(SshPublicKey ... var1);

        public Builder sshPublicKeys(Consumer<SshPublicKey.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder userName(String var1);
    }
}

