/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns properties of the user that you specify.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedUser implements SdkPojo, Serializable, ToCopyableBuilder<ListedUser.Builder, ListedUser> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListedUser::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> HOME_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListedUser::homeDirectory)).setter(setter(Builder::homeDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectory").build()).build();

    private static final SdkField<String> HOME_DIRECTORY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListedUser::homeDirectoryTypeAsString)).setter(setter(Builder::homeDirectoryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectoryType").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListedUser::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<Integer> SSH_PUBLIC_KEY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListedUser::sshPublicKeyCount)).setter(setter(Builder::sshPublicKeyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKeyCount").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListedUser::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            HOME_DIRECTORY_FIELD, HOME_DIRECTORY_TYPE_FIELD, ROLE_FIELD, SSH_PUBLIC_KEY_COUNT_FIELD, USER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String homeDirectory;

    private final String homeDirectoryType;

    private final String role;

    private final Integer sshPublicKeyCount;

    private final String userName;

    private ListedUser(BuilderImpl builder) {
        this.arn = builder.arn;
        this.homeDirectory = builder.homeDirectory;
        this.homeDirectoryType = builder.homeDirectoryType;
        this.role = builder.role;
        this.sshPublicKeyCount = builder.sshPublicKeyCount;
        this.userName = builder.userName;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) for the user that you want to learn about.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) for the user that you want to learn about.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * Specifies the location that files are written to or read from an Amazon S3 bucket for the user you specify by
     * their ARN.
     * </p>
     * 
     * @return Specifies the location that files are written to or read from an Amazon S3 bucket for the user you
     *         specify by their ARN.
     */
    public String homeDirectory() {
        return homeDirectory;
    }

    /**
     * <p>
     * The type of landing directory (folder) you mapped for your users' home directory. If you set it to
     * <code>PATH</code>, the user will see the absolute Amazon S3 bucket paths as is in their file transfer protocol
     * clients. If you set it <code>LOGICAL</code>, you will need to provide mappings in the
     * <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 paths visible to your users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #homeDirectoryType}
     * will return {@link HomeDirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #homeDirectoryTypeAsString}.
     * </p>
     * 
     * @return The type of landing directory (folder) you mapped for your users' home directory. If you set it to
     *         <code>PATH</code>, the user will see the absolute Amazon S3 bucket paths as is in their file transfer
     *         protocol clients. If you set it <code>LOGICAL</code>, you will need to provide mappings in the
     *         <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 paths visible to your users.
     * @see HomeDirectoryType
     */
    public HomeDirectoryType homeDirectoryType() {
        return HomeDirectoryType.fromValue(homeDirectoryType);
    }

    /**
     * <p>
     * The type of landing directory (folder) you mapped for your users' home directory. If you set it to
     * <code>PATH</code>, the user will see the absolute Amazon S3 bucket paths as is in their file transfer protocol
     * clients. If you set it <code>LOGICAL</code>, you will need to provide mappings in the
     * <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 paths visible to your users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #homeDirectoryType}
     * will return {@link HomeDirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #homeDirectoryTypeAsString}.
     * </p>
     * 
     * @return The type of landing directory (folder) you mapped for your users' home directory. If you set it to
     *         <code>PATH</code>, the user will see the absolute Amazon S3 bucket paths as is in their file transfer
     *         protocol clients. If you set it <code>LOGICAL</code>, you will need to provide mappings in the
     *         <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 paths visible to your users.
     * @see HomeDirectoryType
     */
    public String homeDirectoryTypeAsString() {
        return homeDirectoryType;
    }

    /**
     * <p>
     * The role in use by this user. A <i>role</i> is an AWS Identity and Access Management (IAM) entity that, in this
     * case, allows a file transfer protocol-enabled server to act on a user's behalf. It allows the server to inherit
     * the trust relationship that enables that user to perform file operations to their Amazon S3 bucket.
     * </p>
     * 
     * @return The role in use by this user. A <i>role</i> is an AWS Identity and Access Management (IAM) entity that,
     *         in this case, allows a file transfer protocol-enabled server to act on a user's behalf. It allows the
     *         server to inherit the trust relationship that enables that user to perform file operations to their
     *         Amazon S3 bucket.
     */
    public String role() {
        return role;
    }

    /**
     * <p>
     * The number of SSH public keys stored for the user you specified.
     * </p>
     * 
     * @return The number of SSH public keys stored for the user you specified.
     */
    public Integer sshPublicKeyCount() {
        return sshPublicKeyCount;
    }

    /**
     * <p>
     * The name of the user whose ARN was specified. User names are used for authentication purposes.
     * </p>
     * 
     * @return The name of the user whose ARN was specified. User names are used for authentication purposes.
     */
    public String userName() {
        return userName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(homeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(homeDirectoryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKeyCount());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedUser)) {
            return false;
        }
        ListedUser other = (ListedUser) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(homeDirectory(), other.homeDirectory())
                && Objects.equals(homeDirectoryTypeAsString(), other.homeDirectoryTypeAsString())
                && Objects.equals(role(), other.role()) && Objects.equals(sshPublicKeyCount(), other.sshPublicKeyCount())
                && Objects.equals(userName(), other.userName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListedUser").add("Arn", arn()).add("HomeDirectory", homeDirectory())
                .add("HomeDirectoryType", homeDirectoryTypeAsString()).add("Role", role())
                .add("SshPublicKeyCount", sshPublicKeyCount()).add("UserName", userName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "HomeDirectory":
            return Optional.ofNullable(clazz.cast(homeDirectory()));
        case "HomeDirectoryType":
            return Optional.ofNullable(clazz.cast(homeDirectoryTypeAsString()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "SshPublicKeyCount":
            return Optional.ofNullable(clazz.cast(sshPublicKeyCount()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListedUser, T> g) {
        return obj -> g.apply((ListedUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedUser> {
        /**
         * <p>
         * The unique Amazon Resource Name (ARN) for the user that you want to learn about.
         * </p>
         * 
         * @param arn
         *        The unique Amazon Resource Name (ARN) for the user that you want to learn about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Specifies the location that files are written to or read from an Amazon S3 bucket for the user you specify by
         * their ARN.
         * </p>
         * 
         * @param homeDirectory
         *        Specifies the location that files are written to or read from an Amazon S3 bucket for the user you
         *        specify by their ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeDirectory(String homeDirectory);

        /**
         * <p>
         * The type of landing directory (folder) you mapped for your users' home directory. If you set it to
         * <code>PATH</code>, the user will see the absolute Amazon S3 bucket paths as is in their file transfer
         * protocol clients. If you set it <code>LOGICAL</code>, you will need to provide mappings in the
         * <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 paths visible to your users.
         * </p>
         * 
         * @param homeDirectoryType
         *        The type of landing directory (folder) you mapped for your users' home directory. If you set it to
         *        <code>PATH</code>, the user will see the absolute Amazon S3 bucket paths as is in their file transfer
         *        protocol clients. If you set it <code>LOGICAL</code>, you will need to provide mappings in the
         *        <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 paths visible to your users.
         * @see HomeDirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HomeDirectoryType
         */
        Builder homeDirectoryType(String homeDirectoryType);

        /**
         * <p>
         * The type of landing directory (folder) you mapped for your users' home directory. If you set it to
         * <code>PATH</code>, the user will see the absolute Amazon S3 bucket paths as is in their file transfer
         * protocol clients. If you set it <code>LOGICAL</code>, you will need to provide mappings in the
         * <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 paths visible to your users.
         * </p>
         * 
         * @param homeDirectoryType
         *        The type of landing directory (folder) you mapped for your users' home directory. If you set it to
         *        <code>PATH</code>, the user will see the absolute Amazon S3 bucket paths as is in their file transfer
         *        protocol clients. If you set it <code>LOGICAL</code>, you will need to provide mappings in the
         *        <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 paths visible to your users.
         * @see HomeDirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HomeDirectoryType
         */
        Builder homeDirectoryType(HomeDirectoryType homeDirectoryType);

        /**
         * <p>
         * The role in use by this user. A <i>role</i> is an AWS Identity and Access Management (IAM) entity that, in
         * this case, allows a file transfer protocol-enabled server to act on a user's behalf. It allows the server to
         * inherit the trust relationship that enables that user to perform file operations to their Amazon S3 bucket.
         * </p>
         * 
         * @param role
         *        The role in use by this user. A <i>role</i> is an AWS Identity and Access Management (IAM) entity
         *        that, in this case, allows a file transfer protocol-enabled server to act on a user's behalf. It
         *        allows the server to inherit the trust relationship that enables that user to perform file operations
         *        to their Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The number of SSH public keys stored for the user you specified.
         * </p>
         * 
         * @param sshPublicKeyCount
         *        The number of SSH public keys stored for the user you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeyCount(Integer sshPublicKeyCount);

        /**
         * <p>
         * The name of the user whose ARN was specified. User names are used for authentication purposes.
         * </p>
         * 
         * @param userName
         *        The name of the user whose ARN was specified. User names are used for authentication purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String homeDirectory;

        private String homeDirectoryType;

        private String role;

        private Integer sshPublicKeyCount;

        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedUser model) {
            arn(model.arn);
            homeDirectory(model.homeDirectory);
            homeDirectoryType(model.homeDirectoryType);
            role(model.role);
            sshPublicKeyCount(model.sshPublicKeyCount);
            userName(model.userName);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getHomeDirectory() {
            return homeDirectory;
        }

        @Override
        public final Builder homeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
            return this;
        }

        public final void setHomeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
        }

        public final String getHomeDirectoryTypeAsString() {
            return homeDirectoryType;
        }

        @Override
        public final Builder homeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
            return this;
        }

        @Override
        public final Builder homeDirectoryType(HomeDirectoryType homeDirectoryType) {
            this.homeDirectoryType(homeDirectoryType == null ? null : homeDirectoryType.toString());
            return this;
        }

        public final void setHomeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final Integer getSshPublicKeyCount() {
            return sshPublicKeyCount;
        }

        @Override
        public final Builder sshPublicKeyCount(Integer sshPublicKeyCount) {
            this.sshPublicKeyCount = sshPublicKeyCount;
            return this;
        }

        public final void setSshPublicKeyCount(Integer sshPublicKeyCount) {
            this.sshPublicKeyCount = sshPublicKeyCount;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public ListedUser build() {
            return new ListedUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
