/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestIdentityProviderRequest extends TransferRequest implements
        ToCopyableBuilder<TestIdentityProviderRequest.Builder, TestIdentityProviderRequest> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestIdentityProviderRequest::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<String> SERVER_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestIdentityProviderRequest::serverProtocolAsString)).setter(setter(Builder::serverProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerProtocol").build()).build();

    private static final SdkField<String> SOURCE_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestIdentityProviderRequest::sourceIp)).setter(setter(Builder::sourceIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIp").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestIdentityProviderRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestIdentityProviderRequest::userPassword)).setter(setter(Builder::userPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD,
            SERVER_PROTOCOL_FIELD, SOURCE_IP_FIELD, USER_NAME_FIELD, USER_PASSWORD_FIELD));

    private final String serverId;

    private final String serverProtocol;

    private final String sourceIp;

    private final String userName;

    private final String userPassword;

    private TestIdentityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.serverProtocol = builder.serverProtocol;
        this.sourceIp = builder.sourceIp;
        this.userName = builder.userName;
        this.userPassword = builder.userPassword;
    }

    /**
     * <p>
     * A system-assigned identifier for a specific file transfer protocol-enabled server. That server's user
     * authentication method is tested with a user name and password.
     * </p>
     * 
     * @return A system-assigned identifier for a specific file transfer protocol-enabled server. That server's user
     *         authentication method is tested with a user name and password.
     */
    public String serverId() {
        return serverId;
    }

    /**
     * <p>
     * The type of file transfer protocol to be tested.
     * </p>
     * <p>
     * The available protocols are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secure Shell (SSH) File Transfer Protocol (SFTP)
     * </p>
     * </li>
     * <li>
     * <p>
     * File Transfer Protocol Secure (FTPS)
     * </p>
     * </li>
     * <li>
     * <p>
     * File Transfer Protocol (FTP)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverProtocol}
     * will return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverProtocolAsString}.
     * </p>
     * 
     * @return The type of file transfer protocol to be tested.</p>
     *         <p>
     *         The available protocols are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Secure Shell (SSH) File Transfer Protocol (SFTP)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         File Transfer Protocol Secure (FTPS)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         File Transfer Protocol (FTP)
     *         </p>
     *         </li>
     * @see Protocol
     */
    public Protocol serverProtocol() {
        return Protocol.fromValue(serverProtocol);
    }

    /**
     * <p>
     * The type of file transfer protocol to be tested.
     * </p>
     * <p>
     * The available protocols are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secure Shell (SSH) File Transfer Protocol (SFTP)
     * </p>
     * </li>
     * <li>
     * <p>
     * File Transfer Protocol Secure (FTPS)
     * </p>
     * </li>
     * <li>
     * <p>
     * File Transfer Protocol (FTP)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverProtocol}
     * will return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serverProtocolAsString}.
     * </p>
     * 
     * @return The type of file transfer protocol to be tested.</p>
     *         <p>
     *         The available protocols are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Secure Shell (SSH) File Transfer Protocol (SFTP)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         File Transfer Protocol Secure (FTPS)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         File Transfer Protocol (FTP)
     *         </p>
     *         </li>
     * @see Protocol
     */
    public String serverProtocolAsString() {
        return serverProtocol;
    }

    /**
     * <p>
     * The source IP address of the user account to be tested.
     * </p>
     * 
     * @return The source IP address of the user account to be tested.
     */
    public String sourceIp() {
        return sourceIp;
    }

    /**
     * <p>
     * The name of the user account to be tested.
     * </p>
     * 
     * @return The name of the user account to be tested.
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * The password of the user account to be tested.
     * </p>
     * 
     * @return The password of the user account to be tested.
     */
    public String userPassword() {
        return userPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(serverProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIp());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(userPassword());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestIdentityProviderRequest)) {
            return false;
        }
        TestIdentityProviderRequest other = (TestIdentityProviderRequest) obj;
        return Objects.equals(serverId(), other.serverId())
                && Objects.equals(serverProtocolAsString(), other.serverProtocolAsString())
                && Objects.equals(sourceIp(), other.sourceIp()) && Objects.equals(userName(), other.userName())
                && Objects.equals(userPassword(), other.userPassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TestIdentityProviderRequest").add("ServerId", serverId())
                .add("ServerProtocol", serverProtocolAsString()).add("SourceIp", sourceIp()).add("UserName", userName())
                .add("UserPassword", userPassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "ServerProtocol":
            return Optional.ofNullable(clazz.cast(serverProtocolAsString()));
        case "SourceIp":
            return Optional.ofNullable(clazz.cast(sourceIp()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "UserPassword":
            return Optional.ofNullable(clazz.cast(userPassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestIdentityProviderRequest, T> g) {
        return obj -> g.apply((TestIdentityProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestIdentityProviderRequest> {
        /**
         * <p>
         * A system-assigned identifier for a specific file transfer protocol-enabled server. That server's user
         * authentication method is tested with a user name and password.
         * </p>
         * 
         * @param serverId
         *        A system-assigned identifier for a specific file transfer protocol-enabled server. That server's user
         *        authentication method is tested with a user name and password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * The type of file transfer protocol to be tested.
         * </p>
         * <p>
         * The available protocols are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Secure Shell (SSH) File Transfer Protocol (SFTP)
         * </p>
         * </li>
         * <li>
         * <p>
         * File Transfer Protocol Secure (FTPS)
         * </p>
         * </li>
         * <li>
         * <p>
         * File Transfer Protocol (FTP)
         * </p>
         * </li>
         * </ul>
         * 
         * @param serverProtocol
         *        The type of file transfer protocol to be tested.</p>
         *        <p>
         *        The available protocols are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Secure Shell (SSH) File Transfer Protocol (SFTP)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        File Transfer Protocol Secure (FTPS)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        File Transfer Protocol (FTP)
         *        </p>
         *        </li>
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder serverProtocol(String serverProtocol);

        /**
         * <p>
         * The type of file transfer protocol to be tested.
         * </p>
         * <p>
         * The available protocols are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Secure Shell (SSH) File Transfer Protocol (SFTP)
         * </p>
         * </li>
         * <li>
         * <p>
         * File Transfer Protocol Secure (FTPS)
         * </p>
         * </li>
         * <li>
         * <p>
         * File Transfer Protocol (FTP)
         * </p>
         * </li>
         * </ul>
         * 
         * @param serverProtocol
         *        The type of file transfer protocol to be tested.</p>
         *        <p>
         *        The available protocols are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Secure Shell (SSH) File Transfer Protocol (SFTP)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        File Transfer Protocol Secure (FTPS)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        File Transfer Protocol (FTP)
         *        </p>
         *        </li>
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder serverProtocol(Protocol serverProtocol);

        /**
         * <p>
         * The source IP address of the user account to be tested.
         * </p>
         * 
         * @param sourceIp
         *        The source IP address of the user account to be tested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIp(String sourceIp);

        /**
         * <p>
         * The name of the user account to be tested.
         * </p>
         * 
         * @param userName
         *        The name of the user account to be tested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The password of the user account to be tested.
         * </p>
         * 
         * @param userPassword
         *        The password of the user account to be tested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPassword(String userPassword);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private String serverId;

        private String serverProtocol;

        private String sourceIp;

        private String userName;

        private String userPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(TestIdentityProviderRequest model) {
            super(model);
            serverId(model.serverId);
            serverProtocol(model.serverProtocol);
            sourceIp(model.sourceIp);
            userName(model.userName);
            userPassword(model.userPassword);
        }

        public final String getServerId() {
            return serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final String getServerProtocol() {
            return serverProtocol;
        }

        @Override
        public final Builder serverProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
            return this;
        }

        @Override
        public final Builder serverProtocol(Protocol serverProtocol) {
            this.serverProtocol(serverProtocol == null ? null : serverProtocol.toString());
            return this;
        }

        public final void setServerProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
        }

        public final String getSourceIp() {
            return sourceIp;
        }

        @Override
        public final Builder sourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        public final void setSourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getUserPassword() {
            return userPassword;
        }

        @Override
        public final Builder userPassword(String userPassword) {
            this.userPassword = userPassword;
            return this;
        }

        public final void setUserPassword(String userPassword) {
            this.userPassword = userPassword;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestIdentityProviderRequest build() {
            return new TestIdentityProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
