/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an object that contains entries and targets for <code>HomeDirectoryMappings</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HomeDirectoryMapEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<HomeDirectoryMapEntry.Builder, HomeDirectoryMapEntry> {
    private static final SdkField<String> ENTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HomeDirectoryMapEntry::entry)).setter(setter(Builder::entry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entry").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HomeDirectoryMapEntry::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_FIELD, TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entry;

    private final String target;

    private HomeDirectoryMapEntry(BuilderImpl builder) {
        this.entry = builder.entry;
        this.target = builder.target;
    }

    /**
     * <p>
     * Represents an entry and a target for <code>HomeDirectoryMappings</code>.
     * </p>
     * 
     * @return Represents an entry and a target for <code>HomeDirectoryMappings</code>.
     */
    public String entry() {
        return entry;
    }

    /**
     * <p>
     * Represents the map target that is used in a <code>HomeDirectorymapEntry</code>.
     * </p>
     * 
     * @return Represents the map target that is used in a <code>HomeDirectorymapEntry</code>.
     */
    public String target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entry());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HomeDirectoryMapEntry)) {
            return false;
        }
        HomeDirectoryMapEntry other = (HomeDirectoryMapEntry) obj;
        return Objects.equals(entry(), other.entry()) && Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HomeDirectoryMapEntry").add("Entry", entry()).add("Target", target()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entry":
            return Optional.ofNullable(clazz.cast(entry()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HomeDirectoryMapEntry, T> g) {
        return obj -> g.apply((HomeDirectoryMapEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HomeDirectoryMapEntry> {
        /**
         * <p>
         * Represents an entry and a target for <code>HomeDirectoryMappings</code>.
         * </p>
         * 
         * @param entry
         *        Represents an entry and a target for <code>HomeDirectoryMappings</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entry(String entry);

        /**
         * <p>
         * Represents the map target that is used in a <code>HomeDirectorymapEntry</code>.
         * </p>
         * 
         * @param target
         *        Represents the map target that is used in a <code>HomeDirectorymapEntry</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);
    }

    static final class BuilderImpl implements Builder {
        private String entry;

        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(HomeDirectoryMapEntry model) {
            entry(model.entry);
            target(model.target);
        }

        public final String getEntry() {
            return entry;
        }

        @Override
        public final Builder entry(String entry) {
            this.entry = entry;
            return this;
        }

        public final void setEntry(String entry) {
            this.entry = entry;
        }

        public final String getTarget() {
            return target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public HomeDirectoryMapEntry build() {
            return new HomeDirectoryMapEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
