/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The virtual private cloud (VPC) endpoint settings that are configured for your file transfer protocol-enabled server.
 * With a VPC endpoint, you can restrict access to your server and resources only within your VPC. To control incoming
 * internet traffic, invoke the <code>UpdateServer</code> API and attach an Elastic IP to your server's endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointDetails implements SdkPojo, Serializable, ToCopyableBuilder<EndpointDetails.Builder, EndpointDetails> {
    private static final SdkField<List<String>> ADDRESS_ALLOCATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddressAllocationIds")
            .getter(getter(EndpointDetails::addressAllocationIds))
            .setter(setter(Builder::addressAllocationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressAllocationIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(EndpointDetails::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId").getter(getter(EndpointDetails::vpcEndpointId)).setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(EndpointDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(EndpointDetails::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_ALLOCATION_IDS_FIELD,
            SUBNET_IDS_FIELD, VPC_ENDPOINT_ID_FIELD, VPC_ID_FIELD, SECURITY_GROUP_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> addressAllocationIds;

    private final List<String> subnetIds;

    private final String vpcEndpointId;

    private final String vpcId;

    private final List<String> securityGroupIds;

    private EndpointDetails(BuilderImpl builder) {
        this.addressAllocationIds = builder.addressAllocationIds;
        this.subnetIds = builder.subnetIds;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcId = builder.vpcId;
        this.securityGroupIds = builder.securityGroupIds;
    }

    /**
     * Returns true if the AddressAllocationIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAddressAllocationIds() {
        return addressAllocationIds != null && !(addressAllocationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.
     * </p>
     * <note>
     * <p>
     * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> and it is only valid in
     * the <code>UpdateServer</code> API.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAddressAllocationIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of address allocation IDs that are required to attach an Elastic IP address to your server's
     *         endpoint.</p> <note>
     *         <p>
     *         This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> and it is only
     *         valid in the <code>UpdateServer</code> API.
     *         </p>
     */
    public List<String> addressAllocationIds() {
        return addressAllocationIds;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of subnet IDs that are required to host your server endpoint in your VPC.
     * </p>
     * <note>
     * <p>
     * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of subnet IDs that are required to host your server endpoint in your VPC.</p> <note>
     *         <p>
     *         This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
     *         </p>
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The ID of the VPC endpoint.
     * </p>
     * <note>
     * <p>
     * This property can only be set when <code>EndpointType</code> is set to <code>VPC_ENDPOINT</code>.
     * </p>
     * </note>
     * 
     * @return The ID of the VPC endpoint.</p> <note>
     *         <p>
     *         This property can only be set when <code>EndpointType</code> is set to <code>VPC_ENDPOINT</code>.
     *         </p>
     */
    public String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * The VPC ID of the VPC in which a server's endpoint will be hosted.
     * </p>
     * <note>
     * <p>
     * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
     * </p>
     * </note>
     * 
     * @return The VPC ID of the VPC in which a server's endpoint will be hosted.</p> <note>
     *         <p>
     *         This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
     *         </p>
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security groups IDs that are available to attach to your server's endpoint.
     * </p>
     * <note>
     * <p>
     * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
     * </p>
     * <p>
     * You can only edit the <code>SecurityGroupIds</code> property in the <code>UpdateServer</code> API and only if you
     * are changing the <code>EndpointType</code> from <code>PUBLIC</code> or <code>VPC_ENDPOINT</code> to
     * <code>VPC</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of security groups IDs that are available to attach to your server's endpoint.</p> <note>
     *         <p>
     *         This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
     *         </p>
     *         <p>
     *         You can only edit the <code>SecurityGroupIds</code> property in the <code>UpdateServer</code> API and
     *         only if you are changing the <code>EndpointType</code> from <code>PUBLIC</code> or
     *         <code>VPC_ENDPOINT</code> to <code>VPC</code>.
     *         </p>
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addressAllocationIds());
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointDetails)) {
            return false;
        }
        EndpointDetails other = (EndpointDetails) obj;
        return Objects.equals(addressAllocationIds(), other.addressAllocationIds())
                && Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(vpcEndpointId(), other.vpcEndpointId())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(securityGroupIds(), other.securityGroupIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EndpointDetails").add("AddressAllocationIds", addressAllocationIds())
                .add("SubnetIds", subnetIds()).add("VpcEndpointId", vpcEndpointId()).add("VpcId", vpcId())
                .add("SecurityGroupIds", securityGroupIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddressAllocationIds":
            return Optional.ofNullable(clazz.cast(addressAllocationIds()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointDetails, T> g) {
        return obj -> g.apply((EndpointDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointDetails> {
        /**
         * <p>
         * A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.
         * </p>
         * <note>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> and it is only valid
         * in the <code>UpdateServer</code> API.
         * </p>
         * </note>
         * 
         * @param addressAllocationIds
         *        A list of address allocation IDs that are required to attach an Elastic IP address to your server's
         *        endpoint.</p> <note>
         *        <p>
         *        This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> and it is only
         *        valid in the <code>UpdateServer</code> API.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressAllocationIds(Collection<String> addressAllocationIds);

        /**
         * <p>
         * A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.
         * </p>
         * <note>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> and it is only valid
         * in the <code>UpdateServer</code> API.
         * </p>
         * </note>
         * 
         * @param addressAllocationIds
         *        A list of address allocation IDs that are required to attach an Elastic IP address to your server's
         *        endpoint.</p> <note>
         *        <p>
         *        This property can only be set when <code>EndpointType</code> is set to <code>VPC</code> and it is only
         *        valid in the <code>UpdateServer</code> API.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressAllocationIds(String... addressAllocationIds);

        /**
         * <p>
         * A list of subnet IDs that are required to host your server endpoint in your VPC.
         * </p>
         * <note>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
         * </p>
         * </note>
         * 
         * @param subnetIds
         *        A list of subnet IDs that are required to host your server endpoint in your VPC.</p> <note>
         *        <p>
         *        This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of subnet IDs that are required to host your server endpoint in your VPC.
         * </p>
         * <note>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
         * </p>
         * </note>
         * 
         * @param subnetIds
         *        A list of subnet IDs that are required to host your server endpoint in your VPC.</p> <note>
         *        <p>
         *        This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The ID of the VPC endpoint.
         * </p>
         * <note>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC_ENDPOINT</code>.
         * </p>
         * </note>
         * 
         * @param vpcEndpointId
         *        The ID of the VPC endpoint.</p> <note>
         *        <p>
         *        This property can only be set when <code>EndpointType</code> is set to <code>VPC_ENDPOINT</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * The VPC ID of the VPC in which a server's endpoint will be hosted.
         * </p>
         * <note>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
         * </p>
         * </note>
         * 
         * @param vpcId
         *        The VPC ID of the VPC in which a server's endpoint will be hosted.</p> <note>
         *        <p>
         *        This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * A list of security groups IDs that are available to attach to your server's endpoint.
         * </p>
         * <note>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
         * </p>
         * <p>
         * You can only edit the <code>SecurityGroupIds</code> property in the <code>UpdateServer</code> API and only if
         * you are changing the <code>EndpointType</code> from <code>PUBLIC</code> or <code>VPC_ENDPOINT</code> to
         * <code>VPC</code>.
         * </p>
         * </note>
         * 
         * @param securityGroupIds
         *        A list of security groups IDs that are available to attach to your server's endpoint.</p> <note>
         *        <p>
         *        This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
         *        </p>
         *        <p>
         *        You can only edit the <code>SecurityGroupIds</code> property in the <code>UpdateServer</code> API and
         *        only if you are changing the <code>EndpointType</code> from <code>PUBLIC</code> or
         *        <code>VPC_ENDPOINT</code> to <code>VPC</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * A list of security groups IDs that are available to attach to your server's endpoint.
         * </p>
         * <note>
         * <p>
         * This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
         * </p>
         * <p>
         * You can only edit the <code>SecurityGroupIds</code> property in the <code>UpdateServer</code> API and only if
         * you are changing the <code>EndpointType</code> from <code>PUBLIC</code> or <code>VPC_ENDPOINT</code> to
         * <code>VPC</code>.
         * </p>
         * </note>
         * 
         * @param securityGroupIds
         *        A list of security groups IDs that are available to attach to your server's endpoint.</p> <note>
         *        <p>
         *        This property can only be set when <code>EndpointType</code> is set to <code>VPC</code>.
         *        </p>
         *        <p>
         *        You can only edit the <code>SecurityGroupIds</code> property in the <code>UpdateServer</code> API and
         *        only if you are changing the <code>EndpointType</code> from <code>PUBLIC</code> or
         *        <code>VPC_ENDPOINT</code> to <code>VPC</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> addressAllocationIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String vpcEndpointId;

        private String vpcId;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointDetails model) {
            addressAllocationIds(model.addressAllocationIds);
            subnetIds(model.subnetIds);
            vpcEndpointId(model.vpcEndpointId);
            vpcId(model.vpcId);
            securityGroupIds(model.securityGroupIds);
        }

        public final Collection<String> getAddressAllocationIds() {
            return addressAllocationIds;
        }

        @Override
        public final Builder addressAllocationIds(Collection<String> addressAllocationIds) {
            this.addressAllocationIds = AddressAllocationIdsCopier.copy(addressAllocationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addressAllocationIds(String... addressAllocationIds) {
            addressAllocationIds(Arrays.asList(addressAllocationIds));
            return this;
        }

        public final void setAddressAllocationIds(Collection<String> addressAllocationIds) {
            this.addressAllocationIds = AddressAllocationIdsCopier.copy(addressAllocationIds);
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public EndpointDetails build() {
            return new EndpointDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
