/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSecurityPoliciesResponse extends TransferResponse implements
        ToCopyableBuilder<ListSecurityPoliciesResponse.Builder, ListSecurityPoliciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSecurityPoliciesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<String>> SECURITY_POLICY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityPolicyNames")
            .getter(getter(ListSecurityPoliciesResponse::securityPolicyNames))
            .setter(setter(Builder::securityPolicyNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityPolicyNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SECURITY_POLICY_NAMES_FIELD));

    private final String nextToken;

    private final List<String> securityPolicyNames;

    private ListSecurityPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.securityPolicyNames = builder.securityPolicyNames;
    }

    /**
     * <p>
     * When you can get additional results from the <code>ListSecurityPolicies</code> operation, a
     * <code>NextToken</code> parameter is returned in the output. In a following command, you can pass in the
     * <code>NextToken</code> parameter to continue listing security policies.
     * </p>
     * 
     * @return When you can get additional results from the <code>ListSecurityPolicies</code> operation, a
     *         <code>NextToken</code> parameter is returned in the output. In a following command, you can pass in the
     *         <code>NextToken</code> parameter to continue listing security policies.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the SecurityPolicyNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSecurityPolicyNames() {
        return securityPolicyNames != null && !(securityPolicyNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of security policies that were listed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityPolicyNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of security policies that were listed.
     */
    public List<String> securityPolicyNames() {
        return securityPolicyNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityPolicyNames() ? securityPolicyNames() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityPoliciesResponse)) {
            return false;
        }
        ListSecurityPoliciesResponse other = (ListSecurityPoliciesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSecurityPolicyNames() == other.hasSecurityPolicyNames()
                && Objects.equals(securityPolicyNames(), other.securityPolicyNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSecurityPoliciesResponse").add("NextToken", nextToken())
                .add("SecurityPolicyNames", hasSecurityPolicyNames() ? securityPolicyNames() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SecurityPolicyNames":
            return Optional.ofNullable(clazz.cast(securityPolicyNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityPoliciesResponse, T> g) {
        return obj -> g.apply((ListSecurityPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSecurityPoliciesResponse> {
        /**
         * <p>
         * When you can get additional results from the <code>ListSecurityPolicies</code> operation, a
         * <code>NextToken</code> parameter is returned in the output. In a following command, you can pass in the
         * <code>NextToken</code> parameter to continue listing security policies.
         * </p>
         * 
         * @param nextToken
         *        When you can get additional results from the <code>ListSecurityPolicies</code> operation, a
         *        <code>NextToken</code> parameter is returned in the output. In a following command, you can pass in
         *        the <code>NextToken</code> parameter to continue listing security policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of security policies that were listed.
         * </p>
         * 
         * @param securityPolicyNames
         *        An array of security policies that were listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityPolicyNames(Collection<String> securityPolicyNames);

        /**
         * <p>
         * An array of security policies that were listed.
         * </p>
         * 
         * @param securityPolicyNames
         *        An array of security policies that were listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityPolicyNames(String... securityPolicyNames);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<String> securityPolicyNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityPoliciesResponse model) {
            super(model);
            nextToken(model.nextToken);
            securityPolicyNames(model.securityPolicyNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getSecurityPolicyNames() {
            if (securityPolicyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return securityPolicyNames;
        }

        @Override
        public final Builder securityPolicyNames(Collection<String> securityPolicyNames) {
            this.securityPolicyNames = SecurityPolicyNamesCopier.copy(securityPolicyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityPolicyNames(String... securityPolicyNames) {
            securityPolicyNames(Arrays.asList(securityPolicyNames));
            return this;
        }

        public final void setSecurityPolicyNames(Collection<String> securityPolicyNames) {
            this.securityPolicyNames = SecurityPolicyNamesCopier.copy(securityPolicyNames);
        }

        @Override
        public ListSecurityPoliciesResponse build() {
            return new ListSecurityPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
