/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSecurityPolicyResponse extends TransferResponse implements
        ToCopyableBuilder<DescribeSecurityPolicyResponse.Builder, DescribeSecurityPolicyResponse> {
    private static final SdkField<DescribedSecurityPolicy> SECURITY_POLICY_FIELD = SdkField
            .<DescribedSecurityPolicy> builder(MarshallingType.SDK_POJO).memberName("SecurityPolicy")
            .getter(getter(DescribeSecurityPolicyResponse::securityPolicy)).setter(setter(Builder::securityPolicy))
            .constructor(DescribedSecurityPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_POLICY_FIELD));

    private final DescribedSecurityPolicy securityPolicy;

    private DescribeSecurityPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.securityPolicy = builder.securityPolicy;
    }

    /**
     * <p>
     * An array containing the properties of the security policy.
     * </p>
     * 
     * @return An array containing the properties of the security policy.
     */
    public final DescribedSecurityPolicy securityPolicy() {
        return securityPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(securityPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityPolicyResponse)) {
            return false;
        }
        DescribeSecurityPolicyResponse other = (DescribeSecurityPolicyResponse) obj;
        return Objects.equals(securityPolicy(), other.securityPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSecurityPolicyResponse").add("SecurityPolicy", securityPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityPolicy":
            return Optional.ofNullable(clazz.cast(securityPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSecurityPolicyResponse, T> g) {
        return obj -> g.apply((DescribeSecurityPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSecurityPolicyResponse> {
        /**
         * <p>
         * An array containing the properties of the security policy.
         * </p>
         * 
         * @param securityPolicy
         *        An array containing the properties of the security policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityPolicy(DescribedSecurityPolicy securityPolicy);

        /**
         * <p>
         * An array containing the properties of the security policy.
         * </p>
         * This is a convenience that creates an instance of the {@link DescribedSecurityPolicy.Builder} avoiding the
         * need to create one manually via {@link DescribedSecurityPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link DescribedSecurityPolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #securityPolicy(DescribedSecurityPolicy)}.
         * 
         * @param securityPolicy
         *        a consumer that will call methods on {@link DescribedSecurityPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityPolicy(DescribedSecurityPolicy)
         */
        default Builder securityPolicy(Consumer<DescribedSecurityPolicy.Builder> securityPolicy) {
            return securityPolicy(DescribedSecurityPolicy.builder().applyMutation(securityPolicy).build());
        }
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private DescribedSecurityPolicy securityPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityPolicyResponse model) {
            super(model);
            securityPolicy(model.securityPolicy);
        }

        public final DescribedSecurityPolicy.Builder getSecurityPolicy() {
            return securityPolicy != null ? securityPolicy.toBuilder() : null;
        }

        @Override
        public final Builder securityPolicy(DescribedSecurityPolicy securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        public final void setSecurityPolicy(DescribedSecurityPolicy.BuilderImpl securityPolicy) {
            this.securityPolicy = securityPolicy != null ? securityPolicy.build() : null;
        }

        @Override
        public DescribeSecurityPolicyResponse build() {
            return new DescribeSecurityPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
