/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of a user that was specified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribedUser implements SdkPojo, Serializable, ToCopyableBuilder<DescribedUser.Builder, DescribedUser> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribedUser::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> HOME_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeDirectory").getter(getter(DescribedUser::homeDirectory)).setter(setter(Builder::homeDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectory").build()).build();

    private static final SdkField<List<HomeDirectoryMapEntry>> HOME_DIRECTORY_MAPPINGS_FIELD = SdkField
            .<List<HomeDirectoryMapEntry>> builder(MarshallingType.LIST)
            .memberName("HomeDirectoryMappings")
            .getter(getter(DescribedUser::homeDirectoryMappings))
            .setter(setter(Builder::homeDirectoryMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectoryMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HomeDirectoryMapEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(HomeDirectoryMapEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HOME_DIRECTORY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeDirectoryType").getter(getter(DescribedUser::homeDirectoryTypeAsString))
            .setter(setter(Builder::homeDirectoryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectoryType").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Policy")
            .getter(getter(DescribedUser::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final SdkField<PosixProfile> POSIX_PROFILE_FIELD = SdkField.<PosixProfile> builder(MarshallingType.SDK_POJO)
            .memberName("PosixProfile").getter(getter(DescribedUser::posixProfile)).setter(setter(Builder::posixProfile))
            .constructor(PosixProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PosixProfile").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(DescribedUser::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<List<SshPublicKey>> SSH_PUBLIC_KEYS_FIELD = SdkField
            .<List<SshPublicKey>> builder(MarshallingType.LIST)
            .memberName("SshPublicKeys")
            .getter(getter(DescribedUser::sshPublicKeys))
            .setter(setter(Builder::sshPublicKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SshPublicKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(SshPublicKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(DescribedUser::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(DescribedUser::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            HOME_DIRECTORY_FIELD, HOME_DIRECTORY_MAPPINGS_FIELD, HOME_DIRECTORY_TYPE_FIELD, POLICY_FIELD, POSIX_PROFILE_FIELD,
            ROLE_FIELD, SSH_PUBLIC_KEYS_FIELD, TAGS_FIELD, USER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String homeDirectory;

    private final List<HomeDirectoryMapEntry> homeDirectoryMappings;

    private final String homeDirectoryType;

    private final String policy;

    private final PosixProfile posixProfile;

    private final String role;

    private final List<SshPublicKey> sshPublicKeys;

    private final List<Tag> tags;

    private final String userName;

    private DescribedUser(BuilderImpl builder) {
        this.arn = builder.arn;
        this.homeDirectory = builder.homeDirectory;
        this.homeDirectoryMappings = builder.homeDirectoryMappings;
        this.homeDirectoryType = builder.homeDirectoryType;
        this.policy = builder.policy;
        this.posixProfile = builder.posixProfile;
        this.role = builder.role;
        this.sshPublicKeys = builder.sshPublicKeys;
        this.tags = builder.tags;
        this.userName = builder.userName;
    }

    /**
     * <p>
     * Specifies the unique Amazon Resource Name (ARN) for the user that was requested to be described.
     * </p>
     * 
     * @return Specifies the unique Amazon Resource Name (ARN) for the user that was requested to be described.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Specifies the landing directory (or folder), which is the location that files are written to or read from in an
     * Amazon S3 bucket, for the described user. An example is <i>
     * <code>your-Amazon-S3-bucket-name&gt;/home/username</code> </i>.
     * </p>
     * 
     * @return Specifies the landing directory (or folder), which is the location that files are written to or read from
     *         in an Amazon S3 bucket, for the described user. An example is <i>
     *         <code>your-Amazon-S3-bucket-name&gt;/home/username</code> </i>.
     */
    public final String homeDirectory() {
        return homeDirectory;
    }

    /**
     * Returns true if the HomeDirectoryMappings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasHomeDirectoryMappings() {
        return homeDirectoryMappings != null && !(homeDirectoryMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the logical directory mappings that specify what Amazon S3 or EFS paths and keys should be visible to
     * your user and how you want to make them visible. You will need to specify the "<code>Entry</code>" and "
     * <code>Target</code>" pair, where <code>Entry</code> shows how the path is made visible and <code>Target</code> is
     * the actual Amazon S3 or EFS path. If you only specify a target, it will be displayed as is. You will need to also
     * make sure that your AWS Identity and Access Management (IAM) role provides access to paths in <code>Target</code>
     * .
     * </p>
     * <p>
     * In most cases, you can use this value instead of the scope-down policy to lock your user down to the designated
     * home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and set
     * <code>Target</code> to the HomeDirectory parameter value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHomeDirectoryMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the logical directory mappings that specify what Amazon S3 or EFS paths and keys should be
     *         visible to your user and how you want to make them visible. You will need to specify the "
     *         <code>Entry</code>" and "<code>Target</code>" pair, where <code>Entry</code> shows how the path is made
     *         visible and <code>Target</code> is the actual Amazon S3 or EFS path. If you only specify a target, it
     *         will be displayed as is. You will need to also make sure that your AWS Identity and Access Management
     *         (IAM) role provides access to paths in <code>Target</code>.</p>
     *         <p>
     *         In most cases, you can use this value instead of the scope-down policy to lock your user down to the
     *         designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and
     *         set <code>Target</code> to the HomeDirectory parameter value.
     */
    public final List<HomeDirectoryMapEntry> homeDirectoryMappings() {
        return homeDirectoryMappings;
    }

    /**
     * <p>
     * Specifies the type of landing directory (folder) you mapped for your users to see when they log into the file
     * transfer protocol-enabled server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3
     * bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you will
     * need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS
     * paths visible to your users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #homeDirectoryType}
     * will return {@link HomeDirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #homeDirectoryTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of landing directory (folder) you mapped for your users to see when they log into the
     *         file transfer protocol-enabled server. If you set it to <code>PATH</code>, the user will see the absolute
     *         Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it
     *         <code>LOGICAL</code>, you will need to provide mappings in the <code>HomeDirectoryMappings</code> for how
     *         you want to make Amazon S3 or EFS paths visible to your users.
     * @see HomeDirectoryType
     */
    public final HomeDirectoryType homeDirectoryType() {
        return HomeDirectoryType.fromValue(homeDirectoryType);
    }

    /**
     * <p>
     * Specifies the type of landing directory (folder) you mapped for your users to see when they log into the file
     * transfer protocol-enabled server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3
     * bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you will
     * need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS
     * paths visible to your users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #homeDirectoryType}
     * will return {@link HomeDirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #homeDirectoryTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of landing directory (folder) you mapped for your users to see when they log into the
     *         file transfer protocol-enabled server. If you set it to <code>PATH</code>, the user will see the absolute
     *         Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it
     *         <code>LOGICAL</code>, you will need to provide mappings in the <code>HomeDirectoryMappings</code> for how
     *         you want to make Amazon S3 or EFS paths visible to your users.
     * @see HomeDirectoryType
     */
    public final String homeDirectoryTypeAsString() {
        return homeDirectoryType;
    }

    /**
     * <p>
     * Specifies the name of the policy in use for the described user.
     * </p>
     * 
     * @return Specifies the name of the policy in use for the described user.
     */
    public final String policy() {
        return policy;
    }

    /**
     * <p>
     * Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any
     * secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon Elastic File
     * System (Amazon EFS) file systems. The POSIX permissions that are set on files and directories in your file system
     * determine the level of access your users get when transferring files into and out of your Amazon EFS file
     * systems.
     * </p>
     * 
     * @return Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and
     *         any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon
     *         Elastic File System (Amazon EFS) file systems. The POSIX permissions that are set on files and
     *         directories in your file system determine the level of access your users get when transferring files into
     *         and out of your Amazon EFS file systems.
     */
    public final PosixProfile posixProfile() {
        return posixProfile;
    }

    /**
     * <p>
     * The IAM role that controls your users' access to your Amazon S3 bucket. The policies attached to this role will
     * determine the level of access you want to provide your users when transferring files into and out of your Amazon
     * S3 bucket or buckets. The IAM role should also contain a trust relationship that allows a server to access your
     * resources when servicing your users' transfer requests.
     * </p>
     * 
     * @return The IAM role that controls your users' access to your Amazon S3 bucket. The policies attached to this
     *         role will determine the level of access you want to provide your users when transferring files into and
     *         out of your Amazon S3 bucket or buckets. The IAM role should also contain a trust relationship that
     *         allows a server to access your resources when servicing your users' transfer requests.
     */
    public final String role() {
        return role;
    }

    /**
     * Returns true if the SshPublicKeys property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSshPublicKeys() {
        return sshPublicKeys != null && !(sshPublicKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSshPublicKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.
     */
    public final List<SshPublicKey> sshPublicKeys() {
        return sshPublicKeys;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the key-value pairs for the user requested. Tag can be used to search for and group users for a variety
     * of purposes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the key-value pairs for the user requested. Tag can be used to search for and group users for a
     *         variety of purposes.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies the name of the user that was requested to be described. User names are used for authentication
     * purposes. This is the string that will be used by your user when they log in to your server.
     * </p>
     * 
     * @return Specifies the name of the user that was requested to be described. User names are used for authentication
     *         purposes. This is the string that will be used by your user when they log in to your server.
     */
    public final String userName() {
        return userName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(homeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(hasHomeDirectoryMappings() ? homeDirectoryMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(homeDirectoryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(posixProfile());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(hasSshPublicKeys() ? sshPublicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedUser)) {
            return false;
        }
        DescribedUser other = (DescribedUser) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(homeDirectory(), other.homeDirectory())
                && hasHomeDirectoryMappings() == other.hasHomeDirectoryMappings()
                && Objects.equals(homeDirectoryMappings(), other.homeDirectoryMappings())
                && Objects.equals(homeDirectoryTypeAsString(), other.homeDirectoryTypeAsString())
                && Objects.equals(policy(), other.policy()) && Objects.equals(posixProfile(), other.posixProfile())
                && Objects.equals(role(), other.role()) && hasSshPublicKeys() == other.hasSshPublicKeys()
                && Objects.equals(sshPublicKeys(), other.sshPublicKeys()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(userName(), other.userName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribedUser").add("Arn", arn()).add("HomeDirectory", homeDirectory())
                .add("HomeDirectoryMappings", hasHomeDirectoryMappings() ? homeDirectoryMappings() : null)
                .add("HomeDirectoryType", homeDirectoryTypeAsString()).add("Policy", policy())
                .add("PosixProfile", posixProfile()).add("Role", role())
                .add("SshPublicKeys", hasSshPublicKeys() ? sshPublicKeys() : null).add("Tags", hasTags() ? tags() : null)
                .add("UserName", userName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "HomeDirectory":
            return Optional.ofNullable(clazz.cast(homeDirectory()));
        case "HomeDirectoryMappings":
            return Optional.ofNullable(clazz.cast(homeDirectoryMappings()));
        case "HomeDirectoryType":
            return Optional.ofNullable(clazz.cast(homeDirectoryTypeAsString()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "PosixProfile":
            return Optional.ofNullable(clazz.cast(posixProfile()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "SshPublicKeys":
            return Optional.ofNullable(clazz.cast(sshPublicKeys()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribedUser, T> g) {
        return obj -> g.apply((DescribedUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribedUser> {
        /**
         * <p>
         * Specifies the unique Amazon Resource Name (ARN) for the user that was requested to be described.
         * </p>
         * 
         * @param arn
         *        Specifies the unique Amazon Resource Name (ARN) for the user that was requested to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Specifies the landing directory (or folder), which is the location that files are written to or read from in
         * an Amazon S3 bucket, for the described user. An example is <i>
         * <code>your-Amazon-S3-bucket-name&gt;/home/username</code> </i>.
         * </p>
         * 
         * @param homeDirectory
         *        Specifies the landing directory (or folder), which is the location that files are written to or read
         *        from in an Amazon S3 bucket, for the described user. An example is <i>
         *        <code>your-Amazon-S3-bucket-name&gt;/home/username</code> </i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeDirectory(String homeDirectory);

        /**
         * <p>
         * Specifies the logical directory mappings that specify what Amazon S3 or EFS paths and keys should be visible
         * to your user and how you want to make them visible. You will need to specify the "<code>Entry</code>" and "
         * <code>Target</code>" pair, where <code>Entry</code> shows how the path is made visible and
         * <code>Target</code> is the actual Amazon S3 or EFS path. If you only specify a target, it will be displayed
         * as is. You will need to also make sure that your AWS Identity and Access Management (IAM) role provides
         * access to paths in <code>Target</code>.
         * </p>
         * <p>
         * In most cases, you can use this value instead of the scope-down policy to lock your user down to the
         * designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and set
         * <code>Target</code> to the HomeDirectory parameter value.
         * </p>
         * 
         * @param homeDirectoryMappings
         *        Specifies the logical directory mappings that specify what Amazon S3 or EFS paths and keys should be
         *        visible to your user and how you want to make them visible. You will need to specify the "
         *        <code>Entry</code>" and "<code>Target</code>" pair, where <code>Entry</code> shows how the path is
         *        made visible and <code>Target</code> is the actual Amazon S3 or EFS path. If you only specify a
         *        target, it will be displayed as is. You will need to also make sure that your AWS Identity and Access
         *        Management (IAM) role provides access to paths in <code>Target</code>.</p>
         *        <p>
         *        In most cases, you can use this value instead of the scope-down policy to lock your user down to the
         *        designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/'
         *        and set <code>Target</code> to the HomeDirectory parameter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeDirectoryMappings(Collection<HomeDirectoryMapEntry> homeDirectoryMappings);

        /**
         * <p>
         * Specifies the logical directory mappings that specify what Amazon S3 or EFS paths and keys should be visible
         * to your user and how you want to make them visible. You will need to specify the "<code>Entry</code>" and "
         * <code>Target</code>" pair, where <code>Entry</code> shows how the path is made visible and
         * <code>Target</code> is the actual Amazon S3 or EFS path. If you only specify a target, it will be displayed
         * as is. You will need to also make sure that your AWS Identity and Access Management (IAM) role provides
         * access to paths in <code>Target</code>.
         * </p>
         * <p>
         * In most cases, you can use this value instead of the scope-down policy to lock your user down to the
         * designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and set
         * <code>Target</code> to the HomeDirectory parameter value.
         * </p>
         * 
         * @param homeDirectoryMappings
         *        Specifies the logical directory mappings that specify what Amazon S3 or EFS paths and keys should be
         *        visible to your user and how you want to make them visible. You will need to specify the "
         *        <code>Entry</code>" and "<code>Target</code>" pair, where <code>Entry</code> shows how the path is
         *        made visible and <code>Target</code> is the actual Amazon S3 or EFS path. If you only specify a
         *        target, it will be displayed as is. You will need to also make sure that your AWS Identity and Access
         *        Management (IAM) role provides access to paths in <code>Target</code>.</p>
         *        <p>
         *        In most cases, you can use this value instead of the scope-down policy to lock your user down to the
         *        designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/'
         *        and set <code>Target</code> to the HomeDirectory parameter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeDirectoryMappings(HomeDirectoryMapEntry... homeDirectoryMappings);

        /**
         * <p>
         * Specifies the logical directory mappings that specify what Amazon S3 or EFS paths and keys should be visible
         * to your user and how you want to make them visible. You will need to specify the "<code>Entry</code>" and "
         * <code>Target</code>" pair, where <code>Entry</code> shows how the path is made visible and
         * <code>Target</code> is the actual Amazon S3 or EFS path. If you only specify a target, it will be displayed
         * as is. You will need to also make sure that your AWS Identity and Access Management (IAM) role provides
         * access to paths in <code>Target</code>.
         * </p>
         * <p>
         * In most cases, you can use this value instead of the scope-down policy to lock your user down to the
         * designated home directory ("<code>chroot</code>"). To do this, you can set <code>Entry</code> to '/' and set
         * <code>Target</code> to the HomeDirectory parameter value.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HomeDirectoryMapEntry>.Builder} avoiding
         * the need to create one manually via {@link List<HomeDirectoryMapEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HomeDirectoryMapEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #homeDirectoryMappings(List<HomeDirectoryMapEntry>)}.
         * 
         * @param homeDirectoryMappings
         *        a consumer that will call methods on {@link List<HomeDirectoryMapEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #homeDirectoryMappings(List<HomeDirectoryMapEntry>)
         */
        Builder homeDirectoryMappings(Consumer<HomeDirectoryMapEntry.Builder>... homeDirectoryMappings);

        /**
         * <p>
         * Specifies the type of landing directory (folder) you mapped for your users to see when they log into the file
         * transfer protocol-enabled server. If you set it to <code>PATH</code>, the user will see the absolute Amazon
         * S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you
         * will need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or
         * EFS paths visible to your users.
         * </p>
         * 
         * @param homeDirectoryType
         *        Specifies the type of landing directory (folder) you mapped for your users to see when they log into
         *        the file transfer protocol-enabled server. If you set it to <code>PATH</code>, the user will see the
         *        absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it
         *        <code>LOGICAL</code>, you will need to provide mappings in the <code>HomeDirectoryMappings</code> for
         *        how you want to make Amazon S3 or EFS paths visible to your users.
         * @see HomeDirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HomeDirectoryType
         */
        Builder homeDirectoryType(String homeDirectoryType);

        /**
         * <p>
         * Specifies the type of landing directory (folder) you mapped for your users to see when they log into the file
         * transfer protocol-enabled server. If you set it to <code>PATH</code>, the user will see the absolute Amazon
         * S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you
         * will need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or
         * EFS paths visible to your users.
         * </p>
         * 
         * @param homeDirectoryType
         *        Specifies the type of landing directory (folder) you mapped for your users to see when they log into
         *        the file transfer protocol-enabled server. If you set it to <code>PATH</code>, the user will see the
         *        absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it
         *        <code>LOGICAL</code>, you will need to provide mappings in the <code>HomeDirectoryMappings</code> for
         *        how you want to make Amazon S3 or EFS paths visible to your users.
         * @see HomeDirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HomeDirectoryType
         */
        Builder homeDirectoryType(HomeDirectoryType homeDirectoryType);

        /**
         * <p>
         * Specifies the name of the policy in use for the described user.
         * </p>
         * 
         * @param policy
         *        Specifies the name of the policy in use for the described user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any
         * secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon Elastic
         * File System (Amazon EFS) file systems. The POSIX permissions that are set on files and directories in your
         * file system determine the level of access your users get when transferring files into and out of your Amazon
         * EFS file systems.
         * </p>
         * 
         * @param posixProfile
         *        Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>),
         *        and any secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your
         *        Amazon Elastic File System (Amazon EFS) file systems. The POSIX permissions that are set on files and
         *        directories in your file system determine the level of access your users get when transferring files
         *        into and out of your Amazon EFS file systems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder posixProfile(PosixProfile posixProfile);

        /**
         * <p>
         * Specifies the full POSIX identity, including user ID (<code>Uid</code>), group ID (<code>Gid</code>), and any
         * secondary groups IDs (<code>SecondaryGids</code>), that controls your users' access to your Amazon Elastic
         * File System (Amazon EFS) file systems. The POSIX permissions that are set on files and directories in your
         * file system determine the level of access your users get when transferring files into and out of your Amazon
         * EFS file systems.
         * </p>
         * This is a convenience that creates an instance of the {@link PosixProfile.Builder} avoiding the need to
         * create one manually via {@link PosixProfile#builder()}.
         *
         * When the {@link Consumer} completes, {@link PosixProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #posixProfile(PosixProfile)}.
         * 
         * @param posixProfile
         *        a consumer that will call methods on {@link PosixProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #posixProfile(PosixProfile)
         */
        default Builder posixProfile(Consumer<PosixProfile.Builder> posixProfile) {
            return posixProfile(PosixProfile.builder().applyMutation(posixProfile).build());
        }

        /**
         * <p>
         * The IAM role that controls your users' access to your Amazon S3 bucket. The policies attached to this role
         * will determine the level of access you want to provide your users when transferring files into and out of
         * your Amazon S3 bucket or buckets. The IAM role should also contain a trust relationship that allows a server
         * to access your resources when servicing your users' transfer requests.
         * </p>
         * 
         * @param role
         *        The IAM role that controls your users' access to your Amazon S3 bucket. The policies attached to this
         *        role will determine the level of access you want to provide your users when transferring files into
         *        and out of your Amazon S3 bucket or buckets. The IAM role should also contain a trust relationship
         *        that allows a server to access your resources when servicing your users' transfer requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.
         * </p>
         * 
         * @param sshPublicKeys
         *        Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeys(Collection<SshPublicKey> sshPublicKeys);

        /**
         * <p>
         * Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.
         * </p>
         * 
         * @param sshPublicKeys
         *        Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeys(SshPublicKey... sshPublicKeys);

        /**
         * <p>
         * Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SshPublicKey>.Builder} avoiding the need to
         * create one manually via {@link List<SshPublicKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SshPublicKey>.Builder#build()} is called immediately and its
         * result is passed to {@link #sshPublicKeys(List<SshPublicKey>)}.
         * 
         * @param sshPublicKeys
         *        a consumer that will call methods on {@link List<SshPublicKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sshPublicKeys(List<SshPublicKey>)
         */
        Builder sshPublicKeys(Consumer<SshPublicKey.Builder>... sshPublicKeys);

        /**
         * <p>
         * Specifies the key-value pairs for the user requested. Tag can be used to search for and group users for a
         * variety of purposes.
         * </p>
         * 
         * @param tags
         *        Specifies the key-value pairs for the user requested. Tag can be used to search for and group users
         *        for a variety of purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Specifies the key-value pairs for the user requested. Tag can be used to search for and group users for a
         * variety of purposes.
         * </p>
         * 
         * @param tags
         *        Specifies the key-value pairs for the user requested. Tag can be used to search for and group users
         *        for a variety of purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Specifies the key-value pairs for the user requested. Tag can be used to search for and group users for a
         * variety of purposes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specifies the name of the user that was requested to be described. User names are used for authentication
         * purposes. This is the string that will be used by your user when they log in to your server.
         * </p>
         * 
         * @param userName
         *        Specifies the name of the user that was requested to be described. User names are used for
         *        authentication purposes. This is the string that will be used by your user when they log in to your
         *        server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String homeDirectory;

        private List<HomeDirectoryMapEntry> homeDirectoryMappings = DefaultSdkAutoConstructList.getInstance();

        private String homeDirectoryType;

        private String policy;

        private PosixProfile posixProfile;

        private String role;

        private List<SshPublicKey> sshPublicKeys = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedUser model) {
            arn(model.arn);
            homeDirectory(model.homeDirectory);
            homeDirectoryMappings(model.homeDirectoryMappings);
            homeDirectoryType(model.homeDirectoryType);
            policy(model.policy);
            posixProfile(model.posixProfile);
            role(model.role);
            sshPublicKeys(model.sshPublicKeys);
            tags(model.tags);
            userName(model.userName);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getHomeDirectory() {
            return homeDirectory;
        }

        @Override
        public final Builder homeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
            return this;
        }

        public final void setHomeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
        }

        public final List<HomeDirectoryMapEntry.Builder> getHomeDirectoryMappings() {
            List<HomeDirectoryMapEntry.Builder> result = HomeDirectoryMappingsCopier.copyToBuilder(this.homeDirectoryMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder homeDirectoryMappings(Collection<HomeDirectoryMapEntry> homeDirectoryMappings) {
            this.homeDirectoryMappings = HomeDirectoryMappingsCopier.copy(homeDirectoryMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder homeDirectoryMappings(HomeDirectoryMapEntry... homeDirectoryMappings) {
            homeDirectoryMappings(Arrays.asList(homeDirectoryMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder homeDirectoryMappings(Consumer<HomeDirectoryMapEntry.Builder>... homeDirectoryMappings) {
            homeDirectoryMappings(Stream.of(homeDirectoryMappings)
                    .map(c -> HomeDirectoryMapEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHomeDirectoryMappings(Collection<HomeDirectoryMapEntry.BuilderImpl> homeDirectoryMappings) {
            this.homeDirectoryMappings = HomeDirectoryMappingsCopier.copyFromBuilder(homeDirectoryMappings);
        }

        public final String getHomeDirectoryType() {
            return homeDirectoryType;
        }

        @Override
        public final Builder homeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
            return this;
        }

        @Override
        public final Builder homeDirectoryType(HomeDirectoryType homeDirectoryType) {
            this.homeDirectoryType(homeDirectoryType == null ? null : homeDirectoryType.toString());
            return this;
        }

        public final void setHomeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final PosixProfile.Builder getPosixProfile() {
            return posixProfile != null ? posixProfile.toBuilder() : null;
        }

        @Override
        public final Builder posixProfile(PosixProfile posixProfile) {
            this.posixProfile = posixProfile;
            return this;
        }

        public final void setPosixProfile(PosixProfile.BuilderImpl posixProfile) {
            this.posixProfile = posixProfile != null ? posixProfile.build() : null;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final List<SshPublicKey.Builder> getSshPublicKeys() {
            List<SshPublicKey.Builder> result = SshPublicKeysCopier.copyToBuilder(this.sshPublicKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sshPublicKeys(Collection<SshPublicKey> sshPublicKeys) {
            this.sshPublicKeys = SshPublicKeysCopier.copy(sshPublicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshPublicKeys(SshPublicKey... sshPublicKeys) {
            sshPublicKeys(Arrays.asList(sshPublicKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshPublicKeys(Consumer<SshPublicKey.Builder>... sshPublicKeys) {
            sshPublicKeys(Stream.of(sshPublicKeys).map(c -> SshPublicKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSshPublicKeys(Collection<SshPublicKey.BuilderImpl> sshPublicKeys) {
            this.sshPublicKeys = SshPublicKeysCopier.copyFromBuilder(sshPublicKeys);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public DescribedUser build() {
            return new DescribedUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
