/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists the properties for one or more specified associated accesses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedAccess implements SdkPojo, Serializable, ToCopyableBuilder<ListedAccess.Builder, ListedAccess> {
    private static final SdkField<String> HOME_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeDirectory").getter(getter(ListedAccess::homeDirectory)).setter(setter(Builder::homeDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectory").build()).build();

    private static final SdkField<String> HOME_DIRECTORY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeDirectoryType").getter(getter(ListedAccess::homeDirectoryTypeAsString))
            .setter(setter(Builder::homeDirectoryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectoryType").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(ListedAccess::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalId").getter(getter(ListedAccess::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOME_DIRECTORY_FIELD,
            HOME_DIRECTORY_TYPE_FIELD, ROLE_FIELD, EXTERNAL_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String homeDirectory;

    private final String homeDirectoryType;

    private final String role;

    private final String externalId;

    private ListedAccess(BuilderImpl builder) {
        this.homeDirectory = builder.homeDirectory;
        this.homeDirectoryType = builder.homeDirectoryType;
        this.role = builder.role;
        this.externalId = builder.externalId;
    }

    /**
     * <p>
     * The landing directory (folder) for a user when they log in to the server using the client.
     * </p>
     * <p>
     * A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.
     * </p>
     * 
     * @return The landing directory (folder) for a user when they log in to the server using the client.</p>
     *         <p>
     *         A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.
     */
    public final String homeDirectory() {
        return homeDirectory;
    }

    /**
     * <p>
     * The type of landing directory (folder) you want your users' home directory to be when they log into the server.
     * If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their
     * file transfer protocol clients. If you set it <code>LOGICAL</code>, you will need to provide mappings in the
     * <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #homeDirectoryType}
     * will return {@link HomeDirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #homeDirectoryTypeAsString}.
     * </p>
     * 
     * @return The type of landing directory (folder) you want your users' home directory to be when they log into the
     *         server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths
     *         as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you will need to
     *         provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS
     *         paths visible to your users.
     * @see HomeDirectoryType
     */
    public final HomeDirectoryType homeDirectoryType() {
        return HomeDirectoryType.fromValue(homeDirectoryType);
    }

    /**
     * <p>
     * The type of landing directory (folder) you want your users' home directory to be when they log into the server.
     * If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as is in their
     * file transfer protocol clients. If you set it <code>LOGICAL</code>, you will need to provide mappings in the
     * <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to your users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #homeDirectoryType}
     * will return {@link HomeDirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #homeDirectoryTypeAsString}.
     * </p>
     * 
     * @return The type of landing directory (folder) you want your users' home directory to be when they log into the
     *         server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths
     *         as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you will need to
     *         provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS
     *         paths visible to your users.
     * @see HomeDirectoryType
     */
    public final String homeDirectoryTypeAsString() {
        return homeDirectoryType;
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3
     * bucket or EFS file system. The policies attached to this role determine the level of access that you want to
     * provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role
     * should also contain a trust relationship that allows the server to access your resources when servicing your
     * users' transfer requests.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon
     *         S3 bucket or EFS file system. The policies attached to this role determine the level of access that you
     *         want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file
     *         system. The IAM role should also contain a trust relationship that allows the server to access your
     *         resources when servicing your users' transfer requests.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * A unique identifier that is required to identify specific groups within your directory. The users of the group
     * that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using AWS
     * Transfer Family. If you know the group name, you can view the SID values by running the following command using
     * Windows PowerShell.
     * </p>
     * <p>
     * <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
     * </p>
     * <p>
     * In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.
     * </p>
     * <p>
     * The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase
     * alphanumeric characters with no spaces. You can also include underscores or any of the following characters:
     * =,.@:/-
     * </p>
     * 
     * @return A unique identifier that is required to identify specific groups within your directory. The users of the
     *         group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols
     *         using AWS Transfer Family. If you know the group name, you can view the SID values by running the
     *         following command using Windows PowerShell.</p>
     *         <p>
     *         <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
     *         </p>
     *         <p>
     *         In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.
     *         </p>
     *         <p>
     *         The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase
     *         alphanumeric characters with no spaces. You can also include underscores or any of the following
     *         characters: =,.@:/-
     */
    public final String externalId() {
        return externalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(homeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(homeDirectoryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedAccess)) {
            return false;
        }
        ListedAccess other = (ListedAccess) obj;
        return Objects.equals(homeDirectory(), other.homeDirectory())
                && Objects.equals(homeDirectoryTypeAsString(), other.homeDirectoryTypeAsString())
                && Objects.equals(role(), other.role()) && Objects.equals(externalId(), other.externalId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListedAccess").add("HomeDirectory", homeDirectory())
                .add("HomeDirectoryType", homeDirectoryTypeAsString()).add("Role", role()).add("ExternalId", externalId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HomeDirectory":
            return Optional.ofNullable(clazz.cast(homeDirectory()));
        case "HomeDirectoryType":
            return Optional.ofNullable(clazz.cast(homeDirectoryTypeAsString()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "ExternalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListedAccess, T> g) {
        return obj -> g.apply((ListedAccess) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedAccess> {
        /**
         * <p>
         * The landing directory (folder) for a user when they log in to the server using the client.
         * </p>
         * <p>
         * A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.
         * </p>
         * 
         * @param homeDirectory
         *        The landing directory (folder) for a user when they log in to the server using the client.</p>
         *        <p>
         *        A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeDirectory(String homeDirectory);

        /**
         * <p>
         * The type of landing directory (folder) you want your users' home directory to be when they log into the
         * server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as
         * is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you will need to provide
         * mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to
         * your users.
         * </p>
         * 
         * @param homeDirectoryType
         *        The type of landing directory (folder) you want your users' home directory to be when they log into
         *        the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS
         *        paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you will need
         *        to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or
         *        EFS paths visible to your users.
         * @see HomeDirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HomeDirectoryType
         */
        Builder homeDirectoryType(String homeDirectoryType);

        /**
         * <p>
         * The type of landing directory (folder) you want your users' home directory to be when they log into the
         * server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS paths as
         * is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you will need to provide
         * mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or EFS paths visible to
         * your users.
         * </p>
         * 
         * @param homeDirectoryType
         *        The type of landing directory (folder) you want your users' home directory to be when they log into
         *        the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or EFS
         *        paths as is in their file transfer protocol clients. If you set it <code>LOGICAL</code>, you will need
         *        to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or
         *        EFS paths visible to your users.
         * @see HomeDirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HomeDirectoryType
         */
        Builder homeDirectoryType(HomeDirectoryType homeDirectoryType);

        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3
         * bucket or EFS file system. The policies attached to this role determine the level of access that you want to
         * provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM
         * role should also contain a trust relationship that allows the server to access your resources when servicing
         * your users' transfer requests.
         * </p>
         * 
         * @param role
         *        Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your
         *        Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access
         *        that you want to provide your users when transferring files into and out of your Amazon S3 bucket or
         *        EFS file system. The IAM role should also contain a trust relationship that allows the server to
         *        access your resources when servicing your users' transfer requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * A unique identifier that is required to identify specific groups within your directory. The users of the
         * group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols
         * using AWS Transfer Family. If you know the group name, you can view the SID values by running the following
         * command using Windows PowerShell.
         * </p>
         * <p>
         * <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
         * </p>
         * <p>
         * In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.
         * </p>
         * <p>
         * The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase
         * alphanumeric characters with no spaces. You can also include underscores or any of the following characters:
         * =,.@:/-
         * </p>
         * 
         * @param externalId
         *        A unique identifier that is required to identify specific groups within your directory. The users of
         *        the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled
         *        protocols using AWS Transfer Family. If you know the group name, you can view the SID values by
         *        running the following command using Windows PowerShell.</p>
         *        <p>
         *        <code>Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid</code>
         *        </p>
         *        <p>
         *        In that command, replace <i>YourGroupName</i> with the name of your Active Directory group.
         *        </p>
         *        <p>
         *        The regex used to validate this parameter is a string of characters consisting of uppercase and
         *        lowercase alphanumeric characters with no spaces. You can also include underscores or any of the
         *        following characters: =,.@:/-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);
    }

    static final class BuilderImpl implements Builder {
        private String homeDirectory;

        private String homeDirectoryType;

        private String role;

        private String externalId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedAccess model) {
            homeDirectory(model.homeDirectory);
            homeDirectoryType(model.homeDirectoryType);
            role(model.role);
            externalId(model.externalId);
        }

        public final String getHomeDirectory() {
            return homeDirectory;
        }

        @Override
        public final Builder homeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
            return this;
        }

        public final void setHomeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
        }

        public final String getHomeDirectoryType() {
            return homeDirectoryType;
        }

        @Override
        public final Builder homeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
            return this;
        }

        @Override
        public final Builder homeDirectoryType(HomeDirectoryType homeDirectoryType) {
            this.homeDirectoryType(homeDirectoryType == null ? null : homeDirectoryType.toString());
            return this;
        }

        public final void setHomeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getExternalId() {
            return externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public ListedAccess build() {
            return new ListedAccess(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
