/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Each step type has its own <code>StepDetails</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyStepDetails implements SdkPojo, Serializable, ToCopyableBuilder<CopyStepDetails.Builder, CopyStepDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CopyStepDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<InputFileLocation> DESTINATION_FILE_LOCATION_FIELD = SdkField
            .<InputFileLocation> builder(MarshallingType.SDK_POJO).memberName("DestinationFileLocation")
            .getter(getter(CopyStepDetails::destinationFileLocation)).setter(setter(Builder::destinationFileLocation))
            .constructor(InputFileLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationFileLocation").build())
            .build();

    private static final SdkField<String> OVERWRITE_EXISTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OverwriteExisting").getter(getter(CopyStepDetails::overwriteExistingAsString))
            .setter(setter(Builder::overwriteExisting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverwriteExisting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DESTINATION_FILE_LOCATION_FIELD, OVERWRITE_EXISTING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final InputFileLocation destinationFileLocation;

    private final String overwriteExisting;

    private CopyStepDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.destinationFileLocation = builder.destinationFileLocation;
        this.overwriteExisting = builder.overwriteExisting;
    }

    /**
     * <p>
     * The name of the step, used as an identifier.
     * </p>
     * 
     * @return The name of the step, used as an identifier.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the DestinationFileLocation property for this object.
     * 
     * @return The value of the DestinationFileLocation property for this object.
     */
    public final InputFileLocation destinationFileLocation() {
        return destinationFileLocation;
    }

    /**
     * <p>
     * A flag that indicates whether or not to overwrite an existing file of the same name. The default is
     * <code>FALSE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overwriteExisting}
     * will return {@link OverwriteExisting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #overwriteExistingAsString}.
     * </p>
     * 
     * @return A flag that indicates whether or not to overwrite an existing file of the same name. The default is
     *         <code>FALSE</code>.
     * @see OverwriteExisting
     */
    public final OverwriteExisting overwriteExisting() {
        return OverwriteExisting.fromValue(overwriteExisting);
    }

    /**
     * <p>
     * A flag that indicates whether or not to overwrite an existing file of the same name. The default is
     * <code>FALSE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overwriteExisting}
     * will return {@link OverwriteExisting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #overwriteExistingAsString}.
     * </p>
     * 
     * @return A flag that indicates whether or not to overwrite an existing file of the same name. The default is
     *         <code>FALSE</code>.
     * @see OverwriteExisting
     */
    public final String overwriteExistingAsString() {
        return overwriteExisting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(destinationFileLocation());
        hashCode = 31 * hashCode + Objects.hashCode(overwriteExistingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyStepDetails)) {
            return false;
        }
        CopyStepDetails other = (CopyStepDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(destinationFileLocation(), other.destinationFileLocation())
                && Objects.equals(overwriteExistingAsString(), other.overwriteExistingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyStepDetails").add("Name", name()).add("DestinationFileLocation", destinationFileLocation())
                .add("OverwriteExisting", overwriteExistingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DestinationFileLocation":
            return Optional.ofNullable(clazz.cast(destinationFileLocation()));
        case "OverwriteExisting":
            return Optional.ofNullable(clazz.cast(overwriteExistingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyStepDetails, T> g) {
        return obj -> g.apply((CopyStepDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CopyStepDetails> {
        /**
         * <p>
         * The name of the step, used as an identifier.
         * </p>
         * 
         * @param name
         *        The name of the step, used as an identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the DestinationFileLocation property for this object.
         *
         * @param destinationFileLocation
         *        The new value for the DestinationFileLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationFileLocation(InputFileLocation destinationFileLocation);

        /**
         * Sets the value of the DestinationFileLocation property for this object.
         *
         * This is a convenience that creates an instance of the {@link InputFileLocation.Builder} avoiding the need to
         * create one manually via {@link InputFileLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputFileLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationFileLocation(InputFileLocation)}.
         * 
         * @param destinationFileLocation
         *        a consumer that will call methods on {@link InputFileLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationFileLocation(InputFileLocation)
         */
        default Builder destinationFileLocation(Consumer<InputFileLocation.Builder> destinationFileLocation) {
            return destinationFileLocation(InputFileLocation.builder().applyMutation(destinationFileLocation).build());
        }

        /**
         * <p>
         * A flag that indicates whether or not to overwrite an existing file of the same name. The default is
         * <code>FALSE</code>.
         * </p>
         * 
         * @param overwriteExisting
         *        A flag that indicates whether or not to overwrite an existing file of the same name. The default is
         *        <code>FALSE</code>.
         * @see OverwriteExisting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverwriteExisting
         */
        Builder overwriteExisting(String overwriteExisting);

        /**
         * <p>
         * A flag that indicates whether or not to overwrite an existing file of the same name. The default is
         * <code>FALSE</code>.
         * </p>
         * 
         * @param overwriteExisting
         *        A flag that indicates whether or not to overwrite an existing file of the same name. The default is
         *        <code>FALSE</code>.
         * @see OverwriteExisting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverwriteExisting
         */
        Builder overwriteExisting(OverwriteExisting overwriteExisting);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private InputFileLocation destinationFileLocation;

        private String overwriteExisting;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyStepDetails model) {
            name(model.name);
            destinationFileLocation(model.destinationFileLocation);
            overwriteExisting(model.overwriteExisting);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final InputFileLocation.Builder getDestinationFileLocation() {
            return destinationFileLocation != null ? destinationFileLocation.toBuilder() : null;
        }

        public final void setDestinationFileLocation(InputFileLocation.BuilderImpl destinationFileLocation) {
            this.destinationFileLocation = destinationFileLocation != null ? destinationFileLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationFileLocation(InputFileLocation destinationFileLocation) {
            this.destinationFileLocation = destinationFileLocation;
            return this;
        }

        public final String getOverwriteExisting() {
            return overwriteExisting;
        }

        public final void setOverwriteExisting(String overwriteExisting) {
            this.overwriteExisting = overwriteExisting;
        }

        @Override
        @Transient
        public final Builder overwriteExisting(String overwriteExisting) {
            this.overwriteExisting = overwriteExisting;
            return this;
        }

        @Override
        @Transient
        public final Builder overwriteExisting(OverwriteExisting overwriteExisting) {
            this.overwriteExisting(overwriteExisting == null ? null : overwriteExisting.toString());
            return this;
        }

        @Override
        public CopyStepDetails build() {
            return new CopyStepDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
