/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the Amazon S3 or EFS file details to be used in the step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileLocation implements SdkPojo, Serializable, ToCopyableBuilder<FileLocation.Builder, FileLocation> {
    private static final SdkField<S3FileLocation> S3_FILE_LOCATION_FIELD = SdkField
            .<S3FileLocation> builder(MarshallingType.SDK_POJO).memberName("S3FileLocation")
            .getter(getter(FileLocation::s3FileLocation)).setter(setter(Builder::s3FileLocation))
            .constructor(S3FileLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3FileLocation").build()).build();

    private static final SdkField<EfsFileLocation> EFS_FILE_LOCATION_FIELD = SdkField
            .<EfsFileLocation> builder(MarshallingType.SDK_POJO).memberName("EfsFileLocation")
            .getter(getter(FileLocation::efsFileLocation)).setter(setter(Builder::efsFileLocation))
            .constructor(EfsFileLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EfsFileLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FILE_LOCATION_FIELD,
            EFS_FILE_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3FileLocation s3FileLocation;

    private final EfsFileLocation efsFileLocation;

    private FileLocation(BuilderImpl builder) {
        this.s3FileLocation = builder.s3FileLocation;
        this.efsFileLocation = builder.efsFileLocation;
    }

    /**
     * <p>
     * Specifies the S3 details for the file being used, such as bucket, Etag, and so forth.
     * </p>
     * 
     * @return Specifies the S3 details for the file being used, such as bucket, Etag, and so forth.
     */
    public final S3FileLocation s3FileLocation() {
        return s3FileLocation;
    }

    /**
     * <p>
     * Specifies the Amazon EFS ID and the path for the file being used.
     * </p>
     * 
     * @return Specifies the Amazon EFS ID and the path for the file being used.
     */
    public final EfsFileLocation efsFileLocation() {
        return efsFileLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3FileLocation());
        hashCode = 31 * hashCode + Objects.hashCode(efsFileLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileLocation)) {
            return false;
        }
        FileLocation other = (FileLocation) obj;
        return Objects.equals(s3FileLocation(), other.s3FileLocation())
                && Objects.equals(efsFileLocation(), other.efsFileLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileLocation").add("S3FileLocation", s3FileLocation()).add("EfsFileLocation", efsFileLocation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3FileLocation":
            return Optional.ofNullable(clazz.cast(s3FileLocation()));
        case "EfsFileLocation":
            return Optional.ofNullable(clazz.cast(efsFileLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileLocation, T> g) {
        return obj -> g.apply((FileLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileLocation> {
        /**
         * <p>
         * Specifies the S3 details for the file being used, such as bucket, Etag, and so forth.
         * </p>
         * 
         * @param s3FileLocation
         *        Specifies the S3 details for the file being used, such as bucket, Etag, and so forth.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3FileLocation(S3FileLocation s3FileLocation);

        /**
         * <p>
         * Specifies the S3 details for the file being used, such as bucket, Etag, and so forth.
         * </p>
         * This is a convenience that creates an instance of the {@link S3FileLocation.Builder} avoiding the need to
         * create one manually via {@link S3FileLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3FileLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #s3FileLocation(S3FileLocation)}.
         * 
         * @param s3FileLocation
         *        a consumer that will call methods on {@link S3FileLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3FileLocation(S3FileLocation)
         */
        default Builder s3FileLocation(Consumer<S3FileLocation.Builder> s3FileLocation) {
            return s3FileLocation(S3FileLocation.builder().applyMutation(s3FileLocation).build());
        }

        /**
         * <p>
         * Specifies the Amazon EFS ID and the path for the file being used.
         * </p>
         * 
         * @param efsFileLocation
         *        Specifies the Amazon EFS ID and the path for the file being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder efsFileLocation(EfsFileLocation efsFileLocation);

        /**
         * <p>
         * Specifies the Amazon EFS ID and the path for the file being used.
         * </p>
         * This is a convenience that creates an instance of the {@link EfsFileLocation.Builder} avoiding the need to
         * create one manually via {@link EfsFileLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link EfsFileLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #efsFileLocation(EfsFileLocation)}.
         * 
         * @param efsFileLocation
         *        a consumer that will call methods on {@link EfsFileLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #efsFileLocation(EfsFileLocation)
         */
        default Builder efsFileLocation(Consumer<EfsFileLocation.Builder> efsFileLocation) {
            return efsFileLocation(EfsFileLocation.builder().applyMutation(efsFileLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3FileLocation s3FileLocation;

        private EfsFileLocation efsFileLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(FileLocation model) {
            s3FileLocation(model.s3FileLocation);
            efsFileLocation(model.efsFileLocation);
        }

        public final S3FileLocation.Builder getS3FileLocation() {
            return s3FileLocation != null ? s3FileLocation.toBuilder() : null;
        }

        public final void setS3FileLocation(S3FileLocation.BuilderImpl s3FileLocation) {
            this.s3FileLocation = s3FileLocation != null ? s3FileLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder s3FileLocation(S3FileLocation s3FileLocation) {
            this.s3FileLocation = s3FileLocation;
            return this;
        }

        public final EfsFileLocation.Builder getEfsFileLocation() {
            return efsFileLocation != null ? efsFileLocation.toBuilder() : null;
        }

        public final void setEfsFileLocation(EfsFileLocation.BuilderImpl efsFileLocation) {
            this.efsFileLocation = efsFileLocation != null ? efsFileLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder efsFileLocation(EfsFileLocation efsFileLocation) {
            this.efsFileLocation = efsFileLocation;
            return this;
        }

        @Override
        public FileLocation build() {
            return new FileLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
