/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the details for the file location for the file being used in the workflow. Only applicable if you are using
 * S3 storage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3FileLocation implements SdkPojo, Serializable, ToCopyableBuilder<S3FileLocation.Builder, S3FileLocation> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Bucket")
            .getter(getter(S3FileLocation::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(S3FileLocation::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(S3FileLocation::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final SdkField<String> ETAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Etag")
            .getter(getter(S3FileLocation::etag)).setter(setter(Builder::etag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Etag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, KEY_FIELD,
            VERSION_ID_FIELD, ETAG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final String key;

    private final String versionId;

    private final String etag;

    private S3FileLocation(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.versionId = builder.versionId;
        this.etag = builder.etag;
    }

    /**
     * <p>
     * Specifies the S3 bucket that contains the file being used.
     * </p>
     * 
     * @return Specifies the S3 bucket that contains the file being used.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
     * </p>
     * 
     * @return The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * Specifies the file version.
     * </p>
     * 
     * @return Specifies the file version.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * <p>
     * The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its
     * metadata.
     * </p>
     * 
     * @return The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not
     *         its metadata.
     */
    public final String etag() {
        return etag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(etag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3FileLocation)) {
            return false;
        }
        S3FileLocation other = (S3FileLocation) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(key(), other.key())
                && Objects.equals(versionId(), other.versionId()) && Objects.equals(etag(), other.etag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3FileLocation").add("Bucket", bucket()).add("Key", key()).add("VersionId", versionId())
                .add("Etag", etag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "Etag":
            return Optional.ofNullable(clazz.cast(etag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3FileLocation, T> g) {
        return obj -> g.apply((S3FileLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3FileLocation> {
        /**
         * <p>
         * Specifies the S3 bucket that contains the file being used.
         * </p>
         * 
         * @param bucket
         *        Specifies the S3 bucket that contains the file being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
         * </p>
         * 
         * @param key
         *        The name assigned to the file when it was created in S3. You use the object key to retrieve the
         *        object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * Specifies the file version.
         * </p>
         * 
         * @param versionId
         *        Specifies the file version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its
         * metadata.
         * </p>
         * 
         * @param etag
         *        The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object,
         *        not its metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder etag(String etag);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String key;

        private String versionId;

        private String etag;

        private BuilderImpl() {
        }

        private BuilderImpl(S3FileLocation model) {
            bucket(model.bucket);
            key(model.key);
            versionId(model.versionId);
            etag(model.etag);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getEtag() {
            return etag;
        }

        public final void setEtag(String etag) {
            this.etag = etag;
        }

        @Override
        public final Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        public S3FileLocation build() {
            return new S3FileLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
