/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for an execution object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribedExecution implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribedExecution.Builder, DescribedExecution> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionId").getter(getter(DescribedExecution::executionId)).setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()).build();

    private static final SdkField<FileLocation> INITIAL_FILE_LOCATION_FIELD = SdkField
            .<FileLocation> builder(MarshallingType.SDK_POJO).memberName("InitialFileLocation")
            .getter(getter(DescribedExecution::initialFileLocation)).setter(setter(Builder::initialFileLocation))
            .constructor(FileLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialFileLocation").build())
            .build();

    private static final SdkField<ServiceMetadata> SERVICE_METADATA_FIELD = SdkField
            .<ServiceMetadata> builder(MarshallingType.SDK_POJO).memberName("ServiceMetadata")
            .getter(getter(DescribedExecution::serviceMetadata)).setter(setter(Builder::serviceMetadata))
            .constructor(ServiceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceMetadata").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRole").getter(getter(DescribedExecution::executionRole)).setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()).build();

    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField
            .<LoggingConfiguration> builder(MarshallingType.SDK_POJO).memberName("LoggingConfiguration")
            .getter(getter(DescribedExecution::loggingConfiguration)).setter(setter(Builder::loggingConfiguration))
            .constructor(LoggingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build())
            .build();

    private static final SdkField<PosixProfile> POSIX_PROFILE_FIELD = SdkField.<PosixProfile> builder(MarshallingType.SDK_POJO)
            .memberName("PosixProfile").getter(getter(DescribedExecution::posixProfile)).setter(setter(Builder::posixProfile))
            .constructor(PosixProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PosixProfile").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribedExecution::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<ExecutionResults> RESULTS_FIELD = SdkField.<ExecutionResults> builder(MarshallingType.SDK_POJO)
            .memberName("Results").getter(getter(DescribedExecution::results)).setter(setter(Builder::results))
            .constructor(ExecutionResults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD,
            INITIAL_FILE_LOCATION_FIELD, SERVICE_METADATA_FIELD, EXECUTION_ROLE_FIELD, LOGGING_CONFIGURATION_FIELD,
            POSIX_PROFILE_FIELD, STATUS_FIELD, RESULTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String executionId;

    private final FileLocation initialFileLocation;

    private final ServiceMetadata serviceMetadata;

    private final String executionRole;

    private final LoggingConfiguration loggingConfiguration;

    private final PosixProfile posixProfile;

    private final String status;

    private final ExecutionResults results;

    private DescribedExecution(BuilderImpl builder) {
        this.executionId = builder.executionId;
        this.initialFileLocation = builder.initialFileLocation;
        this.serviceMetadata = builder.serviceMetadata;
        this.executionRole = builder.executionRole;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.posixProfile = builder.posixProfile;
        this.status = builder.status;
        this.results = builder.results;
    }

    /**
     * <p>
     * A unique identifier for the execution of a workflow.
     * </p>
     * 
     * @return A unique identifier for the execution of a workflow.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution
     * begins: if the file is being copied, this is the initial (as opposed to destination) file location.
     * </p>
     * 
     * @return A structure that describes the Amazon S3 or EFS file location. This is the file location when the
     *         execution begins: if the file is being copied, this is the initial (as opposed to destination) file
     *         location.
     */
    public final FileLocation initialFileLocation() {
        return initialFileLocation;
    }

    /**
     * <p>
     * A container object for the session details associated with a workflow.
     * </p>
     * 
     * @return A container object for the session details associated with a workflow.
     */
    public final ServiceMetadata serviceMetadata() {
        return serviceMetadata;
    }

    /**
     * <p>
     * The IAM role associated with the execution.
     * </p>
     * 
     * @return The IAM role associated with the execution.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * The IAM logging role associated with the execution.
     * </p>
     * 
     * @return The IAM logging role associated with the execution.
     */
    public final LoggingConfiguration loggingConfiguration() {
        return loggingConfiguration;
    }

    /**
     * Returns the value of the PosixProfile property for this object.
     * 
     * @return The value of the PosixProfile property for this object.
     */
    public final PosixProfile posixProfile() {
        return posixProfile;
    }

    /**
     * <p>
     * The status is one of the execution. Can be in progress, completed, exception encountered, or handling the
     * exception.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status is one of the execution. Can be in progress, completed, exception encountered, or handling the
     *         exception.
     * @see ExecutionStatus
     */
    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status is one of the execution. Can be in progress, completed, exception encountered, or handling the
     * exception.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status is one of the execution. Can be in progress, completed, exception encountered, or handling the
     *         exception.
     * @see ExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A structure that describes the execution results. This includes a list of the steps along with the details of
     * each step, error type and message (if any), and the <code>OnExceptionSteps</code> structure.
     * </p>
     * 
     * @return A structure that describes the execution results. This includes a list of the steps along with the
     *         details of each step, error type and message (if any), and the <code>OnExceptionSteps</code> structure.
     */
    public final ExecutionResults results() {
        return results;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(initialFileLocation());
        hashCode = 31 * hashCode + Objects.hashCode(serviceMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(posixProfile());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(results());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedExecution)) {
            return false;
        }
        DescribedExecution other = (DescribedExecution) obj;
        return Objects.equals(executionId(), other.executionId())
                && Objects.equals(initialFileLocation(), other.initialFileLocation())
                && Objects.equals(serviceMetadata(), other.serviceMetadata())
                && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(loggingConfiguration(), other.loggingConfiguration())
                && Objects.equals(posixProfile(), other.posixProfile())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(results(), other.results());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribedExecution").add("ExecutionId", executionId())
                .add("InitialFileLocation", initialFileLocation()).add("ServiceMetadata", serviceMetadata())
                .add("ExecutionRole", executionRole()).add("LoggingConfiguration", loggingConfiguration())
                .add("PosixProfile", posixProfile()).add("Status", statusAsString()).add("Results", results()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "InitialFileLocation":
            return Optional.ofNullable(clazz.cast(initialFileLocation()));
        case "ServiceMetadata":
            return Optional.ofNullable(clazz.cast(serviceMetadata()));
        case "ExecutionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "LoggingConfiguration":
            return Optional.ofNullable(clazz.cast(loggingConfiguration()));
        case "PosixProfile":
            return Optional.ofNullable(clazz.cast(posixProfile()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribedExecution, T> g) {
        return obj -> g.apply((DescribedExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribedExecution> {
        /**
         * <p>
         * A unique identifier for the execution of a workflow.
         * </p>
         * 
         * @param executionId
         *        A unique identifier for the execution of a workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution
         * begins: if the file is being copied, this is the initial (as opposed to destination) file location.
         * </p>
         * 
         * @param initialFileLocation
         *        A structure that describes the Amazon S3 or EFS file location. This is the file location when the
         *        execution begins: if the file is being copied, this is the initial (as opposed to destination) file
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialFileLocation(FileLocation initialFileLocation);

        /**
         * <p>
         * A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution
         * begins: if the file is being copied, this is the initial (as opposed to destination) file location.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileLocation.Builder} avoiding the need
         * to create one manually via {@link FileLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link FileLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #initialFileLocation(FileLocation)}.
         * 
         * @param initialFileLocation
         *        a consumer that will call methods on {@link FileLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initialFileLocation(FileLocation)
         */
        default Builder initialFileLocation(Consumer<FileLocation.Builder> initialFileLocation) {
            return initialFileLocation(FileLocation.builder().applyMutation(initialFileLocation).build());
        }

        /**
         * <p>
         * A container object for the session details associated with a workflow.
         * </p>
         * 
         * @param serviceMetadata
         *        A container object for the session details associated with a workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceMetadata(ServiceMetadata serviceMetadata);

        /**
         * <p>
         * A container object for the session details associated with a workflow.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceMetadata.Builder} avoiding the
         * need to create one manually via {@link ServiceMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceMetadata(ServiceMetadata)}.
         * 
         * @param serviceMetadata
         *        a consumer that will call methods on {@link ServiceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceMetadata(ServiceMetadata)
         */
        default Builder serviceMetadata(Consumer<ServiceMetadata.Builder> serviceMetadata) {
            return serviceMetadata(ServiceMetadata.builder().applyMutation(serviceMetadata).build());
        }

        /**
         * <p>
         * The IAM role associated with the execution.
         * </p>
         * 
         * @param executionRole
         *        The IAM role associated with the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * The IAM logging role associated with the execution.
         * </p>
         * 
         * @param loggingConfiguration
         *        The IAM logging role associated with the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfiguration(LoggingConfiguration loggingConfiguration);

        /**
         * <p>
         * The IAM logging role associated with the execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingConfiguration.Builder} avoiding
         * the need to create one manually via {@link LoggingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #loggingConfiguration(LoggingConfiguration)}.
         * 
         * @param loggingConfiguration
         *        a consumer that will call methods on {@link LoggingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfiguration(LoggingConfiguration)
         */
        default Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return loggingConfiguration(LoggingConfiguration.builder().applyMutation(loggingConfiguration).build());
        }

        /**
         * Sets the value of the PosixProfile property for this object.
         *
         * @param posixProfile
         *        The new value for the PosixProfile property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder posixProfile(PosixProfile posixProfile);

        /**
         * Sets the value of the PosixProfile property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PosixProfile.Builder} avoiding the need
         * to create one manually via {@link PosixProfile#builder()}.
         *
         * When the {@link Consumer} completes, {@link PosixProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #posixProfile(PosixProfile)}.
         * 
         * @param posixProfile
         *        a consumer that will call methods on {@link PosixProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #posixProfile(PosixProfile)
         */
        default Builder posixProfile(Consumer<PosixProfile.Builder> posixProfile) {
            return posixProfile(PosixProfile.builder().applyMutation(posixProfile).build());
        }

        /**
         * <p>
         * The status is one of the execution. Can be in progress, completed, exception encountered, or handling the
         * exception.
         * </p>
         * 
         * @param status
         *        The status is one of the execution. Can be in progress, completed, exception encountered, or handling
         *        the exception.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status is one of the execution. Can be in progress, completed, exception encountered, or handling the
         * exception.
         * </p>
         * 
         * @param status
         *        The status is one of the execution. Can be in progress, completed, exception encountered, or handling
         *        the exception.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * A structure that describes the execution results. This includes a list of the steps along with the details of
         * each step, error type and message (if any), and the <code>OnExceptionSteps</code> structure.
         * </p>
         * 
         * @param results
         *        A structure that describes the execution results. This includes a list of the steps along with the
         *        details of each step, error type and message (if any), and the <code>OnExceptionSteps</code>
         *        structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(ExecutionResults results);

        /**
         * <p>
         * A structure that describes the execution results. This includes a list of the steps along with the details of
         * each step, error type and message (if any), and the <code>OnExceptionSteps</code> structure.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionResults.Builder} avoiding the
         * need to create one manually via {@link ExecutionResults#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionResults.Builder#build()} is called immediately and its
         * result is passed to {@link #results(ExecutionResults)}.
         * 
         * @param results
         *        a consumer that will call methods on {@link ExecutionResults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(ExecutionResults)
         */
        default Builder results(Consumer<ExecutionResults.Builder> results) {
            return results(ExecutionResults.builder().applyMutation(results).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String executionId;

        private FileLocation initialFileLocation;

        private ServiceMetadata serviceMetadata;

        private String executionRole;

        private LoggingConfiguration loggingConfiguration;

        private PosixProfile posixProfile;

        private String status;

        private ExecutionResults results;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedExecution model) {
            executionId(model.executionId);
            initialFileLocation(model.initialFileLocation);
            serviceMetadata(model.serviceMetadata);
            executionRole(model.executionRole);
            loggingConfiguration(model.loggingConfiguration);
            posixProfile(model.posixProfile);
            status(model.status);
            results(model.results);
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final FileLocation.Builder getInitialFileLocation() {
            return initialFileLocation != null ? initialFileLocation.toBuilder() : null;
        }

        public final void setInitialFileLocation(FileLocation.BuilderImpl initialFileLocation) {
            this.initialFileLocation = initialFileLocation != null ? initialFileLocation.build() : null;
        }

        @Override
        public final Builder initialFileLocation(FileLocation initialFileLocation) {
            this.initialFileLocation = initialFileLocation;
            return this;
        }

        public final ServiceMetadata.Builder getServiceMetadata() {
            return serviceMetadata != null ? serviceMetadata.toBuilder() : null;
        }

        public final void setServiceMetadata(ServiceMetadata.BuilderImpl serviceMetadata) {
            this.serviceMetadata = serviceMetadata != null ? serviceMetadata.build() : null;
        }

        @Override
        public final Builder serviceMetadata(ServiceMetadata serviceMetadata) {
            this.serviceMetadata = serviceMetadata;
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return loggingConfiguration != null ? loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final PosixProfile.Builder getPosixProfile() {
            return posixProfile != null ? posixProfile.toBuilder() : null;
        }

        public final void setPosixProfile(PosixProfile.BuilderImpl posixProfile) {
            this.posixProfile = posixProfile != null ? posixProfile.build() : null;
        }

        @Override
        public final Builder posixProfile(PosixProfile posixProfile) {
            this.posixProfile = posixProfile;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ExecutionResults.Builder getResults() {
            return results != null ? results.toBuilder() : null;
        }

        public final void setResults(ExecutionResults.BuilderImpl results) {
            this.results = results != null ? results.build() : null;
        }

        @Override
        public final Builder results(ExecutionResults results) {
            this.results = results;
            return this;
        }

        @Override
        public DescribedExecution build() {
            return new DescribedExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
