/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container object for the session details associated with a workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceMetadata implements SdkPojo, Serializable, ToCopyableBuilder<ServiceMetadata.Builder, ServiceMetadata> {
    private static final SdkField<UserDetails> USER_DETAILS_FIELD = SdkField.<UserDetails> builder(MarshallingType.SDK_POJO)
            .memberName("UserDetails").getter(getter(ServiceMetadata::userDetails)).setter(setter(Builder::userDetails))
            .constructor(UserDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final UserDetails userDetails;

    private ServiceMetadata(BuilderImpl builder) {
        this.userDetails = builder.userDetails;
    }

    /**
     * <p>
     * The Server ID (<code>ServerId</code>), Session ID (<code>SessionId</code>) and user (<code>UserName</code>) make
     * up the <code>UserDetails</code>.
     * </p>
     * 
     * @return The Server ID (<code>ServerId</code>), Session ID (<code>SessionId</code>) and user (
     *         <code>UserName</code>) make up the <code>UserDetails</code>.
     */
    public final UserDetails userDetails() {
        return userDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceMetadata)) {
            return false;
        }
        ServiceMetadata other = (ServiceMetadata) obj;
        return Objects.equals(userDetails(), other.userDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceMetadata").add("UserDetails", userDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserDetails":
            return Optional.ofNullable(clazz.cast(userDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceMetadata, T> g) {
        return obj -> g.apply((ServiceMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceMetadata> {
        /**
         * <p>
         * The Server ID (<code>ServerId</code>), Session ID (<code>SessionId</code>) and user (<code>UserName</code>)
         * make up the <code>UserDetails</code>.
         * </p>
         * 
         * @param userDetails
         *        The Server ID (<code>ServerId</code>), Session ID (<code>SessionId</code>) and user (
         *        <code>UserName</code>) make up the <code>UserDetails</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDetails(UserDetails userDetails);

        /**
         * <p>
         * The Server ID (<code>ServerId</code>), Session ID (<code>SessionId</code>) and user (<code>UserName</code>)
         * make up the <code>UserDetails</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserDetails.Builder} avoiding the need to
         * create one manually via {@link UserDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserDetails.Builder#build()} is called immediately and its result
         * is passed to {@link #userDetails(UserDetails)}.
         * 
         * @param userDetails
         *        a consumer that will call methods on {@link UserDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userDetails(UserDetails)
         */
        default Builder userDetails(Consumer<UserDetails.Builder> userDetails) {
            return userDetails(UserDetails.builder().applyMutation(userDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UserDetails userDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceMetadata model) {
            userDetails(model.userDetails);
        }

        public final UserDetails.Builder getUserDetails() {
            return userDetails != null ? userDetails.toBuilder() : null;
        }

        public final void setUserDetails(UserDetails.BuilderImpl userDetails) {
            this.userDetails = userDetails != null ? userDetails.build() : null;
        }

        @Override
        public final Builder userDetails(UserDetails userDetails) {
            this.userDetails = userDetails;
            return this;
        }

        @Override
        public ServiceMetadata build() {
            return new ServiceMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
