/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportSshPublicKeyRequest extends TransferRequest implements
        ToCopyableBuilder<ImportSshPublicKeyRequest.Builder, ImportSshPublicKeyRequest> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerId").getter(getter(ImportSshPublicKeyRequest::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SshPublicKeyBody").getter(getter(ImportSshPublicKeyRequest::sshPublicKeyBody))
            .setter(setter(Builder::sshPublicKeyBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKeyBody").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(ImportSshPublicKeyRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD,
            SSH_PUBLIC_KEY_BODY_FIELD, USER_NAME_FIELD));

    private final String serverId;

    private final String sshPublicKeyBody;

    private final String userName;

    private ImportSshPublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.sshPublicKeyBody = builder.sshPublicKeyBody;
        this.userName = builder.userName;
    }

    /**
     * <p>
     * A system-assigned unique identifier for a server.
     * </p>
     * 
     * @return A system-assigned unique identifier for a server.
     */
    public final String serverId() {
        return serverId;
    }

    /**
     * <p>
     * The public key portion of an SSH key pair.
     * </p>
     * 
     * @return The public key portion of an SSH key pair.
     */
    public final String sshPublicKeyBody() {
        return sshPublicKeyBody;
    }

    /**
     * <p>
     * The name of the user account that is assigned to one or more servers.
     * </p>
     * 
     * @return The name of the user account that is assigned to one or more servers.
     */
    public final String userName() {
        return userName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKeyBody());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSshPublicKeyRequest)) {
            return false;
        }
        ImportSshPublicKeyRequest other = (ImportSshPublicKeyRequest) obj;
        return Objects.equals(serverId(), other.serverId()) && Objects.equals(sshPublicKeyBody(), other.sshPublicKeyBody())
                && Objects.equals(userName(), other.userName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportSshPublicKeyRequest").add("ServerId", serverId())
                .add("SshPublicKeyBody", sshPublicKeyBody()).add("UserName", userName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "SshPublicKeyBody":
            return Optional.ofNullable(clazz.cast(sshPublicKeyBody()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportSshPublicKeyRequest, T> g) {
        return obj -> g.apply((ImportSshPublicKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportSshPublicKeyRequest> {
        /**
         * <p>
         * A system-assigned unique identifier for a server.
         * </p>
         * 
         * @param serverId
         *        A system-assigned unique identifier for a server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * The public key portion of an SSH key pair.
         * </p>
         * 
         * @param sshPublicKeyBody
         *        The public key portion of an SSH key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeyBody(String sshPublicKeyBody);

        /**
         * <p>
         * The name of the user account that is assigned to one or more servers.
         * </p>
         * 
         * @param userName
         *        The name of the user account that is assigned to one or more servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private String serverId;

        private String sshPublicKeyBody;

        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSshPublicKeyRequest model) {
            super(model);
            serverId(model.serverId);
            sshPublicKeyBody(model.sshPublicKeyBody);
            userName(model.userName);
        }

        public final String getServerId() {
            return serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getSshPublicKeyBody() {
            return sshPublicKeyBody;
        }

        public final void setSshPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
        }

        @Override
        public final Builder sshPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportSshPublicKeyRequest build() {
            return new ImportSshPublicKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
