/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkflowRequest extends TransferRequest implements
        ToCopyableBuilder<CreateWorkflowRequest.Builder, CreateWorkflowRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateWorkflowRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<WorkflowStep>> STEPS_FIELD = SdkField
            .<List<WorkflowStep>> builder(MarshallingType.LIST)
            .memberName("Steps")
            .getter(getter(CreateWorkflowRequest::steps))
            .setter(setter(Builder::steps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<WorkflowStep>> ON_EXCEPTION_STEPS_FIELD = SdkField
            .<List<WorkflowStep>> builder(MarshallingType.LIST)
            .memberName("OnExceptionSteps")
            .getter(getter(CreateWorkflowRequest::onExceptionSteps))
            .setter(setter(Builder::onExceptionSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnExceptionSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateWorkflowRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            STEPS_FIELD, ON_EXCEPTION_STEPS_FIELD, TAGS_FIELD));

    private final String description;

    private final List<WorkflowStep> steps;

    private final List<WorkflowStep> onExceptionSteps;

    private final List<Tag> tags;

    private CreateWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.steps = builder.steps;
        this.onExceptionSteps = builder.onExceptionSteps;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A textual description for the workflow.
     * </p>
     * 
     * @return A textual description for the workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Steps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSteps() {
        return steps != null && !(steps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the details for the steps that are in the specified workflow.
     * </p>
     * <p>
     * The <code>TYPE</code> specifies which of the following actions is being taken for this step.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>COPY</i>: copy the file to another location
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>CUSTOM</i>: custom step with a lambda target
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>DELETE</i>: delete the file
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>TAG</i>: add a tag to the file
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Currently, copying and tagging are supported only on S3.
     * </p>
     * </note>
     * <p>
     * For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSteps} method.
     * </p>
     * 
     * @return Specifies the details for the steps that are in the specified workflow.</p>
     *         <p>
     *         The <code>TYPE</code> specifies which of the following actions is being taken for this step.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>COPY</i>: copy the file to another location
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>CUSTOM</i>: custom step with a lambda target
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>DELETE</i>: delete the file
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>TAG</i>: add a tag to the file
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Currently, copying and tagging are supported only on S3.
     *         </p>
     *         </note>
     *         <p>
     *         For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path.
     */
    public final List<WorkflowStep> steps() {
        return steps;
    }

    /**
     * For responses, this returns true if the service returned a value for the OnExceptionSteps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOnExceptionSteps() {
        return onExceptionSteps != null && !(onExceptionSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
     * </p>
     * <note>
     * <p>
     * For custom steps, the lambda function needs to send <code>FAILURE</code> to the call back API to kick off the
     * exception steps. Additionally, if the lambda does not send <code>SUCCESS</code> before it times out, the
     * exception steps are executed.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOnExceptionSteps} method.
     * </p>
     * 
     * @return Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>
     *         <note>
     *         <p>
     *         For custom steps, the lambda function needs to send <code>FAILURE</code> to the call back API to kick off
     *         the exception steps. Additionally, if the lambda does not send <code>SUCCESS</code> before it times out,
     *         the exception steps are executed.
     *         </p>
     */
    public final List<WorkflowStep> onExceptionSteps() {
        return onExceptionSteps;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to workflows for
     * any purpose.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to
     *         workflows for any purpose.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSteps() ? steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOnExceptionSteps() ? onExceptionSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowRequest)) {
            return false;
        }
        CreateWorkflowRequest other = (CreateWorkflowRequest) obj;
        return Objects.equals(description(), other.description()) && hasSteps() == other.hasSteps()
                && Objects.equals(steps(), other.steps()) && hasOnExceptionSteps() == other.hasOnExceptionSteps()
                && Objects.equals(onExceptionSteps(), other.onExceptionSteps()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkflowRequest").add("Description", description())
                .add("Steps", hasSteps() ? steps() : null)
                .add("OnExceptionSteps", hasOnExceptionSteps() ? onExceptionSteps() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Steps":
            return Optional.ofNullable(clazz.cast(steps()));
        case "OnExceptionSteps":
            return Optional.ofNullable(clazz.cast(onExceptionSteps()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowRequest, T> g) {
        return obj -> g.apply((CreateWorkflowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkflowRequest> {
        /**
         * <p>
         * A textual description for the workflow.
         * </p>
         * 
         * @param description
         *        A textual description for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the details for the steps that are in the specified workflow.
         * </p>
         * <p>
         * The <code>TYPE</code> specifies which of the following actions is being taken for this step.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>COPY</i>: copy the file to another location
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>CUSTOM</i>: custom step with a lambda target
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>DELETE</i>: delete the file
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>TAG</i>: add a tag to the file
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Currently, copying and tagging are supported only on S3.
         * </p>
         * </note>
         * <p>
         * For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path.
         * </p>
         * 
         * @param steps
         *        Specifies the details for the steps that are in the specified workflow.</p>
         *        <p>
         *        The <code>TYPE</code> specifies which of the following actions is being taken for this step.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>COPY</i>: copy the file to another location
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>CUSTOM</i>: custom step with a lambda target
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>DELETE</i>: delete the file
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>TAG</i>: add a tag to the file
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Currently, copying and tagging are supported only on S3.
         *        </p>
         *        </note>
         *        <p>
         *        For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Collection<WorkflowStep> steps);

        /**
         * <p>
         * Specifies the details for the steps that are in the specified workflow.
         * </p>
         * <p>
         * The <code>TYPE</code> specifies which of the following actions is being taken for this step.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>COPY</i>: copy the file to another location
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>CUSTOM</i>: custom step with a lambda target
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>DELETE</i>: delete the file
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>TAG</i>: add a tag to the file
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Currently, copying and tagging are supported only on S3.
         * </p>
         * </note>
         * <p>
         * For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path.
         * </p>
         * 
         * @param steps
         *        Specifies the details for the steps that are in the specified workflow.</p>
         *        <p>
         *        The <code>TYPE</code> specifies which of the following actions is being taken for this step.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>COPY</i>: copy the file to another location
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>CUSTOM</i>: custom step with a lambda target
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>DELETE</i>: delete the file
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>TAG</i>: add a tag to the file
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Currently, copying and tagging are supported only on S3.
         *        </p>
         *        </note>
         *        <p>
         *        For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(WorkflowStep... steps);

        /**
         * <p>
         * Specifies the details for the steps that are in the specified workflow.
         * </p>
         * <p>
         * The <code>TYPE</code> specifies which of the following actions is being taken for this step.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>COPY</i>: copy the file to another location
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>CUSTOM</i>: custom step with a lambda target
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>DELETE</i>: delete the file
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>TAG</i>: add a tag to the file
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Currently, copying and tagging are supported only on S3.
         * </p>
         * </note>
         * <p>
         * For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<WorkflowStep>.Builder} avoiding the
         * need to create one manually via {@link List<WorkflowStep>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WorkflowStep>.Builder#build()} is called immediately and its
         * result is passed to {@link #steps(List<WorkflowStep>)}.
         * 
         * @param steps
         *        a consumer that will call methods on {@link List<WorkflowStep>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #steps(List<WorkflowStep>)
         */
        Builder steps(Consumer<WorkflowStep.Builder>... steps);

        /**
         * <p>
         * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
         * </p>
         * <note>
         * <p>
         * For custom steps, the lambda function needs to send <code>FAILURE</code> to the call back API to kick off the
         * exception steps. Additionally, if the lambda does not send <code>SUCCESS</code> before it times out, the
         * exception steps are executed.
         * </p>
         * </note>
         * 
         * @param onExceptionSteps
         *        Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>
         *        <note>
         *        <p>
         *        For custom steps, the lambda function needs to send <code>FAILURE</code> to the call back API to kick
         *        off the exception steps. Additionally, if the lambda does not send <code>SUCCESS</code> before it
         *        times out, the exception steps are executed.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onExceptionSteps(Collection<WorkflowStep> onExceptionSteps);

        /**
         * <p>
         * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
         * </p>
         * <note>
         * <p>
         * For custom steps, the lambda function needs to send <code>FAILURE</code> to the call back API to kick off the
         * exception steps. Additionally, if the lambda does not send <code>SUCCESS</code> before it times out, the
         * exception steps are executed.
         * </p>
         * </note>
         * 
         * @param onExceptionSteps
         *        Specifies the steps (actions) to take if errors are encountered during execution of the workflow.</p>
         *        <note>
         *        <p>
         *        For custom steps, the lambda function needs to send <code>FAILURE</code> to the call back API to kick
         *        off the exception steps. Additionally, if the lambda does not send <code>SUCCESS</code> before it
         *        times out, the exception steps are executed.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onExceptionSteps(WorkflowStep... onExceptionSteps);

        /**
         * <p>
         * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
         * </p>
         * <note>
         * <p>
         * For custom steps, the lambda function needs to send <code>FAILURE</code> to the call back API to kick off the
         * exception steps. Additionally, if the lambda does not send <code>SUCCESS</code> before it times out, the
         * exception steps are executed.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link List<WorkflowStep>.Builder}
         * avoiding the need to create one manually via {@link List<WorkflowStep>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WorkflowStep>.Builder#build()} is called immediately and its
         * result is passed to {@link #onExceptionSteps(List<WorkflowStep>)}.
         * 
         * @param onExceptionSteps
         *        a consumer that will call methods on {@link List<WorkflowStep>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onExceptionSteps(List<WorkflowStep>)
         */
        Builder onExceptionSteps(Consumer<WorkflowStep.Builder>... onExceptionSteps);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to workflows
         * for any purpose.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to
         *        workflows for any purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to workflows
         * for any purpose.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to
         *        workflows for any purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to workflows
         * for any purpose.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private String description;

        private List<WorkflowStep> steps = DefaultSdkAutoConstructList.getInstance();

        private List<WorkflowStep> onExceptionSteps = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowRequest model) {
            super(model);
            description(model.description);
            steps(model.steps);
            onExceptionSteps(model.onExceptionSteps);
            tags(model.tags);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<WorkflowStep.Builder> getSteps() {
            List<WorkflowStep.Builder> result = WorkflowStepsCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<WorkflowStep.BuilderImpl> steps) {
            this.steps = WorkflowStepsCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<WorkflowStep> steps) {
            this.steps = WorkflowStepsCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(WorkflowStep... steps) {
            steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<WorkflowStep.Builder>... steps) {
            steps(Stream.of(steps).map(c -> WorkflowStep.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<WorkflowStep.Builder> getOnExceptionSteps() {
            List<WorkflowStep.Builder> result = WorkflowStepsCopier.copyToBuilder(this.onExceptionSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOnExceptionSteps(Collection<WorkflowStep.BuilderImpl> onExceptionSteps) {
            this.onExceptionSteps = WorkflowStepsCopier.copyFromBuilder(onExceptionSteps);
        }

        @Override
        public final Builder onExceptionSteps(Collection<WorkflowStep> onExceptionSteps) {
            this.onExceptionSteps = WorkflowStepsCopier.copy(onExceptionSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onExceptionSteps(WorkflowStep... onExceptionSteps) {
            onExceptionSteps(Arrays.asList(onExceptionSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onExceptionSteps(Consumer<WorkflowStep.Builder>... onExceptionSteps) {
            onExceptionSteps(Stream.of(onExceptionSteps).map(c -> WorkflowStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkflowRequest build() {
            return new CreateWorkflowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
