/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExecutionsRequest extends TransferRequest implements
        ToCopyableBuilder<ListExecutionsRequest.Builder, ListExecutionsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListExecutionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListExecutionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowId").getter(getter(ListExecutionsRequest::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, WORKFLOW_ID_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final String workflowId;

    private ListExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.workflowId = builder.workflowId;
    }

    /**
     * <p>
     * Specifies the aximum number of executions to return.
     * </p>
     * 
     * @return Specifies the aximum number of executions to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output. You can then pass the
     * <code>NextToken</code> parameter in a subsequent command to continue listing additional executions.
     * </p>
     * <p>
     * This is useful for pagination, for instance. If you have 100 executions for a workflow, you might only want to
     * list first 10. If so, callthe API by specifing the <code>max-results</code>:
     * </p>
     * <p>
     * <code>aws transfer list-executions --max-results 10</code>
     * </p>
     * <p>
     * This returns details for the first 10 executions, as well as the pointer (<code>NextToken</code>) to the eleventh
     * execution. You can now call the API again, suppling the <code>NextToken</code> value you received:
     * </p>
     * <p>
     * <code>aws transfer list-executions --max-results 10 --next-token $somePointerReturnedFromPreviousListResult</code>
     * </p>
     * <p>
     * This call returns the next 10 executions, the 11th through the 20th. You can then repeat the call until the
     * details for all 100 executions have been returned.
     * </p>
     * 
     * @return <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output. You can then pass
     *         the <code>NextToken</code> parameter in a subsequent command to continue listing additional
     *         executions.</p>
     *         <p>
     *         This is useful for pagination, for instance. If you have 100 executions for a workflow, you might only
     *         want to list first 10. If so, callthe API by specifing the <code>max-results</code>:
     *         </p>
     *         <p>
     *         <code>aws transfer list-executions --max-results 10</code>
     *         </p>
     *         <p>
     *         This returns details for the first 10 executions, as well as the pointer (<code>NextToken</code>) to the
     *         eleventh execution. You can now call the API again, suppling the <code>NextToken</code> value you
     *         received:
     *         </p>
     *         <p>
     *         <code>aws transfer list-executions --max-results 10 --next-token $somePointerReturnedFromPreviousListResult</code>
     *         </p>
     *         <p>
     *         This call returns the next 10 executions, the 11th through the 20th. You can then repeat the call until
     *         the details for all 100 executions have been returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A unique identifier for the workflow.
     * </p>
     * 
     * @return A unique identifier for the workflow.
     */
    public final String workflowId() {
        return workflowId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExecutionsRequest)) {
            return false;
        }
        ListExecutionsRequest other = (ListExecutionsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(workflowId(), other.workflowId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListExecutionsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("WorkflowId", workflowId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "WorkflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExecutionsRequest, T> g) {
        return obj -> g.apply((ListExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListExecutionsRequest> {
        /**
         * <p>
         * Specifies the aximum number of executions to return.
         * </p>
         * 
         * @param maxResults
         *        Specifies the aximum number of executions to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output. You can then pass the
         * <code>NextToken</code> parameter in a subsequent command to continue listing additional executions.
         * </p>
         * <p>
         * This is useful for pagination, for instance. If you have 100 executions for a workflow, you might only want
         * to list first 10. If so, callthe API by specifing the <code>max-results</code>:
         * </p>
         * <p>
         * <code>aws transfer list-executions --max-results 10</code>
         * </p>
         * <p>
         * This returns details for the first 10 executions, as well as the pointer (<code>NextToken</code>) to the
         * eleventh execution. You can now call the API again, suppling the <code>NextToken</code> value you received:
         * </p>
         * <p>
         * <code>aws transfer list-executions --max-results 10 --next-token $somePointerReturnedFromPreviousListResult</code>
         * </p>
         * <p>
         * This call returns the next 10 executions, the 11th through the 20th. You can then repeat the call until the
         * details for all 100 executions have been returned.
         * </p>
         * 
         * @param nextToken
         *        <code>ListExecutions</code> returns the <code>NextToken</code> parameter in the output. You can then
         *        pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional
         *        executions.</p>
         *        <p>
         *        This is useful for pagination, for instance. If you have 100 executions for a workflow, you might only
         *        want to list first 10. If so, callthe API by specifing the <code>max-results</code>:
         *        </p>
         *        <p>
         *        <code>aws transfer list-executions --max-results 10</code>
         *        </p>
         *        <p>
         *        This returns details for the first 10 executions, as well as the pointer (<code>NextToken</code>) to
         *        the eleventh execution. You can now call the API again, suppling the <code>NextToken</code> value you
         *        received:
         *        </p>
         *        <p>
         *        <code>aws transfer list-executions --max-results 10 --next-token $somePointerReturnedFromPreviousListResult</code>
         *        </p>
         *        <p>
         *        This call returns the next 10 executions, the 11th through the 20th. You can then repeat the call
         *        until the details for all 100 executions have been returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A unique identifier for the workflow.
         * </p>
         * 
         * @param workflowId
         *        A unique identifier for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String workflowId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExecutionsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            workflowId(model.workflowId);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListExecutionsRequest build() {
            return new ListExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
