/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of an agreement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedAgreement implements SdkPojo, Serializable, ToCopyableBuilder<ListedAgreement.Builder, ListedAgreement> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ListedAgreement::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> AGREEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgreementId").getter(getter(ListedAgreement::agreementId)).setter(setter(Builder::agreementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgreementId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ListedAgreement::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListedAgreement::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerId").getter(getter(ListedAgreement::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<String> LOCAL_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocalProfileId").getter(getter(ListedAgreement::localProfileId)).setter(setter(Builder::localProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalProfileId").build()).build();

    private static final SdkField<String> PARTNER_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartnerProfileId").getter(getter(ListedAgreement::partnerProfileId))
            .setter(setter(Builder::partnerProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerProfileId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AGREEMENT_ID_FIELD,
            DESCRIPTION_FIELD, STATUS_FIELD, SERVER_ID_FIELD, LOCAL_PROFILE_ID_FIELD, PARTNER_PROFILE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String agreementId;

    private final String description;

    private final String status;

    private final String serverId;

    private final String localProfileId;

    private final String partnerProfileId;

    private ListedAgreement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.agreementId = builder.agreementId;
        this.description = builder.description;
        this.status = builder.status;
        this.serverId = builder.serverId;
        this.localProfileId = builder.localProfileId;
        this.partnerProfileId = builder.partnerProfileId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the specified agreement.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the specified agreement.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A unique identifier for the agreement. This identifier is returned when you create an agreement.
     * </p>
     * 
     * @return A unique identifier for the agreement. This identifier is returned when you create an agreement.
     */
    public final String agreementId() {
        return agreementId;
    }

    /**
     * <p>
     * The current description for the agreement. You can change it by calling the <code>UpdateAgreement</code>
     * operation and providing a new description.
     * </p>
     * 
     * @return The current description for the agreement. You can change it by calling the <code>UpdateAgreement</code>
     *         operation and providing a new description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The agreement can be either <code>ACTIVE</code> or <code>INACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgreementStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The agreement can be either <code>ACTIVE</code> or <code>INACTIVE</code>.
     * @see AgreementStatusType
     */
    public final AgreementStatusType status() {
        return AgreementStatusType.fromValue(status);
    }

    /**
     * <p>
     * The agreement can be either <code>ACTIVE</code> or <code>INACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgreementStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The agreement can be either <code>ACTIVE</code> or <code>INACTIVE</code>.
     * @see AgreementStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The unique identifier for the agreement.
     * </p>
     * 
     * @return The unique identifier for the agreement.
     */
    public final String serverId() {
        return serverId;
    }

    /**
     * <p>
     * A unique identifier for the AS2 process.
     * </p>
     * 
     * @return A unique identifier for the AS2 process.
     */
    public final String localProfileId() {
        return localProfileId;
    }

    /**
     * <p>
     * A unique identifier for the partner process.
     * </p>
     * 
     * @return A unique identifier for the partner process.
     */
    public final String partnerProfileId() {
        return partnerProfileId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(agreementId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(localProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(partnerProfileId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedAgreement)) {
            return false;
        }
        ListedAgreement other = (ListedAgreement) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(agreementId(), other.agreementId())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(serverId(), other.serverId()) && Objects.equals(localProfileId(), other.localProfileId())
                && Objects.equals(partnerProfileId(), other.partnerProfileId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListedAgreement").add("Arn", arn()).add("AgreementId", agreementId())
                .add("Description", description()).add("Status", statusAsString()).add("ServerId", serverId())
                .add("LocalProfileId", localProfileId()).add("PartnerProfileId", partnerProfileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AgreementId":
            return Optional.ofNullable(clazz.cast(agreementId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "LocalProfileId":
            return Optional.ofNullable(clazz.cast(localProfileId()));
        case "PartnerProfileId":
            return Optional.ofNullable(clazz.cast(partnerProfileId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListedAgreement, T> g) {
        return obj -> g.apply((ListedAgreement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedAgreement> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the specified agreement.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the specified agreement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A unique identifier for the agreement. This identifier is returned when you create an agreement.
         * </p>
         * 
         * @param agreementId
         *        A unique identifier for the agreement. This identifier is returned when you create an agreement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementId(String agreementId);

        /**
         * <p>
         * The current description for the agreement. You can change it by calling the <code>UpdateAgreement</code>
         * operation and providing a new description.
         * </p>
         * 
         * @param description
         *        The current description for the agreement. You can change it by calling the
         *        <code>UpdateAgreement</code> operation and providing a new description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The agreement can be either <code>ACTIVE</code> or <code>INACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The agreement can be either <code>ACTIVE</code> or <code>INACTIVE</code>.
         * @see AgreementStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgreementStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The agreement can be either <code>ACTIVE</code> or <code>INACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The agreement can be either <code>ACTIVE</code> or <code>INACTIVE</code>.
         * @see AgreementStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgreementStatusType
         */
        Builder status(AgreementStatusType status);

        /**
         * <p>
         * The unique identifier for the agreement.
         * </p>
         * 
         * @param serverId
         *        The unique identifier for the agreement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * A unique identifier for the AS2 process.
         * </p>
         * 
         * @param localProfileId
         *        A unique identifier for the AS2 process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localProfileId(String localProfileId);

        /**
         * <p>
         * A unique identifier for the partner process.
         * </p>
         * 
         * @param partnerProfileId
         *        A unique identifier for the partner process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerProfileId(String partnerProfileId);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String agreementId;

        private String description;

        private String status;

        private String serverId;

        private String localProfileId;

        private String partnerProfileId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedAgreement model) {
            arn(model.arn);
            agreementId(model.agreementId);
            description(model.description);
            status(model.status);
            serverId(model.serverId);
            localProfileId(model.localProfileId);
            partnerProfileId(model.partnerProfileId);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAgreementId() {
            return agreementId;
        }

        public final void setAgreementId(String agreementId) {
            this.agreementId = agreementId;
        }

        @Override
        public final Builder agreementId(String agreementId) {
            this.agreementId = agreementId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgreementStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getServerId() {
            return serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getLocalProfileId() {
            return localProfileId;
        }

        public final void setLocalProfileId(String localProfileId) {
            this.localProfileId = localProfileId;
        }

        @Override
        public final Builder localProfileId(String localProfileId) {
            this.localProfileId = localProfileId;
            return this;
        }

        public final String getPartnerProfileId() {
            return partnerProfileId;
        }

        public final void setPartnerProfileId(String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
        }

        @Override
        public final Builder partnerProfileId(String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
            return this;
        }

        @Override
        public ListedAgreement build() {
            return new ListedAgreement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
