/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for a local or partner AS2 profile. profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribedProfile implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribedProfile.Builder, DescribedProfile> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribedProfile::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(DescribedProfile::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()).build();

    private static final SdkField<String> PROFILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileType").getter(getter(DescribedProfile::profileTypeAsString)).setter(setter(Builder::profileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileType").build()).build();

    private static final SdkField<String> AS2_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("As2Id")
            .getter(getter(DescribedProfile::as2Id)).setter(setter(Builder::as2Id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("As2Id").build()).build();

    private static final SdkField<List<String>> CERTIFICATE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CertificateIds")
            .getter(getter(DescribedProfile::certificateIds))
            .setter(setter(Builder::certificateIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(DescribedProfile::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PROFILE_ID_FIELD,
            PROFILE_TYPE_FIELD, AS2_ID_FIELD, CERTIFICATE_IDS_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String profileId;

    private final String profileType;

    private final String as2Id;

    private final List<String> certificateIds;

    private final List<Tag> tags;

    private DescribedProfile(BuilderImpl builder) {
        this.arn = builder.arn;
        this.profileId = builder.profileId;
        this.profileType = builder.profileType;
        this.as2Id = builder.as2Id;
        this.certificateIds = builder.certificateIds;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) for the profile.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) for the profile.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A unique identifier for the local or partner AS2 profile.
     * </p>
     * 
     * @return A unique identifier for the local or partner AS2 profile.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type profiles. If
     * not supplied in the request, the command lists all types of profiles.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profileType} will
     * return {@link ProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type
     *         profiles. If not supplied in the request, the command lists all types of profiles.
     * @see ProfileType
     */
    public final ProfileType profileType() {
        return ProfileType.fromValue(profileType);
    }

    /**
     * <p>
     * Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type profiles. If
     * not supplied in the request, the command lists all types of profiles.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profileType} will
     * return {@link ProfileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type
     *         profiles. If not supplied in the request, the command lists all types of profiles.
     * @see ProfileType
     */
    public final String profileTypeAsString() {
        return profileType;
    }

    /**
     * <p>
     * The unique identifier for the AS2 process.
     * </p>
     * 
     * @return The unique identifier for the AS2 process.
     */
    public final String as2Id() {
        return as2Id;
    }

    /**
     * For responses, this returns true if the service returned a value for the CertificateIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCertificateIds() {
        return certificateIds != null && !(certificateIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of identifiers for the imported certificates. You use this identifier for working with profiles and
     * partner profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCertificateIds} method.
     * </p>
     * 
     * @return An array of identifiers for the imported certificates. You use this identifier for working with profiles
     *         and partner profiles.
     */
    public final List<String> certificateIds() {
        return certificateIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Key-value pairs that can be used to group and search for profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs that can be used to group and search for profiles.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(profileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(as2Id());
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificateIds() ? certificateIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedProfile)) {
            return false;
        }
        DescribedProfile other = (DescribedProfile) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(profileId(), other.profileId())
                && Objects.equals(profileTypeAsString(), other.profileTypeAsString()) && Objects.equals(as2Id(), other.as2Id())
                && hasCertificateIds() == other.hasCertificateIds() && Objects.equals(certificateIds(), other.certificateIds())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribedProfile").add("Arn", arn()).add("ProfileId", profileId())
                .add("ProfileType", profileTypeAsString()).add("As2Id", as2Id())
                .add("CertificateIds", hasCertificateIds() ? certificateIds() : null).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "ProfileType":
            return Optional.ofNullable(clazz.cast(profileTypeAsString()));
        case "As2Id":
            return Optional.ofNullable(clazz.cast(as2Id()));
        case "CertificateIds":
            return Optional.ofNullable(clazz.cast(certificateIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribedProfile, T> g) {
        return obj -> g.apply((DescribedProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribedProfile> {
        /**
         * <p>
         * The unique Amazon Resource Name (ARN) for the profile.
         * </p>
         * 
         * @param arn
         *        The unique Amazon Resource Name (ARN) for the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A unique identifier for the local or partner AS2 profile.
         * </p>
         * 
         * @param profileId
         *        A unique identifier for the local or partner AS2 profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type profiles.
         * If not supplied in the request, the command lists all types of profiles.
         * </p>
         * 
         * @param profileType
         *        Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type
         *        profiles. If not supplied in the request, the command lists all types of profiles.
         * @see ProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileType
         */
        Builder profileType(String profileType);

        /**
         * <p>
         * Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type profiles.
         * If not supplied in the request, the command lists all types of profiles.
         * </p>
         * 
         * @param profileType
         *        Indicates whether to list only <code>LOCAL</code> type profiles or only <code>PARTNER</code> type
         *        profiles. If not supplied in the request, the command lists all types of profiles.
         * @see ProfileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProfileType
         */
        Builder profileType(ProfileType profileType);

        /**
         * <p>
         * The unique identifier for the AS2 process.
         * </p>
         * 
         * @param as2Id
         *        The unique identifier for the AS2 process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder as2Id(String as2Id);

        /**
         * <p>
         * An array of identifiers for the imported certificates. You use this identifier for working with profiles and
         * partner profiles.
         * </p>
         * 
         * @param certificateIds
         *        An array of identifiers for the imported certificates. You use this identifier for working with
         *        profiles and partner profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateIds(Collection<String> certificateIds);

        /**
         * <p>
         * An array of identifiers for the imported certificates. You use this identifier for working with profiles and
         * partner profiles.
         * </p>
         * 
         * @param certificateIds
         *        An array of identifiers for the imported certificates. You use this identifier for working with
         *        profiles and partner profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateIds(String... certificateIds);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for profiles.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for profiles.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for profiles.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String profileId;

        private String profileType;

        private String as2Id;

        private List<String> certificateIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedProfile model) {
            arn(model.arn);
            profileId(model.profileId);
            profileType(model.profileType);
            as2Id(model.as2Id);
            certificateIds(model.certificateIds);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getProfileType() {
            return profileType;
        }

        public final void setProfileType(String profileType) {
            this.profileType = profileType;
        }

        @Override
        public final Builder profileType(String profileType) {
            this.profileType = profileType;
            return this;
        }

        @Override
        public final Builder profileType(ProfileType profileType) {
            this.profileType(profileType == null ? null : profileType.toString());
            return this;
        }

        public final String getAs2Id() {
            return as2Id;
        }

        public final void setAs2Id(String as2Id) {
            this.as2Id = as2Id;
        }

        @Override
        public final Builder as2Id(String as2Id) {
            this.as2Id = as2Id;
            return this;
        }

        public final Collection<String> getCertificateIds() {
            if (certificateIds instanceof SdkAutoConstructList) {
                return null;
            }
            return certificateIds;
        }

        public final void setCertificateIds(Collection<String> certificateIds) {
            this.certificateIds = CertificateIdsCopier.copy(certificateIds);
        }

        @Override
        public final Builder certificateIds(Collection<String> certificateIds) {
            this.certificateIds = CertificateIdsCopier.copy(certificateIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateIds(String... certificateIds) {
            certificateIds(Arrays.asList(certificateIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribedProfile build() {
            return new DescribedProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
