/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.transfer.model.AccessDeniedException;
import software.amazon.awssdk.services.transfer.model.ConflictException;
import software.amazon.awssdk.services.transfer.model.CreateAccessRequest;
import software.amazon.awssdk.services.transfer.model.CreateAccessResponse;
import software.amazon.awssdk.services.transfer.model.CreateAgreementRequest;
import software.amazon.awssdk.services.transfer.model.CreateAgreementResponse;
import software.amazon.awssdk.services.transfer.model.CreateConnectorRequest;
import software.amazon.awssdk.services.transfer.model.CreateConnectorResponse;
import software.amazon.awssdk.services.transfer.model.CreateProfileRequest;
import software.amazon.awssdk.services.transfer.model.CreateProfileResponse;
import software.amazon.awssdk.services.transfer.model.CreateServerRequest;
import software.amazon.awssdk.services.transfer.model.CreateServerResponse;
import software.amazon.awssdk.services.transfer.model.CreateUserRequest;
import software.amazon.awssdk.services.transfer.model.CreateUserResponse;
import software.amazon.awssdk.services.transfer.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.transfer.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.transfer.model.DeleteAccessRequest;
import software.amazon.awssdk.services.transfer.model.DeleteAccessResponse;
import software.amazon.awssdk.services.transfer.model.DeleteAgreementRequest;
import software.amazon.awssdk.services.transfer.model.DeleteAgreementResponse;
import software.amazon.awssdk.services.transfer.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.transfer.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.transfer.model.DeleteConnectorRequest;
import software.amazon.awssdk.services.transfer.model.DeleteConnectorResponse;
import software.amazon.awssdk.services.transfer.model.DeleteProfileRequest;
import software.amazon.awssdk.services.transfer.model.DeleteProfileResponse;
import software.amazon.awssdk.services.transfer.model.DeleteServerRequest;
import software.amazon.awssdk.services.transfer.model.DeleteServerResponse;
import software.amazon.awssdk.services.transfer.model.DeleteSshPublicKeyRequest;
import software.amazon.awssdk.services.transfer.model.DeleteSshPublicKeyResponse;
import software.amazon.awssdk.services.transfer.model.DeleteUserRequest;
import software.amazon.awssdk.services.transfer.model.DeleteUserResponse;
import software.amazon.awssdk.services.transfer.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.transfer.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.transfer.model.DescribeAccessRequest;
import software.amazon.awssdk.services.transfer.model.DescribeAccessResponse;
import software.amazon.awssdk.services.transfer.model.DescribeAgreementRequest;
import software.amazon.awssdk.services.transfer.model.DescribeAgreementResponse;
import software.amazon.awssdk.services.transfer.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.transfer.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.transfer.model.DescribeConnectorRequest;
import software.amazon.awssdk.services.transfer.model.DescribeConnectorResponse;
import software.amazon.awssdk.services.transfer.model.DescribeExecutionRequest;
import software.amazon.awssdk.services.transfer.model.DescribeExecutionResponse;
import software.amazon.awssdk.services.transfer.model.DescribeProfileRequest;
import software.amazon.awssdk.services.transfer.model.DescribeProfileResponse;
import software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyRequest;
import software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyResponse;
import software.amazon.awssdk.services.transfer.model.DescribeServerRequest;
import software.amazon.awssdk.services.transfer.model.DescribeServerResponse;
import software.amazon.awssdk.services.transfer.model.DescribeUserRequest;
import software.amazon.awssdk.services.transfer.model.DescribeUserResponse;
import software.amazon.awssdk.services.transfer.model.DescribeWorkflowRequest;
import software.amazon.awssdk.services.transfer.model.DescribeWorkflowResponse;
import software.amazon.awssdk.services.transfer.model.ImportCertificateRequest;
import software.amazon.awssdk.services.transfer.model.ImportCertificateResponse;
import software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyRequest;
import software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyResponse;
import software.amazon.awssdk.services.transfer.model.InternalServiceErrorException;
import software.amazon.awssdk.services.transfer.model.InvalidNextTokenException;
import software.amazon.awssdk.services.transfer.model.InvalidRequestException;
import software.amazon.awssdk.services.transfer.model.ListAccessesRequest;
import software.amazon.awssdk.services.transfer.model.ListAccessesResponse;
import software.amazon.awssdk.services.transfer.model.ListAgreementsRequest;
import software.amazon.awssdk.services.transfer.model.ListAgreementsResponse;
import software.amazon.awssdk.services.transfer.model.ListCertificatesRequest;
import software.amazon.awssdk.services.transfer.model.ListCertificatesResponse;
import software.amazon.awssdk.services.transfer.model.ListConnectorsRequest;
import software.amazon.awssdk.services.transfer.model.ListConnectorsResponse;
import software.amazon.awssdk.services.transfer.model.ListExecutionsRequest;
import software.amazon.awssdk.services.transfer.model.ListExecutionsResponse;
import software.amazon.awssdk.services.transfer.model.ListProfilesRequest;
import software.amazon.awssdk.services.transfer.model.ListProfilesResponse;
import software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesRequest;
import software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse;
import software.amazon.awssdk.services.transfer.model.ListServersRequest;
import software.amazon.awssdk.services.transfer.model.ListServersResponse;
import software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.transfer.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.transfer.model.ListUsersRequest;
import software.amazon.awssdk.services.transfer.model.ListUsersResponse;
import software.amazon.awssdk.services.transfer.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.transfer.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.transfer.model.ResourceExistsException;
import software.amazon.awssdk.services.transfer.model.ResourceNotFoundException;
import software.amazon.awssdk.services.transfer.model.SendWorkflowStepStateRequest;
import software.amazon.awssdk.services.transfer.model.SendWorkflowStepStateResponse;
import software.amazon.awssdk.services.transfer.model.ServiceUnavailableException;
import software.amazon.awssdk.services.transfer.model.StartFileTransferRequest;
import software.amazon.awssdk.services.transfer.model.StartFileTransferResponse;
import software.amazon.awssdk.services.transfer.model.StartServerRequest;
import software.amazon.awssdk.services.transfer.model.StartServerResponse;
import software.amazon.awssdk.services.transfer.model.StopServerRequest;
import software.amazon.awssdk.services.transfer.model.StopServerResponse;
import software.amazon.awssdk.services.transfer.model.TagResourceRequest;
import software.amazon.awssdk.services.transfer.model.TagResourceResponse;
import software.amazon.awssdk.services.transfer.model.TestIdentityProviderRequest;
import software.amazon.awssdk.services.transfer.model.TestIdentityProviderResponse;
import software.amazon.awssdk.services.transfer.model.ThrottlingException;
import software.amazon.awssdk.services.transfer.model.TransferException;
import software.amazon.awssdk.services.transfer.model.UntagResourceRequest;
import software.amazon.awssdk.services.transfer.model.UntagResourceResponse;
import software.amazon.awssdk.services.transfer.model.UpdateAccessRequest;
import software.amazon.awssdk.services.transfer.model.UpdateAccessResponse;
import software.amazon.awssdk.services.transfer.model.UpdateAgreementRequest;
import software.amazon.awssdk.services.transfer.model.UpdateAgreementResponse;
import software.amazon.awssdk.services.transfer.model.UpdateCertificateRequest;
import software.amazon.awssdk.services.transfer.model.UpdateCertificateResponse;
import software.amazon.awssdk.services.transfer.model.UpdateConnectorRequest;
import software.amazon.awssdk.services.transfer.model.UpdateConnectorResponse;
import software.amazon.awssdk.services.transfer.model.UpdateProfileRequest;
import software.amazon.awssdk.services.transfer.model.UpdateProfileResponse;
import software.amazon.awssdk.services.transfer.model.UpdateServerRequest;
import software.amazon.awssdk.services.transfer.model.UpdateServerResponse;
import software.amazon.awssdk.services.transfer.model.UpdateUserRequest;
import software.amazon.awssdk.services.transfer.model.UpdateUserResponse;
import software.amazon.awssdk.services.transfer.paginators.ListAccessesIterable;
import software.amazon.awssdk.services.transfer.paginators.ListAgreementsIterable;
import software.amazon.awssdk.services.transfer.paginators.ListCertificatesIterable;
import software.amazon.awssdk.services.transfer.paginators.ListConnectorsIterable;
import software.amazon.awssdk.services.transfer.paginators.ListExecutionsIterable;
import software.amazon.awssdk.services.transfer.paginators.ListProfilesIterable;
import software.amazon.awssdk.services.transfer.paginators.ListSecurityPoliciesIterable;
import software.amazon.awssdk.services.transfer.paginators.ListServersIterable;
import software.amazon.awssdk.services.transfer.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.transfer.paginators.ListUsersIterable;
import software.amazon.awssdk.services.transfer.paginators.ListWorkflowsIterable;
import software.amazon.awssdk.services.transfer.waiters.TransferWaiter;

/**
 * Service client for accessing AWS Transfer. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Transfer Family is a fully managed service that enables the transfer of files over the File Transfer Protocol (FTP),
 * File Transfer Protocol over SSL (FTPS), or Secure Shell (SSH) File Transfer Protocol (SFTP) directly into and out of
 * Amazon Simple Storage Service (Amazon S3). Amazon Web Services helps you seamlessly migrate your file transfer
 * workflows to Transfer Family by integrating with existing authentication systems, and providing DNS routing with
 * Amazon Route 53 so nothing changes for your customers and partners, or their applications. With your data in Amazon
 * S3, you can use it with Amazon Web Services for processing, analytics, machine learning, and archiving. Getting
 * started with Transfer Family is easy since there is no infrastructure to buy and set up.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface TransferClient extends SdkClient {
    String SERVICE_NAME = "transfer";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "transfer";

    /**
     * Create a {@link TransferClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TransferClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TransferClient}.
     */
    static TransferClientBuilder builder() {
        return new DefaultTransferClientBuilder();
    }

    /**
     * <p>
     * Used by administrators to choose which groups in the directory should have access to upload and download files
     * over the enabled protocols using Transfer Family. For example, a Microsoft Active Directory might contain 50,000
     * users, but only a small fraction might need the ability to transfer files to the server. An administrator can use
     * <code>CreateAccess</code> to limit the access to the correct set of users who need this ability.
     * </p>
     *
     * @param createAccessRequest
     * @return Result of the CreateAccess operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.CreateAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAccessResponse createAccess(CreateAccessRequest createAccessRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceExistsException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by administrators to choose which groups in the directory should have access to upload and download files
     * over the enabled protocols using Transfer Family. For example, a Microsoft Active Directory might contain 50,000
     * users, but only a small fraction might need the ability to transfer files to the server. An administrator can use
     * <code>CreateAccess</code> to limit the access to the correct set of users who need this ability.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAccessRequest#builder()}
     * </p>
     *
     * @param createAccessRequest
     *        A {@link Consumer} that will call methods on {@link CreateAccessRequest.Builder} to create a request.
     * @return Result of the CreateAccess operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.CreateAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAccessResponse createAccess(Consumer<CreateAccessRequest.Builder> createAccessRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return createAccess(CreateAccessRequest.builder().applyMutation(createAccessRequest).build());
    }

    /**
     * <p>
     * Creates an agreement. An agreement is a bilateral trading partner agreement, or partnership, between an Transfer
     * Family server and an AS2 process. The agreement defines the file and message transfer relationship between the
     * server and the AS2 process. To define an agreement, Transfer Family combines a server, local profile, partner
     * profile, certificate, and other attributes.
     * </p>
     * <p>
     * The partner is identified with the <code>PartnerProfileId</code>, and the AS2 process is identified with the
     * <code>LocalProfileId</code>.
     * </p>
     *
     * @param createAgreementRequest
     * @return Result of the CreateAgreement operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.CreateAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateAgreement" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAgreementResponse createAgreement(CreateAgreementRequest createAgreementRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an agreement. An agreement is a bilateral trading partner agreement, or partnership, between an Transfer
     * Family server and an AS2 process. The agreement defines the file and message transfer relationship between the
     * server and the AS2 process. To define an agreement, Transfer Family combines a server, local profile, partner
     * profile, certificate, and other attributes.
     * </p>
     * <p>
     * The partner is identified with the <code>PartnerProfileId</code>, and the AS2 process is identified with the
     * <code>LocalProfileId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAgreementRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAgreementRequest#builder()}
     * </p>
     *
     * @param createAgreementRequest
     *        A {@link Consumer} that will call methods on {@link CreateAgreementRequest.Builder} to create a request.
     * @return Result of the CreateAgreement operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.CreateAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateAgreement" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAgreementResponse createAgreement(Consumer<CreateAgreementRequest.Builder> createAgreementRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return createAgreement(CreateAgreementRequest.builder().applyMutation(createAgreementRequest).build());
    }

    /**
     * <p>
     * Creates the connector, which captures the parameters for an outbound connection for the AS2 protocol. The
     * connector is required for sending files from a customer's non Amazon Web Services server.
     * </p>
     *
     * @param createConnectorRequest
     * @return Result of the CreateConnector operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.CreateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateConnectorResponse createConnector(CreateConnectorRequest createConnectorRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the connector, which captures the parameters for an outbound connection for the AS2 protocol. The
     * connector is required for sending files from a customer's non Amazon Web Services server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectorRequest#builder()}
     * </p>
     *
     * @param createConnectorRequest
     *        A {@link Consumer} that will call methods on {@link CreateConnectorRequest.Builder} to create a request.
     * @return Result of the CreateConnector operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.CreateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateConnectorResponse createConnector(Consumer<CreateConnectorRequest.Builder> createConnectorRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return createConnector(CreateConnectorRequest.builder().applyMutation(createConnectorRequest).build());
    }

    /**
     * <p>
     * Creates the profile for the AS2 process. The agreement is between the partner and the AS2 process.
     * </p>
     *
     * @param createProfileRequest
     * @return Result of the CreateProfile operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProfileResponse createProfile(CreateProfileRequest createProfileRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the profile for the AS2 process. The agreement is between the partner and the AS2 process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProfileRequest#builder()}
     * </p>
     *
     * @param createProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateProfileRequest.Builder} to create a request.
     * @return Result of the CreateProfile operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProfileResponse createProfile(Consumer<CreateProfileRequest.Builder> createProfileRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return createProfile(CreateProfileRequest.builder().applyMutation(createProfileRequest).build());
    }

    /**
     * <p>
     * Instantiates an auto-scaling virtual server based on the selected file transfer protocol in Amazon Web Services.
     * When you make updates to your file transfer protocol-enabled server or when you work with users, use the
     * service-generated <code>ServerId</code> property that is assigned to the newly created server.
     * </p>
     *
     * @param createServerRequest
     * @return Result of the CreateServer operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.CreateServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateServerResponse createServer(CreateServerRequest createServerRequest) throws AccessDeniedException,
            ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Instantiates an auto-scaling virtual server based on the selected file transfer protocol in Amazon Web Services.
     * When you make updates to your file transfer protocol-enabled server or when you work with users, use the
     * service-generated <code>ServerId</code> property that is assigned to the newly created server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateServerRequest#builder()}
     * </p>
     *
     * @param createServerRequest
     *        A {@link Consumer} that will call methods on {@link CreateServerRequest.Builder} to create a request.
     * @return Result of the CreateServer operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.CreateServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateServerResponse createServer(Consumer<CreateServerRequest.Builder> createServerRequest)
            throws AccessDeniedException, ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceExistsException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            TransferException {
        return createServer(CreateServerRequest.builder().applyMutation(createServerRequest).build());
    }

    /**
     * <p>
     * Creates a user and associates them with an existing file transfer protocol-enabled server. You can only create
     * and associate users with servers that have the <code>IdentityProviderType</code> set to
     * <code>SERVICE_MANAGED</code>. Using parameters for <code>CreateUser</code>, you can specify the user name, set
     * the home directory, store the user's public key, and assign the user's Identity and Access Management (IAM) role.
     * You can also optionally add a session policy, and assign metadata with tags that can be used to group and search
     * for users.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(CreateUserRequest createUserRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceExistsException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user and associates them with an existing file transfer protocol-enabled server. You can only create
     * and associate users with servers that have the <code>IdentityProviderType</code> set to
     * <code>SERVICE_MANAGED</code>. Using parameters for <code>CreateUser</code>, you can specify the user name, set
     * the home directory, store the user's public key, and assign the user's Identity and Access Management (IAM) role.
     * You can also optionally add a session policy, and assign metadata with tags that can be used to group and search
     * for users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserRequest.Builder} to create a request.
     * @return Result of the CreateUser operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(Consumer<CreateUserRequest.Builder> createUserRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Allows you to create a workflow with specified steps and step details the workflow invokes after file transfer
     * completes. After creating a workflow, you can associate the workflow created with any transfer servers by
     * specifying the <code>workflow-details</code> field in <code>CreateServer</code> and <code>UpdateServer</code>
     * operations.
     * </p>
     *
     * @param createWorkflowRequest
     * @return Result of the CreateWorkflow operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWorkflowResponse createWorkflow(CreateWorkflowRequest createWorkflowRequest) throws AccessDeniedException,
            ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException,
            ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to create a workflow with specified steps and step details the workflow invokes after file transfer
     * completes. After creating a workflow, you can associate the workflow created with any transfer servers by
     * specifying the <code>workflow-details</code> field in <code>CreateServer</code> and <code>UpdateServer</code>
     * operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkflowRequest#builder()}
     * </p>
     *
     * @param createWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorkflowRequest.Builder} to create a request.
     * @return Result of the CreateWorkflow operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWorkflowResponse createWorkflow(Consumer<CreateWorkflowRequest.Builder> createWorkflowRequest)
            throws AccessDeniedException, ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceExistsException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        return createWorkflow(CreateWorkflowRequest.builder().applyMutation(createWorkflowRequest).build());
    }

    /**
     * <p>
     * Allows you to delete the access specified in the <code>ServerID</code> and <code>ExternalID</code> parameters.
     * </p>
     *
     * @param deleteAccessRequest
     * @return Result of the DeleteAccess operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAccessResponse deleteAccess(DeleteAccessRequest deleteAccessRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to delete the access specified in the <code>ServerID</code> and <code>ExternalID</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAccessRequest#builder()}
     * </p>
     *
     * @param deleteAccessRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAccessRequest.Builder} to create a request.
     * @return Result of the DeleteAccess operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAccessResponse deleteAccess(Consumer<DeleteAccessRequest.Builder> deleteAccessRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return deleteAccess(DeleteAccessRequest.builder().applyMutation(deleteAccessRequest).build());
    }

    /**
     * <p>
     * Delete the agreement that's specified in the provided <code>AgreementId</code>.
     * </p>
     *
     * @param deleteAgreementRequest
     * @return Result of the DeleteAgreement operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteAgreement" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAgreementResponse deleteAgreement(DeleteAgreementRequest deleteAgreementRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the agreement that's specified in the provided <code>AgreementId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAgreementRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAgreementRequest#builder()}
     * </p>
     *
     * @param deleteAgreementRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAgreementRequest.Builder} to create a request.
     * @return Result of the DeleteAgreement operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteAgreement" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAgreementResponse deleteAgreement(Consumer<DeleteAgreementRequest.Builder> deleteAgreementRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return deleteAgreement(DeleteAgreementRequest.builder().applyMutation(deleteAgreementRequest).build());
    }

    /**
     * <p>
     * Deletes the certificate that's specified in the <code>CertificateId</code> parameter.
     * </p>
     *
     * @param deleteCertificateRequest
     * @return Result of the DeleteCertificate operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest deleteCertificateRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the certificate that's specified in the <code>CertificateId</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCertificateRequest#builder()}
     * </p>
     *
     * @param deleteCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCertificateRequest.Builder} to create a request.
     * @return Result of the DeleteCertificate operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteCertificateResponse deleteCertificate(Consumer<DeleteCertificateRequest.Builder> deleteCertificateRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return deleteCertificate(DeleteCertificateRequest.builder().applyMutation(deleteCertificateRequest).build());
    }

    /**
     * <p>
     * Deletes the agreement that's specified in the provided <code>ConnectorId</code>.
     * </p>
     *
     * @param deleteConnectorRequest
     * @return Result of the DeleteConnector operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteConnectorResponse deleteConnector(DeleteConnectorRequest deleteConnectorRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the agreement that's specified in the provided <code>ConnectorId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectorRequest#builder()}
     * </p>
     *
     * @param deleteConnectorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConnectorRequest.Builder} to create a request.
     * @return Result of the DeleteConnector operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteConnectorResponse deleteConnector(Consumer<DeleteConnectorRequest.Builder> deleteConnectorRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return deleteConnector(DeleteConnectorRequest.builder().applyMutation(deleteConnectorRequest).build());
    }

    /**
     * <p>
     * Deletes the profile that's specified in the <code>ProfileId</code> parameter.
     * </p>
     *
     * @param deleteProfileRequest
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProfileResponse deleteProfile(DeleteProfileRequest deleteProfileRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the profile that's specified in the <code>ProfileId</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProfileRequest#builder()}
     * </p>
     *
     * @param deleteProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProfileRequest.Builder} to create a request.
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProfileResponse deleteProfile(Consumer<DeleteProfileRequest.Builder> deleteProfileRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return deleteProfile(DeleteProfileRequest.builder().applyMutation(deleteProfileRequest).build());
    }

    /**
     * <p>
     * Deletes the file transfer protocol-enabled server that you specify.
     * </p>
     * <p>
     * No response returns from this operation.
     * </p>
     *
     * @param deleteServerRequest
     * @return Result of the DeleteServer operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteServer" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteServerResponse deleteServer(DeleteServerRequest deleteServerRequest) throws AccessDeniedException,
            ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the file transfer protocol-enabled server that you specify.
     * </p>
     * <p>
     * No response returns from this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteServerRequest#builder()}
     * </p>
     *
     * @param deleteServerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteServerRequest.Builder} to create a request.
     * @return Result of the DeleteServer operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteServer" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteServerResponse deleteServer(Consumer<DeleteServerRequest.Builder> deleteServerRequest)
            throws AccessDeniedException, ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return deleteServer(DeleteServerRequest.builder().applyMutation(deleteServerRequest).build());
    }

    /**
     * <p>
     * Deletes a user's Secure Shell (SSH) public key.
     * </p>
     *
     * @param deleteSshPublicKeyRequest
     * @return Result of the DeleteSshPublicKey operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteSshPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteSshPublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSshPublicKeyResponse deleteSshPublicKey(DeleteSshPublicKeyRequest deleteSshPublicKeyRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user's Secure Shell (SSH) public key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSshPublicKeyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSshPublicKeyRequest#builder()}
     * </p>
     *
     * @param deleteSshPublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSshPublicKeyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSshPublicKey operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteSshPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteSshPublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSshPublicKeyResponse deleteSshPublicKey(Consumer<DeleteSshPublicKeyRequest.Builder> deleteSshPublicKeyRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        return deleteSshPublicKey(DeleteSshPublicKeyRequest.builder().applyMutation(deleteSshPublicKeyRequest).build());
    }

    /**
     * <p>
     * Deletes the user belonging to a file transfer protocol-enabled server you specify.
     * </p>
     * <p>
     * No response returns from this operation.
     * </p>
     * <note>
     * <p>
     * When you delete a user from a server, the user's information is lost.
     * </p>
     * </note>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the user belonging to a file transfer protocol-enabled server you specify.
     * </p>
     * <p>
     * No response returns from this operation.
     * </p>
     * <note>
     * <p>
     * When you delete a user from a server, the user's information is lost.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     * @return Result of the DeleteUser operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes the specified workflow.
     * </p>
     *
     * @param deleteWorkflowRequest
     * @return Result of the DeleteWorkflow operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWorkflowResponse deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) throws AccessDeniedException,
            ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkflowRequest#builder()}
     * </p>
     *
     * @param deleteWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorkflowRequest.Builder} to create a request.
     * @return Result of the DeleteWorkflow operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWorkflowResponse deleteWorkflow(Consumer<DeleteWorkflowRequest.Builder> deleteWorkflowRequest)
            throws AccessDeniedException, ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return deleteWorkflow(DeleteWorkflowRequest.builder().applyMutation(deleteWorkflowRequest).build());
    }

    /**
     * <p>
     * Describes the access that is assigned to the specific file transfer protocol-enabled server, as identified by its
     * <code>ServerId</code> property and its <code>ExternalId</code>.
     * </p>
     * <p>
     * The response from this call returns the properties of the access that is associated with the
     * <code>ServerId</code> value that was specified.
     * </p>
     *
     * @param describeAccessRequest
     * @return Result of the DescribeAccess operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAccessResponse describeAccess(DescribeAccessRequest describeAccessRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the access that is assigned to the specific file transfer protocol-enabled server, as identified by its
     * <code>ServerId</code> property and its <code>ExternalId</code>.
     * </p>
     * <p>
     * The response from this call returns the properties of the access that is associated with the
     * <code>ServerId</code> value that was specified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccessRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAccessRequest#builder()}
     * </p>
     *
     * @param describeAccessRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccessRequest.Builder} to create a request.
     * @return Result of the DescribeAccess operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAccessResponse describeAccess(Consumer<DescribeAccessRequest.Builder> describeAccessRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return describeAccess(DescribeAccessRequest.builder().applyMutation(describeAccessRequest).build());
    }

    /**
     * <p>
     * Describes the agreement that's identified by the <code>AgreementId</code>.
     * </p>
     *
     * @param describeAgreementRequest
     * @return Result of the DescribeAgreement operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeAgreement" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAgreementResponse describeAgreement(DescribeAgreementRequest describeAgreementRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the agreement that's identified by the <code>AgreementId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAgreementRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAgreementRequest#builder()}
     * </p>
     *
     * @param describeAgreementRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAgreementRequest.Builder} to create a request.
     * @return Result of the DescribeAgreement operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeAgreement" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAgreementResponse describeAgreement(Consumer<DescribeAgreementRequest.Builder> describeAgreementRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return describeAgreement(DescribeAgreementRequest.builder().applyMutation(describeAgreementRequest).build());
    }

    /**
     * <p>
     * Describes the certificate that's identified by the <code>CertificateId</code>.
     * </p>
     *
     * @param describeCertificateRequest
     * @return Result of the DescribeCertificate operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeCertificateResponse describeCertificate(DescribeCertificateRequest describeCertificateRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the certificate that's identified by the <code>CertificateId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificateRequest#builder()}
     * </p>
     *
     * @param describeCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCertificateRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeCertificate operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeCertificateResponse describeCertificate(
            Consumer<DescribeCertificateRequest.Builder> describeCertificateRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, TransferException {
        return describeCertificate(DescribeCertificateRequest.builder().applyMutation(describeCertificateRequest).build());
    }

    /**
     * <p>
     * Describes the connector that's identified by the <code>ConnectorId.</code>
     * </p>
     *
     * @param describeConnectorRequest
     * @return Result of the DescribeConnector operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConnectorResponse describeConnector(DescribeConnectorRequest describeConnectorRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the connector that's identified by the <code>ConnectorId.</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeConnectorRequest#builder()}
     * </p>
     *
     * @param describeConnectorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConnectorRequest.Builder} to create a request.
     * @return Result of the DescribeConnector operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeConnectorResponse describeConnector(Consumer<DescribeConnectorRequest.Builder> describeConnectorRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return describeConnector(DescribeConnectorRequest.builder().applyMutation(describeConnectorRequest).build());
    }

    /**
     * <p>
     * You can use <code>DescribeExecution</code> to check the details of the execution of the specified workflow.
     * </p>
     *
     * @param describeExecutionRequest
     * @return Result of the DescribeExecution operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeExecutionResponse describeExecution(DescribeExecutionRequest describeExecutionRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can use <code>DescribeExecution</code> to check the details of the execution of the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExecutionRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeExecutionRequest#builder()}
     * </p>
     *
     * @param describeExecutionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeExecutionRequest.Builder} to create a request.
     * @return Result of the DescribeExecution operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeExecutionResponse describeExecution(Consumer<DescribeExecutionRequest.Builder> describeExecutionRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return describeExecution(DescribeExecutionRequest.builder().applyMutation(describeExecutionRequest).build());
    }

    /**
     * <p>
     * Returns the details of the profile that's specified by the <code>ProfileId</code>.
     * </p>
     *
     * @param describeProfileRequest
     * @return Result of the DescribeProfile operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeProfileResponse describeProfile(DescribeProfileRequest describeProfileRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the profile that's specified by the <code>ProfileId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProfileRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProfileRequest#builder()}
     * </p>
     *
     * @param describeProfileRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProfileRequest.Builder} to create a request.
     * @return Result of the DescribeProfile operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeProfileResponse describeProfile(Consumer<DescribeProfileRequest.Builder> describeProfileRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return describeProfile(DescribeProfileRequest.builder().applyMutation(describeProfileRequest).build());
    }

    /**
     * <p>
     * Describes the security policy that is attached to your file transfer protocol-enabled server. The response
     * contains a description of the security policy's properties. For more information about security policies, see <a
     * href="https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html">Working with security
     * policies</a>.
     * </p>
     *
     * @param describeSecurityPolicyRequest
     * @return Result of the DescribeSecurityPolicy operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSecurityPolicyResponse describeSecurityPolicy(DescribeSecurityPolicyRequest describeSecurityPolicyRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the security policy that is attached to your file transfer protocol-enabled server. The response
     * contains a description of the security policy's properties. For more information about security policies, see <a
     * href="https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html">Working with security
     * policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSecurityPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSecurityPolicyRequest#builder()}
     * </p>
     *
     * @param describeSecurityPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSecurityPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSecurityPolicy operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSecurityPolicyResponse describeSecurityPolicy(
            Consumer<DescribeSecurityPolicyRequest.Builder> describeSecurityPolicyRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, TransferException {
        return describeSecurityPolicy(DescribeSecurityPolicyRequest.builder().applyMutation(describeSecurityPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Describes a file transfer protocol-enabled server that you specify by passing the <code>ServerId</code>
     * parameter.
     * </p>
     * <p>
     * The response contains a description of a server's properties. When you set <code>EndpointType</code> to VPC, the
     * response will contain the <code>EndpointDetails</code>.
     * </p>
     *
     * @param describeServerRequest
     * @return Result of the DescribeServer operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeServer" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeServerResponse describeServer(DescribeServerRequest describeServerRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a file transfer protocol-enabled server that you specify by passing the <code>ServerId</code>
     * parameter.
     * </p>
     * <p>
     * The response contains a description of a server's properties. When you set <code>EndpointType</code> to VPC, the
     * response will contain the <code>EndpointDetails</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServerRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeServerRequest#builder()}
     * </p>
     *
     * @param describeServerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeServerRequest.Builder} to create a request.
     * @return Result of the DescribeServer operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeServer" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeServerResponse describeServer(Consumer<DescribeServerRequest.Builder> describeServerRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return describeServer(DescribeServerRequest.builder().applyMutation(describeServerRequest).build());
    }

    /**
     * <p>
     * Describes the user assigned to the specific file transfer protocol-enabled server, as identified by its
     * <code>ServerId</code> property.
     * </p>
     * <p>
     * The response from this call returns the properties of the user associated with the <code>ServerId</code> value
     * that was specified.
     * </p>
     *
     * @param describeUserRequest
     * @return Result of the DescribeUser operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the user assigned to the specific file transfer protocol-enabled server, as identified by its
     * <code>ServerId</code> property.
     * </p>
     * <p>
     * The response from this call returns the properties of the user associated with the <code>ServerId</code> value
     * that was specified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUserRequest#builder()}
     * </p>
     *
     * @param describeUserRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserRequest.Builder} to create a request.
     * @return Result of the DescribeUser operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUserResponse describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return describeUser(DescribeUserRequest.builder().applyMutation(describeUserRequest).build());
    }

    /**
     * <p>
     * Describes the specified workflow.
     * </p>
     *
     * @param describeWorkflowRequest
     * @return Result of the DescribeWorkflow operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeWorkflowResponse describeWorkflow(DescribeWorkflowRequest describeWorkflowRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkflowRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWorkflowRequest#builder()}
     * </p>
     *
     * @param describeWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorkflowRequest.Builder} to create a request.
     * @return Result of the DescribeWorkflow operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.DescribeWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeWorkflowResponse describeWorkflow(Consumer<DescribeWorkflowRequest.Builder> describeWorkflowRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return describeWorkflow(DescribeWorkflowRequest.builder().applyMutation(describeWorkflowRequest).build());
    }

    /**
     * <p>
     * Imports the signing and encryption certificates that you need to create local (AS2) profiles and partner
     * profiles.
     * </p>
     *
     * @param importCertificateRequest
     * @return Result of the ImportCertificate operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ImportCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default ImportCertificateResponse importCertificate(ImportCertificateRequest importCertificateRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports the signing and encryption certificates that you need to create local (AS2) profiles and partner
     * profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link ImportCertificateRequest#builder()}
     * </p>
     *
     * @param importCertificateRequest
     *        A {@link Consumer} that will call methods on {@link ImportCertificateRequest.Builder} to create a request.
     * @return Result of the ImportCertificate operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ImportCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default ImportCertificateResponse importCertificate(Consumer<ImportCertificateRequest.Builder> importCertificateRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return importCertificate(ImportCertificateRequest.builder().applyMutation(importCertificateRequest).build());
    }

    /**
     * <p>
     * Adds a Secure Shell (SSH) public key to a user account identified by a <code>UserName</code> value assigned to
     * the specific file transfer protocol-enabled server, identified by <code>ServerId</code>.
     * </p>
     * <p>
     * The response returns the <code>UserName</code> value, the <code>ServerId</code> value, and the name of the
     * <code>SshPublicKeyId</code>.
     * </p>
     *
     * @param importSshPublicKeyRequest
     * @return Result of the ImportSshPublicKey operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ImportSshPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportSshPublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default ImportSshPublicKeyResponse importSshPublicKey(ImportSshPublicKeyRequest importSshPublicKeyRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a Secure Shell (SSH) public key to a user account identified by a <code>UserName</code> value assigned to
     * the specific file transfer protocol-enabled server, identified by <code>ServerId</code>.
     * </p>
     * <p>
     * The response returns the <code>UserName</code> value, the <code>ServerId</code> value, and the name of the
     * <code>SshPublicKeyId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportSshPublicKeyRequest.Builder} avoiding the
     * need to create one manually via {@link ImportSshPublicKeyRequest#builder()}
     * </p>
     *
     * @param importSshPublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link ImportSshPublicKeyRequest.Builder} to create a
     *        request.
     * @return Result of the ImportSshPublicKey operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ImportSshPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportSshPublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default ImportSshPublicKeyResponse importSshPublicKey(Consumer<ImportSshPublicKeyRequest.Builder> importSshPublicKeyRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        return importSshPublicKey(ImportSshPublicKeyRequest.builder().applyMutation(importSshPublicKeyRequest).build());
    }

    /**
     * <p>
     * Lists the details for all the accesses you have on your server.
     * </p>
     *
     * @param listAccessesRequest
     * @return Result of the ListAccesses operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListAccesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAccesses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccessesResponse listAccesses(ListAccessesRequest listAccessesRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the details for all the accesses you have on your server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAccessesRequest#builder()}
     * </p>
     *
     * @param listAccessesRequest
     *        A {@link Consumer} that will call methods on {@link ListAccessesRequest.Builder} to create a request.
     * @return Result of the ListAccesses operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListAccesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAccesses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccessesResponse listAccesses(Consumer<ListAccessesRequest.Builder> listAccessesRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return listAccesses(ListAccessesRequest.builder().applyMutation(listAccessesRequest).build());
    }

    /**
     * <p>
     * Lists the details for all the accesses you have on your server.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAccesses(software.amazon.awssdk.services.transfer.model.ListAccessesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAccessesIterable responses = client.listAccessesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListAccessesIterable responses = client.listAccessesPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListAccessesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAccessesIterable responses = client.listAccessesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccesses(software.amazon.awssdk.services.transfer.model.ListAccessesRequest)} operation.</b>
     * </p>
     *
     * @param listAccessesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListAccesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAccesses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccessesIterable listAccessesPaginator(ListAccessesRequest listAccessesRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the details for all the accesses you have on your server.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAccesses(software.amazon.awssdk.services.transfer.model.ListAccessesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAccessesIterable responses = client.listAccessesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListAccessesIterable responses = client.listAccessesPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListAccessesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAccessesIterable responses = client.listAccessesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccesses(software.amazon.awssdk.services.transfer.model.ListAccessesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAccessesRequest#builder()}
     * </p>
     *
     * @param listAccessesRequest
     *        A {@link Consumer} that will call methods on {@link ListAccessesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListAccesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAccesses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccessesIterable listAccessesPaginator(Consumer<ListAccessesRequest.Builder> listAccessesRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return listAccessesPaginator(ListAccessesRequest.builder().applyMutation(listAccessesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the agreements for the server that's identified by the <code>ServerId</code> that you supply.
     * If you want to limit the results to a certain number, supply a value for the <code>MaxResults</code> parameter.
     * If you ran the command previously and received a value for <code>NextToken</code>, you can supply that value to
     * continue listing agreements from where you left off.
     * </p>
     *
     * @param listAgreementsRequest
     * @return Result of the ListAgreements operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListAgreements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAgreements" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgreementsResponse listAgreements(ListAgreementsRequest listAgreementsRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the agreements for the server that's identified by the <code>ServerId</code> that you supply.
     * If you want to limit the results to a certain number, supply a value for the <code>MaxResults</code> parameter.
     * If you ran the command previously and received a value for <code>NextToken</code>, you can supply that value to
     * continue listing agreements from where you left off.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgreementsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAgreementsRequest#builder()}
     * </p>
     *
     * @param listAgreementsRequest
     *        A {@link Consumer} that will call methods on {@link ListAgreementsRequest.Builder} to create a request.
     * @return Result of the ListAgreements operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListAgreements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAgreements" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgreementsResponse listAgreements(Consumer<ListAgreementsRequest.Builder> listAgreementsRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return listAgreements(ListAgreementsRequest.builder().applyMutation(listAgreementsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the agreements for the server that's identified by the <code>ServerId</code> that you supply.
     * If you want to limit the results to a certain number, supply a value for the <code>MaxResults</code> parameter.
     * If you ran the command previously and received a value for <code>NextToken</code>, you can supply that value to
     * continue listing agreements from where you left off.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAgreements(software.amazon.awssdk.services.transfer.model.ListAgreementsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAgreementsIterable responses = client.listAgreementsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListAgreementsIterable responses = client
     *             .listAgreementsPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListAgreementsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAgreementsIterable responses = client.listAgreementsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgreements(software.amazon.awssdk.services.transfer.model.ListAgreementsRequest)} operation.</b>
     * </p>
     *
     * @param listAgreementsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListAgreements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAgreements" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgreementsIterable listAgreementsPaginator(ListAgreementsRequest listAgreementsRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the agreements for the server that's identified by the <code>ServerId</code> that you supply.
     * If you want to limit the results to a certain number, supply a value for the <code>MaxResults</code> parameter.
     * If you ran the command previously and received a value for <code>NextToken</code>, you can supply that value to
     * continue listing agreements from where you left off.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAgreements(software.amazon.awssdk.services.transfer.model.ListAgreementsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAgreementsIterable responses = client.listAgreementsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListAgreementsIterable responses = client
     *             .listAgreementsPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListAgreementsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAgreementsIterable responses = client.listAgreementsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgreements(software.amazon.awssdk.services.transfer.model.ListAgreementsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgreementsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAgreementsRequest#builder()}
     * </p>
     *
     * @param listAgreementsRequest
     *        A {@link Consumer} that will call methods on {@link ListAgreementsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListAgreements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAgreements" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgreementsIterable listAgreementsPaginator(Consumer<ListAgreementsRequest.Builder> listAgreementsRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return listAgreementsPaginator(ListAgreementsRequest.builder().applyMutation(listAgreementsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the current certificates that have been imported into Transfer Family. If you want to limit the
     * results to a certain number, supply a value for the <code>MaxResults</code> parameter. If you ran the command
     * previously and received a value for the <code>NextToken</code> parameter, you can supply that value to continue
     * listing certificates from where you left off.
     * </p>
     *
     * @param listCertificatesRequest
     * @return Result of the ListCertificates operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCertificatesResponse listCertificates(ListCertificatesRequest listCertificatesRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the current certificates that have been imported into Transfer Family. If you want to limit the
     * results to a certain number, supply a value for the <code>MaxResults</code> parameter. If you ran the command
     * previously and received a value for the <code>NextToken</code> parameter, you can supply that value to continue
     * listing certificates from where you left off.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCertificatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCertificatesRequest#builder()}
     * </p>
     *
     * @param listCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link ListCertificatesRequest.Builder} to create a request.
     * @return Result of the ListCertificates operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCertificatesResponse listCertificates(Consumer<ListCertificatesRequest.Builder> listCertificatesRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return listCertificates(ListCertificatesRequest.builder().applyMutation(listCertificatesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the current certificates that have been imported into Transfer Family. If you want to limit the
     * results to a certain number, supply a value for the <code>MaxResults</code> parameter. If you ran the command
     * previously and received a value for the <code>NextToken</code> parameter, you can supply that value to continue
     * listing certificates from where you left off.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCertificates(software.amazon.awssdk.services.transfer.model.ListCertificatesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListCertificatesIterable responses = client.listCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListCertificatesIterable responses = client
     *             .listCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListCertificatesIterable responses = client.listCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCertificates(software.amazon.awssdk.services.transfer.model.ListCertificatesRequest)} operation.</b>
     * </p>
     *
     * @param listCertificatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCertificatesIterable listCertificatesPaginator(ListCertificatesRequest listCertificatesRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the current certificates that have been imported into Transfer Family. If you want to limit the
     * results to a certain number, supply a value for the <code>MaxResults</code> parameter. If you ran the command
     * previously and received a value for the <code>NextToken</code> parameter, you can supply that value to continue
     * listing certificates from where you left off.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCertificates(software.amazon.awssdk.services.transfer.model.ListCertificatesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListCertificatesIterable responses = client.listCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListCertificatesIterable responses = client
     *             .listCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListCertificatesIterable responses = client.listCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCertificates(software.amazon.awssdk.services.transfer.model.ListCertificatesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCertificatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCertificatesRequest#builder()}
     * </p>
     *
     * @param listCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link ListCertificatesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCertificatesIterable listCertificatesPaginator(Consumer<ListCertificatesRequest.Builder> listCertificatesRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return listCertificatesPaginator(ListCertificatesRequest.builder().applyMutation(listCertificatesRequest).build());
    }

    /**
     * <p>
     * Lists the connectors for the specified Region.
     * </p>
     *
     * @param listConnectorsRequest
     * @return Result of the ListConnectors operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConnectorsResponse listConnectors(ListConnectorsRequest listConnectorsRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the connectors for the specified Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConnectorsRequest#builder()}
     * </p>
     *
     * @param listConnectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListConnectorsRequest.Builder} to create a request.
     * @return Result of the ListConnectors operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConnectorsResponse listConnectors(Consumer<ListConnectorsRequest.Builder> listConnectorsRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return listConnectors(ListConnectorsRequest.builder().applyMutation(listConnectorsRequest).build());
    }

    /**
     * <p>
     * Lists the connectors for the specified Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConnectors(software.amazon.awssdk.services.transfer.model.ListConnectorsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListConnectorsIterable responses = client.listConnectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListConnectorsIterable responses = client
     *             .listConnectorsPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListConnectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListConnectorsIterable responses = client.listConnectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectors(software.amazon.awssdk.services.transfer.model.ListConnectorsRequest)} operation.</b>
     * </p>
     *
     * @param listConnectorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConnectorsIterable listConnectorsPaginator(ListConnectorsRequest listConnectorsRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the connectors for the specified Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConnectors(software.amazon.awssdk.services.transfer.model.ListConnectorsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListConnectorsIterable responses = client.listConnectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListConnectorsIterable responses = client
     *             .listConnectorsPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListConnectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListConnectorsIterable responses = client.listConnectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectors(software.amazon.awssdk.services.transfer.model.ListConnectorsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConnectorsRequest#builder()}
     * </p>
     *
     * @param listConnectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListConnectorsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConnectorsIterable listConnectorsPaginator(Consumer<ListConnectorsRequest.Builder> listConnectorsRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return listConnectorsPaginator(ListConnectorsRequest.builder().applyMutation(listConnectorsRequest).build());
    }

    /**
     * <p>
     * Lists all executions for the specified workflow.
     * </p>
     *
     * @param listExecutionsRequest
     * @return Result of the ListExecutions operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExecutionsResponse listExecutions(ListExecutionsRequest listExecutionsRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all executions for the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExecutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExecutionsRequest#builder()}
     * </p>
     *
     * @param listExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListExecutionsRequest.Builder} to create a request.
     * @return Result of the ListExecutions operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExecutionsResponse listExecutions(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return listExecutions(ListExecutionsRequest.builder().applyMutation(listExecutionsRequest).build());
    }

    /**
     * <p>
     * Lists all executions for the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExecutions(software.amazon.awssdk.services.transfer.model.ListExecutionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListExecutionsIterable responses = client.listExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListExecutionsIterable responses = client
     *             .listExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListExecutionsIterable responses = client.listExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExecutions(software.amazon.awssdk.services.transfer.model.ListExecutionsRequest)} operation.</b>
     * </p>
     *
     * @param listExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExecutionsIterable listExecutionsPaginator(ListExecutionsRequest listExecutionsRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all executions for the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExecutions(software.amazon.awssdk.services.transfer.model.ListExecutionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListExecutionsIterable responses = client.listExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListExecutionsIterable responses = client
     *             .listExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListExecutionsIterable responses = client.listExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExecutions(software.amazon.awssdk.services.transfer.model.ListExecutionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExecutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExecutionsRequest#builder()}
     * </p>
     *
     * @param listExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListExecutionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExecutionsIterable listExecutionsPaginator(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return listExecutionsPaginator(ListExecutionsRequest.builder().applyMutation(listExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the profiles for your system. If you want to limit the results to a certain number, supply a
     * value for the <code>MaxResults</code> parameter. If you ran the command previously and received a value for
     * <code>NextToken</code>, you can supply that value to continue listing profiles from where you left off.
     * </p>
     *
     * @param listProfilesRequest
     * @return Result of the ListProfiles operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProfilesResponse listProfiles(ListProfilesRequest listProfilesRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the profiles for your system. If you want to limit the results to a certain number, supply a
     * value for the <code>MaxResults</code> parameter. If you ran the command previously and received a value for
     * <code>NextToken</code>, you can supply that value to continue listing profiles from where you left off.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link ListProfilesRequest#builder()}
     * </p>
     *
     * @param listProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListProfilesRequest.Builder} to create a request.
     * @return Result of the ListProfiles operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProfilesResponse listProfiles(Consumer<ListProfilesRequest.Builder> listProfilesRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return listProfiles(ListProfilesRequest.builder().applyMutation(listProfilesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the profiles for your system. If you want to limit the results to a certain number, supply a
     * value for the <code>MaxResults</code> parameter. If you ran the command previously and received a value for
     * <code>NextToken</code>, you can supply that value to continue listing profiles from where you left off.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProfiles(software.amazon.awssdk.services.transfer.model.ListProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfiles(software.amazon.awssdk.services.transfer.model.ListProfilesRequest)} operation.</b>
     * </p>
     *
     * @param listProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProfilesIterable listProfilesPaginator(ListProfilesRequest listProfilesRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the profiles for your system. If you want to limit the results to a certain number, supply a
     * value for the <code>MaxResults</code> parameter. If you ran the command previously and received a value for
     * <code>NextToken</code>, you can supply that value to continue listing profiles from where you left off.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listProfiles(software.amazon.awssdk.services.transfer.model.ListProfilesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListProfilesIterable responses = client.listProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfiles(software.amazon.awssdk.services.transfer.model.ListProfilesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link ListProfilesRequest#builder()}
     * </p>
     *
     * @param listProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListProfilesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProfilesIterable listProfilesPaginator(Consumer<ListProfilesRequest.Builder> listProfilesRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return listProfilesPaginator(ListProfilesRequest.builder().applyMutation(listProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the security policies that are attached to your file transfer protocol-enabled servers.
     * </p>
     *
     * @param listSecurityPoliciesRequest
     * @return Result of the ListSecurityPolicies operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListSecurityPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecurityPoliciesResponse listSecurityPolicies(ListSecurityPoliciesRequest listSecurityPoliciesRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the security policies that are attached to your file transfer protocol-enabled servers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecurityPoliciesRequest#builder()}
     * </p>
     *
     * @param listSecurityPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListSecurityPoliciesRequest.Builder} to create a
     *        request.
     * @return Result of the ListSecurityPolicies operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListSecurityPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecurityPoliciesResponse listSecurityPolicies(
            Consumer<ListSecurityPoliciesRequest.Builder> listSecurityPoliciesRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException,
            SdkClientException, TransferException {
        return listSecurityPolicies(ListSecurityPoliciesRequest.builder().applyMutation(listSecurityPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the security policies that are attached to your file transfer protocol-enabled servers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListSecurityPoliciesIterable responses = client.listSecurityPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListSecurityPoliciesIterable responses = client
     *             .listSecurityPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListSecurityPoliciesIterable responses = client.listSecurityPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSecurityPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListSecurityPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecurityPoliciesIterable listSecurityPoliciesPaginator(ListSecurityPoliciesRequest listSecurityPoliciesRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the security policies that are attached to your file transfer protocol-enabled servers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListSecurityPoliciesIterable responses = client.listSecurityPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListSecurityPoliciesIterable responses = client
     *             .listSecurityPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListSecurityPoliciesIterable responses = client.listSecurityPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecurityPoliciesRequest#builder()}
     * </p>
     *
     * @param listSecurityPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListSecurityPoliciesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListSecurityPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecurityPoliciesIterable listSecurityPoliciesPaginator(
            Consumer<ListSecurityPoliciesRequest.Builder> listSecurityPoliciesRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException,
            SdkClientException, TransferException {
        return listSecurityPoliciesPaginator(ListSecurityPoliciesRequest.builder().applyMutation(listSecurityPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.
     * </p>
     *
     * @return Result of the ListServers operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListServers
     * @see #listServers(ListServersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServersResponse listServers() throws ServiceUnavailableException, InternalServiceErrorException,
            InvalidNextTokenException, InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        return listServers(ListServersRequest.builder().build());
    }

    /**
     * <p>
     * Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.
     * </p>
     *
     * @param listServersRequest
     * @return Result of the ListServers operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServersResponse listServers(ListServersRequest listServersRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException,
            SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServersRequest.Builder} avoiding the need to
     * create one manually via {@link ListServersRequest#builder()}
     * </p>
     *
     * @param listServersRequest
     *        A {@link Consumer} that will call methods on {@link ListServersRequest.Builder} to create a request.
     * @return Result of the ListServers operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServersResponse listServers(Consumer<ListServersRequest.Builder> listServersRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        return listServers(ListServersRequest.builder().applyMutation(listServersRequest).build());
    }

    /**
     * <p>
     * Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listServers(software.amazon.awssdk.services.transfer.model.ListServersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListServersIterable responses = client.listServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListServersIterable responses = client.listServersPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListServersIterable responses = client.listServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServers(software.amazon.awssdk.services.transfer.model.ListServersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListServers
     * @see #listServersPaginator(ListServersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServersIterable listServersPaginator() throws ServiceUnavailableException, InternalServiceErrorException,
            InvalidNextTokenException, InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        return listServersPaginator(ListServersRequest.builder().build());
    }

    /**
     * <p>
     * Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listServers(software.amazon.awssdk.services.transfer.model.ListServersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListServersIterable responses = client.listServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListServersIterable responses = client.listServersPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListServersIterable responses = client.listServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServers(software.amazon.awssdk.services.transfer.model.ListServersRequest)} operation.</b>
     * </p>
     *
     * @param listServersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServersIterable listServersPaginator(ListServersRequest listServersRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException,
            SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listServers(software.amazon.awssdk.services.transfer.model.ListServersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListServersIterable responses = client.listServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListServersIterable responses = client.listServersPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListServersIterable responses = client.listServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServers(software.amazon.awssdk.services.transfer.model.ListServersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServersRequest.Builder} avoiding the need to
     * create one manually via {@link ListServersRequest#builder()}
     * </p>
     *
     * @param listServersRequest
     *        A {@link Consumer} that will call methods on {@link ListServersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServersIterable listServersPaginator(Consumer<ListServersRequest.Builder> listServersRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        return listServersPaginator(ListServersRequest.builder().applyMutation(listServersRequest).build());
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * user, server, or role.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * user, server, or role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException,
            SdkClientException, TransferException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * user, server, or role.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * user, server, or role.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException,
            SdkClientException, TransferException {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Lists the users for a file transfer protocol-enabled server that you specify by passing the <code>ServerId</code>
     * parameter.
     * </p>
     *
     * @param listUsersRequest
     * @return Result of the ListUsers operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the users for a file transfer protocol-enabled server that you specify by passing the <code>ServerId</code>
     * parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return Result of the ListUsers operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, TransferException {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Lists the users for a file transfer protocol-enabled server that you specify by passing the <code>ServerId</code>
     * parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.transfer.model.ListUsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.transfer.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @param listUsersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersIterable listUsersPaginator(ListUsersRequest listUsersRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the users for a file transfer protocol-enabled server that you specify by passing the <code>ServerId</code>
     * parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.transfer.model.ListUsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.transfer.model.ListUsersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersIterable listUsersPaginator(Consumer<ListUsersRequest.Builder> listUsersRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return listUsersPaginator(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Lists all of your workflows.
     * </p>
     *
     * @param listWorkflowsRequest
     * @return Result of the ListWorkflows operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkflowsResponse listWorkflows(ListWorkflowsRequest listWorkflowsRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidNextTokenException, InvalidRequestException, AwsServiceException,
            SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of your workflows.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowsRequest.Builder} to create a request.
     * @return Result of the ListWorkflows operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkflowsResponse listWorkflows(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        return listWorkflows(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * Lists all of your workflows.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorkflows(software.amazon.awssdk.services.transfer.model.ListWorkflowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListWorkflowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflows(software.amazon.awssdk.services.transfer.model.ListWorkflowsRequest)} operation.</b>
     * </p>
     *
     * @param listWorkflowsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkflowsIterable listWorkflowsPaginator(ListWorkflowsRequest listWorkflowsRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of your workflows.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorkflows(software.amazon.awssdk.services.transfer.model.ListWorkflowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.transfer.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     *     for (software.amazon.awssdk.services.transfer.model.ListWorkflowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListWorkflowsIterable responses = client.listWorkflowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflows(software.amazon.awssdk.services.transfer.model.ListWorkflowsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> parameter that was passed is invalid.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkflowsIterable listWorkflowsPaginator(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidNextTokenException,
            InvalidRequestException, AwsServiceException, SdkClientException, TransferException {
        return listWorkflowsPaginator(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * Sends a callback for asynchronous custom steps.
     * </p>
     * <p>
     * The <code>ExecutionId</code>, <code>WorkflowId</code>, and <code>Token</code> are passed to the target resource
     * during execution of a custom step of a workflow. You must include those with their callback as well as providing
     * a status.
     * </p>
     *
     * @param sendWorkflowStepStateRequest
     * @return Result of the SendWorkflowStepState operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.SendWorkflowStepState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/SendWorkflowStepState"
     *      target="_top">AWS API Documentation</a>
     */
    default SendWorkflowStepStateResponse sendWorkflowStepState(SendWorkflowStepStateRequest sendWorkflowStepStateRequest)
            throws AccessDeniedException, ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a callback for asynchronous custom steps.
     * </p>
     * <p>
     * The <code>ExecutionId</code>, <code>WorkflowId</code>, and <code>Token</code> are passed to the target resource
     * during execution of a custom step of a workflow. You must include those with their callback as well as providing
     * a status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendWorkflowStepStateRequest.Builder} avoiding the
     * need to create one manually via {@link SendWorkflowStepStateRequest#builder()}
     * </p>
     *
     * @param sendWorkflowStepStateRequest
     *        A {@link Consumer} that will call methods on {@link SendWorkflowStepStateRequest.Builder} to create a
     *        request.
     * @return Result of the SendWorkflowStepState operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.SendWorkflowStepState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/SendWorkflowStepState"
     *      target="_top">AWS API Documentation</a>
     */
    default SendWorkflowStepStateResponse sendWorkflowStepState(
            Consumer<SendWorkflowStepStateRequest.Builder> sendWorkflowStepStateRequest) throws AccessDeniedException,
            ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        return sendWorkflowStepState(SendWorkflowStepStateRequest.builder().applyMutation(sendWorkflowStepStateRequest).build());
    }

    /**
     * <p>
     * Begins an outbound file transfer. You specify the <code>ConnectorId</code> and the file paths for where to send
     * the files.
     * </p>
     *
     * @param startFileTransferRequest
     * @return Result of the StartFileTransfer operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.StartFileTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartFileTransfer" target="_top">AWS
     *      API Documentation</a>
     */
    default StartFileTransferResponse startFileTransfer(StartFileTransferRequest startFileTransferRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Begins an outbound file transfer. You specify the <code>ConnectorId</code> and the file paths for where to send
     * the files.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFileTransferRequest.Builder} avoiding the need
     * to create one manually via {@link StartFileTransferRequest#builder()}
     * </p>
     *
     * @param startFileTransferRequest
     *        A {@link Consumer} that will call methods on {@link StartFileTransferRequest.Builder} to create a request.
     * @return Result of the StartFileTransfer operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.StartFileTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartFileTransfer" target="_top">AWS
     *      API Documentation</a>
     */
    default StartFileTransferResponse startFileTransfer(Consumer<StartFileTransferRequest.Builder> startFileTransferRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        return startFileTransfer(StartFileTransferRequest.builder().applyMutation(startFileTransferRequest).build());
    }

    /**
     * <p>
     * Changes the state of a file transfer protocol-enabled server from <code>OFFLINE</code> to <code>ONLINE</code>. It
     * has no impact on a server that is already <code>ONLINE</code>. An <code>ONLINE</code> server can accept and
     * process file transfer jobs.
     * </p>
     * <p>
     * The state of <code>STARTING</code> indicates that the server is in an intermediate state, either not fully able
     * to respond, or not fully online. The values of <code>START_FAILED</code> can indicate an error condition.
     * </p>
     * <p>
     * No response is returned from this call.
     * </p>
     *
     * @param startServerRequest
     * @return Result of the StartServer operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.StartServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartServer" target="_top">AWS API
     *      Documentation</a>
     */
    default StartServerResponse startServer(StartServerRequest startServerRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the state of a file transfer protocol-enabled server from <code>OFFLINE</code> to <code>ONLINE</code>. It
     * has no impact on a server that is already <code>ONLINE</code>. An <code>ONLINE</code> server can accept and
     * process file transfer jobs.
     * </p>
     * <p>
     * The state of <code>STARTING</code> indicates that the server is in an intermediate state, either not fully able
     * to respond, or not fully online. The values of <code>START_FAILED</code> can indicate an error condition.
     * </p>
     * <p>
     * No response is returned from this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartServerRequest.Builder} avoiding the need to
     * create one manually via {@link StartServerRequest#builder()}
     * </p>
     *
     * @param startServerRequest
     *        A {@link Consumer} that will call methods on {@link StartServerRequest.Builder} to create a request.
     * @return Result of the StartServer operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.StartServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartServer" target="_top">AWS API
     *      Documentation</a>
     */
    default StartServerResponse startServer(Consumer<StartServerRequest.Builder> startServerRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        return startServer(StartServerRequest.builder().applyMutation(startServerRequest).build());
    }

    /**
     * <p>
     * Changes the state of a file transfer protocol-enabled server from <code>ONLINE</code> to <code>OFFLINE</code>. An
     * <code>OFFLINE</code> server cannot accept and process file transfer jobs. Information tied to your server, such
     * as server and user properties, are not affected by stopping your server.
     * </p>
     * <note>
     * <p>
     * Stopping the server does not reduce or impact your file transfer protocol endpoint billing; you must delete the
     * server to stop being billed.
     * </p>
     * </note>
     * <p>
     * The state of <code>STOPPING</code> indicates that the server is in an intermediate state, either not fully able
     * to respond, or not fully offline. The values of <code>STOP_FAILED</code> can indicate an error condition.
     * </p>
     * <p>
     * No response is returned from this call.
     * </p>
     *
     * @param stopServerRequest
     * @return Result of the StopServer operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.StopServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StopServer" target="_top">AWS API
     *      Documentation</a>
     */
    default StopServerResponse stopServer(StopServerRequest stopServerRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the state of a file transfer protocol-enabled server from <code>ONLINE</code> to <code>OFFLINE</code>. An
     * <code>OFFLINE</code> server cannot accept and process file transfer jobs. Information tied to your server, such
     * as server and user properties, are not affected by stopping your server.
     * </p>
     * <note>
     * <p>
     * Stopping the server does not reduce or impact your file transfer protocol endpoint billing; you must delete the
     * server to stop being billed.
     * </p>
     * </note>
     * <p>
     * The state of <code>STOPPING</code> indicates that the server is in an intermediate state, either not fully able
     * to respond, or not fully offline. The values of <code>STOP_FAILED</code> can indicate an error condition.
     * </p>
     * <p>
     * No response is returned from this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopServerRequest.Builder} avoiding the need to
     * create one manually via {@link StopServerRequest#builder()}
     * </p>
     *
     * @param stopServerRequest
     *        A {@link Consumer} that will call methods on {@link StopServerRequest.Builder} to create a request.
     * @return Result of the StopServer operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.StopServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StopServer" target="_top">AWS API
     *      Documentation</a>
     */
    default StopServerResponse stopServer(Consumer<StopServerRequest.Builder> stopServerRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        return stopServer(StopServerRequest.builder().applyMutation(stopServerRequest).build());
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     * <p>
     * There is no response returned from this call.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     * <p>
     * There is no response returned from this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * If the <code>IdentityProviderType</code> of a file transfer protocol-enabled server is
     * <code>AWS_DIRECTORY_SERVICE</code> or <code>API_Gateway</code>, tests whether your identity provider is set up
     * successfully. We highly recommend that you call this operation to test your authentication method as soon as you
     * create your server. By doing so, you can troubleshoot issues with the identity provider integration to ensure
     * that your users can successfully use the service.
     * </p>
     * <p>
     * The <code>ServerId</code> and <code>UserName</code> parameters are required. The <code>ServerProtocol</code>,
     * <code>SourceIp</code>, and <code>UserPassword</code> are all optional.
     * </p>
     * <note>
     * <p>
     * You cannot use <code>TestIdentityProvider</code> if the <code>IdentityProviderType</code> of your server is
     * <code>SERVICE_MANAGED</code>.
     * </p>
     * </note>
     * <ul>
     * <li>
     * <p>
     * If you provide any incorrect values for any parameters, the <code>Response</code> field is empty.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you provide a server ID for a server that uses service-managed users, you get an error:
     * </p>
     * <p>
     * <code> An error occurred (InvalidRequestException) when calling the TestIdentityProvider operation: s-<i>server-ID</i> not configured for external auth </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you enter a Server ID for the <code>--server-id</code> parameter that does not identify an actual Transfer
     * server, you receive the following error:
     * </p>
     * <p>
     * <code>An error occurred (ResourceNotFoundException) when calling the TestIdentityProvider operation: Unknown server</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param testIdentityProviderRequest
     * @return Result of the TestIdentityProvider operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.TestIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TestIdentityProvider" target="_top">AWS
     *      API Documentation</a>
     */
    default TestIdentityProviderResponse testIdentityProvider(TestIdentityProviderRequest testIdentityProviderRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * If the <code>IdentityProviderType</code> of a file transfer protocol-enabled server is
     * <code>AWS_DIRECTORY_SERVICE</code> or <code>API_Gateway</code>, tests whether your identity provider is set up
     * successfully. We highly recommend that you call this operation to test your authentication method as soon as you
     * create your server. By doing so, you can troubleshoot issues with the identity provider integration to ensure
     * that your users can successfully use the service.
     * </p>
     * <p>
     * The <code>ServerId</code> and <code>UserName</code> parameters are required. The <code>ServerProtocol</code>,
     * <code>SourceIp</code>, and <code>UserPassword</code> are all optional.
     * </p>
     * <note>
     * <p>
     * You cannot use <code>TestIdentityProvider</code> if the <code>IdentityProviderType</code> of your server is
     * <code>SERVICE_MANAGED</code>.
     * </p>
     * </note>
     * <ul>
     * <li>
     * <p>
     * If you provide any incorrect values for any parameters, the <code>Response</code> field is empty.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you provide a server ID for a server that uses service-managed users, you get an error:
     * </p>
     * <p>
     * <code> An error occurred (InvalidRequestException) when calling the TestIdentityProvider operation: s-<i>server-ID</i> not configured for external auth </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you enter a Server ID for the <code>--server-id</code> parameter that does not identify an actual Transfer
     * server, you receive the following error:
     * </p>
     * <p>
     * <code>An error occurred (ResourceNotFoundException) when calling the TestIdentityProvider operation: Unknown server</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link TestIdentityProviderRequest#builder()}
     * </p>
     *
     * @param testIdentityProviderRequest
     *        A {@link Consumer} that will call methods on {@link TestIdentityProviderRequest.Builder} to create a
     *        request.
     * @return Result of the TestIdentityProvider operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.TestIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TestIdentityProvider" target="_top">AWS
     *      API Documentation</a>
     */
    default TestIdentityProviderResponse testIdentityProvider(
            Consumer<TestIdentityProviderRequest.Builder> testIdentityProviderRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, TransferException {
        return testIdentityProvider(TestIdentityProviderRequest.builder().applyMutation(testIdentityProviderRequest).build());
    }

    /**
     * <p>
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     * <p>
     * No response is returned from this call.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     * <p>
     * No response is returned from this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Allows you to update parameters for the access specified in the <code>ServerID</code> and <code>ExternalID</code>
     * parameters.
     * </p>
     *
     * @param updateAccessRequest
     * @return Result of the UpdateAccess operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UpdateAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAccessResponse updateAccess(UpdateAccessRequest updateAccessRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceExistsException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to update parameters for the access specified in the <code>ServerID</code> and <code>ExternalID</code>
     * parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccessRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAccessRequest#builder()}
     * </p>
     *
     * @param updateAccessRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAccessRequest.Builder} to create a request.
     * @return Result of the UpdateAccess operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UpdateAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAccessResponse updateAccess(Consumer<UpdateAccessRequest.Builder> updateAccessRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return updateAccess(UpdateAccessRequest.builder().applyMutation(updateAccessRequest).build());
    }

    /**
     * <p>
     * Updates some of the parameters for an existing agreement. Provide the <code>AgreementId</code> and the
     * <code>ServerId</code> for the agreement that you want to update, along with the new values for the parameters to
     * update.
     * </p>
     *
     * @param updateAgreementRequest
     * @return Result of the UpdateAgreement operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UpdateAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateAgreement" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAgreementResponse updateAgreement(UpdateAgreementRequest updateAgreementRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates some of the parameters for an existing agreement. Provide the <code>AgreementId</code> and the
     * <code>ServerId</code> for the agreement that you want to update, along with the new values for the parameters to
     * update.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAgreementRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAgreementRequest#builder()}
     * </p>
     *
     * @param updateAgreementRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAgreementRequest.Builder} to create a request.
     * @return Result of the UpdateAgreement operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UpdateAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateAgreement" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAgreementResponse updateAgreement(Consumer<UpdateAgreementRequest.Builder> updateAgreementRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return updateAgreement(UpdateAgreementRequest.builder().applyMutation(updateAgreementRequest).build());
    }

    /**
     * <p>
     * Updates the active and inactive dates for a certificate.
     * </p>
     *
     * @param updateCertificateRequest
     * @return Result of the UpdateCertificate operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UpdateCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateCertificateResponse updateCertificate(UpdateCertificateRequest updateCertificateRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the active and inactive dates for a certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateCertificateRequest#builder()}
     * </p>
     *
     * @param updateCertificateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCertificateRequest.Builder} to create a request.
     * @return Result of the UpdateCertificate operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UpdateCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateCertificateResponse updateCertificate(Consumer<UpdateCertificateRequest.Builder> updateCertificateRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return updateCertificate(UpdateCertificateRequest.builder().applyMutation(updateCertificateRequest).build());
    }

    /**
     * <p>
     * Updates some of the parameters for an existing connector. Provide the <code>ConnectorId</code> for the connector
     * that you want to update, along with the new values for the parameters to update.
     * </p>
     *
     * @param updateConnectorRequest
     * @return Result of the UpdateConnector operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UpdateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateConnectorResponse updateConnector(UpdateConnectorRequest updateConnectorRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates some of the parameters for an existing connector. Provide the <code>ConnectorId</code> for the connector
     * that you want to update, along with the new values for the parameters to update.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateConnectorRequest#builder()}
     * </p>
     *
     * @param updateConnectorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConnectorRequest.Builder} to create a request.
     * @return Result of the UpdateConnector operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UpdateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateConnectorResponse updateConnector(Consumer<UpdateConnectorRequest.Builder> updateConnectorRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException, ResourceExistsException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return updateConnector(UpdateConnectorRequest.builder().applyMutation(updateConnectorRequest).build());
    }

    /**
     * <p>
     * Updates some of the parameters for an existing profile. Provide the <code>ProfileId</code> for the profile that
     * you want to update, along with the new values for the parameters to update.
     * </p>
     *
     * @param updateProfileRequest
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProfileResponse updateProfile(UpdateProfileRequest updateProfileRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates some of the parameters for an existing profile. Provide the <code>ProfileId</code> for the profile that
     * you want to update, along with the new values for the parameters to update.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProfileRequest#builder()}
     * </p>
     *
     * @param updateProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProfileRequest.Builder} to create a request.
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateProfileResponse updateProfile(Consumer<UpdateProfileRequest.Builder> updateProfileRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, TransferException {
        return updateProfile(UpdateProfileRequest.builder().applyMutation(updateProfileRequest).build());
    }

    /**
     * <p>
     * Updates the file transfer protocol-enabled server's properties after that server has been created.
     * </p>
     * <p>
     * The <code>UpdateServer</code> call returns the <code>ServerId</code> of the server you updated.
     * </p>
     *
     * @param updateServerRequest
     * @return Result of the UpdateServer operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws ConflictException
     *         This exception is thrown when the <code>UpdateServer</code> is called for a file transfer
     *         protocol-enabled server that has VPC as the endpoint type and the server's <code>VpcEndpointID</code> is
     *         not in the available state.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UpdateServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateServer" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateServerResponse updateServer(UpdateServerRequest updateServerRequest) throws AccessDeniedException,
            ServiceUnavailableException, ConflictException, InternalServiceErrorException, InvalidRequestException,
            ResourceExistsException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the file transfer protocol-enabled server's properties after that server has been created.
     * </p>
     * <p>
     * The <code>UpdateServer</code> call returns the <code>ServerId</code> of the server you updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateServerRequest#builder()}
     * </p>
     *
     * @param updateServerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateServerRequest.Builder} to create a request.
     * @return Result of the UpdateServer operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws ConflictException
     *         This exception is thrown when the <code>UpdateServer</code> is called for a file transfer
     *         protocol-enabled server that has VPC as the endpoint type and the server's <code>VpcEndpointID</code> is
     *         not in the available state.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceExistsException
     *         The requested resource does not exist.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UpdateServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateServer" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateServerResponse updateServer(Consumer<UpdateServerRequest.Builder> updateServerRequest)
            throws AccessDeniedException, ServiceUnavailableException, ConflictException, InternalServiceErrorException,
            InvalidRequestException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, TransferException {
        return updateServer(UpdateServerRequest.builder().applyMutation(updateServerRequest).build());
    }

    /**
     * <p>
     * Assigns new properties to a user. Parameters you pass modify any or all of the following: the home directory,
     * role, and policy for the <code>UserName</code> and <code>ServerId</code> you specify.
     * </p>
     * <p>
     * The response returns the <code>ServerId</code> and the <code>UserName</code> for the updated user.
     * </p>
     *
     * @param updateUserRequest
     * @return Result of the UpdateUser operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws ServiceUnavailableException,
            InternalServiceErrorException, InvalidRequestException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, TransferException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns new properties to a user. Parameters you pass modify any or all of the following: the home directory,
     * role, and policy for the <code>UserName</code> and <code>ServerId</code> you specify.
     * </p>
     * <p>
     * The response returns the <code>ServerId</code> and the <code>UserName</code> for the updated user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on {@link UpdateUserRequest.Builder} to create a request.
     * @return Result of the UpdateUser operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request has failed because the Amazon Web ServicesTransfer Family service is not available.
     * @throws InternalServiceErrorException
     *         This exception is thrown when an error occurs in the Amazon Web ServicesTransfer Family service.
     * @throws InvalidRequestException
     *         This exception is thrown when the client submits a malformed request.
     * @throws ResourceNotFoundException
     *         This exception is thrown when a resource is not found by the Amazon Web ServicesTransfer Family service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TransferException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TransferClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateUserResponse updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest)
            throws ServiceUnavailableException, InternalServiceErrorException, InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TransferException {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    /**
     * Create an instance of {@link TransferWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link TransferWaiter}
     */
    default TransferWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}
