/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the steps in the workflow, as well as the steps to execute in case of any errors during workflow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionResults implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionResults.Builder, ExecutionResults> {
    private static final SdkField<List<ExecutionStepResult>> STEPS_FIELD = SdkField
            .<List<ExecutionStepResult>> builder(MarshallingType.LIST)
            .memberName("Steps")
            .getter(getter(ExecutionResults::steps))
            .setter(setter(Builder::steps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExecutionStepResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExecutionStepResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ExecutionStepResult>> ON_EXCEPTION_STEPS_FIELD = SdkField
            .<List<ExecutionStepResult>> builder(MarshallingType.LIST)
            .memberName("OnExceptionSteps")
            .getter(getter(ExecutionResults::onExceptionSteps))
            .setter(setter(Builder::onExceptionSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnExceptionSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExecutionStepResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExecutionStepResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEPS_FIELD,
            ON_EXCEPTION_STEPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ExecutionStepResult> steps;

    private final List<ExecutionStepResult> onExceptionSteps;

    private ExecutionResults(BuilderImpl builder) {
        this.steps = builder.steps;
        this.onExceptionSteps = builder.onExceptionSteps;
    }

    /**
     * For responses, this returns true if the service returned a value for the Steps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSteps() {
        return steps != null && !(steps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the details for the steps that are in the specified workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSteps} method.
     * </p>
     * 
     * @return Specifies the details for the steps that are in the specified workflow.
     */
    public final List<ExecutionStepResult> steps() {
        return steps;
    }

    /**
     * For responses, this returns true if the service returned a value for the OnExceptionSteps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOnExceptionSteps() {
        return onExceptionSteps != null && !(onExceptionSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOnExceptionSteps} method.
     * </p>
     * 
     * @return Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
     */
    public final List<ExecutionStepResult> onExceptionSteps() {
        return onExceptionSteps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSteps() ? steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOnExceptionSteps() ? onExceptionSteps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionResults)) {
            return false;
        }
        ExecutionResults other = (ExecutionResults) obj;
        return hasSteps() == other.hasSteps() && Objects.equals(steps(), other.steps())
                && hasOnExceptionSteps() == other.hasOnExceptionSteps()
                && Objects.equals(onExceptionSteps(), other.onExceptionSteps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionResults").add("Steps", hasSteps() ? steps() : null)
                .add("OnExceptionSteps", hasOnExceptionSteps() ? onExceptionSteps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Steps":
            return Optional.ofNullable(clazz.cast(steps()));
        case "OnExceptionSteps":
            return Optional.ofNullable(clazz.cast(onExceptionSteps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionResults, T> g) {
        return obj -> g.apply((ExecutionResults) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionResults> {
        /**
         * <p>
         * Specifies the details for the steps that are in the specified workflow.
         * </p>
         * 
         * @param steps
         *        Specifies the details for the steps that are in the specified workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Collection<ExecutionStepResult> steps);

        /**
         * <p>
         * Specifies the details for the steps that are in the specified workflow.
         * </p>
         * 
         * @param steps
         *        Specifies the details for the steps that are in the specified workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(ExecutionStepResult... steps);

        /**
         * <p>
         * Specifies the details for the steps that are in the specified workflow.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ExecutionStepResult>.Builder}
         * avoiding the need to create one manually via {@link List<ExecutionStepResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExecutionStepResult>.Builder#build()} is called immediately
         * and its result is passed to {@link #steps(List<ExecutionStepResult>)}.
         * 
         * @param steps
         *        a consumer that will call methods on {@link List<ExecutionStepResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #steps(List<ExecutionStepResult>)
         */
        Builder steps(Consumer<ExecutionStepResult.Builder>... steps);

        /**
         * <p>
         * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
         * </p>
         * 
         * @param onExceptionSteps
         *        Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onExceptionSteps(Collection<ExecutionStepResult> onExceptionSteps);

        /**
         * <p>
         * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
         * </p>
         * 
         * @param onExceptionSteps
         *        Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onExceptionSteps(ExecutionStepResult... onExceptionSteps);

        /**
         * <p>
         * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ExecutionStepResult>.Builder}
         * avoiding the need to create one manually via {@link List<ExecutionStepResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExecutionStepResult>.Builder#build()} is called immediately
         * and its result is passed to {@link #onExceptionSteps(List<ExecutionStepResult>)}.
         * 
         * @param onExceptionSteps
         *        a consumer that will call methods on {@link List<ExecutionStepResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onExceptionSteps(List<ExecutionStepResult>)
         */
        Builder onExceptionSteps(Consumer<ExecutionStepResult.Builder>... onExceptionSteps);
    }

    static final class BuilderImpl implements Builder {
        private List<ExecutionStepResult> steps = DefaultSdkAutoConstructList.getInstance();

        private List<ExecutionStepResult> onExceptionSteps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionResults model) {
            steps(model.steps);
            onExceptionSteps(model.onExceptionSteps);
        }

        public final List<ExecutionStepResult.Builder> getSteps() {
            List<ExecutionStepResult.Builder> result = ExecutionStepResultsCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<ExecutionStepResult.BuilderImpl> steps) {
            this.steps = ExecutionStepResultsCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<ExecutionStepResult> steps) {
            this.steps = ExecutionStepResultsCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(ExecutionStepResult... steps) {
            steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<ExecutionStepResult.Builder>... steps) {
            steps(Stream.of(steps).map(c -> ExecutionStepResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ExecutionStepResult.Builder> getOnExceptionSteps() {
            List<ExecutionStepResult.Builder> result = ExecutionStepResultsCopier.copyToBuilder(this.onExceptionSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOnExceptionSteps(Collection<ExecutionStepResult.BuilderImpl> onExceptionSteps) {
            this.onExceptionSteps = ExecutionStepResultsCopier.copyFromBuilder(onExceptionSteps);
        }

        @Override
        public final Builder onExceptionSteps(Collection<ExecutionStepResult> onExceptionSteps) {
            this.onExceptionSteps = ExecutionStepResultsCopier.copy(onExceptionSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onExceptionSteps(ExecutionStepResult... onExceptionSteps) {
            onExceptionSteps(Arrays.asList(onExceptionSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onExceptionSteps(Consumer<ExecutionStepResult.Builder>... onExceptionSteps) {
            onExceptionSteps(Stream.of(onExceptionSteps).map(c -> ExecutionStepResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExecutionResults build() {
            return new ExecutionResults(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
