/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccessResponse extends TransferResponse implements
        ToCopyableBuilder<DescribeAccessResponse.Builder, DescribeAccessResponse> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerId").getter(getter(DescribeAccessResponse::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<DescribedAccess> ACCESS_FIELD = SdkField.<DescribedAccess> builder(MarshallingType.SDK_POJO)
            .memberName("Access").getter(getter(DescribeAccessResponse::access)).setter(setter(Builder::access))
            .constructor(DescribedAccess::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Access").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SERVER_ID_FIELD, ACCESS_FIELD));

    private final String serverId;

    private final DescribedAccess access;

    private DescribeAccessResponse(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.access = builder.access;
    }

    /**
     * <p>
     * A system-assigned unique identifier for a server that has this access assigned.
     * </p>
     * 
     * @return A system-assigned unique identifier for a server that has this access assigned.
     */
    public final String serverId() {
        return serverId;
    }

    /**
     * <p>
     * The external ID of the server that the access is attached to.
     * </p>
     * 
     * @return The external ID of the server that the access is attached to.
     */
    public final DescribedAccess access() {
        return access;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(access());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccessResponse)) {
            return false;
        }
        DescribeAccessResponse other = (DescribeAccessResponse) obj;
        return Objects.equals(serverId(), other.serverId()) && Objects.equals(access(), other.access());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccessResponse").add("ServerId", serverId()).add("Access", access()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "Access":
            return Optional.ofNullable(clazz.cast(access()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccessResponse, T> g) {
        return obj -> g.apply((DescribeAccessResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAccessResponse> {
        /**
         * <p>
         * A system-assigned unique identifier for a server that has this access assigned.
         * </p>
         * 
         * @param serverId
         *        A system-assigned unique identifier for a server that has this access assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * The external ID of the server that the access is attached to.
         * </p>
         * 
         * @param access
         *        The external ID of the server that the access is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder access(DescribedAccess access);

        /**
         * <p>
         * The external ID of the server that the access is attached to.
         * </p>
         * This is a convenience method that creates an instance of the {@link DescribedAccess.Builder} avoiding the
         * need to create one manually via {@link DescribedAccess#builder()}.
         *
         * When the {@link Consumer} completes, {@link DescribedAccess.Builder#build()} is called immediately and its
         * result is passed to {@link #access(DescribedAccess)}.
         * 
         * @param access
         *        a consumer that will call methods on {@link DescribedAccess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #access(DescribedAccess)
         */
        default Builder access(Consumer<DescribedAccess.Builder> access) {
            return access(DescribedAccess.builder().applyMutation(access).build());
        }
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String serverId;

        private DescribedAccess access;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccessResponse model) {
            super(model);
            serverId(model.serverId);
            access(model.access);
        }

        public final String getServerId() {
            return serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final DescribedAccess.Builder getAccess() {
            return access != null ? access.toBuilder() : null;
        }

        public final void setAccess(DescribedAccess.BuilderImpl access) {
            this.access = access != null ? access.build() : null;
        }

        @Override
        public final Builder access(DescribedAccess access) {
            this.access = access;
            return this;
        }

        @Override
        public DescribeAccessResponse build() {
            return new DescribeAccessResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
