/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectorRequest extends TransferRequest implements
        ToCopyableBuilder<UpdateConnectorRequest.Builder, UpdateConnectorRequest> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorId").getter(getter(UpdateConnectorRequest::connectorId)).setter(setter(Builder::connectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(UpdateConnectorRequest::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<As2ConnectorConfig> AS2_CONFIG_FIELD = SdkField
            .<As2ConnectorConfig> builder(MarshallingType.SDK_POJO).memberName("As2Config")
            .getter(getter(UpdateConnectorRequest::as2Config)).setter(setter(Builder::as2Config))
            .constructor(As2ConnectorConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("As2Config").build()).build();

    private static final SdkField<String> ACCESS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessRole").getter(getter(UpdateConnectorRequest::accessRole)).setter(setter(Builder::accessRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRole").build()).build();

    private static final SdkField<String> LOGGING_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoggingRole").getter(getter(UpdateConnectorRequest::loggingRole)).setter(setter(Builder::loggingRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD, URL_FIELD,
            AS2_CONFIG_FIELD, ACCESS_ROLE_FIELD, LOGGING_ROLE_FIELD));

    private final String connectorId;

    private final String url;

    private final As2ConnectorConfig as2Config;

    private final String accessRole;

    private final String loggingRole;

    private UpdateConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.connectorId = builder.connectorId;
        this.url = builder.url;
        this.as2Config = builder.as2Config;
        this.accessRole = builder.accessRole;
        this.loggingRole = builder.loggingRole;
    }

    /**
     * <p>
     * The unique identifier for the connector.
     * </p>
     * 
     * @return The unique identifier for the connector.
     */
    public final String connectorId() {
        return connectorId;
    }

    /**
     * <p>
     * The URL of the partner's AS2 endpoint.
     * </p>
     * 
     * @return The URL of the partner's AS2 endpoint.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * A structure that contains the parameters for a connector object.
     * </p>
     * 
     * @return A structure that contains the parameters for a connector object.
     */
    public final As2ConnectorConfig as2Config() {
        return as2Config;
    }

    /**
     * <p>
     * With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths in the
     * request parameter, <code>SendFilePaths</code>. We use the file’s parent directory (for example, for
     * <code>--send-file-paths /bucket/dir/file.txt</code>, parent directory is <code>/bucket/dir/</code>) to
     * temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a
     * final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code> needs to
     * provide read and write access to the parent directory of the file location used in the
     * <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent
     * directory of the files that you intend to send with <code>StartFileTransfer</code>.
     * </p>
     * 
     * @return With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths in
     *         the request parameter, <code>SendFilePaths</code>. We use the file’s parent directory (for example, for
     *         <code>--send-file-paths /bucket/dir/file.txt</code>, parent directory is <code>/bucket/dir/</code>) to
     *         temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and
     *         write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code>
     *         needs to provide read and write access to the parent directory of the file location used in the
     *         <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the
     *         parent directory of the files that you intend to send with <code>StartFileTransfer</code>.
     */
    public final String accessRole() {
        return accessRole;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a connector to turn
     * on CloudWatch logging for Amazon S3 events. When set, you can view connector activity in your CloudWatch logs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a connector
     *         to turn on CloudWatch logging for Amazon S3 events. When set, you can view connector activity in your
     *         CloudWatch logs.
     */
    public final String loggingRole() {
        return loggingRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(as2Config());
        hashCode = 31 * hashCode + Objects.hashCode(accessRole());
        hashCode = 31 * hashCode + Objects.hashCode(loggingRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectorRequest)) {
            return false;
        }
        UpdateConnectorRequest other = (UpdateConnectorRequest) obj;
        return Objects.equals(connectorId(), other.connectorId()) && Objects.equals(url(), other.url())
                && Objects.equals(as2Config(), other.as2Config()) && Objects.equals(accessRole(), other.accessRole())
                && Objects.equals(loggingRole(), other.loggingRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectorRequest").add("ConnectorId", connectorId()).add("Url", url())
                .add("As2Config", as2Config()).add("AccessRole", accessRole()).add("LoggingRole", loggingRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorId":
            return Optional.ofNullable(clazz.cast(connectorId()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "As2Config":
            return Optional.ofNullable(clazz.cast(as2Config()));
        case "AccessRole":
            return Optional.ofNullable(clazz.cast(accessRole()));
        case "LoggingRole":
            return Optional.ofNullable(clazz.cast(loggingRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectorRequest, T> g) {
        return obj -> g.apply((UpdateConnectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConnectorRequest> {
        /**
         * <p>
         * The unique identifier for the connector.
         * </p>
         * 
         * @param connectorId
         *        The unique identifier for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorId(String connectorId);

        /**
         * <p>
         * The URL of the partner's AS2 endpoint.
         * </p>
         * 
         * @param url
         *        The URL of the partner's AS2 endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * A structure that contains the parameters for a connector object.
         * </p>
         * 
         * @param as2Config
         *        A structure that contains the parameters for a connector object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder as2Config(As2ConnectorConfig as2Config);

        /**
         * <p>
         * A structure that contains the parameters for a connector object.
         * </p>
         * This is a convenience method that creates an instance of the {@link As2ConnectorConfig.Builder} avoiding the
         * need to create one manually via {@link As2ConnectorConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link As2ConnectorConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #as2Config(As2ConnectorConfig)}.
         * 
         * @param as2Config
         *        a consumer that will call methods on {@link As2ConnectorConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #as2Config(As2ConnectorConfig)
         */
        default Builder as2Config(Consumer<As2ConnectorConfig.Builder> as2Config) {
            return as2Config(As2ConnectorConfig.builder().applyMutation(as2Config).build());
        }

        /**
         * <p>
         * With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths in the
         * request parameter, <code>SendFilePaths</code>. We use the file’s parent directory (for example, for
         * <code>--send-file-paths /bucket/dir/file.txt</code>, parent directory is <code>/bucket/dir/</code>) to
         * temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and
         * write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code>
         * needs to provide read and write access to the parent directory of the file location used in the
         * <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent
         * directory of the files that you intend to send with <code>StartFileTransfer</code>.
         * </p>
         * 
         * @param accessRole
         *        With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths
         *        in the request parameter, <code>SendFilePaths</code>. We use the file’s parent directory (for example,
         *        for <code>--send-file-paths /bucket/dir/file.txt</code>, parent directory is <code>/bucket/dir/</code>
         *        ) to temporarily store a processed AS2 message file, store the MDN when we receive them from the
         *        partner, and write a final JSON file containing relevant metadata of the transmission. So, the
         *        <code>AccessRole</code> needs to provide read and write access to the parent directory of the file
         *        location used in the <code>StartFileTransfer</code> request. Additionally, you need to provide read
         *        and write access to the parent directory of the files that you intend to send with
         *        <code>StartFileTransfer</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessRole(String accessRole);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a connector to
         * turn on CloudWatch logging for Amazon S3 events. When set, you can view connector activity in your CloudWatch
         * logs.
         * </p>
         * 
         * @param loggingRole
         *        The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a
         *        connector to turn on CloudWatch logging for Amazon S3 events. When set, you can view connector
         *        activity in your CloudWatch logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingRole(String loggingRole);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private String connectorId;

        private String url;

        private As2ConnectorConfig as2Config;

        private String accessRole;

        private String loggingRole;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectorRequest model) {
            super(model);
            connectorId(model.connectorId);
            url(model.url);
            as2Config(model.as2Config);
            accessRole(model.accessRole);
            loggingRole(model.loggingRole);
        }

        public final String getConnectorId() {
            return connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final As2ConnectorConfig.Builder getAs2Config() {
            return as2Config != null ? as2Config.toBuilder() : null;
        }

        public final void setAs2Config(As2ConnectorConfig.BuilderImpl as2Config) {
            this.as2Config = as2Config != null ? as2Config.build() : null;
        }

        @Override
        public final Builder as2Config(As2ConnectorConfig as2Config) {
            this.as2Config = as2Config;
            return this;
        }

        public final String getAccessRole() {
            return accessRole;
        }

        public final void setAccessRole(String accessRole) {
            this.accessRole = accessRole;
        }

        @Override
        public final Builder accessRole(String accessRole) {
            this.accessRole = accessRole;
            return this;
        }

        public final String getLoggingRole() {
            return loggingRole;
        }

        public final void setLoggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
        }

        @Override
        public final Builder loggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectorRequest build() {
            return new UpdateConnectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
