/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCertificatesResponse extends TransferResponse implements
        ToCopyableBuilder<ListCertificatesResponse.Builder, ListCertificatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCertificatesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ListedCertificate>> CERTIFICATES_FIELD = SdkField
            .<List<ListedCertificate>> builder(MarshallingType.LIST)
            .memberName("Certificates")
            .getter(getter(ListCertificatesResponse::certificates))
            .setter(setter(Builder::certificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListedCertificate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListedCertificate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CERTIFICATES_FIELD));

    private final String nextToken;

    private final List<ListedCertificate> certificates;

    private ListCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.certificates = builder.certificates;
    }

    /**
     * <p>
     * Returns the next token, which you can use to list the next certificate.
     * </p>
     * 
     * @return Returns the next token, which you can use to list the next certificate.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Certificates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCertificates() {
        return certificates != null && !(certificates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns an array of the certificates that are specified in the <code>ListCertificates</code> call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCertificates} method.
     * </p>
     * 
     * @return Returns an array of the certificates that are specified in the <code>ListCertificates</code> call.
     */
    public final List<ListedCertificate> certificates() {
        return certificates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificates() ? certificates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesResponse)) {
            return false;
        }
        ListCertificatesResponse other = (ListCertificatesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasCertificates() == other.hasCertificates()
                && Objects.equals(certificates(), other.certificates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCertificatesResponse").add("NextToken", nextToken())
                .add("Certificates", hasCertificates() ? certificates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Certificates":
            return Optional.ofNullable(clazz.cast(certificates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCertificatesResponse, T> g) {
        return obj -> g.apply((ListCertificatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCertificatesResponse> {
        /**
         * <p>
         * Returns the next token, which you can use to list the next certificate.
         * </p>
         * 
         * @param nextToken
         *        Returns the next token, which you can use to list the next certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Returns an array of the certificates that are specified in the <code>ListCertificates</code> call.
         * </p>
         * 
         * @param certificates
         *        Returns an array of the certificates that are specified in the <code>ListCertificates</code> call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Collection<ListedCertificate> certificates);

        /**
         * <p>
         * Returns an array of the certificates that are specified in the <code>ListCertificates</code> call.
         * </p>
         * 
         * @param certificates
         *        Returns an array of the certificates that are specified in the <code>ListCertificates</code> call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(ListedCertificate... certificates);

        /**
         * <p>
         * Returns an array of the certificates that are specified in the <code>ListCertificates</code> call.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ListedCertificate>.Builder} avoiding
         * the need to create one manually via {@link List<ListedCertificate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ListedCertificate>.Builder#build()} is called immediately
         * and its result is passed to {@link #certificates(List<ListedCertificate>)}.
         * 
         * @param certificates
         *        a consumer that will call methods on {@link List<ListedCertificate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificates(List<ListedCertificate>)
         */
        Builder certificates(Consumer<ListedCertificate.Builder>... certificates);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ListedCertificate> certificates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesResponse model) {
            super(model);
            nextToken(model.nextToken);
            certificates(model.certificates);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListedCertificate.Builder> getCertificates() {
            List<ListedCertificate.Builder> result = ListedCertificatesCopier.copyToBuilder(this.certificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificates(Collection<ListedCertificate.BuilderImpl> certificates) {
            this.certificates = ListedCertificatesCopier.copyFromBuilder(certificates);
        }

        @Override
        public final Builder certificates(Collection<ListedCertificate> certificates) {
            this.certificates = ListedCertificatesCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(ListedCertificate... certificates) {
            certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<ListedCertificate.Builder>... certificates) {
            certificates(Stream.of(certificates).map(c -> ListedCertificate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCertificatesResponse build() {
            return new ListCertificatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
