/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAgreementResponse extends TransferResponse implements
        ToCopyableBuilder<CreateAgreementResponse.Builder, CreateAgreementResponse> {
    private static final SdkField<String> AGREEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgreementId").getter(getter(CreateAgreementResponse::agreementId)).setter(setter(Builder::agreementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgreementId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGREEMENT_ID_FIELD));

    private final String agreementId;

    private CreateAgreementResponse(BuilderImpl builder) {
        super(builder);
        this.agreementId = builder.agreementId;
    }

    /**
     * <p>
     * The unique identifier for the agreement. Use this ID for deleting, or updating an agreement, as well as in any
     * other API calls that require that you specify the agreement ID.
     * </p>
     * 
     * @return The unique identifier for the agreement. Use this ID for deleting, or updating an agreement, as well as
     *         in any other API calls that require that you specify the agreement ID.
     */
    public final String agreementId() {
        return agreementId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agreementId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgreementResponse)) {
            return false;
        }
        CreateAgreementResponse other = (CreateAgreementResponse) obj;
        return Objects.equals(agreementId(), other.agreementId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAgreementResponse").add("AgreementId", agreementId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgreementId":
            return Optional.ofNullable(clazz.cast(agreementId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAgreementResponse, T> g) {
        return obj -> g.apply((CreateAgreementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAgreementResponse> {
        /**
         * <p>
         * The unique identifier for the agreement. Use this ID for deleting, or updating an agreement, as well as in
         * any other API calls that require that you specify the agreement ID.
         * </p>
         * 
         * @param agreementId
         *        The unique identifier for the agreement. Use this ID for deleting, or updating an agreement, as well
         *        as in any other API calls that require that you specify the agreement ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementId(String agreementId);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String agreementId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgreementResponse model) {
            super(model);
            agreementId(model.agreementId);
        }

        public final String getAgreementId() {
            return agreementId;
        }

        public final void setAgreementId(String agreementId) {
            this.agreementId = agreementId;
        }

        @Override
        public final Builder agreementId(String agreementId) {
            this.agreementId = agreementId;
            return this;
        }

        @Override
        public CreateAgreementResponse build() {
            return new CreateAgreementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
