/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowDetail implements SdkPojo, Serializable, ToCopyableBuilder<WorkflowDetail.Builder, WorkflowDetail> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowId").getter(getter(WorkflowDetail::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowId").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRole").getter(getter(WorkflowDetail::executionRole)).setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD,
            EXECUTION_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workflowId;

    private final String executionRole;

    private WorkflowDetail(BuilderImpl builder) {
        this.workflowId = builder.workflowId;
        this.executionRole = builder.executionRole;
    }

    /**
     * <p>
     * A unique identifier for the workflow.
     * </p>
     * 
     * @return A unique identifier for the workflow.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all
     * workflow steps can operate on the required resources
     * </p>
     * 
     * @return Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that
     *         all workflow steps can operate on the required resources
     */
    public final String executionRole() {
        return executionRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowDetail)) {
            return false;
        }
        WorkflowDetail other = (WorkflowDetail) obj;
        return Objects.equals(workflowId(), other.workflowId()) && Objects.equals(executionRole(), other.executionRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowDetail").add("WorkflowId", workflowId()).add("ExecutionRole", executionRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "ExecutionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowDetail, T> g) {
        return obj -> g.apply((WorkflowDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowDetail> {
        /**
         * <p>
         * A unique identifier for the workflow.
         * </p>
         * 
         * @param workflowId
         *        A unique identifier for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all
         * workflow steps can operate on the required resources
         * </p>
         * 
         * @param executionRole
         *        Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so
         *        that all workflow steps can operate on the required resources
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);
    }

    static final class BuilderImpl implements Builder {
        private String workflowId;

        private String executionRole;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowDetail model) {
            workflowId(model.workflowId);
            executionRole(model.executionRole);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        @Override
        public WorkflowDetail build() {
            return new WorkflowDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
