/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for a server host key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribedHostKey implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribedHostKey.Builder, DescribedHostKey> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribedHostKey::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> HOST_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostKeyId").getter(getter(DescribedHostKey::hostKeyId)).setter(setter(Builder::hostKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKeyId").build()).build();

    private static final SdkField<String> HOST_KEY_FINGERPRINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostKeyFingerprint").getter(getter(DescribedHostKey::hostKeyFingerprint))
            .setter(setter(Builder::hostKeyFingerprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKeyFingerprint").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribedHostKey::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DescribedHostKey::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Instant> DATE_IMPORTED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateImported").getter(getter(DescribedHostKey::dateImported)).setter(setter(Builder::dateImported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateImported").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(DescribedHostKey::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, HOST_KEY_ID_FIELD,
            HOST_KEY_FINGERPRINT_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, DATE_IMPORTED_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String hostKeyId;

    private final String hostKeyFingerprint;

    private final String description;

    private final String type;

    private final Instant dateImported;

    private final List<Tag> tags;

    private DescribedHostKey(BuilderImpl builder) {
        this.arn = builder.arn;
        this.hostKeyId = builder.hostKeyId;
        this.hostKeyFingerprint = builder.hostKeyFingerprint;
        this.description = builder.description;
        this.type = builder.type;
        this.dateImported = builder.dateImported;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) for the host key.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) for the host key.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A unique identifier for the host key.
     * </p>
     * 
     * @return A unique identifier for the host key.
     */
    public final String hostKeyId() {
        return hostKeyId;
    }

    /**
     * <p>
     * The public key fingerprint, which is a short sequence of bytes used to identify the longer public key.
     * </p>
     * 
     * @return The public key fingerprint, which is a short sequence of bytes used to identify the longer public key.
     */
    public final String hostKeyFingerprint() {
        return hostKeyFingerprint;
    }

    /**
     * <p>
     * The text description for this host key.
     * </p>
     * 
     * @return The text description for this host key.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The encryption algorithm used for the host key. The <code>Type</code> is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ssh-rsa
     * </p>
     * </li>
     * <li>
     * <p>
     * ssh-ed25519
     * </p>
     * </li>
     * <li>
     * <p>
     * ecdsa-sha2-nistp256
     * </p>
     * </li>
     * <li>
     * <p>
     * ecdsa-sha2-nistp384
     * </p>
     * </li>
     * <li>
     * <p>
     * ecdsa-sha2-nistp521
     * </p>
     * </li>
     * </ul>
     * 
     * @return The encryption algorithm used for the host key. The <code>Type</code> is one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ssh-rsa
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ssh-ed25519
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ecdsa-sha2-nistp256
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ecdsa-sha2-nistp384
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ecdsa-sha2-nistp521
     *         </p>
     *         </li>
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The date on which the host key was added to the server.
     * </p>
     * 
     * @return The date on which the host key was added to the server.
     */
    public final Instant dateImported() {
        return dateImported;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Key-value pairs that can be used to group and search for host keys.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs that can be used to group and search for host keys.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hostKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hostKeyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(dateImported());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedHostKey)) {
            return false;
        }
        DescribedHostKey other = (DescribedHostKey) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(hostKeyId(), other.hostKeyId())
                && Objects.equals(hostKeyFingerprint(), other.hostKeyFingerprint())
                && Objects.equals(description(), other.description()) && Objects.equals(type(), other.type())
                && Objects.equals(dateImported(), other.dateImported()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribedHostKey").add("Arn", arn()).add("HostKeyId", hostKeyId())
                .add("HostKeyFingerprint", hostKeyFingerprint()).add("Description", description()).add("Type", type())
                .add("DateImported", dateImported()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "HostKeyId":
            return Optional.ofNullable(clazz.cast(hostKeyId()));
        case "HostKeyFingerprint":
            return Optional.ofNullable(clazz.cast(hostKeyFingerprint()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "DateImported":
            return Optional.ofNullable(clazz.cast(dateImported()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribedHostKey, T> g) {
        return obj -> g.apply((DescribedHostKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribedHostKey> {
        /**
         * <p>
         * The unique Amazon Resource Name (ARN) for the host key.
         * </p>
         * 
         * @param arn
         *        The unique Amazon Resource Name (ARN) for the host key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A unique identifier for the host key.
         * </p>
         * 
         * @param hostKeyId
         *        A unique identifier for the host key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostKeyId(String hostKeyId);

        /**
         * <p>
         * The public key fingerprint, which is a short sequence of bytes used to identify the longer public key.
         * </p>
         * 
         * @param hostKeyFingerprint
         *        The public key fingerprint, which is a short sequence of bytes used to identify the longer public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostKeyFingerprint(String hostKeyFingerprint);

        /**
         * <p>
         * The text description for this host key.
         * </p>
         * 
         * @param description
         *        The text description for this host key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The encryption algorithm used for the host key. The <code>Type</code> is one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ssh-rsa
         * </p>
         * </li>
         * <li>
         * <p>
         * ssh-ed25519
         * </p>
         * </li>
         * <li>
         * <p>
         * ecdsa-sha2-nistp256
         * </p>
         * </li>
         * <li>
         * <p>
         * ecdsa-sha2-nistp384
         * </p>
         * </li>
         * <li>
         * <p>
         * ecdsa-sha2-nistp521
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The encryption algorithm used for the host key. The <code>Type</code> is one of the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ssh-rsa
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ssh-ed25519
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ecdsa-sha2-nistp256
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ecdsa-sha2-nistp384
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ecdsa-sha2-nistp521
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The date on which the host key was added to the server.
         * </p>
         * 
         * @param dateImported
         *        The date on which the host key was added to the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateImported(Instant dateImported);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for host keys.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for host keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for host keys.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for host keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for host keys.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.transfer.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String hostKeyId;

        private String hostKeyFingerprint;

        private String description;

        private String type;

        private Instant dateImported;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedHostKey model) {
            arn(model.arn);
            hostKeyId(model.hostKeyId);
            hostKeyFingerprint(model.hostKeyFingerprint);
            description(model.description);
            type(model.type);
            dateImported(model.dateImported);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getHostKeyId() {
            return hostKeyId;
        }

        public final void setHostKeyId(String hostKeyId) {
            this.hostKeyId = hostKeyId;
        }

        @Override
        public final Builder hostKeyId(String hostKeyId) {
            this.hostKeyId = hostKeyId;
            return this;
        }

        public final String getHostKeyFingerprint() {
            return hostKeyFingerprint;
        }

        public final void setHostKeyFingerprint(String hostKeyFingerprint) {
            this.hostKeyFingerprint = hostKeyFingerprint;
        }

        @Override
        public final Builder hostKeyFingerprint(String hostKeyFingerprint) {
            this.hostKeyFingerprint = hostKeyFingerprint;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getDateImported() {
            return dateImported;
        }

        public final void setDateImported(Instant dateImported) {
            this.dateImported = dateImported;
        }

        @Override
        public final Builder dateImported(Instant dateImported) {
            this.dateImported = dateImported;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribedHostKey build() {
            return new DescribedHostKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
