/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns properties of the host key that is specified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedHostKey implements SdkPojo, Serializable, ToCopyableBuilder<ListedHostKey.Builder, ListedHostKey> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ListedHostKey::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> HOST_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostKeyId").getter(getter(ListedHostKey::hostKeyId)).setter(setter(Builder::hostKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKeyId").build()).build();

    private static final SdkField<String> FINGERPRINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Fingerprint").getter(getter(ListedHostKey::fingerprint)).setter(setter(Builder::fingerprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fingerprint").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ListedHostKey::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ListedHostKey::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Instant> DATE_IMPORTED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateImported").getter(getter(ListedHostKey::dateImported)).setter(setter(Builder::dateImported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateImported").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, HOST_KEY_ID_FIELD,
            FINGERPRINT_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, DATE_IMPORTED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String hostKeyId;

    private final String fingerprint;

    private final String description;

    private final String type;

    private final Instant dateImported;

    private ListedHostKey(BuilderImpl builder) {
        this.arn = builder.arn;
        this.hostKeyId = builder.hostKeyId;
        this.fingerprint = builder.fingerprint;
        this.description = builder.description;
        this.type = builder.type;
        this.dateImported = builder.dateImported;
    }

    /**
     * <p>
     * Specifies the unique Amazon Resource Name (ARN) of the host key.
     * </p>
     * 
     * @return Specifies the unique Amazon Resource Name (ARN) of the host key.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String hostKeyId() {
        return hostKeyId;
    }

    /**
     * <p>
     * The public key fingerprint, which is a short sequence of bytes used to identify the longer public key.
     * </p>
     * 
     * @return The public key fingerprint, which is a short sequence of bytes used to identify the longer public key.
     */
    public final String fingerprint() {
        return fingerprint;
    }

    /**
     * <p>
     * The current description for the host key. You can change it by calling the <code>UpdateHostKey</code> operation
     * and providing a new description.
     * </p>
     * 
     * @return The current description for the host key. You can change it by calling the <code>UpdateHostKey</code>
     *         operation and providing a new description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The encryption algorithm used for the host key. The <code>Type</code> is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ssh-rsa
     * </p>
     * </li>
     * <li>
     * <p>
     * ssh-ed25519
     * </p>
     * </li>
     * <li>
     * <p>
     * ecdsa-sha2-nistp256
     * </p>
     * </li>
     * <li>
     * <p>
     * ecdsa-sha2-nistp384
     * </p>
     * </li>
     * <li>
     * <p>
     * ecdsa-sha2-nistp521
     * </p>
     * </li>
     * </ul>
     * 
     * @return The encryption algorithm used for the host key. The <code>Type</code> is one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ssh-rsa
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ssh-ed25519
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ecdsa-sha2-nistp256
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ecdsa-sha2-nistp384
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ecdsa-sha2-nistp521
     *         </p>
     *         </li>
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The date on which the host key was added to the server.
     * </p>
     * 
     * @return The date on which the host key was added to the server.
     */
    public final Instant dateImported() {
        return dateImported;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hostKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(fingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(dateImported());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedHostKey)) {
            return false;
        }
        ListedHostKey other = (ListedHostKey) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(hostKeyId(), other.hostKeyId())
                && Objects.equals(fingerprint(), other.fingerprint()) && Objects.equals(description(), other.description())
                && Objects.equals(type(), other.type()) && Objects.equals(dateImported(), other.dateImported());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListedHostKey").add("Arn", arn()).add("HostKeyId", hostKeyId())
                .add("Fingerprint", fingerprint()).add("Description", description()).add("Type", type())
                .add("DateImported", dateImported()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "HostKeyId":
            return Optional.ofNullable(clazz.cast(hostKeyId()));
        case "Fingerprint":
            return Optional.ofNullable(clazz.cast(fingerprint()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "DateImported":
            return Optional.ofNullable(clazz.cast(dateImported()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListedHostKey, T> g) {
        return obj -> g.apply((ListedHostKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedHostKey> {
        /**
         * <p>
         * Specifies the unique Amazon Resource Name (ARN) of the host key.
         * </p>
         * 
         * @param arn
         *        Specifies the unique Amazon Resource Name (ARN) of the host key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p/>
         * 
         * @param hostKeyId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostKeyId(String hostKeyId);

        /**
         * <p>
         * The public key fingerprint, which is a short sequence of bytes used to identify the longer public key.
         * </p>
         * 
         * @param fingerprint
         *        The public key fingerprint, which is a short sequence of bytes used to identify the longer public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fingerprint(String fingerprint);

        /**
         * <p>
         * The current description for the host key. You can change it by calling the <code>UpdateHostKey</code>
         * operation and providing a new description.
         * </p>
         * 
         * @param description
         *        The current description for the host key. You can change it by calling the <code>UpdateHostKey</code>
         *        operation and providing a new description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The encryption algorithm used for the host key. The <code>Type</code> is one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ssh-rsa
         * </p>
         * </li>
         * <li>
         * <p>
         * ssh-ed25519
         * </p>
         * </li>
         * <li>
         * <p>
         * ecdsa-sha2-nistp256
         * </p>
         * </li>
         * <li>
         * <p>
         * ecdsa-sha2-nistp384
         * </p>
         * </li>
         * <li>
         * <p>
         * ecdsa-sha2-nistp521
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The encryption algorithm used for the host key. The <code>Type</code> is one of the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ssh-rsa
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ssh-ed25519
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ecdsa-sha2-nistp256
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ecdsa-sha2-nistp384
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ecdsa-sha2-nistp521
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The date on which the host key was added to the server.
         * </p>
         * 
         * @param dateImported
         *        The date on which the host key was added to the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateImported(Instant dateImported);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String hostKeyId;

        private String fingerprint;

        private String description;

        private String type;

        private Instant dateImported;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedHostKey model) {
            arn(model.arn);
            hostKeyId(model.hostKeyId);
            fingerprint(model.fingerprint);
            description(model.description);
            type(model.type);
            dateImported(model.dateImported);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getHostKeyId() {
            return hostKeyId;
        }

        public final void setHostKeyId(String hostKeyId) {
            this.hostKeyId = hostKeyId;
        }

        @Override
        public final Builder hostKeyId(String hostKeyId) {
            this.hostKeyId = hostKeyId;
            return this;
        }

        public final String getFingerprint() {
            return fingerprint;
        }

        public final void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Override
        public final Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getDateImported() {
            return dateImported;
        }

        public final void setDateImported(Instant dateImported) {
            this.dateImported = dateImported;
        }

        @Override
        public final Builder dateImported(Instant dateImported) {
            this.dateImported = dateImported;
            return this;
        }

        @Override
        public ListedHostKey build() {
            return new ListedHostKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
