/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The basic building block of a workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowStep implements SdkPojo, Serializable, ToCopyableBuilder<WorkflowStep.Builder, WorkflowStep> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(WorkflowStep::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<CopyStepDetails> COPY_STEP_DETAILS_FIELD = SdkField
            .<CopyStepDetails> builder(MarshallingType.SDK_POJO).memberName("CopyStepDetails")
            .getter(getter(WorkflowStep::copyStepDetails)).setter(setter(Builder::copyStepDetails))
            .constructor(CopyStepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyStepDetails").build()).build();

    private static final SdkField<CustomStepDetails> CUSTOM_STEP_DETAILS_FIELD = SdkField
            .<CustomStepDetails> builder(MarshallingType.SDK_POJO).memberName("CustomStepDetails")
            .getter(getter(WorkflowStep::customStepDetails)).setter(setter(Builder::customStepDetails))
            .constructor(CustomStepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomStepDetails").build()).build();

    private static final SdkField<DeleteStepDetails> DELETE_STEP_DETAILS_FIELD = SdkField
            .<DeleteStepDetails> builder(MarshallingType.SDK_POJO).memberName("DeleteStepDetails")
            .getter(getter(WorkflowStep::deleteStepDetails)).setter(setter(Builder::deleteStepDetails))
            .constructor(DeleteStepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteStepDetails").build()).build();

    private static final SdkField<TagStepDetails> TAG_STEP_DETAILS_FIELD = SdkField
            .<TagStepDetails> builder(MarshallingType.SDK_POJO).memberName("TagStepDetails")
            .getter(getter(WorkflowStep::tagStepDetails)).setter(setter(Builder::tagStepDetails))
            .constructor(TagStepDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagStepDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            COPY_STEP_DETAILS_FIELD, CUSTOM_STEP_DETAILS_FIELD, DELETE_STEP_DETAILS_FIELD, TAG_STEP_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final CopyStepDetails copyStepDetails;

    private final CustomStepDetails customStepDetails;

    private final DeleteStepDetails deleteStepDetails;

    private final TagStepDetails tagStepDetails;

    private WorkflowStep(BuilderImpl builder) {
        this.type = builder.type;
        this.copyStepDetails = builder.copyStepDetails;
        this.customStepDetails = builder.customStepDetails;
        this.deleteStepDetails = builder.deleteStepDetails;
        this.tagStepDetails = builder.tagStepDetails;
    }

    /**
     * <p>
     * Currently, the following step types are supported.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Copy</i>: copy the file to another location
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Custom</i>: custom step with a lambda target
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Delete</i>: delete the file
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Tag</i>: add a tag to the file
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkflowStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Currently, the following step types are supported. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Copy</i>: copy the file to another location
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Custom</i>: custom step with a lambda target
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Delete</i>: delete the file
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Tag</i>: add a tag to the file
     *         </p>
     *         </li>
     * @see WorkflowStepType
     */
    public final WorkflowStepType type() {
        return WorkflowStepType.fromValue(type);
    }

    /**
     * <p>
     * Currently, the following step types are supported.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Copy</i>: copy the file to another location
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Custom</i>: custom step with a lambda target
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Delete</i>: delete the file
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Tag</i>: add a tag to the file
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkflowStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Currently, the following step types are supported. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Copy</i>: copy the file to another location
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Custom</i>: custom step with a lambda target
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Delete</i>: delete the file
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Tag</i>: add a tag to the file
     *         </p>
     *         </li>
     * @see WorkflowStepType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Details for a step that performs a file copy.
     * </p>
     * <p>
     * Consists of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A description
     * </p>
     * </li>
     * <li>
     * <p>
     * An S3 or EFS location for the destination of the file copy.
     * </p>
     * </li>
     * <li>
     * <p>
     * A flag that indicates whether or not to overwrite an existing file of the same name. The default is
     * <code>FALSE</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Details for a step that performs a file copy.</p>
     *         <p>
     *         Consists of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A description
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An S3 or EFS location for the destination of the file copy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A flag that indicates whether or not to overwrite an existing file of the same name. The default is
     *         <code>FALSE</code>.
     *         </p>
     *         </li>
     */
    public final CopyStepDetails copyStepDetails() {
        return copyStepDetails;
    }

    /**
     * <p>
     * Details for a step that invokes a lambda function.
     * </p>
     * <p>
     * Consists of the lambda function name, target, and timeout (in seconds).
     * </p>
     * 
     * @return Details for a step that invokes a lambda function.</p>
     *         <p>
     *         Consists of the lambda function name, target, and timeout (in seconds).
     */
    public final CustomStepDetails customStepDetails() {
        return customStepDetails;
    }

    /**
     * <p>
     * You need to specify the name of the file to be deleted.
     * </p>
     * 
     * @return You need to specify the name of the file to be deleted.
     */
    public final DeleteStepDetails deleteStepDetails() {
        return deleteStepDetails;
    }

    /**
     * <p>
     * Details for a step that creates one or more tags.
     * </p>
     * <p>
     * You specify one or more tags: each tag contains a key/value pair.
     * </p>
     * 
     * @return Details for a step that creates one or more tags.</p>
     *         <p>
     *         You specify one or more tags: each tag contains a key/value pair.
     */
    public final TagStepDetails tagStepDetails() {
        return tagStepDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(copyStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(customStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(deleteStepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(tagStepDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowStep)) {
            return false;
        }
        WorkflowStep other = (WorkflowStep) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(copyStepDetails(), other.copyStepDetails())
                && Objects.equals(customStepDetails(), other.customStepDetails())
                && Objects.equals(deleteStepDetails(), other.deleteStepDetails())
                && Objects.equals(tagStepDetails(), other.tagStepDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowStep").add("Type", typeAsString()).add("CopyStepDetails", copyStepDetails())
                .add("CustomStepDetails", customStepDetails()).add("DeleteStepDetails", deleteStepDetails())
                .add("TagStepDetails", tagStepDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "CopyStepDetails":
            return Optional.ofNullable(clazz.cast(copyStepDetails()));
        case "CustomStepDetails":
            return Optional.ofNullable(clazz.cast(customStepDetails()));
        case "DeleteStepDetails":
            return Optional.ofNullable(clazz.cast(deleteStepDetails()));
        case "TagStepDetails":
            return Optional.ofNullable(clazz.cast(tagStepDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowStep, T> g) {
        return obj -> g.apply((WorkflowStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowStep> {
        /**
         * <p>
         * Currently, the following step types are supported.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Copy</i>: copy the file to another location
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Custom</i>: custom step with a lambda target
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Delete</i>: delete the file
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Tag</i>: add a tag to the file
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Currently, the following step types are supported. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Copy</i>: copy the file to another location
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Custom</i>: custom step with a lambda target
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Delete</i>: delete the file
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Tag</i>: add a tag to the file
         *        </p>
         *        </li>
         * @see WorkflowStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStepType
         */
        Builder type(String type);

        /**
         * <p>
         * Currently, the following step types are supported.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Copy</i>: copy the file to another location
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Custom</i>: custom step with a lambda target
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Delete</i>: delete the file
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Tag</i>: add a tag to the file
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Currently, the following step types are supported. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Copy</i>: copy the file to another location
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Custom</i>: custom step with a lambda target
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Delete</i>: delete the file
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Tag</i>: add a tag to the file
         *        </p>
         *        </li>
         * @see WorkflowStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStepType
         */
        Builder type(WorkflowStepType type);

        /**
         * <p>
         * Details for a step that performs a file copy.
         * </p>
         * <p>
         * Consists of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A description
         * </p>
         * </li>
         * <li>
         * <p>
         * An S3 or EFS location for the destination of the file copy.
         * </p>
         * </li>
         * <li>
         * <p>
         * A flag that indicates whether or not to overwrite an existing file of the same name. The default is
         * <code>FALSE</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param copyStepDetails
         *        Details for a step that performs a file copy.</p>
         *        <p>
         *        Consists of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A description
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An S3 or EFS location for the destination of the file copy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A flag that indicates whether or not to overwrite an existing file of the same name. The default is
         *        <code>FALSE</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyStepDetails(CopyStepDetails copyStepDetails);

        /**
         * <p>
         * Details for a step that performs a file copy.
         * </p>
         * <p>
         * Consists of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A description
         * </p>
         * </li>
         * <li>
         * <p>
         * An S3 or EFS location for the destination of the file copy.
         * </p>
         * </li>
         * <li>
         * <p>
         * A flag that indicates whether or not to overwrite an existing file of the same name. The default is
         * <code>FALSE</code>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link CopyStepDetails.Builder} avoiding the need to
         * create one manually via {@link CopyStepDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link CopyStepDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #copyStepDetails(CopyStepDetails)}.
         * 
         * @param copyStepDetails
         *        a consumer that will call methods on {@link CopyStepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #copyStepDetails(CopyStepDetails)
         */
        default Builder copyStepDetails(Consumer<CopyStepDetails.Builder> copyStepDetails) {
            return copyStepDetails(CopyStepDetails.builder().applyMutation(copyStepDetails).build());
        }

        /**
         * <p>
         * Details for a step that invokes a lambda function.
         * </p>
         * <p>
         * Consists of the lambda function name, target, and timeout (in seconds).
         * </p>
         * 
         * @param customStepDetails
         *        Details for a step that invokes a lambda function.</p>
         *        <p>
         *        Consists of the lambda function name, target, and timeout (in seconds).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customStepDetails(CustomStepDetails customStepDetails);

        /**
         * <p>
         * Details for a step that invokes a lambda function.
         * </p>
         * <p>
         * Consists of the lambda function name, target, and timeout (in seconds).
         * </p>
         * This is a convenience that creates an instance of the {@link CustomStepDetails.Builder} avoiding the need to
         * create one manually via {@link CustomStepDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomStepDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #customStepDetails(CustomStepDetails)}.
         * 
         * @param customStepDetails
         *        a consumer that will call methods on {@link CustomStepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customStepDetails(CustomStepDetails)
         */
        default Builder customStepDetails(Consumer<CustomStepDetails.Builder> customStepDetails) {
            return customStepDetails(CustomStepDetails.builder().applyMutation(customStepDetails).build());
        }

        /**
         * <p>
         * You need to specify the name of the file to be deleted.
         * </p>
         * 
         * @param deleteStepDetails
         *        You need to specify the name of the file to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteStepDetails(DeleteStepDetails deleteStepDetails);

        /**
         * <p>
         * You need to specify the name of the file to be deleted.
         * </p>
         * This is a convenience that creates an instance of the {@link DeleteStepDetails.Builder} avoiding the need to
         * create one manually via {@link DeleteStepDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeleteStepDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #deleteStepDetails(DeleteStepDetails)}.
         * 
         * @param deleteStepDetails
         *        a consumer that will call methods on {@link DeleteStepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteStepDetails(DeleteStepDetails)
         */
        default Builder deleteStepDetails(Consumer<DeleteStepDetails.Builder> deleteStepDetails) {
            return deleteStepDetails(DeleteStepDetails.builder().applyMutation(deleteStepDetails).build());
        }

        /**
         * <p>
         * Details for a step that creates one or more tags.
         * </p>
         * <p>
         * You specify one or more tags: each tag contains a key/value pair.
         * </p>
         * 
         * @param tagStepDetails
         *        Details for a step that creates one or more tags.</p>
         *        <p>
         *        You specify one or more tags: each tag contains a key/value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagStepDetails(TagStepDetails tagStepDetails);

        /**
         * <p>
         * Details for a step that creates one or more tags.
         * </p>
         * <p>
         * You specify one or more tags: each tag contains a key/value pair.
         * </p>
         * This is a convenience that creates an instance of the {@link TagStepDetails.Builder} avoiding the need to
         * create one manually via {@link TagStepDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link TagStepDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #tagStepDetails(TagStepDetails)}.
         * 
         * @param tagStepDetails
         *        a consumer that will call methods on {@link TagStepDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagStepDetails(TagStepDetails)
         */
        default Builder tagStepDetails(Consumer<TagStepDetails.Builder> tagStepDetails) {
            return tagStepDetails(TagStepDetails.builder().applyMutation(tagStepDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private CopyStepDetails copyStepDetails;

        private CustomStepDetails customStepDetails;

        private DeleteStepDetails deleteStepDetails;

        private TagStepDetails tagStepDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowStep model) {
            type(model.type);
            copyStepDetails(model.copyStepDetails);
            customStepDetails(model.customStepDetails);
            deleteStepDetails(model.deleteStepDetails);
            tagStepDetails(model.tagStepDetails);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(WorkflowStepType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final CopyStepDetails.Builder getCopyStepDetails() {
            return copyStepDetails != null ? copyStepDetails.toBuilder() : null;
        }

        public final void setCopyStepDetails(CopyStepDetails.BuilderImpl copyStepDetails) {
            this.copyStepDetails = copyStepDetails != null ? copyStepDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder copyStepDetails(CopyStepDetails copyStepDetails) {
            this.copyStepDetails = copyStepDetails;
            return this;
        }

        public final CustomStepDetails.Builder getCustomStepDetails() {
            return customStepDetails != null ? customStepDetails.toBuilder() : null;
        }

        public final void setCustomStepDetails(CustomStepDetails.BuilderImpl customStepDetails) {
            this.customStepDetails = customStepDetails != null ? customStepDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder customStepDetails(CustomStepDetails customStepDetails) {
            this.customStepDetails = customStepDetails;
            return this;
        }

        public final DeleteStepDetails.Builder getDeleteStepDetails() {
            return deleteStepDetails != null ? deleteStepDetails.toBuilder() : null;
        }

        public final void setDeleteStepDetails(DeleteStepDetails.BuilderImpl deleteStepDetails) {
            this.deleteStepDetails = deleteStepDetails != null ? deleteStepDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder deleteStepDetails(DeleteStepDetails deleteStepDetails) {
            this.deleteStepDetails = deleteStepDetails;
            return this;
        }

        public final TagStepDetails.Builder getTagStepDetails() {
            return tagStepDetails != null ? tagStepDetails.toBuilder() : null;
        }

        public final void setTagStepDetails(TagStepDetails.BuilderImpl tagStepDetails) {
            this.tagStepDetails = tagStepDetails != null ? tagStepDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder tagStepDetails(TagStepDetails tagStepDetails) {
            this.tagStepDetails = tagStepDetails;
            return this;
        }

        @Override
        public WorkflowStep build() {
            return new WorkflowStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
