/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the following details for the step: error (if any), outputs (if any), and the step type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionStepResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionStepResult.Builder, ExecutionStepResult> {
    private static final SdkField<String> STEP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StepType").getter(getter(ExecutionStepResult::stepTypeAsString)).setter(setter(Builder::stepType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepType").build()).build();

    private static final SdkField<String> OUTPUTS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Outputs")
            .getter(getter(ExecutionStepResult::outputs)).setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build()).build();

    private static final SdkField<ExecutionError> ERROR_FIELD = SdkField.<ExecutionError> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(ExecutionStepResult::error)).setter(setter(Builder::error))
            .constructor(ExecutionError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_TYPE_FIELD,
            OUTPUTS_FIELD, ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stepType;

    private final String outputs;

    private final ExecutionError error;

    private ExecutionStepResult(BuilderImpl builder) {
        this.stepType = builder.stepType;
        this.outputs = builder.outputs;
        this.error = builder.error;
    }

    /**
     * <p>
     * One of the available step types.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Copy</i>: copy the file to another location
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Custom</i>: custom step with a lambda target
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Delete</i>: delete the file
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Tag</i>: add a tag to the file
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepType} will
     * return {@link WorkflowStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stepTypeAsString}.
     * </p>
     * 
     * @return One of the available step types.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Copy</i>: copy the file to another location
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Custom</i>: custom step with a lambda target
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Delete</i>: delete the file
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Tag</i>: add a tag to the file
     *         </p>
     *         </li>
     * @see WorkflowStepType
     */
    public final WorkflowStepType stepType() {
        return WorkflowStepType.fromValue(stepType);
    }

    /**
     * <p>
     * One of the available step types.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Copy</i>: copy the file to another location
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Custom</i>: custom step with a lambda target
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Delete</i>: delete the file
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Tag</i>: add a tag to the file
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepType} will
     * return {@link WorkflowStepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stepTypeAsString}.
     * </p>
     * 
     * @return One of the available step types.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Copy</i>: copy the file to another location
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Custom</i>: custom step with a lambda target
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Delete</i>: delete the file
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Tag</i>: add a tag to the file
     *         </p>
     *         </li>
     * @see WorkflowStepType
     */
    public final String stepTypeAsString() {
        return stepType;
    }

    /**
     * <p>
     * The values for the key/value pair applied as a tag to the file. Only applicable if the step type is
     * <code>TAG</code>.
     * </p>
     * 
     * @return The values for the key/value pair applied as a tag to the file. Only applicable if the step type is
     *         <code>TAG</code>.
     */
    public final String outputs() {
        return outputs;
    }

    /**
     * <p>
     * Specifies the details for an error, if it occurred during execution of the specified workfow step.
     * </p>
     * 
     * @return Specifies the details for an error, if it occurred during execution of the specified workfow step.
     */
    public final ExecutionError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputs());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionStepResult)) {
            return false;
        }
        ExecutionStepResult other = (ExecutionStepResult) obj;
        return Objects.equals(stepTypeAsString(), other.stepTypeAsString()) && Objects.equals(outputs(), other.outputs())
                && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionStepResult").add("StepType", stepTypeAsString()).add("Outputs", outputs())
                .add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StepType":
            return Optional.ofNullable(clazz.cast(stepTypeAsString()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionStepResult, T> g) {
        return obj -> g.apply((ExecutionStepResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionStepResult> {
        /**
         * <p>
         * One of the available step types.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Copy</i>: copy the file to another location
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Custom</i>: custom step with a lambda target
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Delete</i>: delete the file
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Tag</i>: add a tag to the file
         * </p>
         * </li>
         * </ul>
         * 
         * @param stepType
         *        One of the available step types.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Copy</i>: copy the file to another location
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Custom</i>: custom step with a lambda target
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Delete</i>: delete the file
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Tag</i>: add a tag to the file
         *        </p>
         *        </li>
         * @see WorkflowStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStepType
         */
        Builder stepType(String stepType);

        /**
         * <p>
         * One of the available step types.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Copy</i>: copy the file to another location
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Custom</i>: custom step with a lambda target
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Delete</i>: delete the file
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Tag</i>: add a tag to the file
         * </p>
         * </li>
         * </ul>
         * 
         * @param stepType
         *        One of the available step types.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Copy</i>: copy the file to another location
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Custom</i>: custom step with a lambda target
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Delete</i>: delete the file
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Tag</i>: add a tag to the file
         *        </p>
         *        </li>
         * @see WorkflowStepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStepType
         */
        Builder stepType(WorkflowStepType stepType);

        /**
         * <p>
         * The values for the key/value pair applied as a tag to the file. Only applicable if the step type is
         * <code>TAG</code>.
         * </p>
         * 
         * @param outputs
         *        The values for the key/value pair applied as a tag to the file. Only applicable if the step type is
         *        <code>TAG</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(String outputs);

        /**
         * <p>
         * Specifies the details for an error, if it occurred during execution of the specified workfow step.
         * </p>
         * 
         * @param error
         *        Specifies the details for an error, if it occurred during execution of the specified workfow step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ExecutionError error);

        /**
         * <p>
         * Specifies the details for an error, if it occurred during execution of the specified workfow step.
         * </p>
         * This is a convenience that creates an instance of the {@link ExecutionError.Builder} avoiding the need to
         * create one manually via {@link ExecutionError#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionError.Builder#build()} is called immediately and its
         * result is passed to {@link #error(ExecutionError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ExecutionError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ExecutionError)
         */
        default Builder error(Consumer<ExecutionError.Builder> error) {
            return error(ExecutionError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stepType;

        private String outputs;

        private ExecutionError error;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionStepResult model) {
            stepType(model.stepType);
            outputs(model.outputs);
            error(model.error);
        }

        public final String getStepType() {
            return stepType;
        }

        public final void setStepType(String stepType) {
            this.stepType = stepType;
        }

        @Override
        @Transient
        public final Builder stepType(String stepType) {
            this.stepType = stepType;
            return this;
        }

        @Override
        @Transient
        public final Builder stepType(WorkflowStepType stepType) {
            this.stepType(stepType == null ? null : stepType.toString());
            return this;
        }

        public final String getOutputs() {
            return outputs;
        }

        public final void setOutputs(String outputs) {
            this.outputs = outputs;
        }

        @Override
        @Transient
        public final Builder outputs(String outputs) {
            this.outputs = outputs;
            return this;
        }

        public final ExecutionError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ExecutionError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        @Transient
        public final Builder error(ExecutionError error) {
            this.error = error;
            return this;
        }

        @Override
        public ExecutionStepResult build() {
            return new ExecutionStepResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
