/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of a security policy that was specified. For more information about security policies, see
 * <a href="https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html">Working with security
 * policies</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribedSecurityPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribedSecurityPolicy.Builder, DescribedSecurityPolicy> {
    private static final SdkField<Boolean> FIPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Fips")
            .getter(getter(DescribedSecurityPolicy::fips)).setter(setter(Builder::fips))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fips").build()).build();

    private static final SdkField<String> SECURITY_POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityPolicyName").getter(getter(DescribedSecurityPolicy::securityPolicyName))
            .setter(setter(Builder::securityPolicyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityPolicyName").build())
            .build();

    private static final SdkField<List<String>> SSH_CIPHERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SshCiphers")
            .getter(getter(DescribedSecurityPolicy::sshCiphers))
            .setter(setter(Builder::sshCiphers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshCiphers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SSH_KEXS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SshKexs")
            .getter(getter(DescribedSecurityPolicy::sshKexs))
            .setter(setter(Builder::sshKexs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshKexs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SSH_MACS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SshMacs")
            .getter(getter(DescribedSecurityPolicy::sshMacs))
            .setter(setter(Builder::sshMacs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshMacs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TLS_CIPHERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TlsCiphers")
            .getter(getter(DescribedSecurityPolicy::tlsCiphers))
            .setter(setter(Builder::tlsCiphers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsCiphers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIPS_FIELD,
            SECURITY_POLICY_NAME_FIELD, SSH_CIPHERS_FIELD, SSH_KEXS_FIELD, SSH_MACS_FIELD, TLS_CIPHERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean fips;

    private final String securityPolicyName;

    private final List<String> sshCiphers;

    private final List<String> sshKexs;

    private final List<String> sshMacs;

    private final List<String> tlsCiphers;

    private DescribedSecurityPolicy(BuilderImpl builder) {
        this.fips = builder.fips;
        this.securityPolicyName = builder.securityPolicyName;
        this.sshCiphers = builder.sshCiphers;
        this.sshKexs = builder.sshKexs;
        this.sshMacs = builder.sshMacs;
        this.tlsCiphers = builder.tlsCiphers;
    }

    /**
     * <p>
     * Specifies whether this policy enables Federal Information Processing Standards (FIPS).
     * </p>
     * 
     * @return Specifies whether this policy enables Federal Information Processing Standards (FIPS).
     */
    public final Boolean fips() {
        return fips;
    }

    /**
     * <p>
     * Specifies the name of the security policy that is attached to the server.
     * </p>
     * 
     * @return Specifies the name of the security policy that is attached to the server.
     */
    public final String securityPolicyName() {
        return securityPolicyName;
    }

    /**
     * For responses, this returns true if the service returned a value for the SshCiphers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSshCiphers() {
        return sshCiphers != null && !(sshCiphers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in the security policy that is attached to
     * the server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSshCiphers} method.
     * </p>
     * 
     * @return Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in the security policy that is
     *         attached to the server.
     */
    public final List<String> sshCiphers() {
        return sshCiphers;
    }

    /**
     * For responses, this returns true if the service returned a value for the SshKexs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSshKexs() {
        return sshKexs != null && !(sshKexs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the enabled SSH key exchange (KEX) encryption algorithms in the security policy that is attached to the
     * server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSshKexs} method.
     * </p>
     * 
     * @return Specifies the enabled SSH key exchange (KEX) encryption algorithms in the security policy that is
     *         attached to the server.
     */
    public final List<String> sshKexs() {
        return sshKexs;
    }

    /**
     * For responses, this returns true if the service returned a value for the SshMacs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSshMacs() {
        return sshMacs != null && !(sshMacs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the enabled SSH message authentication code (MAC) encryption algorithms in the security policy that is
     * attached to the server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSshMacs} method.
     * </p>
     * 
     * @return Specifies the enabled SSH message authentication code (MAC) encryption algorithms in the security policy
     *         that is attached to the server.
     */
    public final List<String> sshMacs() {
        return sshMacs;
    }

    /**
     * For responses, this returns true if the service returned a value for the TlsCiphers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTlsCiphers() {
        return tlsCiphers != null && !(tlsCiphers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the enabled Transport Layer Security (TLS) cipher encryption algorithms in the security policy that is
     * attached to the server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTlsCiphers} method.
     * </p>
     * 
     * @return Specifies the enabled Transport Layer Security (TLS) cipher encryption algorithms in the security policy
     *         that is attached to the server.
     */
    public final List<String> tlsCiphers() {
        return tlsCiphers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fips());
        hashCode = 31 * hashCode + Objects.hashCode(securityPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSshCiphers() ? sshCiphers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSshKexs() ? sshKexs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSshMacs() ? sshMacs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTlsCiphers() ? tlsCiphers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedSecurityPolicy)) {
            return false;
        }
        DescribedSecurityPolicy other = (DescribedSecurityPolicy) obj;
        return Objects.equals(fips(), other.fips()) && Objects.equals(securityPolicyName(), other.securityPolicyName())
                && hasSshCiphers() == other.hasSshCiphers() && Objects.equals(sshCiphers(), other.sshCiphers())
                && hasSshKexs() == other.hasSshKexs() && Objects.equals(sshKexs(), other.sshKexs())
                && hasSshMacs() == other.hasSshMacs() && Objects.equals(sshMacs(), other.sshMacs())
                && hasTlsCiphers() == other.hasTlsCiphers() && Objects.equals(tlsCiphers(), other.tlsCiphers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribedSecurityPolicy").add("Fips", fips()).add("SecurityPolicyName", securityPolicyName())
                .add("SshCiphers", hasSshCiphers() ? sshCiphers() : null).add("SshKexs", hasSshKexs() ? sshKexs() : null)
                .add("SshMacs", hasSshMacs() ? sshMacs() : null).add("TlsCiphers", hasTlsCiphers() ? tlsCiphers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fips":
            return Optional.ofNullable(clazz.cast(fips()));
        case "SecurityPolicyName":
            return Optional.ofNullable(clazz.cast(securityPolicyName()));
        case "SshCiphers":
            return Optional.ofNullable(clazz.cast(sshCiphers()));
        case "SshKexs":
            return Optional.ofNullable(clazz.cast(sshKexs()));
        case "SshMacs":
            return Optional.ofNullable(clazz.cast(sshMacs()));
        case "TlsCiphers":
            return Optional.ofNullable(clazz.cast(tlsCiphers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribedSecurityPolicy, T> g) {
        return obj -> g.apply((DescribedSecurityPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribedSecurityPolicy> {
        /**
         * <p>
         * Specifies whether this policy enables Federal Information Processing Standards (FIPS).
         * </p>
         * 
         * @param fips
         *        Specifies whether this policy enables Federal Information Processing Standards (FIPS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fips(Boolean fips);

        /**
         * <p>
         * Specifies the name of the security policy that is attached to the server.
         * </p>
         * 
         * @param securityPolicyName
         *        Specifies the name of the security policy that is attached to the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityPolicyName(String securityPolicyName);

        /**
         * <p>
         * Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in the security policy that is attached
         * to the server.
         * </p>
         * 
         * @param sshCiphers
         *        Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in the security policy that is
         *        attached to the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshCiphers(Collection<String> sshCiphers);

        /**
         * <p>
         * Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in the security policy that is attached
         * to the server.
         * </p>
         * 
         * @param sshCiphers
         *        Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in the security policy that is
         *        attached to the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshCiphers(String... sshCiphers);

        /**
         * <p>
         * Specifies the enabled SSH key exchange (KEX) encryption algorithms in the security policy that is attached to
         * the server.
         * </p>
         * 
         * @param sshKexs
         *        Specifies the enabled SSH key exchange (KEX) encryption algorithms in the security policy that is
         *        attached to the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshKexs(Collection<String> sshKexs);

        /**
         * <p>
         * Specifies the enabled SSH key exchange (KEX) encryption algorithms in the security policy that is attached to
         * the server.
         * </p>
         * 
         * @param sshKexs
         *        Specifies the enabled SSH key exchange (KEX) encryption algorithms in the security policy that is
         *        attached to the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshKexs(String... sshKexs);

        /**
         * <p>
         * Specifies the enabled SSH message authentication code (MAC) encryption algorithms in the security policy that
         * is attached to the server.
         * </p>
         * 
         * @param sshMacs
         *        Specifies the enabled SSH message authentication code (MAC) encryption algorithms in the security
         *        policy that is attached to the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshMacs(Collection<String> sshMacs);

        /**
         * <p>
         * Specifies the enabled SSH message authentication code (MAC) encryption algorithms in the security policy that
         * is attached to the server.
         * </p>
         * 
         * @param sshMacs
         *        Specifies the enabled SSH message authentication code (MAC) encryption algorithms in the security
         *        policy that is attached to the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshMacs(String... sshMacs);

        /**
         * <p>
         * Specifies the enabled Transport Layer Security (TLS) cipher encryption algorithms in the security policy that
         * is attached to the server.
         * </p>
         * 
         * @param tlsCiphers
         *        Specifies the enabled Transport Layer Security (TLS) cipher encryption algorithms in the security
         *        policy that is attached to the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsCiphers(Collection<String> tlsCiphers);

        /**
         * <p>
         * Specifies the enabled Transport Layer Security (TLS) cipher encryption algorithms in the security policy that
         * is attached to the server.
         * </p>
         * 
         * @param tlsCiphers
         *        Specifies the enabled Transport Layer Security (TLS) cipher encryption algorithms in the security
         *        policy that is attached to the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsCiphers(String... tlsCiphers);
    }

    static final class BuilderImpl implements Builder {
        private Boolean fips;

        private String securityPolicyName;

        private List<String> sshCiphers = DefaultSdkAutoConstructList.getInstance();

        private List<String> sshKexs = DefaultSdkAutoConstructList.getInstance();

        private List<String> sshMacs = DefaultSdkAutoConstructList.getInstance();

        private List<String> tlsCiphers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedSecurityPolicy model) {
            fips(model.fips);
            securityPolicyName(model.securityPolicyName);
            sshCiphers(model.sshCiphers);
            sshKexs(model.sshKexs);
            sshMacs(model.sshMacs);
            tlsCiphers(model.tlsCiphers);
        }

        public final Boolean getFips() {
            return fips;
        }

        public final void setFips(Boolean fips) {
            this.fips = fips;
        }

        @Override
        @Transient
        public final Builder fips(Boolean fips) {
            this.fips = fips;
            return this;
        }

        public final String getSecurityPolicyName() {
            return securityPolicyName;
        }

        public final void setSecurityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
        }

        @Override
        @Transient
        public final Builder securityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
            return this;
        }

        public final Collection<String> getSshCiphers() {
            if (sshCiphers instanceof SdkAutoConstructList) {
                return null;
            }
            return sshCiphers;
        }

        public final void setSshCiphers(Collection<String> sshCiphers) {
            this.sshCiphers = SecurityPolicyOptionsCopier.copy(sshCiphers);
        }

        @Override
        @Transient
        public final Builder sshCiphers(Collection<String> sshCiphers) {
            this.sshCiphers = SecurityPolicyOptionsCopier.copy(sshCiphers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sshCiphers(String... sshCiphers) {
            sshCiphers(Arrays.asList(sshCiphers));
            return this;
        }

        public final Collection<String> getSshKexs() {
            if (sshKexs instanceof SdkAutoConstructList) {
                return null;
            }
            return sshKexs;
        }

        public final void setSshKexs(Collection<String> sshKexs) {
            this.sshKexs = SecurityPolicyOptionsCopier.copy(sshKexs);
        }

        @Override
        @Transient
        public final Builder sshKexs(Collection<String> sshKexs) {
            this.sshKexs = SecurityPolicyOptionsCopier.copy(sshKexs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sshKexs(String... sshKexs) {
            sshKexs(Arrays.asList(sshKexs));
            return this;
        }

        public final Collection<String> getSshMacs() {
            if (sshMacs instanceof SdkAutoConstructList) {
                return null;
            }
            return sshMacs;
        }

        public final void setSshMacs(Collection<String> sshMacs) {
            this.sshMacs = SecurityPolicyOptionsCopier.copy(sshMacs);
        }

        @Override
        @Transient
        public final Builder sshMacs(Collection<String> sshMacs) {
            this.sshMacs = SecurityPolicyOptionsCopier.copy(sshMacs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sshMacs(String... sshMacs) {
            sshMacs(Arrays.asList(sshMacs));
            return this;
        }

        public final Collection<String> getTlsCiphers() {
            if (tlsCiphers instanceof SdkAutoConstructList) {
                return null;
            }
            return tlsCiphers;
        }

        public final void setTlsCiphers(Collection<String> tlsCiphers) {
            this.tlsCiphers = SecurityPolicyOptionsCopier.copy(tlsCiphers);
        }

        @Override
        @Transient
        public final Builder tlsCiphers(Collection<String> tlsCiphers) {
            this.tlsCiphers = SecurityPolicyOptionsCopier.copy(tlsCiphers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tlsCiphers(String... tlsCiphers) {
            tlsCiphers(Arrays.asList(tlsCiphers));
            return this;
        }

        @Override
        public DescribedSecurityPolicy build() {
            return new DescribedSecurityPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
