/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The protocol settings that are configured for your server.
 * </p>
 * <note>
 * <p>
 * This type is only valid in the <code>UpdateServer</code> API.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtocolDetails implements SdkPojo, Serializable, ToCopyableBuilder<ProtocolDetails.Builder, ProtocolDetails> {
    private static final SdkField<String> PASSIVE_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PassiveIp").getter(getter(ProtocolDetails::passiveIp)).setter(setter(Builder::passiveIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PassiveIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PASSIVE_IP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String passiveIp;

    private ProtocolDetails(BuilderImpl builder) {
        this.passiveIp = builder.passiveIp;
    }

    /**
     * <p>
     * Indicates passive mode, for FTP and FTPS protocols. Enter a single dotted-quad IPv4 address, such as the external
     * IP address of a firewall, router, or load balancer. For example:
     * </p>
     * <p>
     * <code> aws transfer update-server --protocol-details PassiveIp=<i>0.0.0.0</i> </code>
     * </p>
     * <p>
     * Replace <code> <i>0.0.0.0</i> </code> in the example above with the actual IP address you want to use.
     * </p>
     * <note>
     * <p>
     * If you change the <code>PassiveIp</code> value, you must stop and then restart your Transfer server for the
     * change to take effect. For details on using Passive IP (PASV) in a NAT environment, see <a href=
     * "http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/"
     * >Configuring your FTPS server behind a firewall or NAT with Amazon Web Services Transfer Family</a>.
     * </p>
     * </note>
     * 
     * @return Indicates passive mode, for FTP and FTPS protocols. Enter a single dotted-quad IPv4 address, such as the
     *         external IP address of a firewall, router, or load balancer. For example: </p>
     *         <p>
     *         <code> aws transfer update-server --protocol-details PassiveIp=<i>0.0.0.0</i> </code>
     *         </p>
     *         <p>
     *         Replace <code> <i>0.0.0.0</i> </code> in the example above with the actual IP address you want to use.
     *         </p>
     *         <note>
     *         <p>
     *         If you change the <code>PassiveIp</code> value, you must stop and then restart your Transfer server for
     *         the change to take effect. For details on using Passive IP (PASV) in a NAT environment, see <a href=
     *         "http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/"
     *         >Configuring your FTPS server behind a firewall or NAT with Amazon Web Services Transfer Family</a>.
     *         </p>
     */
    public final String passiveIp() {
        return passiveIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(passiveIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtocolDetails)) {
            return false;
        }
        ProtocolDetails other = (ProtocolDetails) obj;
        return Objects.equals(passiveIp(), other.passiveIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtocolDetails").add("PassiveIp", passiveIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PassiveIp":
            return Optional.ofNullable(clazz.cast(passiveIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtocolDetails, T> g) {
        return obj -> g.apply((ProtocolDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtocolDetails> {
        /**
         * <p>
         * Indicates passive mode, for FTP and FTPS protocols. Enter a single dotted-quad IPv4 address, such as the
         * external IP address of a firewall, router, or load balancer. For example:
         * </p>
         * <p>
         * <code> aws transfer update-server --protocol-details PassiveIp=<i>0.0.0.0</i> </code>
         * </p>
         * <p>
         * Replace <code> <i>0.0.0.0</i> </code> in the example above with the actual IP address you want to use.
         * </p>
         * <note>
         * <p>
         * If you change the <code>PassiveIp</code> value, you must stop and then restart your Transfer server for the
         * change to take effect. For details on using Passive IP (PASV) in a NAT environment, see <a href=
         * "http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/"
         * >Configuring your FTPS server behind a firewall or NAT with Amazon Web Services Transfer Family</a>.
         * </p>
         * </note>
         * 
         * @param passiveIp
         *        Indicates passive mode, for FTP and FTPS protocols. Enter a single dotted-quad IPv4 address, such as
         *        the external IP address of a firewall, router, or load balancer. For example: </p>
         *        <p>
         *        <code> aws transfer update-server --protocol-details PassiveIp=<i>0.0.0.0</i> </code>
         *        </p>
         *        <p>
         *        Replace <code> <i>0.0.0.0</i> </code> in the example above with the actual IP address you want to use.
         *        </p>
         *        <note>
         *        <p>
         *        If you change the <code>PassiveIp</code> value, you must stop and then restart your Transfer server
         *        for the change to take effect. For details on using Passive IP (PASV) in a NAT environment, see <a
         *        href=
         *        "http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/"
         *        >Configuring your FTPS server behind a firewall or NAT with Amazon Web Services Transfer Family</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passiveIp(String passiveIp);
    }

    static final class BuilderImpl implements Builder {
        private String passiveIp;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtocolDetails model) {
            passiveIp(model.passiveIp);
        }

        public final String getPassiveIp() {
            return passiveIp;
        }

        public final void setPassiveIp(String passiveIp) {
            this.passiveIp = passiveIp;
        }

        @Override
        @Transient
        public final Builder passiveIp(String passiveIp) {
            this.passiveIp = passiveIp;
            return this;
        }

        @Override
        public ProtocolDetails build() {
            return new ProtocolDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
