/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details for an SFTP connector object. The connector object is used for transferring files to and from a
 * partner's SFTP server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SftpConnectorConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SftpConnectorConfig.Builder, SftpConnectorConfig> {
    private static final SdkField<String> USER_SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserSecretId").getter(getter(SftpConnectorConfig::userSecretId)).setter(setter(Builder::userSecretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSecretId").build()).build();

    private static final SdkField<List<String>> TRUSTED_HOST_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TrustedHostKeys")
            .getter(getter(SftpConnectorConfig::trustedHostKeys))
            .setter(setter(Builder::trustedHostKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedHostKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_SECRET_ID_FIELD,
            TRUSTED_HOST_KEYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userSecretId;

    private final List<String> trustedHostKeys;

    private SftpConnectorConfig(BuilderImpl builder) {
        this.userSecretId = builder.userSecretId;
        this.trustedHostKeys = builder.trustedHostKeys;
    }

    /**
     * <p>
     * The identifier for the secret (in Amazon Web Services Secrets Manager) that contains the SFTP user's private key,
     * password, or both. The identifier can be either the Amazon Resource Name (ARN) or the name of the secret.
     * </p>
     * 
     * @return The identifier for the secret (in Amazon Web Services Secrets Manager) that contains the SFTP user's
     *         private key, password, or both. The identifier can be either the Amazon Resource Name (ARN) or the name
     *         of the secret.
     */
    public final String userSecretId() {
        return userSecretId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrustedHostKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrustedHostKeys() {
        return trustedHostKeys != null && !(trustedHostKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The public portion of the host key, or keys, that are used to authenticate the user to the external server to
     * which you are connecting. You can use the <code>ssh-keyscan</code> command against the SFTP server to retrieve
     * the necessary key.
     * </p>
     * <p>
     * The three standard SSH public key format elements are <code>&lt;key type&gt;</code>,
     * <code>&lt;body base64&gt;</code>, and an optional <code>&lt;comment&gt;</code>, with spaces between each element.
     * Specify only the <code>&lt;key type&gt;</code> and <code>&lt;body base64&gt;</code>: do not enter the
     * <code>&lt;comment&gt;</code> portion of the key.
     * </p>
     * <p>
     * For the trusted host key, Transfer Family accepts RSA and ECDSA keys.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For RSA keys, the key type is <code>ssh-rsa</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For ECDSA keys, the key type is either <code>ecdsa-sha2-nistp256</code>, <code>ecdsa-sha2-nistp384</code>, or
     * <code>ecdsa-sha2-nistp521</code>, depending on the size of the key you generated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrustedHostKeys} method.
     * </p>
     * 
     * @return The public portion of the host key, or keys, that are used to authenticate the user to the external
     *         server to which you are connecting. You can use the <code>ssh-keyscan</code> command against the SFTP
     *         server to retrieve the necessary key.</p>
     *         <p>
     *         The three standard SSH public key format elements are <code>&lt;key type&gt;</code>,
     *         <code>&lt;body base64&gt;</code>, and an optional <code>&lt;comment&gt;</code>, with spaces between each
     *         element. Specify only the <code>&lt;key type&gt;</code> and <code>&lt;body base64&gt;</code>: do not
     *         enter the <code>&lt;comment&gt;</code> portion of the key.
     *         </p>
     *         <p>
     *         For the trusted host key, Transfer Family accepts RSA and ECDSA keys.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For RSA keys, the key type is <code>ssh-rsa</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For ECDSA keys, the key type is either <code>ecdsa-sha2-nistp256</code>, <code>ecdsa-sha2-nistp384</code>
     *         , or <code>ecdsa-sha2-nistp521</code>, depending on the size of the key you generated.
     *         </p>
     *         </li>
     */
    public final List<String> trustedHostKeys() {
        return trustedHostKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrustedHostKeys() ? trustedHostKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SftpConnectorConfig)) {
            return false;
        }
        SftpConnectorConfig other = (SftpConnectorConfig) obj;
        return Objects.equals(userSecretId(), other.userSecretId()) && hasTrustedHostKeys() == other.hasTrustedHostKeys()
                && Objects.equals(trustedHostKeys(), other.trustedHostKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SftpConnectorConfig").add("UserSecretId", userSecretId())
                .add("TrustedHostKeys", hasTrustedHostKeys() ? trustedHostKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserSecretId":
            return Optional.ofNullable(clazz.cast(userSecretId()));
        case "TrustedHostKeys":
            return Optional.ofNullable(clazz.cast(trustedHostKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SftpConnectorConfig, T> g) {
        return obj -> g.apply((SftpConnectorConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SftpConnectorConfig> {
        /**
         * <p>
         * The identifier for the secret (in Amazon Web Services Secrets Manager) that contains the SFTP user's private
         * key, password, or both. The identifier can be either the Amazon Resource Name (ARN) or the name of the
         * secret.
         * </p>
         * 
         * @param userSecretId
         *        The identifier for the secret (in Amazon Web Services Secrets Manager) that contains the SFTP user's
         *        private key, password, or both. The identifier can be either the Amazon Resource Name (ARN) or the
         *        name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSecretId(String userSecretId);

        /**
         * <p>
         * The public portion of the host key, or keys, that are used to authenticate the user to the external server to
         * which you are connecting. You can use the <code>ssh-keyscan</code> command against the SFTP server to
         * retrieve the necessary key.
         * </p>
         * <p>
         * The three standard SSH public key format elements are <code>&lt;key type&gt;</code>,
         * <code>&lt;body base64&gt;</code>, and an optional <code>&lt;comment&gt;</code>, with spaces between each
         * element. Specify only the <code>&lt;key type&gt;</code> and <code>&lt;body base64&gt;</code>: do not enter
         * the <code>&lt;comment&gt;</code> portion of the key.
         * </p>
         * <p>
         * For the trusted host key, Transfer Family accepts RSA and ECDSA keys.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For RSA keys, the key type is <code>ssh-rsa</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For ECDSA keys, the key type is either <code>ecdsa-sha2-nistp256</code>, <code>ecdsa-sha2-nistp384</code>, or
         * <code>ecdsa-sha2-nistp521</code>, depending on the size of the key you generated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param trustedHostKeys
         *        The public portion of the host key, or keys, that are used to authenticate the user to the external
         *        server to which you are connecting. You can use the <code>ssh-keyscan</code> command against the SFTP
         *        server to retrieve the necessary key.</p>
         *        <p>
         *        The three standard SSH public key format elements are <code>&lt;key type&gt;</code>,
         *        <code>&lt;body base64&gt;</code>, and an optional <code>&lt;comment&gt;</code>, with spaces between
         *        each element. Specify only the <code>&lt;key type&gt;</code> and <code>&lt;body base64&gt;</code>: do
         *        not enter the <code>&lt;comment&gt;</code> portion of the key.
         *        </p>
         *        <p>
         *        For the trusted host key, Transfer Family accepts RSA and ECDSA keys.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For RSA keys, the key type is <code>ssh-rsa</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For ECDSA keys, the key type is either <code>ecdsa-sha2-nistp256</code>,
         *        <code>ecdsa-sha2-nistp384</code>, or <code>ecdsa-sha2-nistp521</code>, depending on the size of the
         *        key you generated.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedHostKeys(Collection<String> trustedHostKeys);

        /**
         * <p>
         * The public portion of the host key, or keys, that are used to authenticate the user to the external server to
         * which you are connecting. You can use the <code>ssh-keyscan</code> command against the SFTP server to
         * retrieve the necessary key.
         * </p>
         * <p>
         * The three standard SSH public key format elements are <code>&lt;key type&gt;</code>,
         * <code>&lt;body base64&gt;</code>, and an optional <code>&lt;comment&gt;</code>, with spaces between each
         * element. Specify only the <code>&lt;key type&gt;</code> and <code>&lt;body base64&gt;</code>: do not enter
         * the <code>&lt;comment&gt;</code> portion of the key.
         * </p>
         * <p>
         * For the trusted host key, Transfer Family accepts RSA and ECDSA keys.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For RSA keys, the key type is <code>ssh-rsa</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For ECDSA keys, the key type is either <code>ecdsa-sha2-nistp256</code>, <code>ecdsa-sha2-nistp384</code>, or
         * <code>ecdsa-sha2-nistp521</code>, depending on the size of the key you generated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param trustedHostKeys
         *        The public portion of the host key, or keys, that are used to authenticate the user to the external
         *        server to which you are connecting. You can use the <code>ssh-keyscan</code> command against the SFTP
         *        server to retrieve the necessary key.</p>
         *        <p>
         *        The three standard SSH public key format elements are <code>&lt;key type&gt;</code>,
         *        <code>&lt;body base64&gt;</code>, and an optional <code>&lt;comment&gt;</code>, with spaces between
         *        each element. Specify only the <code>&lt;key type&gt;</code> and <code>&lt;body base64&gt;</code>: do
         *        not enter the <code>&lt;comment&gt;</code> portion of the key.
         *        </p>
         *        <p>
         *        For the trusted host key, Transfer Family accepts RSA and ECDSA keys.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For RSA keys, the key type is <code>ssh-rsa</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For ECDSA keys, the key type is either <code>ecdsa-sha2-nistp256</code>,
         *        <code>ecdsa-sha2-nistp384</code>, or <code>ecdsa-sha2-nistp521</code>, depending on the size of the
         *        key you generated.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedHostKeys(String... trustedHostKeys);
    }

    static final class BuilderImpl implements Builder {
        private String userSecretId;

        private List<String> trustedHostKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SftpConnectorConfig model) {
            userSecretId(model.userSecretId);
            trustedHostKeys(model.trustedHostKeys);
        }

        public final String getUserSecretId() {
            return userSecretId;
        }

        public final void setUserSecretId(String userSecretId) {
            this.userSecretId = userSecretId;
        }

        @Override
        public final Builder userSecretId(String userSecretId) {
            this.userSecretId = userSecretId;
            return this;
        }

        public final Collection<String> getTrustedHostKeys() {
            if (trustedHostKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return trustedHostKeys;
        }

        public final void setTrustedHostKeys(Collection<String> trustedHostKeys) {
            this.trustedHostKeys = SftpConnectorTrustedHostKeyListCopier.copy(trustedHostKeys);
        }

        @Override
        public final Builder trustedHostKeys(Collection<String> trustedHostKeys) {
            this.trustedHostKeys = SftpConnectorTrustedHostKeyListCopier.copy(trustedHostKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustedHostKeys(String... trustedHostKeys) {
            trustedHostKeys(Arrays.asList(trustedHostKeys));
            return this;
        }

        @Override
        public SftpConnectorConfig build() {
            return new SftpConnectorConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
