/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of a certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedCertificate implements SdkPojo, Serializable,
        ToCopyableBuilder<ListedCertificate.Builder, ListedCertificate> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ListedCertificate::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateId").getter(getter(ListedCertificate::certificateId)).setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()).build();

    private static final SdkField<String> USAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Usage")
            .getter(getter(ListedCertificate::usageAsString)).setter(setter(Builder::usage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Usage").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListedCertificate::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> ACTIVE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ActiveDate").getter(getter(ListedCertificate::activeDate)).setter(setter(Builder::activeDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDate").build()).build();

    private static final SdkField<Instant> INACTIVE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InactiveDate").getter(getter(ListedCertificate::inactiveDate)).setter(setter(Builder::inactiveDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InactiveDate").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ListedCertificate::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ListedCertificate::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CERTIFICATE_ID_FIELD, USAGE_FIELD, STATUS_FIELD, ACTIVE_DATE_FIELD, INACTIVE_DATE_FIELD, TYPE_FIELD,
            DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String certificateId;

    private final String usage;

    private final String status;

    private final Instant activeDate;

    private final Instant inactiveDate;

    private final String type;

    private final String description;

    private ListedCertificate(BuilderImpl builder) {
        this.arn = builder.arn;
        this.certificateId = builder.certificateId;
        this.usage = builder.usage;
        this.status = builder.status;
        this.activeDate = builder.activeDate;
        this.inactiveDate = builder.inactiveDate;
        this.type = builder.type;
        this.description = builder.description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the specified certificate.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the specified certificate.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * An array of identifiers for the imported certificates. You use this identifier for working with profiles and
     * partner profiles.
     * </p>
     * 
     * @return An array of identifiers for the imported certificates. You use this identifier for working with profiles
     *         and partner profiles.
     */
    public final String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * Specifies whether this certificate is used for signing or encryption.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usage} will return
     * {@link CertificateUsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageAsString}.
     * </p>
     * 
     * @return Specifies whether this certificate is used for signing or encryption.
     * @see CertificateUsageType
     */
    public final CertificateUsageType usage() {
        return CertificateUsageType.fromValue(usage);
    }

    /**
     * <p>
     * Specifies whether this certificate is used for signing or encryption.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usage} will return
     * {@link CertificateUsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageAsString}.
     * </p>
     * 
     * @return Specifies whether this certificate is used for signing or encryption.
     * @see CertificateUsageType
     */
    public final String usageAsString() {
        return usage;
    }

    /**
     * <p>
     * The certificate can be either <code>ACTIVE</code>, <code>PENDING_ROTATION</code>, or <code>INACTIVE</code>.
     * <code>PENDING_ROTATION</code> means that this certificate will replace the current certificate when it expires.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The certificate can be either <code>ACTIVE</code>, <code>PENDING_ROTATION</code>, or
     *         <code>INACTIVE</code>. <code>PENDING_ROTATION</code> means that this certificate will replace the current
     *         certificate when it expires.
     * @see CertificateStatusType
     */
    public final CertificateStatusType status() {
        return CertificateStatusType.fromValue(status);
    }

    /**
     * <p>
     * The certificate can be either <code>ACTIVE</code>, <code>PENDING_ROTATION</code>, or <code>INACTIVE</code>.
     * <code>PENDING_ROTATION</code> means that this certificate will replace the current certificate when it expires.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The certificate can be either <code>ACTIVE</code>, <code>PENDING_ROTATION</code>, or
     *         <code>INACTIVE</code>. <code>PENDING_ROTATION</code> means that this certificate will replace the current
     *         certificate when it expires.
     * @see CertificateStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An optional date that specifies when the certificate becomes active.
     * </p>
     * 
     * @return An optional date that specifies when the certificate becomes active.
     */
    public final Instant activeDate() {
        return activeDate;
    }

    /**
     * <p>
     * An optional date that specifies when the certificate becomes inactive.
     * </p>
     * 
     * @return An optional date that specifies when the certificate becomes inactive.
     */
    public final Instant inactiveDate() {
        return inactiveDate;
    }

    /**
     * <p>
     * The type for the certificate. If a private key has been specified for the certificate, its type is
     * <code>CERTIFICATE_WITH_PRIVATE_KEY</code>. If there is no private key, the type is <code>CERTIFICATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CertificateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type for the certificate. If a private key has been specified for the certificate, its type is
     *         <code>CERTIFICATE_WITH_PRIVATE_KEY</code>. If there is no private key, the type is
     *         <code>CERTIFICATE</code>.
     * @see CertificateType
     */
    public final CertificateType type() {
        return CertificateType.fromValue(type);
    }

    /**
     * <p>
     * The type for the certificate. If a private key has been specified for the certificate, its type is
     * <code>CERTIFICATE_WITH_PRIVATE_KEY</code>. If there is no private key, the type is <code>CERTIFICATE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CertificateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type for the certificate. If a private key has been specified for the certificate, its type is
     *         <code>CERTIFICATE_WITH_PRIVATE_KEY</code>. If there is no private key, the type is
     *         <code>CERTIFICATE</code>.
     * @see CertificateType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name or short description that's used to identify the certificate.
     * </p>
     * 
     * @return The name or short description that's used to identify the certificate.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(usageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(activeDate());
        hashCode = 31 * hashCode + Objects.hashCode(inactiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedCertificate)) {
            return false;
        }
        ListedCertificate other = (ListedCertificate) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(usageAsString(), other.usageAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(activeDate(), other.activeDate())
                && Objects.equals(inactiveDate(), other.inactiveDate()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListedCertificate").add("Arn", arn()).add("CertificateId", certificateId())
                .add("Usage", usageAsString()).add("Status", statusAsString()).add("ActiveDate", activeDate())
                .add("InactiveDate", inactiveDate()).add("Type", typeAsString()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CertificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "Usage":
            return Optional.ofNullable(clazz.cast(usageAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ActiveDate":
            return Optional.ofNullable(clazz.cast(activeDate()));
        case "InactiveDate":
            return Optional.ofNullable(clazz.cast(inactiveDate()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListedCertificate, T> g) {
        return obj -> g.apply((ListedCertificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedCertificate> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the specified certificate.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the specified certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * An array of identifiers for the imported certificates. You use this identifier for working with profiles and
         * partner profiles.
         * </p>
         * 
         * @param certificateId
         *        An array of identifiers for the imported certificates. You use this identifier for working with
         *        profiles and partner profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * Specifies whether this certificate is used for signing or encryption.
         * </p>
         * 
         * @param usage
         *        Specifies whether this certificate is used for signing or encryption.
         * @see CertificateUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateUsageType
         */
        Builder usage(String usage);

        /**
         * <p>
         * Specifies whether this certificate is used for signing or encryption.
         * </p>
         * 
         * @param usage
         *        Specifies whether this certificate is used for signing or encryption.
         * @see CertificateUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateUsageType
         */
        Builder usage(CertificateUsageType usage);

        /**
         * <p>
         * The certificate can be either <code>ACTIVE</code>, <code>PENDING_ROTATION</code>, or <code>INACTIVE</code>.
         * <code>PENDING_ROTATION</code> means that this certificate will replace the current certificate when it
         * expires.
         * </p>
         * 
         * @param status
         *        The certificate can be either <code>ACTIVE</code>, <code>PENDING_ROTATION</code>, or
         *        <code>INACTIVE</code>. <code>PENDING_ROTATION</code> means that this certificate will replace the
         *        current certificate when it expires.
         * @see CertificateStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The certificate can be either <code>ACTIVE</code>, <code>PENDING_ROTATION</code>, or <code>INACTIVE</code>.
         * <code>PENDING_ROTATION</code> means that this certificate will replace the current certificate when it
         * expires.
         * </p>
         * 
         * @param status
         *        The certificate can be either <code>ACTIVE</code>, <code>PENDING_ROTATION</code>, or
         *        <code>INACTIVE</code>. <code>PENDING_ROTATION</code> means that this certificate will replace the
         *        current certificate when it expires.
         * @see CertificateStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatusType
         */
        Builder status(CertificateStatusType status);

        /**
         * <p>
         * An optional date that specifies when the certificate becomes active.
         * </p>
         * 
         * @param activeDate
         *        An optional date that specifies when the certificate becomes active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDate(Instant activeDate);

        /**
         * <p>
         * An optional date that specifies when the certificate becomes inactive.
         * </p>
         * 
         * @param inactiveDate
         *        An optional date that specifies when the certificate becomes inactive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inactiveDate(Instant inactiveDate);

        /**
         * <p>
         * The type for the certificate. If a private key has been specified for the certificate, its type is
         * <code>CERTIFICATE_WITH_PRIVATE_KEY</code>. If there is no private key, the type is <code>CERTIFICATE</code>.
         * </p>
         * 
         * @param type
         *        The type for the certificate. If a private key has been specified for the certificate, its type is
         *        <code>CERTIFICATE_WITH_PRIVATE_KEY</code>. If there is no private key, the type is
         *        <code>CERTIFICATE</code>.
         * @see CertificateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateType
         */
        Builder type(String type);

        /**
         * <p>
         * The type for the certificate. If a private key has been specified for the certificate, its type is
         * <code>CERTIFICATE_WITH_PRIVATE_KEY</code>. If there is no private key, the type is <code>CERTIFICATE</code>.
         * </p>
         * 
         * @param type
         *        The type for the certificate. If a private key has been specified for the certificate, its type is
         *        <code>CERTIFICATE_WITH_PRIVATE_KEY</code>. If there is no private key, the type is
         *        <code>CERTIFICATE</code>.
         * @see CertificateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateType
         */
        Builder type(CertificateType type);

        /**
         * <p>
         * The name or short description that's used to identify the certificate.
         * </p>
         * 
         * @param description
         *        The name or short description that's used to identify the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String certificateId;

        private String usage;

        private String status;

        private Instant activeDate;

        private Instant inactiveDate;

        private String type;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedCertificate model) {
            arn(model.arn);
            certificateId(model.certificateId);
            usage(model.usage);
            status(model.status);
            activeDate(model.activeDate);
            inactiveDate(model.inactiveDate);
            type(model.type);
            description(model.description);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final String getUsage() {
            return usage;
        }

        public final void setUsage(String usage) {
            this.usage = usage;
        }

        @Override
        public final Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public final Builder usage(CertificateUsageType usage) {
            this.usage(usage == null ? null : usage.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getActiveDate() {
            return activeDate;
        }

        public final void setActiveDate(Instant activeDate) {
            this.activeDate = activeDate;
        }

        @Override
        public final Builder activeDate(Instant activeDate) {
            this.activeDate = activeDate;
            return this;
        }

        public final Instant getInactiveDate() {
            return inactiveDate;
        }

        public final void setInactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
        }

        @Override
        public final Builder inactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public ListedCertificate build() {
            return new ListedCertificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
