/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartFileTransferResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, StartFileTransferResponse> {
    private static final SdkField<String> TRANSFER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransferId").getter(StartFileTransferResponse.getter(StartFileTransferResponse::transferId)).setter(StartFileTransferResponse.setter(Builder::transferId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFER_ID_FIELD));
    private final String transferId;

    private StartFileTransferResponse(BuilderImpl builder) {
        super(builder);
        this.transferId = builder.transferId;
    }

    public final String transferId() {
        return this.transferId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transferId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFileTransferResponse)) {
            return false;
        }
        StartFileTransferResponse other = (StartFileTransferResponse)((Object)obj);
        return Objects.equals(this.transferId(), other.transferId());
    }

    public final String toString() {
        return ToString.builder((String)"StartFileTransferResponse").add("TransferId", (Object)this.transferId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransferId": {
                return Optional.ofNullable(clazz.cast(this.transferId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartFileTransferResponse, T> g) {
        return obj -> g.apply((StartFileTransferResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String transferId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartFileTransferResponse model) {
            super(model);
            this.transferId(model.transferId);
        }

        public final String getTransferId() {
            return this.transferId;
        }

        public final void setTransferId(String transferId) {
            this.transferId = transferId;
        }

        @Override
        public final Builder transferId(String transferId) {
            this.transferId = transferId;
            return this;
        }

        @Override
        public StartFileTransferResponse build() {
            return new StartFileTransferResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartFileTransferResponse> {
        public Builder transferId(String var1);
    }
}

