/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAgreementRequest extends TransferRequest implements
        ToCopyableBuilder<UpdateAgreementRequest.Builder, UpdateAgreementRequest> {
    private static final SdkField<String> AGREEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgreementId").getter(getter(UpdateAgreementRequest::agreementId)).setter(setter(Builder::agreementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgreementId").build()).build();

    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerId").getter(getter(UpdateAgreementRequest::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateAgreementRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateAgreementRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> LOCAL_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocalProfileId").getter(getter(UpdateAgreementRequest::localProfileId))
            .setter(setter(Builder::localProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalProfileId").build()).build();

    private static final SdkField<String> PARTNER_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartnerProfileId").getter(getter(UpdateAgreementRequest::partnerProfileId))
            .setter(setter(Builder::partnerProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerProfileId").build()).build();

    private static final SdkField<String> BASE_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseDirectory").getter(getter(UpdateAgreementRequest::baseDirectory))
            .setter(setter(Builder::baseDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseDirectory").build()).build();

    private static final SdkField<String> ACCESS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessRole").getter(getter(UpdateAgreementRequest::accessRole)).setter(setter(Builder::accessRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGREEMENT_ID_FIELD,
            SERVER_ID_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, LOCAL_PROFILE_ID_FIELD, PARTNER_PROFILE_ID_FIELD,
            BASE_DIRECTORY_FIELD, ACCESS_ROLE_FIELD));

    private final String agreementId;

    private final String serverId;

    private final String description;

    private final String status;

    private final String localProfileId;

    private final String partnerProfileId;

    private final String baseDirectory;

    private final String accessRole;

    private UpdateAgreementRequest(BuilderImpl builder) {
        super(builder);
        this.agreementId = builder.agreementId;
        this.serverId = builder.serverId;
        this.description = builder.description;
        this.status = builder.status;
        this.localProfileId = builder.localProfileId;
        this.partnerProfileId = builder.partnerProfileId;
        this.baseDirectory = builder.baseDirectory;
        this.accessRole = builder.accessRole;
    }

    /**
     * <p>
     * A unique identifier for the agreement. This identifier is returned when you create an agreement.
     * </p>
     * 
     * @return A unique identifier for the agreement. This identifier is returned when you create an agreement.
     */
    public final String agreementId() {
        return agreementId;
    }

    /**
     * <p>
     * A system-assigned unique identifier for a server instance. This is the specific server that the agreement uses.
     * </p>
     * 
     * @return A system-assigned unique identifier for a server instance. This is the specific server that the agreement
     *         uses.
     */
    public final String serverId() {
        return serverId;
    }

    /**
     * <p>
     * To replace the existing description, provide a short description for the agreement.
     * </p>
     * 
     * @return To replace the existing description, provide a short description for the agreement.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * You can update the status for the agreement, either activating an inactive agreement or the reverse.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgreementStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return You can update the status for the agreement, either activating an inactive agreement or the reverse.
     * @see AgreementStatusType
     */
    public final AgreementStatusType status() {
        return AgreementStatusType.fromValue(status);
    }

    /**
     * <p>
     * You can update the status for the agreement, either activating an inactive agreement or the reverse.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgreementStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return You can update the status for the agreement, either activating an inactive agreement or the reverse.
     * @see AgreementStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A unique identifier for the AS2 local profile.
     * </p>
     * <p>
     * To change the local profile identifier, provide a new value here.
     * </p>
     * 
     * @return A unique identifier for the AS2 local profile.</p>
     *         <p>
     *         To change the local profile identifier, provide a new value here.
     */
    public final String localProfileId() {
        return localProfileId;
    }

    /**
     * <p>
     * A unique identifier for the partner profile. To change the partner profile identifier, provide a new value here.
     * </p>
     * 
     * @return A unique identifier for the partner profile. To change the partner profile identifier, provide a new
     *         value here.
     */
    public final String partnerProfileId() {
        return partnerProfileId;
    }

    /**
     * <p>
     * To change the landing directory (folder) for files that are transferred, provide the bucket folder that you want
     * to use; for example, <code>/<i>DOC-EXAMPLE-BUCKET</i>/<i>home</i>/<i>mydirectory</i> </code>.
     * </p>
     * 
     * @return To change the landing directory (folder) for files that are transferred, provide the bucket folder that
     *         you want to use; for example, <code>/<i>DOC-EXAMPLE-BUCKET</i>/<i>home</i>/<i>mydirectory</i> </code>.
     */
    public final String baseDirectory() {
        return baseDirectory;
    }

    /**
     * <p>
     * Connectors are used to send files using either the AS2 or SFTP protocol. For the access role, provide the Amazon
     * Resource Name (ARN) of the Identity and Access Management role to use.
     * </p>
     * <p>
     * <b>For AS2 connectors</b>
     * </p>
     * <p>
     * With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths in the
     * request parameter, <code>SendFilePaths</code>. We use the file’s parent directory (for example, for
     * <code>--send-file-paths /bucket/dir/file.txt</code>, parent directory is <code>/bucket/dir/</code>) to
     * temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a
     * final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code> needs to
     * provide read and write access to the parent directory of the file location used in the
     * <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent
     * directory of the files that you intend to send with <code>StartFileTransfer</code>.
     * </p>
     * <p>
     * If you are using Basic authentication for your AS2 connector, the access role requires the
     * <code>secretsmanager:GetSecretValue</code> permission for the secret. If the secret is encrypted using a
     * customer-managed key instead of the Amazon Web Services managed key in Secrets Manager, then the role also needs
     * the <code>kms:Decrypt</code> permission for that key.
     * </p>
     * <p>
     * <b>For SFTP connectors</b>
     * </p>
     * <p>
     * Make sure that the access role provides read and write access to the parent directory of the file location that's
     * used in the <code>StartFileTransfer</code> request. Additionally, make sure that the role provides
     * <code>secretsmanager:GetSecretValue</code> permission to Secrets Manager.
     * </p>
     * 
     * @return Connectors are used to send files using either the AS2 or SFTP protocol. For the access role, provide the
     *         Amazon Resource Name (ARN) of the Identity and Access Management role to use.</p>
     *         <p>
     *         <b>For AS2 connectors</b>
     *         </p>
     *         <p>
     *         With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths in
     *         the request parameter, <code>SendFilePaths</code>. We use the file’s parent directory (for example, for
     *         <code>--send-file-paths /bucket/dir/file.txt</code>, parent directory is <code>/bucket/dir/</code>) to
     *         temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and
     *         write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code>
     *         needs to provide read and write access to the parent directory of the file location used in the
     *         <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the
     *         parent directory of the files that you intend to send with <code>StartFileTransfer</code>.
     *         </p>
     *         <p>
     *         If you are using Basic authentication for your AS2 connector, the access role requires the
     *         <code>secretsmanager:GetSecretValue</code> permission for the secret. If the secret is encrypted using a
     *         customer-managed key instead of the Amazon Web Services managed key in Secrets Manager, then the role
     *         also needs the <code>kms:Decrypt</code> permission for that key.
     *         </p>
     *         <p>
     *         <b>For SFTP connectors</b>
     *         </p>
     *         <p>
     *         Make sure that the access role provides read and write access to the parent directory of the file
     *         location that's used in the <code>StartFileTransfer</code> request. Additionally, make sure that the role
     *         provides <code>secretsmanager:GetSecretValue</code> permission to Secrets Manager.
     */
    public final String accessRole() {
        return accessRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agreementId());
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(localProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(partnerProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(baseDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(accessRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgreementRequest)) {
            return false;
        }
        UpdateAgreementRequest other = (UpdateAgreementRequest) obj;
        return Objects.equals(agreementId(), other.agreementId()) && Objects.equals(serverId(), other.serverId())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(localProfileId(), other.localProfileId())
                && Objects.equals(partnerProfileId(), other.partnerProfileId())
                && Objects.equals(baseDirectory(), other.baseDirectory()) && Objects.equals(accessRole(), other.accessRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAgreementRequest").add("AgreementId", agreementId()).add("ServerId", serverId())
                .add("Description", description()).add("Status", statusAsString()).add("LocalProfileId", localProfileId())
                .add("PartnerProfileId", partnerProfileId()).add("BaseDirectory", baseDirectory())
                .add("AccessRole", accessRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgreementId":
            return Optional.ofNullable(clazz.cast(agreementId()));
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LocalProfileId":
            return Optional.ofNullable(clazz.cast(localProfileId()));
        case "PartnerProfileId":
            return Optional.ofNullable(clazz.cast(partnerProfileId()));
        case "BaseDirectory":
            return Optional.ofNullable(clazz.cast(baseDirectory()));
        case "AccessRole":
            return Optional.ofNullable(clazz.cast(accessRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgreementRequest, T> g) {
        return obj -> g.apply((UpdateAgreementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAgreementRequest> {
        /**
         * <p>
         * A unique identifier for the agreement. This identifier is returned when you create an agreement.
         * </p>
         * 
         * @param agreementId
         *        A unique identifier for the agreement. This identifier is returned when you create an agreement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementId(String agreementId);

        /**
         * <p>
         * A system-assigned unique identifier for a server instance. This is the specific server that the agreement
         * uses.
         * </p>
         * 
         * @param serverId
         *        A system-assigned unique identifier for a server instance. This is the specific server that the
         *        agreement uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * To replace the existing description, provide a short description for the agreement.
         * </p>
         * 
         * @param description
         *        To replace the existing description, provide a short description for the agreement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * You can update the status for the agreement, either activating an inactive agreement or the reverse.
         * </p>
         * 
         * @param status
         *        You can update the status for the agreement, either activating an inactive agreement or the reverse.
         * @see AgreementStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgreementStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * You can update the status for the agreement, either activating an inactive agreement or the reverse.
         * </p>
         * 
         * @param status
         *        You can update the status for the agreement, either activating an inactive agreement or the reverse.
         * @see AgreementStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgreementStatusType
         */
        Builder status(AgreementStatusType status);

        /**
         * <p>
         * A unique identifier for the AS2 local profile.
         * </p>
         * <p>
         * To change the local profile identifier, provide a new value here.
         * </p>
         * 
         * @param localProfileId
         *        A unique identifier for the AS2 local profile.</p>
         *        <p>
         *        To change the local profile identifier, provide a new value here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localProfileId(String localProfileId);

        /**
         * <p>
         * A unique identifier for the partner profile. To change the partner profile identifier, provide a new value
         * here.
         * </p>
         * 
         * @param partnerProfileId
         *        A unique identifier for the partner profile. To change the partner profile identifier, provide a new
         *        value here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerProfileId(String partnerProfileId);

        /**
         * <p>
         * To change the landing directory (folder) for files that are transferred, provide the bucket folder that you
         * want to use; for example, <code>/<i>DOC-EXAMPLE-BUCKET</i>/<i>home</i>/<i>mydirectory</i> </code>.
         * </p>
         * 
         * @param baseDirectory
         *        To change the landing directory (folder) for files that are transferred, provide the bucket folder
         *        that you want to use; for example,
         *        <code>/<i>DOC-EXAMPLE-BUCKET</i>/<i>home</i>/<i>mydirectory</i> </code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseDirectory(String baseDirectory);

        /**
         * <p>
         * Connectors are used to send files using either the AS2 or SFTP protocol. For the access role, provide the
         * Amazon Resource Name (ARN) of the Identity and Access Management role to use.
         * </p>
         * <p>
         * <b>For AS2 connectors</b>
         * </p>
         * <p>
         * With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths in the
         * request parameter, <code>SendFilePaths</code>. We use the file’s parent directory (for example, for
         * <code>--send-file-paths /bucket/dir/file.txt</code>, parent directory is <code>/bucket/dir/</code>) to
         * temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and
         * write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code>
         * needs to provide read and write access to the parent directory of the file location used in the
         * <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent
         * directory of the files that you intend to send with <code>StartFileTransfer</code>.
         * </p>
         * <p>
         * If you are using Basic authentication for your AS2 connector, the access role requires the
         * <code>secretsmanager:GetSecretValue</code> permission for the secret. If the secret is encrypted using a
         * customer-managed key instead of the Amazon Web Services managed key in Secrets Manager, then the role also
         * needs the <code>kms:Decrypt</code> permission for that key.
         * </p>
         * <p>
         * <b>For SFTP connectors</b>
         * </p>
         * <p>
         * Make sure that the access role provides read and write access to the parent directory of the file location
         * that's used in the <code>StartFileTransfer</code> request. Additionally, make sure that the role provides
         * <code>secretsmanager:GetSecretValue</code> permission to Secrets Manager.
         * </p>
         * 
         * @param accessRole
         *        Connectors are used to send files using either the AS2 or SFTP protocol. For the access role, provide
         *        the Amazon Resource Name (ARN) of the Identity and Access Management role to use.</p>
         *        <p>
         *        <b>For AS2 connectors</b>
         *        </p>
         *        <p>
         *        With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths
         *        in the request parameter, <code>SendFilePaths</code>. We use the file’s parent directory (for example,
         *        for <code>--send-file-paths /bucket/dir/file.txt</code>, parent directory is <code>/bucket/dir/</code>
         *        ) to temporarily store a processed AS2 message file, store the MDN when we receive them from the
         *        partner, and write a final JSON file containing relevant metadata of the transmission. So, the
         *        <code>AccessRole</code> needs to provide read and write access to the parent directory of the file
         *        location used in the <code>StartFileTransfer</code> request. Additionally, you need to provide read
         *        and write access to the parent directory of the files that you intend to send with
         *        <code>StartFileTransfer</code>.
         *        </p>
         *        <p>
         *        If you are using Basic authentication for your AS2 connector, the access role requires the
         *        <code>secretsmanager:GetSecretValue</code> permission for the secret. If the secret is encrypted using
         *        a customer-managed key instead of the Amazon Web Services managed key in Secrets Manager, then the
         *        role also needs the <code>kms:Decrypt</code> permission for that key.
         *        </p>
         *        <p>
         *        <b>For SFTP connectors</b>
         *        </p>
         *        <p>
         *        Make sure that the access role provides read and write access to the parent directory of the file
         *        location that's used in the <code>StartFileTransfer</code> request. Additionally, make sure that the
         *        role provides <code>secretsmanager:GetSecretValue</code> permission to Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessRole(String accessRole);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private String agreementId;

        private String serverId;

        private String description;

        private String status;

        private String localProfileId;

        private String partnerProfileId;

        private String baseDirectory;

        private String accessRole;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgreementRequest model) {
            super(model);
            agreementId(model.agreementId);
            serverId(model.serverId);
            description(model.description);
            status(model.status);
            localProfileId(model.localProfileId);
            partnerProfileId(model.partnerProfileId);
            baseDirectory(model.baseDirectory);
            accessRole(model.accessRole);
        }

        public final String getAgreementId() {
            return agreementId;
        }

        public final void setAgreementId(String agreementId) {
            this.agreementId = agreementId;
        }

        @Override
        public final Builder agreementId(String agreementId) {
            this.agreementId = agreementId;
            return this;
        }

        public final String getServerId() {
            return serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgreementStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getLocalProfileId() {
            return localProfileId;
        }

        public final void setLocalProfileId(String localProfileId) {
            this.localProfileId = localProfileId;
        }

        @Override
        public final Builder localProfileId(String localProfileId) {
            this.localProfileId = localProfileId;
            return this;
        }

        public final String getPartnerProfileId() {
            return partnerProfileId;
        }

        public final void setPartnerProfileId(String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
        }

        @Override
        public final Builder partnerProfileId(String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
            return this;
        }

        public final String getBaseDirectory() {
            return baseDirectory;
        }

        public final void setBaseDirectory(String baseDirectory) {
            this.baseDirectory = baseDirectory;
        }

        @Override
        public final Builder baseDirectory(String baseDirectory) {
            this.baseDirectory = baseDirectory;
            return this;
        }

        public final String getAccessRole() {
            return accessRole;
        }

        public final void setAccessRole(String accessRole) {
            this.accessRole = accessRole;
        }

        @Override
        public final Builder accessRole(String accessRole) {
            this.accessRole = accessRole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAgreementRequest build() {
            return new UpdateAgreementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
