/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CompressionEnum {
    ZLIB("ZLIB"),
    DISABLED("DISABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CompressionEnum> VALUE_MAP;
    private final String value;

    private CompressionEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CompressionEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CompressionEnum> knownValues() {
        EnumSet<CompressionEnum> knownValues = EnumSet.allOf(CompressionEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CompressionEnum.class, CompressionEnum::toString);
    }
}

