/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProfileResponse extends TransferResponse implements
        ToCopyableBuilder<DescribeProfileResponse.Builder, DescribeProfileResponse> {
    private static final SdkField<DescribedProfile> PROFILE_FIELD = SdkField.<DescribedProfile> builder(MarshallingType.SDK_POJO)
            .memberName("Profile").getter(getter(DescribeProfileResponse::profile)).setter(setter(Builder::profile))
            .constructor(DescribedProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_FIELD));

    private final DescribedProfile profile;

    private DescribeProfileResponse(BuilderImpl builder) {
        super(builder);
        this.profile = builder.profile;
    }

    /**
     * <p>
     * The details of the specified profile, returned as an object.
     * </p>
     * 
     * @return The details of the specified profile, returned as an object.
     */
    public final DescribedProfile profile() {
        return profile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProfileResponse)) {
            return false;
        }
        DescribeProfileResponse other = (DescribeProfileResponse) obj;
        return Objects.equals(profile(), other.profile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProfileResponse").add("Profile", profile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Profile":
            return Optional.ofNullable(clazz.cast(profile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProfileResponse, T> g) {
        return obj -> g.apply((DescribeProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProfileResponse> {
        /**
         * <p>
         * The details of the specified profile, returned as an object.
         * </p>
         * 
         * @param profile
         *        The details of the specified profile, returned as an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profile(DescribedProfile profile);

        /**
         * <p>
         * The details of the specified profile, returned as an object.
         * </p>
         * This is a convenience method that creates an instance of the {@link DescribedProfile.Builder} avoiding the
         * need to create one manually via {@link DescribedProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DescribedProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #profile(DescribedProfile)}.
         * 
         * @param profile
         *        a consumer that will call methods on {@link DescribedProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profile(DescribedProfile)
         */
        default Builder profile(Consumer<DescribedProfile.Builder> profile) {
            return profile(DescribedProfile.builder().applyMutation(profile).build());
        }
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private DescribedProfile profile;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProfileResponse model) {
            super(model);
            profile(model.profile);
        }

        public final DescribedProfile.Builder getProfile() {
            return profile != null ? profile.toBuilder() : null;
        }

        public final void setProfile(DescribedProfile.BuilderImpl profile) {
            this.profile = profile != null ? profile.build() : null;
        }

        @Override
        public final Builder profile(DescribedProfile profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public DescribeProfileResponse build() {
            return new DescribeProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
