/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportCertificateRequest extends TransferRequest implements
        ToCopyableBuilder<ImportCertificateRequest.Builder, ImportCertificateRequest> {
    private static final SdkField<String> USAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Usage")
            .getter(getter(ImportCertificateRequest::usageAsString)).setter(setter(Builder::usage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Usage").build()).build();

    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Certificate").getter(getter(ImportCertificateRequest::certificate)).setter(setter(Builder::certificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final SdkField<String> CERTIFICATE_CHAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateChain").getter(getter(ImportCertificateRequest::certificateChain))
            .setter(setter(Builder::certificateChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateChain").build()).build();

    private static final SdkField<String> PRIVATE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateKey").getter(getter(ImportCertificateRequest::privateKey)).setter(setter(Builder::privateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKey").build()).build();

    private static final SdkField<Instant> ACTIVE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ActiveDate").getter(getter(ImportCertificateRequest::activeDate)).setter(setter(Builder::activeDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDate").build()).build();

    private static final SdkField<Instant> INACTIVE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InactiveDate").getter(getter(ImportCertificateRequest::inactiveDate))
            .setter(setter(Builder::inactiveDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InactiveDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ImportCertificateRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ImportCertificateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_FIELD,
            CERTIFICATE_FIELD, CERTIFICATE_CHAIN_FIELD, PRIVATE_KEY_FIELD, ACTIVE_DATE_FIELD, INACTIVE_DATE_FIELD,
            DESCRIPTION_FIELD, TAGS_FIELD));

    private final String usage;

    private final String certificate;

    private final String certificateChain;

    private final String privateKey;

    private final Instant activeDate;

    private final Instant inactiveDate;

    private final String description;

    private final List<Tag> tags;

    private ImportCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.usage = builder.usage;
        this.certificate = builder.certificate;
        this.certificateChain = builder.certificateChain;
        this.privateKey = builder.privateKey;
        this.activeDate = builder.activeDate;
        this.inactiveDate = builder.inactiveDate;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Specifies how this certificate is used. It can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SIGNING</code>: For signing AS2 messages
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENCRYPTION</code>: For encrypting AS2 messages
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TLS</code>: For securing AS2 communications sent over HTTPS
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usage} will return
     * {@link CertificateUsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageAsString}.
     * </p>
     * 
     * @return Specifies how this certificate is used. It can be used in the following ways:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SIGNING</code>: For signing AS2 messages
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENCRYPTION</code>: For encrypting AS2 messages
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TLS</code>: For securing AS2 communications sent over HTTPS
     *         </p>
     *         </li>
     * @see CertificateUsageType
     */
    public final CertificateUsageType usage() {
        return CertificateUsageType.fromValue(usage);
    }

    /**
     * <p>
     * Specifies how this certificate is used. It can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SIGNING</code>: For signing AS2 messages
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENCRYPTION</code>: For encrypting AS2 messages
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TLS</code>: For securing AS2 communications sent over HTTPS
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usage} will return
     * {@link CertificateUsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #usageAsString}.
     * </p>
     * 
     * @return Specifies how this certificate is used. It can be used in the following ways:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SIGNING</code>: For signing AS2 messages
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENCRYPTION</code>: For encrypting AS2 messages
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TLS</code>: For securing AS2 communications sent over HTTPS
     *         </p>
     *         </li>
     * @see CertificateUsageType
     */
    public final String usageAsString() {
        return usage;
    }

    /**
     * <ul>
     * <li>
     * <p>
     * For the CLI, provide a file path for a certificate in URI format. For example,
     * <code>--certificate file://encryption-cert.pem</code>. Alternatively, you can provide the raw content.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the SDK, specify the raw content of a certificate file. For example,
     * <code>--certificate "`cat encryption-cert.pem`"</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return <li>
     *         <p>
     *         For the CLI, provide a file path for a certificate in URI format. For example,
     *         <code>--certificate file://encryption-cert.pem</code>. Alternatively, you can provide the raw content.
     *         </p>
     *         </li> <li>
     *         <p>
     *         For the SDK, specify the raw content of a certificate file. For example,
     *         <code>--certificate "`cat encryption-cert.pem`"</code>.
     *         </p>
     *         </li>
     */
    public final String certificate() {
        return certificate;
    }

    /**
     * <p>
     * An optional list of certificates that make up the chain for the certificate that's being imported.
     * </p>
     * 
     * @return An optional list of certificates that make up the chain for the certificate that's being imported.
     */
    public final String certificateChain() {
        return certificateChain;
    }

    /**
     * <ul>
     * <li>
     * <p>
     * For the CLI, provide a file path for a private key in URI format.For example,
     * <code>--private-key file://encryption-key.pem</code>. Alternatively, you can provide the raw content of the
     * private key file.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the SDK, specify the raw content of a private key file. For example,
     * <code>--private-key "`cat encryption-key.pem`"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return <li>
     *         <p>
     *         For the CLI, provide a file path for a private key in URI format.For example,
     *         <code>--private-key file://encryption-key.pem</code>. Alternatively, you can provide the raw content of
     *         the private key file.
     *         </p>
     *         </li> <li>
     *         <p>
     *         For the SDK, specify the raw content of a private key file. For example,
     *         <code>--private-key "`cat encryption-key.pem`"</code>
     *         </p>
     *         </li>
     */
    public final String privateKey() {
        return privateKey;
    }

    /**
     * <p>
     * An optional date that specifies when the certificate becomes active.
     * </p>
     * 
     * @return An optional date that specifies when the certificate becomes active.
     */
    public final Instant activeDate() {
        return activeDate;
    }

    /**
     * <p>
     * An optional date that specifies when the certificate becomes inactive.
     * </p>
     * 
     * @return An optional date that specifies when the certificate becomes inactive.
     */
    public final Instant inactiveDate() {
        return inactiveDate;
    }

    /**
     * <p>
     * A short description that helps identify the certificate.
     * </p>
     * 
     * @return A short description that helps identify the certificate.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Key-value pairs that can be used to group and search for certificates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs that can be used to group and search for certificates.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(usageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(certificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(activeDate());
        hashCode = 31 * hashCode + Objects.hashCode(inactiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportCertificateRequest)) {
            return false;
        }
        ImportCertificateRequest other = (ImportCertificateRequest) obj;
        return Objects.equals(usageAsString(), other.usageAsString()) && Objects.equals(certificate(), other.certificate())
                && Objects.equals(certificateChain(), other.certificateChain())
                && Objects.equals(privateKey(), other.privateKey()) && Objects.equals(activeDate(), other.activeDate())
                && Objects.equals(inactiveDate(), other.inactiveDate()) && Objects.equals(description(), other.description())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportCertificateRequest").add("Usage", usageAsString())
                .add("Certificate", certificate() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CertificateChain", certificateChain() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PrivateKey", privateKey() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ActiveDate", activeDate()).add("InactiveDate", inactiveDate()).add("Description", description())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Usage":
            return Optional.ofNullable(clazz.cast(usageAsString()));
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "CertificateChain":
            return Optional.ofNullable(clazz.cast(certificateChain()));
        case "PrivateKey":
            return Optional.ofNullable(clazz.cast(privateKey()));
        case "ActiveDate":
            return Optional.ofNullable(clazz.cast(activeDate()));
        case "InactiveDate":
            return Optional.ofNullable(clazz.cast(inactiveDate()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportCertificateRequest, T> g) {
        return obj -> g.apply((ImportCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportCertificateRequest> {
        /**
         * <p>
         * Specifies how this certificate is used. It can be used in the following ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SIGNING</code>: For signing AS2 messages
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENCRYPTION</code>: For encrypting AS2 messages
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TLS</code>: For securing AS2 communications sent over HTTPS
         * </p>
         * </li>
         * </ul>
         * 
         * @param usage
         *        Specifies how this certificate is used. It can be used in the following ways:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SIGNING</code>: For signing AS2 messages
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENCRYPTION</code>: For encrypting AS2 messages
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TLS</code>: For securing AS2 communications sent over HTTPS
         *        </p>
         *        </li>
         * @see CertificateUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateUsageType
         */
        Builder usage(String usage);

        /**
         * <p>
         * Specifies how this certificate is used. It can be used in the following ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SIGNING</code>: For signing AS2 messages
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENCRYPTION</code>: For encrypting AS2 messages
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TLS</code>: For securing AS2 communications sent over HTTPS
         * </p>
         * </li>
         * </ul>
         * 
         * @param usage
         *        Specifies how this certificate is used. It can be used in the following ways:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SIGNING</code>: For signing AS2 messages
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENCRYPTION</code>: For encrypting AS2 messages
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TLS</code>: For securing AS2 communications sent over HTTPS
         *        </p>
         *        </li>
         * @see CertificateUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateUsageType
         */
        Builder usage(CertificateUsageType usage);

        /**
         * <ul>
         * <li>
         * <p>
         * For the CLI, provide a file path for a certificate in URI format. For example,
         * <code>--certificate file://encryption-cert.pem</code>. Alternatively, you can provide the raw content.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the SDK, specify the raw content of a certificate file. For example,
         * <code>--certificate "`cat encryption-cert.pem`"</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param certificate
         *        <li>
         *        <p>
         *        For the CLI, provide a file path for a certificate in URI format. For example,
         *        <code>--certificate file://encryption-cert.pem</code>. Alternatively, you can provide the raw content.
         *        </p>
         *        </li> <li>
         *        <p>
         *        For the SDK, specify the raw content of a certificate file. For example,
         *        <code>--certificate "`cat encryption-cert.pem`"</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(String certificate);

        /**
         * <p>
         * An optional list of certificates that make up the chain for the certificate that's being imported.
         * </p>
         * 
         * @param certificateChain
         *        An optional list of certificates that make up the chain for the certificate that's being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateChain(String certificateChain);

        /**
         * <ul>
         * <li>
         * <p>
         * For the CLI, provide a file path for a private key in URI format.For example,
         * <code>--private-key file://encryption-key.pem</code>. Alternatively, you can provide the raw content of the
         * private key file.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the SDK, specify the raw content of a private key file. For example,
         * <code>--private-key "`cat encryption-key.pem`"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param privateKey
         *        <li>
         *        <p>
         *        For the CLI, provide a file path for a private key in URI format.For example,
         *        <code>--private-key file://encryption-key.pem</code>. Alternatively, you can provide the raw content
         *        of the private key file.
         *        </p>
         *        </li> <li>
         *        <p>
         *        For the SDK, specify the raw content of a private key file. For example,
         *        <code>--private-key "`cat encryption-key.pem`"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKey(String privateKey);

        /**
         * <p>
         * An optional date that specifies when the certificate becomes active.
         * </p>
         * 
         * @param activeDate
         *        An optional date that specifies when the certificate becomes active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDate(Instant activeDate);

        /**
         * <p>
         * An optional date that specifies when the certificate becomes inactive.
         * </p>
         * 
         * @param inactiveDate
         *        An optional date that specifies when the certificate becomes inactive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inactiveDate(Instant inactiveDate);

        /**
         * <p>
         * A short description that helps identify the certificate.
         * </p>
         * 
         * @param description
         *        A short description that helps identify the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for certificates.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for certificates.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for certificates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.transfer.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private String usage;

        private String certificate;

        private String certificateChain;

        private String privateKey;

        private Instant activeDate;

        private Instant inactiveDate;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportCertificateRequest model) {
            super(model);
            usage(model.usage);
            certificate(model.certificate);
            certificateChain(model.certificateChain);
            privateKey(model.privateKey);
            activeDate(model.activeDate);
            inactiveDate(model.inactiveDate);
            description(model.description);
            tags(model.tags);
        }

        public final String getUsage() {
            return usage;
        }

        public final void setUsage(String usage) {
            this.usage = usage;
        }

        @Override
        public final Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public final Builder usage(CertificateUsageType usage) {
            this.usage(usage == null ? null : usage.toString());
            return this;
        }

        public final String getCertificate() {
            return certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final String getCertificateChain() {
            return certificateChain;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        @Override
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final String getPrivateKey() {
            return privateKey;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final Instant getActiveDate() {
            return activeDate;
        }

        public final void setActiveDate(Instant activeDate) {
            this.activeDate = activeDate;
        }

        @Override
        public final Builder activeDate(Instant activeDate) {
            this.activeDate = activeDate;
            return this;
        }

        public final Instant getInactiveDate() {
            return inactiveDate;
        }

        public final void setInactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
        }

        @Override
        public final Builder inactiveDate(Instant inactiveDate) {
            this.inactiveDate = inactiveDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportCertificateRequest build() {
            return new ImportCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
