/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.transfer.model.CreateAccessRequest;
import software.amazon.awssdk.services.transfer.model.CreateAccessResponse;
import software.amazon.awssdk.services.transfer.model.CreateAgreementRequest;
import software.amazon.awssdk.services.transfer.model.CreateAgreementResponse;
import software.amazon.awssdk.services.transfer.model.CreateConnectorRequest;
import software.amazon.awssdk.services.transfer.model.CreateConnectorResponse;
import software.amazon.awssdk.services.transfer.model.CreateProfileRequest;
import software.amazon.awssdk.services.transfer.model.CreateProfileResponse;
import software.amazon.awssdk.services.transfer.model.CreateServerRequest;
import software.amazon.awssdk.services.transfer.model.CreateServerResponse;
import software.amazon.awssdk.services.transfer.model.CreateUserRequest;
import software.amazon.awssdk.services.transfer.model.CreateUserResponse;
import software.amazon.awssdk.services.transfer.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.transfer.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.transfer.model.DeleteAccessRequest;
import software.amazon.awssdk.services.transfer.model.DeleteAccessResponse;
import software.amazon.awssdk.services.transfer.model.DeleteAgreementRequest;
import software.amazon.awssdk.services.transfer.model.DeleteAgreementResponse;
import software.amazon.awssdk.services.transfer.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.transfer.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.transfer.model.DeleteConnectorRequest;
import software.amazon.awssdk.services.transfer.model.DeleteConnectorResponse;
import software.amazon.awssdk.services.transfer.model.DeleteHostKeyRequest;
import software.amazon.awssdk.services.transfer.model.DeleteHostKeyResponse;
import software.amazon.awssdk.services.transfer.model.DeleteProfileRequest;
import software.amazon.awssdk.services.transfer.model.DeleteProfileResponse;
import software.amazon.awssdk.services.transfer.model.DeleteServerRequest;
import software.amazon.awssdk.services.transfer.model.DeleteServerResponse;
import software.amazon.awssdk.services.transfer.model.DeleteSshPublicKeyRequest;
import software.amazon.awssdk.services.transfer.model.DeleteSshPublicKeyResponse;
import software.amazon.awssdk.services.transfer.model.DeleteUserRequest;
import software.amazon.awssdk.services.transfer.model.DeleteUserResponse;
import software.amazon.awssdk.services.transfer.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.transfer.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.transfer.model.DescribeAccessRequest;
import software.amazon.awssdk.services.transfer.model.DescribeAccessResponse;
import software.amazon.awssdk.services.transfer.model.DescribeAgreementRequest;
import software.amazon.awssdk.services.transfer.model.DescribeAgreementResponse;
import software.amazon.awssdk.services.transfer.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.transfer.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.transfer.model.DescribeConnectorRequest;
import software.amazon.awssdk.services.transfer.model.DescribeConnectorResponse;
import software.amazon.awssdk.services.transfer.model.DescribeExecutionRequest;
import software.amazon.awssdk.services.transfer.model.DescribeExecutionResponse;
import software.amazon.awssdk.services.transfer.model.DescribeHostKeyRequest;
import software.amazon.awssdk.services.transfer.model.DescribeHostKeyResponse;
import software.amazon.awssdk.services.transfer.model.DescribeProfileRequest;
import software.amazon.awssdk.services.transfer.model.DescribeProfileResponse;
import software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyRequest;
import software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyResponse;
import software.amazon.awssdk.services.transfer.model.DescribeServerRequest;
import software.amazon.awssdk.services.transfer.model.DescribeServerResponse;
import software.amazon.awssdk.services.transfer.model.DescribeUserRequest;
import software.amazon.awssdk.services.transfer.model.DescribeUserResponse;
import software.amazon.awssdk.services.transfer.model.DescribeWorkflowRequest;
import software.amazon.awssdk.services.transfer.model.DescribeWorkflowResponse;
import software.amazon.awssdk.services.transfer.model.ImportCertificateRequest;
import software.amazon.awssdk.services.transfer.model.ImportCertificateResponse;
import software.amazon.awssdk.services.transfer.model.ImportHostKeyRequest;
import software.amazon.awssdk.services.transfer.model.ImportHostKeyResponse;
import software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyRequest;
import software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyResponse;
import software.amazon.awssdk.services.transfer.model.ListAccessesRequest;
import software.amazon.awssdk.services.transfer.model.ListAccessesResponse;
import software.amazon.awssdk.services.transfer.model.ListAgreementsRequest;
import software.amazon.awssdk.services.transfer.model.ListAgreementsResponse;
import software.amazon.awssdk.services.transfer.model.ListCertificatesRequest;
import software.amazon.awssdk.services.transfer.model.ListCertificatesResponse;
import software.amazon.awssdk.services.transfer.model.ListConnectorsRequest;
import software.amazon.awssdk.services.transfer.model.ListConnectorsResponse;
import software.amazon.awssdk.services.transfer.model.ListExecutionsRequest;
import software.amazon.awssdk.services.transfer.model.ListExecutionsResponse;
import software.amazon.awssdk.services.transfer.model.ListHostKeysRequest;
import software.amazon.awssdk.services.transfer.model.ListHostKeysResponse;
import software.amazon.awssdk.services.transfer.model.ListProfilesRequest;
import software.amazon.awssdk.services.transfer.model.ListProfilesResponse;
import software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesRequest;
import software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse;
import software.amazon.awssdk.services.transfer.model.ListServersRequest;
import software.amazon.awssdk.services.transfer.model.ListServersResponse;
import software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.transfer.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.transfer.model.ListUsersRequest;
import software.amazon.awssdk.services.transfer.model.ListUsersResponse;
import software.amazon.awssdk.services.transfer.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.transfer.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.transfer.model.SendWorkflowStepStateRequest;
import software.amazon.awssdk.services.transfer.model.SendWorkflowStepStateResponse;
import software.amazon.awssdk.services.transfer.model.StartFileTransferRequest;
import software.amazon.awssdk.services.transfer.model.StartFileTransferResponse;
import software.amazon.awssdk.services.transfer.model.StartServerRequest;
import software.amazon.awssdk.services.transfer.model.StartServerResponse;
import software.amazon.awssdk.services.transfer.model.StopServerRequest;
import software.amazon.awssdk.services.transfer.model.StopServerResponse;
import software.amazon.awssdk.services.transfer.model.TagResourceRequest;
import software.amazon.awssdk.services.transfer.model.TagResourceResponse;
import software.amazon.awssdk.services.transfer.model.TestConnectionRequest;
import software.amazon.awssdk.services.transfer.model.TestConnectionResponse;
import software.amazon.awssdk.services.transfer.model.TestIdentityProviderRequest;
import software.amazon.awssdk.services.transfer.model.TestIdentityProviderResponse;
import software.amazon.awssdk.services.transfer.model.UntagResourceRequest;
import software.amazon.awssdk.services.transfer.model.UntagResourceResponse;
import software.amazon.awssdk.services.transfer.model.UpdateAccessRequest;
import software.amazon.awssdk.services.transfer.model.UpdateAccessResponse;
import software.amazon.awssdk.services.transfer.model.UpdateAgreementRequest;
import software.amazon.awssdk.services.transfer.model.UpdateAgreementResponse;
import software.amazon.awssdk.services.transfer.model.UpdateCertificateRequest;
import software.amazon.awssdk.services.transfer.model.UpdateCertificateResponse;
import software.amazon.awssdk.services.transfer.model.UpdateConnectorRequest;
import software.amazon.awssdk.services.transfer.model.UpdateConnectorResponse;
import software.amazon.awssdk.services.transfer.model.UpdateHostKeyRequest;
import software.amazon.awssdk.services.transfer.model.UpdateHostKeyResponse;
import software.amazon.awssdk.services.transfer.model.UpdateProfileRequest;
import software.amazon.awssdk.services.transfer.model.UpdateProfileResponse;
import software.amazon.awssdk.services.transfer.model.UpdateServerRequest;
import software.amazon.awssdk.services.transfer.model.UpdateServerResponse;
import software.amazon.awssdk.services.transfer.model.UpdateUserRequest;
import software.amazon.awssdk.services.transfer.model.UpdateUserResponse;
import software.amazon.awssdk.services.transfer.paginators.ListAccessesPublisher;
import software.amazon.awssdk.services.transfer.paginators.ListAgreementsPublisher;
import software.amazon.awssdk.services.transfer.paginators.ListCertificatesPublisher;
import software.amazon.awssdk.services.transfer.paginators.ListConnectorsPublisher;
import software.amazon.awssdk.services.transfer.paginators.ListExecutionsPublisher;
import software.amazon.awssdk.services.transfer.paginators.ListProfilesPublisher;
import software.amazon.awssdk.services.transfer.paginators.ListSecurityPoliciesPublisher;
import software.amazon.awssdk.services.transfer.paginators.ListServersPublisher;
import software.amazon.awssdk.services.transfer.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.transfer.paginators.ListUsersPublisher;
import software.amazon.awssdk.services.transfer.paginators.ListWorkflowsPublisher;
import software.amazon.awssdk.services.transfer.waiters.TransferAsyncWaiter;

/**
 * Service client for accessing AWS Transfer asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Transfer Family is a fully managed service that enables the transfer of files over the File Transfer Protocol (FTP),
 * File Transfer Protocol over SSL (FTPS), or Secure Shell (SSH) File Transfer Protocol (SFTP) directly into and out of
 * Amazon Simple Storage Service (Amazon S3) or Amazon EFS. Additionally, you can use Applicability Statement 2 (AS2) to
 * transfer files into and out of Amazon S3. Amazon Web Services helps you seamlessly migrate your file transfer
 * workflows to Transfer Family by integrating with existing authentication systems, and providing DNS routing with
 * Amazon Route 53 so nothing changes for your customers and partners, or their applications. With your data in Amazon
 * S3, you can use it with Amazon Web Services for processing, analytics, machine learning, and archiving. Getting
 * started with Transfer Family is easy since there is no infrastructure to buy and set up.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface TransferAsyncClient extends AwsClient {
    String SERVICE_NAME = "transfer";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "transfer";

    /**
     * <p>
     * Used by administrators to choose which groups in the directory should have access to upload and download files
     * over the enabled protocols using Transfer Family. For example, a Microsoft Active Directory might contain 50,000
     * users, but only a small fraction might need the ability to transfer files to the server. An administrator can use
     * <code>CreateAccess</code> to limit the access to the correct set of users who need this ability.
     * </p>
     *
     * @param createAccessRequest
     * @return A Java Future containing the result of the CreateAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.CreateAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAccessResponse> createAccess(CreateAccessRequest createAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by administrators to choose which groups in the directory should have access to upload and download files
     * over the enabled protocols using Transfer Family. For example, a Microsoft Active Directory might contain 50,000
     * users, but only a small fraction might need the ability to transfer files to the server. An administrator can use
     * <code>CreateAccess</code> to limit the access to the correct set of users who need this ability.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAccessRequest#builder()}
     * </p>
     *
     * @param createAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.CreateAccessRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.CreateAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAccessResponse> createAccess(Consumer<CreateAccessRequest.Builder> createAccessRequest) {
        return createAccess(CreateAccessRequest.builder().applyMutation(createAccessRequest).build());
    }

    /**
     * <p>
     * Creates an agreement. An agreement is a bilateral trading partner agreement, or partnership, between an Transfer
     * Family server and an AS2 process. The agreement defines the file and message transfer relationship between the
     * server and the AS2 process. To define an agreement, Transfer Family combines a server, local profile, partner
     * profile, certificate, and other attributes.
     * </p>
     * <p>
     * The partner is identified with the <code>PartnerProfileId</code>, and the AS2 process is identified with the
     * <code>LocalProfileId</code>.
     * </p>
     *
     * @param createAgreementRequest
     * @return A Java Future containing the result of the CreateAgreement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.CreateAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateAgreement" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAgreementResponse> createAgreement(CreateAgreementRequest createAgreementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an agreement. An agreement is a bilateral trading partner agreement, or partnership, between an Transfer
     * Family server and an AS2 process. The agreement defines the file and message transfer relationship between the
     * server and the AS2 process. To define an agreement, Transfer Family combines a server, local profile, partner
     * profile, certificate, and other attributes.
     * </p>
     * <p>
     * The partner is identified with the <code>PartnerProfileId</code>, and the AS2 process is identified with the
     * <code>LocalProfileId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAgreementRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAgreementRequest#builder()}
     * </p>
     *
     * @param createAgreementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.CreateAgreementRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAgreement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.CreateAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateAgreement" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAgreementResponse> createAgreement(
            Consumer<CreateAgreementRequest.Builder> createAgreementRequest) {
        return createAgreement(CreateAgreementRequest.builder().applyMutation(createAgreementRequest).build());
    }

    /**
     * <p>
     * Creates the connector, which captures the parameters for a connection for the AS2 or SFTP protocol. For AS2, the
     * connector is required for sending files to an externally hosted AS2 server. For SFTP, the connector is required
     * when sending files to an SFTP server or receiving files from an SFTP server. For more details about connectors,
     * see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/configure-as2-connector.html">Configure AS2
     * connectors</a> and <a
     * href="https://docs.aws.amazon.com/transfer/latest/userguide/configure-sftp-connector.html">Create SFTP
     * connectors</a>.
     * </p>
     * <note>
     * <p>
     * You must specify exactly one configuration object: either for AS2 (<code>As2Config</code>) or SFTP (
     * <code>SftpConfig</code>).
     * </p>
     * </note>
     *
     * @param createConnectorRequest
     * @return A Java Future containing the result of the CreateConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.CreateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateConnectorResponse> createConnector(CreateConnectorRequest createConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the connector, which captures the parameters for a connection for the AS2 or SFTP protocol. For AS2, the
     * connector is required for sending files to an externally hosted AS2 server. For SFTP, the connector is required
     * when sending files to an SFTP server or receiving files from an SFTP server. For more details about connectors,
     * see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/configure-as2-connector.html">Configure AS2
     * connectors</a> and <a
     * href="https://docs.aws.amazon.com/transfer/latest/userguide/configure-sftp-connector.html">Create SFTP
     * connectors</a>.
     * </p>
     * <note>
     * <p>
     * You must specify exactly one configuration object: either for AS2 (<code>As2Config</code>) or SFTP (
     * <code>SftpConfig</code>).
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link CreateConnectorRequest#builder()}
     * </p>
     *
     * @param createConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.CreateConnectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.CreateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateConnectorResponse> createConnector(
            Consumer<CreateConnectorRequest.Builder> createConnectorRequest) {
        return createConnector(CreateConnectorRequest.builder().applyMutation(createConnectorRequest).build());
    }

    /**
     * <p>
     * Creates the local or partner profile to use for AS2 transfers.
     * </p>
     *
     * @param createProfileRequest
     * @return A Java Future containing the result of the CreateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProfileResponse> createProfile(CreateProfileRequest createProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the local or partner profile to use for AS2 transfers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProfileRequest#builder()}
     * </p>
     *
     * @param createProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.CreateProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProfileResponse> createProfile(Consumer<CreateProfileRequest.Builder> createProfileRequest) {
        return createProfile(CreateProfileRequest.builder().applyMutation(createProfileRequest).build());
    }

    /**
     * <p>
     * Instantiates an auto-scaling virtual server based on the selected file transfer protocol in Amazon Web Services.
     * When you make updates to your file transfer protocol-enabled server or when you work with users, use the
     * service-generated <code>ServerId</code> property that is assigned to the newly created server.
     * </p>
     *
     * @param createServerRequest
     * @return A Java Future containing the result of the CreateServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.CreateServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateServerResponse> createServer(CreateServerRequest createServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Instantiates an auto-scaling virtual server based on the selected file transfer protocol in Amazon Web Services.
     * When you make updates to your file transfer protocol-enabled server or when you work with users, use the
     * service-generated <code>ServerId</code> property that is assigned to the newly created server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateServerRequest#builder()}
     * </p>
     *
     * @param createServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.CreateServerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.CreateServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateServerResponse> createServer(Consumer<CreateServerRequest.Builder> createServerRequest) {
        return createServer(CreateServerRequest.builder().applyMutation(createServerRequest).build());
    }

    /**
     * <p>
     * Creates a user and associates them with an existing file transfer protocol-enabled server. You can only create
     * and associate users with servers that have the <code>IdentityProviderType</code> set to
     * <code>SERVICE_MANAGED</code>. Using parameters for <code>CreateUser</code>, you can specify the user name, set
     * the home directory, store the user's public key, and assign the user's Identity and Access Management (IAM) role.
     * You can also optionally add a session policy, and assign metadata with tags that can be used to group and search
     * for users.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user and associates them with an existing file transfer protocol-enabled server. You can only create
     * and associate users with servers that have the <code>IdentityProviderType</code> set to
     * <code>SERVICE_MANAGED</code>. Using parameters for <code>CreateUser</code>, you can specify the user name, set
     * the home directory, store the user's public key, and assign the user's Identity and Access Management (IAM) role.
     * You can also optionally add a session policy, and assign metadata with tags that can be used to group and search
     * for users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.CreateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(Consumer<CreateUserRequest.Builder> createUserRequest) {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Allows you to create a workflow with specified steps and step details the workflow invokes after file transfer
     * completes. After creating a workflow, you can associate the workflow created with any transfer servers by
     * specifying the <code>workflow-details</code> field in <code>CreateServer</code> and <code>UpdateServer</code>
     * operations.
     * </p>
     *
     * @param createWorkflowRequest
     * @return A Java Future containing the result of the CreateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkflowResponse> createWorkflow(CreateWorkflowRequest createWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to create a workflow with specified steps and step details the workflow invokes after file transfer
     * completes. After creating a workflow, you can associate the workflow created with any transfer servers by
     * specifying the <code>workflow-details</code> field in <code>CreateServer</code> and <code>UpdateServer</code>
     * operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkflowRequest#builder()}
     * </p>
     *
     * @param createWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.CreateWorkflowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkflowResponse> createWorkflow(Consumer<CreateWorkflowRequest.Builder> createWorkflowRequest) {
        return createWorkflow(CreateWorkflowRequest.builder().applyMutation(createWorkflowRequest).build());
    }

    /**
     * <p>
     * Allows you to delete the access specified in the <code>ServerID</code> and <code>ExternalID</code> parameters.
     * </p>
     *
     * @param deleteAccessRequest
     * @return A Java Future containing the result of the DeleteAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAccessResponse> deleteAccess(DeleteAccessRequest deleteAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to delete the access specified in the <code>ServerID</code> and <code>ExternalID</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAccessRequest#builder()}
     * </p>
     *
     * @param deleteAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DeleteAccessRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAccessResponse> deleteAccess(Consumer<DeleteAccessRequest.Builder> deleteAccessRequest) {
        return deleteAccess(DeleteAccessRequest.builder().applyMutation(deleteAccessRequest).build());
    }

    /**
     * <p>
     * Delete the agreement that's specified in the provided <code>AgreementId</code>.
     * </p>
     *
     * @param deleteAgreementRequest
     * @return A Java Future containing the result of the DeleteAgreement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteAgreement" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAgreementResponse> deleteAgreement(DeleteAgreementRequest deleteAgreementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the agreement that's specified in the provided <code>AgreementId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAgreementRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAgreementRequest#builder()}
     * </p>
     *
     * @param deleteAgreementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DeleteAgreementRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAgreement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteAgreement" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAgreementResponse> deleteAgreement(
            Consumer<DeleteAgreementRequest.Builder> deleteAgreementRequest) {
        return deleteAgreement(DeleteAgreementRequest.builder().applyMutation(deleteAgreementRequest).build());
    }

    /**
     * <p>
     * Deletes the certificate that's specified in the <code>CertificateId</code> parameter.
     * </p>
     *
     * @param deleteCertificateRequest
     * @return A Java Future containing the result of the DeleteCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest deleteCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the certificate that's specified in the <code>CertificateId</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCertificateRequest#builder()}
     * </p>
     *
     * @param deleteCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DeleteCertificateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCertificateResponse> deleteCertificate(
            Consumer<DeleteCertificateRequest.Builder> deleteCertificateRequest) {
        return deleteCertificate(DeleteCertificateRequest.builder().applyMutation(deleteCertificateRequest).build());
    }

    /**
     * <p>
     * Deletes the connector that's specified in the provided <code>ConnectorId</code>.
     * </p>
     *
     * @param deleteConnectorRequest
     * @return A Java Future containing the result of the DeleteConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteConnectorResponse> deleteConnector(DeleteConnectorRequest deleteConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the connector that's specified in the provided <code>ConnectorId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectorRequest#builder()}
     * </p>
     *
     * @param deleteConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DeleteConnectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteConnectorResponse> deleteConnector(
            Consumer<DeleteConnectorRequest.Builder> deleteConnectorRequest) {
        return deleteConnector(DeleteConnectorRequest.builder().applyMutation(deleteConnectorRequest).build());
    }

    /**
     * <p>
     * Deletes the host key that's specified in the <code>HostKeyId</code> parameter.
     * </p>
     *
     * @param deleteHostKeyRequest
     * @return A Java Future containing the result of the DeleteHostKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteHostKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteHostKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteHostKeyResponse> deleteHostKey(DeleteHostKeyRequest deleteHostKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the host key that's specified in the <code>HostKeyId</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHostKeyRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteHostKeyRequest#builder()}
     * </p>
     *
     * @param deleteHostKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DeleteHostKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteHostKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteHostKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteHostKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteHostKeyResponse> deleteHostKey(Consumer<DeleteHostKeyRequest.Builder> deleteHostKeyRequest) {
        return deleteHostKey(DeleteHostKeyRequest.builder().applyMutation(deleteHostKeyRequest).build());
    }

    /**
     * <p>
     * Deletes the profile that's specified in the <code>ProfileId</code> parameter.
     * </p>
     *
     * @param deleteProfileRequest
     * @return A Java Future containing the result of the DeleteProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProfileResponse> deleteProfile(DeleteProfileRequest deleteProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the profile that's specified in the <code>ProfileId</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProfileRequest#builder()}
     * </p>
     *
     * @param deleteProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DeleteProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProfileResponse> deleteProfile(Consumer<DeleteProfileRequest.Builder> deleteProfileRequest) {
        return deleteProfile(DeleteProfileRequest.builder().applyMutation(deleteProfileRequest).build());
    }

    /**
     * <p>
     * Deletes the file transfer protocol-enabled server that you specify.
     * </p>
     * <p>
     * No response returns from this operation.
     * </p>
     *
     * @param deleteServerRequest
     * @return A Java Future containing the result of the DeleteServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteServerResponse> deleteServer(DeleteServerRequest deleteServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the file transfer protocol-enabled server that you specify.
     * </p>
     * <p>
     * No response returns from this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteServerRequest#builder()}
     * </p>
     *
     * @param deleteServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DeleteServerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteServerResponse> deleteServer(Consumer<DeleteServerRequest.Builder> deleteServerRequest) {
        return deleteServer(DeleteServerRequest.builder().applyMutation(deleteServerRequest).build());
    }

    /**
     * <p>
     * Deletes a user's Secure Shell (SSH) public key.
     * </p>
     *
     * @param deleteSshPublicKeyRequest
     * @return A Java Future containing the result of the DeleteSshPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteSshPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteSshPublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSshPublicKeyResponse> deleteSshPublicKey(DeleteSshPublicKeyRequest deleteSshPublicKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user's Secure Shell (SSH) public key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSshPublicKeyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSshPublicKeyRequest#builder()}
     * </p>
     *
     * @param deleteSshPublicKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DeleteSshPublicKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSshPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteSshPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteSshPublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSshPublicKeyResponse> deleteSshPublicKey(
            Consumer<DeleteSshPublicKeyRequest.Builder> deleteSshPublicKeyRequest) {
        return deleteSshPublicKey(DeleteSshPublicKeyRequest.builder().applyMutation(deleteSshPublicKeyRequest).build());
    }

    /**
     * <p>
     * Deletes the user belonging to a file transfer protocol-enabled server you specify.
     * </p>
     * <p>
     * No response returns from this operation.
     * </p>
     * <note>
     * <p>
     * When you delete a user from a server, the user's information is lost.
     * </p>
     * </note>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the user belonging to a file transfer protocol-enabled server you specify.
     * </p>
     * <p>
     * No response returns from this operation.
     * </p>
     * <note>
     * <p>
     * When you delete a user from a server, the user's information is lost.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DeleteUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes the specified workflow.
     * </p>
     *
     * @param deleteWorkflowRequest
     * @return A Java Future containing the result of the DeleteWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkflowResponse> deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkflowRequest#builder()}
     * </p>
     *
     * @param deleteWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DeleteWorkflowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkflowResponse> deleteWorkflow(Consumer<DeleteWorkflowRequest.Builder> deleteWorkflowRequest) {
        return deleteWorkflow(DeleteWorkflowRequest.builder().applyMutation(deleteWorkflowRequest).build());
    }

    /**
     * <p>
     * Describes the access that is assigned to the specific file transfer protocol-enabled server, as identified by its
     * <code>ServerId</code> property and its <code>ExternalId</code>.
     * </p>
     * <p>
     * The response from this call returns the properties of the access that is associated with the
     * <code>ServerId</code> value that was specified.
     * </p>
     *
     * @param describeAccessRequest
     * @return A Java Future containing the result of the DescribeAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAccessResponse> describeAccess(DescribeAccessRequest describeAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the access that is assigned to the specific file transfer protocol-enabled server, as identified by its
     * <code>ServerId</code> property and its <code>ExternalId</code>.
     * </p>
     * <p>
     * The response from this call returns the properties of the access that is associated with the
     * <code>ServerId</code> value that was specified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccessRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAccessRequest#builder()}
     * </p>
     *
     * @param describeAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DescribeAccessRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAccessResponse> describeAccess(Consumer<DescribeAccessRequest.Builder> describeAccessRequest) {
        return describeAccess(DescribeAccessRequest.builder().applyMutation(describeAccessRequest).build());
    }

    /**
     * <p>
     * Describes the agreement that's identified by the <code>AgreementId</code>.
     * </p>
     *
     * @param describeAgreementRequest
     * @return A Java Future containing the result of the DescribeAgreement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeAgreement" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAgreementResponse> describeAgreement(DescribeAgreementRequest describeAgreementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the agreement that's identified by the <code>AgreementId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAgreementRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAgreementRequest#builder()}
     * </p>
     *
     * @param describeAgreementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DescribeAgreementRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAgreement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeAgreement" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAgreementResponse> describeAgreement(
            Consumer<DescribeAgreementRequest.Builder> describeAgreementRequest) {
        return describeAgreement(DescribeAgreementRequest.builder().applyMutation(describeAgreementRequest).build());
    }

    /**
     * <p>
     * Describes the certificate that's identified by the <code>CertificateId</code>.
     * </p>
     *
     * @param describeCertificateRequest
     * @return A Java Future containing the result of the DescribeCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeCertificateResponse> describeCertificate(
            DescribeCertificateRequest describeCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the certificate that's identified by the <code>CertificateId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificateRequest#builder()}
     * </p>
     *
     * @param describeCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DescribeCertificateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeCertificateResponse> describeCertificate(
            Consumer<DescribeCertificateRequest.Builder> describeCertificateRequest) {
        return describeCertificate(DescribeCertificateRequest.builder().applyMutation(describeCertificateRequest).build());
    }

    /**
     * <p>
     * Describes the connector that's identified by the <code>ConnectorId.</code>
     * </p>
     *
     * @param describeConnectorRequest
     * @return A Java Future containing the result of the DescribeConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConnectorResponse> describeConnector(DescribeConnectorRequest describeConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the connector that's identified by the <code>ConnectorId.</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeConnectorRequest#builder()}
     * </p>
     *
     * @param describeConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DescribeConnectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeConnector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeConnectorResponse> describeConnector(
            Consumer<DescribeConnectorRequest.Builder> describeConnectorRequest) {
        return describeConnector(DescribeConnectorRequest.builder().applyMutation(describeConnectorRequest).build());
    }

    /**
     * <p>
     * You can use <code>DescribeExecution</code> to check the details of the execution of the specified workflow.
     * </p>
     * <note>
     * <p>
     * This API call only returns details for in-progress workflows.
     * </p>
     * <p>
     * If you provide an ID for an execution that is not in progress, or if the execution doesn't match the specified
     * workflow ID, you receive a <code>ResourceNotFound</code> exception.
     * </p>
     * </note>
     *
     * @param describeExecutionRequest
     * @return A Java Future containing the result of the DescribeExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeExecutionResponse> describeExecution(DescribeExecutionRequest describeExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can use <code>DescribeExecution</code> to check the details of the execution of the specified workflow.
     * </p>
     * <note>
     * <p>
     * This API call only returns details for in-progress workflows.
     * </p>
     * <p>
     * If you provide an ID for an execution that is not in progress, or if the execution doesn't match the specified
     * workflow ID, you receive a <code>ResourceNotFound</code> exception.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExecutionRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeExecutionRequest#builder()}
     * </p>
     *
     * @param describeExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DescribeExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeExecutionResponse> describeExecution(
            Consumer<DescribeExecutionRequest.Builder> describeExecutionRequest) {
        return describeExecution(DescribeExecutionRequest.builder().applyMutation(describeExecutionRequest).build());
    }

    /**
     * <p>
     * Returns the details of the host key that's specified by the <code>HostKeyId</code> and <code>ServerId</code>.
     * </p>
     *
     * @param describeHostKeyRequest
     * @return A Java Future containing the result of the DescribeHostKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeHostKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeHostKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeHostKeyResponse> describeHostKey(DescribeHostKeyRequest describeHostKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the host key that's specified by the <code>HostKeyId</code> and <code>ServerId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHostKeyRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeHostKeyRequest#builder()}
     * </p>
     *
     * @param describeHostKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DescribeHostKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeHostKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeHostKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeHostKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeHostKeyResponse> describeHostKey(
            Consumer<DescribeHostKeyRequest.Builder> describeHostKeyRequest) {
        return describeHostKey(DescribeHostKeyRequest.builder().applyMutation(describeHostKeyRequest).build());
    }

    /**
     * <p>
     * Returns the details of the profile that's specified by the <code>ProfileId</code>.
     * </p>
     *
     * @param describeProfileRequest
     * @return A Java Future containing the result of the DescribeProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeProfileResponse> describeProfile(DescribeProfileRequest describeProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details of the profile that's specified by the <code>ProfileId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProfileRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProfileRequest#builder()}
     * </p>
     *
     * @param describeProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DescribeProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeProfileResponse> describeProfile(
            Consumer<DescribeProfileRequest.Builder> describeProfileRequest) {
        return describeProfile(DescribeProfileRequest.builder().applyMutation(describeProfileRequest).build());
    }

    /**
     * <p>
     * Describes the security policy that is attached to your file transfer protocol-enabled server. The response
     * contains a description of the security policy's properties. For more information about security policies, see <a
     * href="https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html">Working with security
     * policies</a>.
     * </p>
     *
     * @param describeSecurityPolicyRequest
     * @return A Java Future containing the result of the DescribeSecurityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSecurityPolicyResponse> describeSecurityPolicy(
            DescribeSecurityPolicyRequest describeSecurityPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the security policy that is attached to your file transfer protocol-enabled server. The response
     * contains a description of the security policy's properties. For more information about security policies, see <a
     * href="https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html">Working with security
     * policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSecurityPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSecurityPolicyRequest#builder()}
     * </p>
     *
     * @param describeSecurityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSecurityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSecurityPolicyResponse> describeSecurityPolicy(
            Consumer<DescribeSecurityPolicyRequest.Builder> describeSecurityPolicyRequest) {
        return describeSecurityPolicy(DescribeSecurityPolicyRequest.builder().applyMutation(describeSecurityPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Describes a file transfer protocol-enabled server that you specify by passing the <code>ServerId</code>
     * parameter.
     * </p>
     * <p>
     * The response contains a description of a server's properties. When you set <code>EndpointType</code> to VPC, the
     * response will contain the <code>EndpointDetails</code>.
     * </p>
     *
     * @param describeServerRequest
     * @return A Java Future containing the result of the DescribeServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeServerResponse> describeServer(DescribeServerRequest describeServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a file transfer protocol-enabled server that you specify by passing the <code>ServerId</code>
     * parameter.
     * </p>
     * <p>
     * The response contains a description of a server's properties. When you set <code>EndpointType</code> to VPC, the
     * response will contain the <code>EndpointDetails</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServerRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeServerRequest#builder()}
     * </p>
     *
     * @param describeServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DescribeServerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeServerResponse> describeServer(Consumer<DescribeServerRequest.Builder> describeServerRequest) {
        return describeServer(DescribeServerRequest.builder().applyMutation(describeServerRequest).build());
    }

    /**
     * <p>
     * Describes the user assigned to the specific file transfer protocol-enabled server, as identified by its
     * <code>ServerId</code> property.
     * </p>
     * <p>
     * The response from this call returns the properties of the user associated with the <code>ServerId</code> value
     * that was specified.
     * </p>
     *
     * @param describeUserRequest
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(DescribeUserRequest describeUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the user assigned to the specific file transfer protocol-enabled server, as identified by its
     * <code>ServerId</code> property.
     * </p>
     * <p>
     * The response from this call returns the properties of the user associated with the <code>ServerId</code> value
     * that was specified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUserRequest#builder()}
     * </p>
     *
     * @param describeUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DescribeUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeUserResponse> describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest) {
        return describeUser(DescribeUserRequest.builder().applyMutation(describeUserRequest).build());
    }

    /**
     * <p>
     * Describes the specified workflow.
     * </p>
     *
     * @param describeWorkflowRequest
     * @return A Java Future containing the result of the DescribeWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeWorkflowResponse> describeWorkflow(DescribeWorkflowRequest describeWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkflowRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWorkflowRequest#builder()}
     * </p>
     *
     * @param describeWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.DescribeWorkflowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.DescribeWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeWorkflowResponse> describeWorkflow(
            Consumer<DescribeWorkflowRequest.Builder> describeWorkflowRequest) {
        return describeWorkflow(DescribeWorkflowRequest.builder().applyMutation(describeWorkflowRequest).build());
    }

    /**
     * <p>
     * Imports the signing and encryption certificates that you need to create local (AS2) profiles and partner
     * profiles.
     * </p>
     *
     * @param importCertificateRequest
     * @return A Java Future containing the result of the ImportCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ImportCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ImportCertificateResponse> importCertificate(ImportCertificateRequest importCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports the signing and encryption certificates that you need to create local (AS2) profiles and partner
     * profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link ImportCertificateRequest#builder()}
     * </p>
     *
     * @param importCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ImportCertificateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ImportCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ImportCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ImportCertificateResponse> importCertificate(
            Consumer<ImportCertificateRequest.Builder> importCertificateRequest) {
        return importCertificate(ImportCertificateRequest.builder().applyMutation(importCertificateRequest).build());
    }

    /**
     * <p>
     * Adds a host key to the server that's specified by the <code>ServerId</code> parameter.
     * </p>
     *
     * @param importHostKeyRequest
     * @return A Java Future containing the result of the ImportHostKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ImportHostKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportHostKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportHostKeyResponse> importHostKey(ImportHostKeyRequest importHostKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a host key to the server that's specified by the <code>ServerId</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportHostKeyRequest.Builder} avoiding the need to
     * create one manually via {@link ImportHostKeyRequest#builder()}
     * </p>
     *
     * @param importHostKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ImportHostKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ImportHostKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ImportHostKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportHostKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportHostKeyResponse> importHostKey(Consumer<ImportHostKeyRequest.Builder> importHostKeyRequest) {
        return importHostKey(ImportHostKeyRequest.builder().applyMutation(importHostKeyRequest).build());
    }

    /**
     * <p>
     * Adds a Secure Shell (SSH) public key to a Transfer Family user identified by a <code>UserName</code> value
     * assigned to the specific file transfer protocol-enabled server, identified by <code>ServerId</code>.
     * </p>
     * <p>
     * The response returns the <code>UserName</code> value, the <code>ServerId</code> value, and the name of the
     * <code>SshPublicKeyId</code>.
     * </p>
     *
     * @param importSshPublicKeyRequest
     * @return A Java Future containing the result of the ImportSshPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ImportSshPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportSshPublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ImportSshPublicKeyResponse> importSshPublicKey(ImportSshPublicKeyRequest importSshPublicKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a Secure Shell (SSH) public key to a Transfer Family user identified by a <code>UserName</code> value
     * assigned to the specific file transfer protocol-enabled server, identified by <code>ServerId</code>.
     * </p>
     * <p>
     * The response returns the <code>UserName</code> value, the <code>ServerId</code> value, and the name of the
     * <code>SshPublicKeyId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportSshPublicKeyRequest.Builder} avoiding the
     * need to create one manually via {@link ImportSshPublicKeyRequest#builder()}
     * </p>
     *
     * @param importSshPublicKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ImportSshPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ImportSshPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportSshPublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ImportSshPublicKeyResponse> importSshPublicKey(
            Consumer<ImportSshPublicKeyRequest.Builder> importSshPublicKeyRequest) {
        return importSshPublicKey(ImportSshPublicKeyRequest.builder().applyMutation(importSshPublicKeyRequest).build());
    }

    /**
     * <p>
     * Lists the details for all the accesses you have on your server.
     * </p>
     *
     * @param listAccessesRequest
     * @return A Java Future containing the result of the ListAccesses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListAccesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAccesses" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccessesResponse> listAccesses(ListAccessesRequest listAccessesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the details for all the accesses you have on your server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAccessesRequest#builder()}
     * </p>
     *
     * @param listAccessesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListAccessesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAccesses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListAccesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAccesses" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAccessesResponse> listAccesses(Consumer<ListAccessesRequest.Builder> listAccessesRequest) {
        return listAccesses(ListAccessesRequest.builder().applyMutation(listAccessesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAccesses(software.amazon.awssdk.services.transfer.model.ListAccessesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAccessesPublisher publisher = client.listAccessesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAccessesPublisher publisher = client.listAccessesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListAccessesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListAccessesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccesses(software.amazon.awssdk.services.transfer.model.ListAccessesRequest)} operation.</b>
     * </p>
     *
     * @param listAccessesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListAccesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAccesses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccessesPublisher listAccessesPaginator(ListAccessesRequest listAccessesRequest) {
        return new ListAccessesPublisher(this, listAccessesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAccesses(software.amazon.awssdk.services.transfer.model.ListAccessesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAccessesPublisher publisher = client.listAccessesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAccessesPublisher publisher = client.listAccessesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListAccessesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListAccessesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccesses(software.amazon.awssdk.services.transfer.model.ListAccessesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAccessesRequest#builder()}
     * </p>
     *
     * @param listAccessesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListAccessesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListAccesses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAccesses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAccessesPublisher listAccessesPaginator(Consumer<ListAccessesRequest.Builder> listAccessesRequest) {
        return listAccessesPaginator(ListAccessesRequest.builder().applyMutation(listAccessesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the agreements for the server that's identified by the <code>ServerId</code> that you supply.
     * If you want to limit the results to a certain number, supply a value for the <code>MaxResults</code> parameter.
     * If you ran the command previously and received a value for <code>NextToken</code>, you can supply that value to
     * continue listing agreements from where you left off.
     * </p>
     *
     * @param listAgreementsRequest
     * @return A Java Future containing the result of the ListAgreements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListAgreements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAgreements" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAgreementsResponse> listAgreements(ListAgreementsRequest listAgreementsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the agreements for the server that's identified by the <code>ServerId</code> that you supply.
     * If you want to limit the results to a certain number, supply a value for the <code>MaxResults</code> parameter.
     * If you ran the command previously and received a value for <code>NextToken</code>, you can supply that value to
     * continue listing agreements from where you left off.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgreementsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAgreementsRequest#builder()}
     * </p>
     *
     * @param listAgreementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListAgreementsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAgreements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListAgreements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAgreements" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAgreementsResponse> listAgreements(Consumer<ListAgreementsRequest.Builder> listAgreementsRequest) {
        return listAgreements(ListAgreementsRequest.builder().applyMutation(listAgreementsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgreements(software.amazon.awssdk.services.transfer.model.ListAgreementsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAgreementsPublisher publisher = client.listAgreementsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAgreementsPublisher publisher = client.listAgreementsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListAgreementsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListAgreementsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgreements(software.amazon.awssdk.services.transfer.model.ListAgreementsRequest)} operation.</b>
     * </p>
     *
     * @param listAgreementsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListAgreements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAgreements" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgreementsPublisher listAgreementsPaginator(ListAgreementsRequest listAgreementsRequest) {
        return new ListAgreementsPublisher(this, listAgreementsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgreements(software.amazon.awssdk.services.transfer.model.ListAgreementsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAgreementsPublisher publisher = client.listAgreementsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListAgreementsPublisher publisher = client.listAgreementsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListAgreementsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListAgreementsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgreements(software.amazon.awssdk.services.transfer.model.ListAgreementsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgreementsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAgreementsRequest#builder()}
     * </p>
     *
     * @param listAgreementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListAgreementsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListAgreements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAgreements" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgreementsPublisher listAgreementsPaginator(Consumer<ListAgreementsRequest.Builder> listAgreementsRequest) {
        return listAgreementsPaginator(ListAgreementsRequest.builder().applyMutation(listAgreementsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the current certificates that have been imported into Transfer Family. If you want to limit the
     * results to a certain number, supply a value for the <code>MaxResults</code> parameter. If you ran the command
     * previously and received a value for the <code>NextToken</code> parameter, you can supply that value to continue
     * listing certificates from where you left off.
     * </p>
     *
     * @param listCertificatesRequest
     * @return A Java Future containing the result of the ListCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCertificatesResponse> listCertificates(ListCertificatesRequest listCertificatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the current certificates that have been imported into Transfer Family. If you want to limit the
     * results to a certain number, supply a value for the <code>MaxResults</code> parameter. If you ran the command
     * previously and received a value for the <code>NextToken</code> parameter, you can supply that value to continue
     * listing certificates from where you left off.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCertificatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCertificatesRequest#builder()}
     * </p>
     *
     * @param listCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListCertificatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCertificatesResponse> listCertificates(
            Consumer<ListCertificatesRequest.Builder> listCertificatesRequest) {
        return listCertificates(ListCertificatesRequest.builder().applyMutation(listCertificatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCertificates(software.amazon.awssdk.services.transfer.model.ListCertificatesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListCertificatesPublisher publisher = client.listCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListCertificatesPublisher publisher = client.listCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCertificates(software.amazon.awssdk.services.transfer.model.ListCertificatesRequest)} operation.</b>
     * </p>
     *
     * @param listCertificatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCertificatesPublisher listCertificatesPaginator(ListCertificatesRequest listCertificatesRequest) {
        return new ListCertificatesPublisher(this, listCertificatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCertificates(software.amazon.awssdk.services.transfer.model.ListCertificatesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListCertificatesPublisher publisher = client.listCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListCertificatesPublisher publisher = client.listCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCertificates(software.amazon.awssdk.services.transfer.model.ListCertificatesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCertificatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCertificatesRequest#builder()}
     * </p>
     *
     * @param listCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListCertificatesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCertificatesPublisher listCertificatesPaginator(Consumer<ListCertificatesRequest.Builder> listCertificatesRequest) {
        return listCertificatesPaginator(ListCertificatesRequest.builder().applyMutation(listCertificatesRequest).build());
    }

    /**
     * <p>
     * Lists the connectors for the specified Region.
     * </p>
     *
     * @param listConnectorsRequest
     * @return A Java Future containing the result of the ListConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListConnectorsResponse> listConnectors(ListConnectorsRequest listConnectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the connectors for the specified Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConnectorsRequest#builder()}
     * </p>
     *
     * @param listConnectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListConnectorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListConnectorsResponse> listConnectors(Consumer<ListConnectorsRequest.Builder> listConnectorsRequest) {
        return listConnectors(ListConnectorsRequest.builder().applyMutation(listConnectorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnectors(software.amazon.awssdk.services.transfer.model.ListConnectorsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectors(software.amazon.awssdk.services.transfer.model.ListConnectorsRequest)} operation.</b>
     * </p>
     *
     * @param listConnectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConnectorsPublisher listConnectorsPaginator(ListConnectorsRequest listConnectorsRequest) {
        return new ListConnectorsPublisher(this, listConnectorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConnectors(software.amazon.awssdk.services.transfer.model.ListConnectorsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListConnectorsPublisher publisher = client.listConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConnectors(software.amazon.awssdk.services.transfer.model.ListConnectorsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorsRequest.Builder} avoiding the need to
     * create one manually via {@link ListConnectorsRequest#builder()}
     * </p>
     *
     * @param listConnectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListConnectorsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListConnectors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListConnectorsPublisher listConnectorsPaginator(Consumer<ListConnectorsRequest.Builder> listConnectorsRequest) {
        return listConnectorsPaginator(ListConnectorsRequest.builder().applyMutation(listConnectorsRequest).build());
    }

    /**
     * <p>
     * Lists all in-progress executions for the specified workflow.
     * </p>
     * <note>
     * <p>
     * If the specified workflow ID cannot be found, <code>ListExecutions</code> returns a <code>ResourceNotFound</code>
     * exception.
     * </p>
     * </note>
     *
     * @param listExecutionsRequest
     * @return A Java Future containing the result of the ListExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExecutionsResponse> listExecutions(ListExecutionsRequest listExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all in-progress executions for the specified workflow.
     * </p>
     * <note>
     * <p>
     * If the specified workflow ID cannot be found, <code>ListExecutions</code> returns a <code>ResourceNotFound</code>
     * exception.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExecutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExecutionsRequest#builder()}
     * </p>
     *
     * @param listExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListExecutionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExecutionsResponse> listExecutions(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest) {
        return listExecutions(ListExecutionsRequest.builder().applyMutation(listExecutionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listExecutions(software.amazon.awssdk.services.transfer.model.ListExecutionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListExecutionsPublisher publisher = client.listExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListExecutionsPublisher publisher = client.listExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExecutions(software.amazon.awssdk.services.transfer.model.ListExecutionsRequest)} operation.</b>
     * </p>
     *
     * @param listExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExecutionsPublisher listExecutionsPaginator(ListExecutionsRequest listExecutionsRequest) {
        return new ListExecutionsPublisher(this, listExecutionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listExecutions(software.amazon.awssdk.services.transfer.model.ListExecutionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListExecutionsPublisher publisher = client.listExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListExecutionsPublisher publisher = client.listExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExecutions(software.amazon.awssdk.services.transfer.model.ListExecutionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExecutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExecutionsRequest#builder()}
     * </p>
     *
     * @param listExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListExecutionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListExecutions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExecutionsPublisher listExecutionsPaginator(Consumer<ListExecutionsRequest.Builder> listExecutionsRequest) {
        return listExecutionsPaginator(ListExecutionsRequest.builder().applyMutation(listExecutionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of host keys for the server that's specified by the <code>ServerId</code> parameter.
     * </p>
     *
     * @param listHostKeysRequest
     * @return A Java Future containing the result of the ListHostKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListHostKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListHostKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListHostKeysResponse> listHostKeys(ListHostKeysRequest listHostKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of host keys for the server that's specified by the <code>ServerId</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHostKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListHostKeysRequest#builder()}
     * </p>
     *
     * @param listHostKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListHostKeysRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListHostKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListHostKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListHostKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListHostKeysResponse> listHostKeys(Consumer<ListHostKeysRequest.Builder> listHostKeysRequest) {
        return listHostKeys(ListHostKeysRequest.builder().applyMutation(listHostKeysRequest).build());
    }

    /**
     * <p>
     * Returns a list of the profiles for your system. If you want to limit the results to a certain number, supply a
     * value for the <code>MaxResults</code> parameter. If you ran the command previously and received a value for
     * <code>NextToken</code>, you can supply that value to continue listing profiles from where you left off.
     * </p>
     *
     * @param listProfilesRequest
     * @return A Java Future containing the result of the ListProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProfilesResponse> listProfiles(ListProfilesRequest listProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the profiles for your system. If you want to limit the results to a certain number, supply a
     * value for the <code>MaxResults</code> parameter. If you ran the command previously and received a value for
     * <code>NextToken</code>, you can supply that value to continue listing profiles from where you left off.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link ListProfilesRequest#builder()}
     * </p>
     *
     * @param listProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListProfilesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListProfilesResponse> listProfiles(Consumer<ListProfilesRequest.Builder> listProfilesRequest) {
        return listProfiles(ListProfilesRequest.builder().applyMutation(listProfilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listProfiles(software.amazon.awssdk.services.transfer.model.ListProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListProfilesPublisher publisher = client.listProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListProfilesPublisher publisher = client.listProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfiles(software.amazon.awssdk.services.transfer.model.ListProfilesRequest)} operation.</b>
     * </p>
     *
     * @param listProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProfilesPublisher listProfilesPaginator(ListProfilesRequest listProfilesRequest) {
        return new ListProfilesPublisher(this, listProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listProfiles(software.amazon.awssdk.services.transfer.model.ListProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListProfilesPublisher publisher = client.listProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListProfilesPublisher publisher = client.listProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfiles(software.amazon.awssdk.services.transfer.model.ListProfilesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link ListProfilesRequest#builder()}
     * </p>
     *
     * @param listProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListProfilesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProfilesPublisher listProfilesPaginator(Consumer<ListProfilesRequest.Builder> listProfilesRequest) {
        return listProfilesPaginator(ListProfilesRequest.builder().applyMutation(listProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the security policies that are attached to your file transfer protocol-enabled servers.
     * </p>
     *
     * @param listSecurityPoliciesRequest
     * @return A Java Future containing the result of the ListSecurityPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListSecurityPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSecurityPoliciesResponse> listSecurityPolicies(
            ListSecurityPoliciesRequest listSecurityPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the security policies that are attached to your file transfer protocol-enabled servers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecurityPoliciesRequest#builder()}
     * </p>
     *
     * @param listSecurityPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSecurityPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListSecurityPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSecurityPoliciesResponse> listSecurityPolicies(
            Consumer<ListSecurityPoliciesRequest.Builder> listSecurityPoliciesRequest) {
        return listSecurityPolicies(ListSecurityPoliciesRequest.builder().applyMutation(listSecurityPoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListSecurityPoliciesPublisher publisher = client.listSecurityPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListSecurityPoliciesPublisher publisher = client.listSecurityPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSecurityPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListSecurityPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecurityPoliciesPublisher listSecurityPoliciesPaginator(ListSecurityPoliciesRequest listSecurityPoliciesRequest) {
        return new ListSecurityPoliciesPublisher(this, listSecurityPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListSecurityPoliciesPublisher publisher = client.listSecurityPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListSecurityPoliciesPublisher publisher = client.listSecurityPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecurityPoliciesRequest#builder()}
     * </p>
     *
     * @param listSecurityPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListSecurityPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSecurityPoliciesPublisher listSecurityPoliciesPaginator(
            Consumer<ListSecurityPoliciesRequest.Builder> listSecurityPoliciesRequest) {
        return listSecurityPoliciesPaginator(ListSecurityPoliciesRequest.builder().applyMutation(listSecurityPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.
     * </p>
     *
     * @param listServersRequest
     * @return A Java Future containing the result of the ListServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListServersResponse> listServers(ListServersRequest listServersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServersRequest.Builder} avoiding the need to
     * create one manually via {@link ListServersRequest#builder()}
     * </p>
     *
     * @param listServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListServersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListServersResponse> listServers(Consumer<ListServersRequest.Builder> listServersRequest) {
        return listServers(ListServersRequest.builder().applyMutation(listServersRequest).build());
    }

    /**
     * <p>
     * Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.
     * </p>
     *
     * @return A Java Future containing the result of the ListServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListServersResponse> listServers() {
        return listServers(ListServersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listServers(software.amazon.awssdk.services.transfer.model.ListServersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListServersPublisher publisher = client.listServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListServersPublisher publisher = client.listServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServers(software.amazon.awssdk.services.transfer.model.ListServersRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServersPublisher listServersPaginator() {
        return listServersPaginator(ListServersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listServers(software.amazon.awssdk.services.transfer.model.ListServersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListServersPublisher publisher = client.listServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListServersPublisher publisher = client.listServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServers(software.amazon.awssdk.services.transfer.model.ListServersRequest)} operation.</b>
     * </p>
     *
     * @param listServersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServersPublisher listServersPaginator(ListServersRequest listServersRequest) {
        return new ListServersPublisher(this, listServersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listServers(software.amazon.awssdk.services.transfer.model.ListServersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListServersPublisher publisher = client.listServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListServersPublisher publisher = client.listServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServers(software.amazon.awssdk.services.transfer.model.ListServersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServersRequest.Builder} avoiding the need to
     * create one manually via {@link ListServersRequest#builder()}
     * </p>
     *
     * @param listServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListServersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServersPublisher listServersPaginator(Consumer<ListServersRequest.Builder> listServersRequest) {
        return listServersPaginator(ListServersRequest.builder().applyMutation(listServersRequest).build());
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * user, server, or role.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * user, server, or role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Lists the users for a file transfer protocol-enabled server that you specify by passing the <code>ServerId</code>
     * parameter.
     * </p>
     *
     * @param listUsersRequest
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the users for a file transfer protocol-enabled server that you specify by passing the <code>ServerId</code>
     * parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListUsersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListUsersResponse> listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.transfer.model.ListUsersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.transfer.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @param listUsersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersPublisher listUsersPaginator(ListUsersRequest listUsersRequest) {
        return new ListUsersPublisher(this, listUsersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.transfer.model.ListUsersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.transfer.model.ListUsersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListUsersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersPublisher listUsersPaginator(Consumer<ListUsersRequest.Builder> listUsersRequest) {
        return listUsersPaginator(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Lists all workflows associated with your Amazon Web Services account for your current region.
     * </p>
     *
     * @param listWorkflowsRequest
     * @return A Java Future containing the result of the ListWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorkflowsResponse> listWorkflows(ListWorkflowsRequest listWorkflowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all workflows associated with your Amazon Web Services account for your current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListWorkflowsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorkflowsResponse> listWorkflows(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest) {
        return listWorkflows(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listWorkflows(software.amazon.awssdk.services.transfer.model.ListWorkflowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflows(software.amazon.awssdk.services.transfer.model.ListWorkflowsRequest)} operation.</b>
     * </p>
     *
     * @param listWorkflowsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkflowsPublisher listWorkflowsPaginator(ListWorkflowsRequest listWorkflowsRequest) {
        return new ListWorkflowsPublisher(this, listWorkflowsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listWorkflows(software.amazon.awssdk.services.transfer.model.ListWorkflowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.transfer.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.transfer.model.ListWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.transfer.model.ListWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflows(software.amazon.awssdk.services.transfer.model.ListWorkflowsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.ListWorkflowsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> parameter that was passed is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkflowsPublisher listWorkflowsPaginator(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest) {
        return listWorkflowsPaginator(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * Sends a callback for asynchronous custom steps.
     * </p>
     * <p>
     * The <code>ExecutionId</code>, <code>WorkflowId</code>, and <code>Token</code> are passed to the target resource
     * during execution of a custom step of a workflow. You must include those with their callback as well as providing
     * a status.
     * </p>
     *
     * @param sendWorkflowStepStateRequest
     * @return A Java Future containing the result of the SendWorkflowStepState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.SendWorkflowStepState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/SendWorkflowStepState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendWorkflowStepStateResponse> sendWorkflowStepState(
            SendWorkflowStepStateRequest sendWorkflowStepStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a callback for asynchronous custom steps.
     * </p>
     * <p>
     * The <code>ExecutionId</code>, <code>WorkflowId</code>, and <code>Token</code> are passed to the target resource
     * during execution of a custom step of a workflow. You must include those with their callback as well as providing
     * a status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendWorkflowStepStateRequest.Builder} avoiding the
     * need to create one manually via {@link SendWorkflowStepStateRequest#builder()}
     * </p>
     *
     * @param sendWorkflowStepStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.SendWorkflowStepStateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SendWorkflowStepState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.SendWorkflowStepState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/SendWorkflowStepState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendWorkflowStepStateResponse> sendWorkflowStepState(
            Consumer<SendWorkflowStepStateRequest.Builder> sendWorkflowStepStateRequest) {
        return sendWorkflowStepState(SendWorkflowStepStateRequest.builder().applyMutation(sendWorkflowStepStateRequest).build());
    }

    /**
     * <p>
     * Begins a file transfer between local Amazon Web Services storage and a remote AS2 or SFTP server.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For an AS2 connector, you specify the <code>ConnectorId</code> and one or more <code>SendFilePaths</code> to
     * identify the files you want to transfer.
     * </p>
     * </li>
     * <li>
     * <p>
     * For an SFTP connector, the file transfer can be either outbound or inbound. In both cases, you specify the
     * <code>ConnectorId</code>. Depending on the direction of the transfer, you also specify the following items:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are transferring file from a partner's SFTP server to Amazon Web Services storage, you specify one or more
     * <code>RetreiveFilePaths</code> to identify the files you want to transfer, and a <code>LocalDirectoryPath</code>
     * to specify the destination folder.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are transferring file to a partner's SFTP server from Amazon Web Services storage, you specify one or more
     * <code>SendFilePaths</code> to identify the files you want to transfer, and a <code>RemoteDirectoryPath</code> to
     * specify the destination folder.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     *
     * @param startFileTransferRequest
     * @return A Java Future containing the result of the StartFileTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.StartFileTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartFileTransfer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartFileTransferResponse> startFileTransfer(StartFileTransferRequest startFileTransferRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Begins a file transfer between local Amazon Web Services storage and a remote AS2 or SFTP server.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For an AS2 connector, you specify the <code>ConnectorId</code> and one or more <code>SendFilePaths</code> to
     * identify the files you want to transfer.
     * </p>
     * </li>
     * <li>
     * <p>
     * For an SFTP connector, the file transfer can be either outbound or inbound. In both cases, you specify the
     * <code>ConnectorId</code>. Depending on the direction of the transfer, you also specify the following items:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are transferring file from a partner's SFTP server to Amazon Web Services storage, you specify one or more
     * <code>RetreiveFilePaths</code> to identify the files you want to transfer, and a <code>LocalDirectoryPath</code>
     * to specify the destination folder.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are transferring file to a partner's SFTP server from Amazon Web Services storage, you specify one or more
     * <code>SendFilePaths</code> to identify the files you want to transfer, and a <code>RemoteDirectoryPath</code> to
     * specify the destination folder.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFileTransferRequest.Builder} avoiding the need
     * to create one manually via {@link StartFileTransferRequest#builder()}
     * </p>
     *
     * @param startFileTransferRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.StartFileTransferRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartFileTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.StartFileTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartFileTransfer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartFileTransferResponse> startFileTransfer(
            Consumer<StartFileTransferRequest.Builder> startFileTransferRequest) {
        return startFileTransfer(StartFileTransferRequest.builder().applyMutation(startFileTransferRequest).build());
    }

    /**
     * <p>
     * Changes the state of a file transfer protocol-enabled server from <code>OFFLINE</code> to <code>ONLINE</code>. It
     * has no impact on a server that is already <code>ONLINE</code>. An <code>ONLINE</code> server can accept and
     * process file transfer jobs.
     * </p>
     * <p>
     * The state of <code>STARTING</code> indicates that the server is in an intermediate state, either not fully able
     * to respond, or not fully online. The values of <code>START_FAILED</code> can indicate an error condition.
     * </p>
     * <p>
     * No response is returned from this call.
     * </p>
     *
     * @param startServerRequest
     * @return A Java Future containing the result of the StartServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.StartServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartServerResponse> startServer(StartServerRequest startServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the state of a file transfer protocol-enabled server from <code>OFFLINE</code> to <code>ONLINE</code>. It
     * has no impact on a server that is already <code>ONLINE</code>. An <code>ONLINE</code> server can accept and
     * process file transfer jobs.
     * </p>
     * <p>
     * The state of <code>STARTING</code> indicates that the server is in an intermediate state, either not fully able
     * to respond, or not fully online. The values of <code>START_FAILED</code> can indicate an error condition.
     * </p>
     * <p>
     * No response is returned from this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartServerRequest.Builder} avoiding the need to
     * create one manually via {@link StartServerRequest#builder()}
     * </p>
     *
     * @param startServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.StartServerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.StartServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartServerResponse> startServer(Consumer<StartServerRequest.Builder> startServerRequest) {
        return startServer(StartServerRequest.builder().applyMutation(startServerRequest).build());
    }

    /**
     * <p>
     * Changes the state of a file transfer protocol-enabled server from <code>ONLINE</code> to <code>OFFLINE</code>. An
     * <code>OFFLINE</code> server cannot accept and process file transfer jobs. Information tied to your server, such
     * as server and user properties, are not affected by stopping your server.
     * </p>
     * <note>
     * <p>
     * Stopping the server does not reduce or impact your file transfer protocol endpoint billing; you must delete the
     * server to stop being billed.
     * </p>
     * </note>
     * <p>
     * The state of <code>STOPPING</code> indicates that the server is in an intermediate state, either not fully able
     * to respond, or not fully offline. The values of <code>STOP_FAILED</code> can indicate an error condition.
     * </p>
     * <p>
     * No response is returned from this call.
     * </p>
     *
     * @param stopServerRequest
     * @return A Java Future containing the result of the StopServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.StopServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StopServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopServerResponse> stopServer(StopServerRequest stopServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the state of a file transfer protocol-enabled server from <code>ONLINE</code> to <code>OFFLINE</code>. An
     * <code>OFFLINE</code> server cannot accept and process file transfer jobs. Information tied to your server, such
     * as server and user properties, are not affected by stopping your server.
     * </p>
     * <note>
     * <p>
     * Stopping the server does not reduce or impact your file transfer protocol endpoint billing; you must delete the
     * server to stop being billed.
     * </p>
     * </note>
     * <p>
     * The state of <code>STOPPING</code> indicates that the server is in an intermediate state, either not fully able
     * to respond, or not fully offline. The values of <code>STOP_FAILED</code> can indicate an error condition.
     * </p>
     * <p>
     * No response is returned from this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopServerRequest.Builder} avoiding the need to
     * create one manually via {@link StopServerRequest#builder()}
     * </p>
     *
     * @param stopServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.StopServerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.StopServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StopServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopServerResponse> stopServer(Consumer<StopServerRequest.Builder> stopServerRequest) {
        return stopServer(StopServerRequest.builder().applyMutation(stopServerRequest).build());
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     * <p>
     * There is no response returned from this call.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     * <p>
     * There is no response returned from this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Tests whether your SFTP connector is set up successfully. We highly recommend that you call this operation to
     * test your ability to transfer files between local Amazon Web Services storage and a trading partner's SFTP
     * server.
     * </p>
     *
     * @param testConnectionRequest
     * @return A Java Future containing the result of the TestConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.TestConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TestConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestConnectionResponse> testConnection(TestConnectionRequest testConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests whether your SFTP connector is set up successfully. We highly recommend that you call this operation to
     * test your ability to transfer files between local Amazon Web Services storage and a trading partner's SFTP
     * server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestConnectionRequest.Builder} avoiding the need to
     * create one manually via {@link TestConnectionRequest#builder()}
     * </p>
     *
     * @param testConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.TestConnectionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TestConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.TestConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TestConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestConnectionResponse> testConnection(Consumer<TestConnectionRequest.Builder> testConnectionRequest) {
        return testConnection(TestConnectionRequest.builder().applyMutation(testConnectionRequest).build());
    }

    /**
     * <p>
     * If the <code>IdentityProviderType</code> of a file transfer protocol-enabled server is
     * <code>AWS_DIRECTORY_SERVICE</code> or <code>API_Gateway</code>, tests whether your identity provider is set up
     * successfully. We highly recommend that you call this operation to test your authentication method as soon as you
     * create your server. By doing so, you can troubleshoot issues with the identity provider integration to ensure
     * that your users can successfully use the service.
     * </p>
     * <p>
     * The <code>ServerId</code> and <code>UserName</code> parameters are required. The <code>ServerProtocol</code>,
     * <code>SourceIp</code>, and <code>UserPassword</code> are all optional.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You cannot use <code>TestIdentityProvider</code> if the <code>IdentityProviderType</code> of your server is
     * <code>SERVICE_MANAGED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TestIdentityProvider</code> does not work with keys: it only accepts passwords.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TestIdentityProvider</code> can test the password operation for a custom Identity Provider that handles
     * keys and passwords.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you provide any incorrect values for any parameters, the <code>Response</code> field is empty.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you provide a server ID for a server that uses service-managed users, you get an error:
     * </p>
     * <p>
     * <code> An error occurred (InvalidRequestException) when calling the TestIdentityProvider operation: s-<i>server-ID</i> not configured for external auth </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you enter a Server ID for the <code>--server-id</code> parameter that does not identify an actual Transfer
     * server, you receive the following error:
     * </p>
     * <p>
     * <code>An error occurred (ResourceNotFoundException) when calling the TestIdentityProvider operation: Unknown server</code>
     * .
     * </p>
     * <p>
     * It is possible your sever is in a different region. You can specify a region by adding the following:
     * <code>--region region-code</code>, such as <code>--region us-east-2</code> to specify a server in <b>US East
     * (Ohio)</b>.
     * </p>
     * </li>
     * </ul>
     *
     * @param testIdentityProviderRequest
     * @return A Java Future containing the result of the TestIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.TestIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TestIdentityProvider" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TestIdentityProviderResponse> testIdentityProvider(
            TestIdentityProviderRequest testIdentityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * If the <code>IdentityProviderType</code> of a file transfer protocol-enabled server is
     * <code>AWS_DIRECTORY_SERVICE</code> or <code>API_Gateway</code>, tests whether your identity provider is set up
     * successfully. We highly recommend that you call this operation to test your authentication method as soon as you
     * create your server. By doing so, you can troubleshoot issues with the identity provider integration to ensure
     * that your users can successfully use the service.
     * </p>
     * <p>
     * The <code>ServerId</code> and <code>UserName</code> parameters are required. The <code>ServerProtocol</code>,
     * <code>SourceIp</code>, and <code>UserPassword</code> are all optional.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You cannot use <code>TestIdentityProvider</code> if the <code>IdentityProviderType</code> of your server is
     * <code>SERVICE_MANAGED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TestIdentityProvider</code> does not work with keys: it only accepts passwords.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TestIdentityProvider</code> can test the password operation for a custom Identity Provider that handles
     * keys and passwords.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you provide any incorrect values for any parameters, the <code>Response</code> field is empty.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you provide a server ID for a server that uses service-managed users, you get an error:
     * </p>
     * <p>
     * <code> An error occurred (InvalidRequestException) when calling the TestIdentityProvider operation: s-<i>server-ID</i> not configured for external auth </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you enter a Server ID for the <code>--server-id</code> parameter that does not identify an actual Transfer
     * server, you receive the following error:
     * </p>
     * <p>
     * <code>An error occurred (ResourceNotFoundException) when calling the TestIdentityProvider operation: Unknown server</code>
     * .
     * </p>
     * <p>
     * It is possible your sever is in a different region. You can specify a region by adding the following:
     * <code>--region region-code</code>, such as <code>--region us-east-2</code> to specify a server in <b>US East
     * (Ohio)</b>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link TestIdentityProviderRequest#builder()}
     * </p>
     *
     * @param testIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.TestIdentityProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TestIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.TestIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TestIdentityProvider" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TestIdentityProviderResponse> testIdentityProvider(
            Consumer<TestIdentityProviderRequest.Builder> testIdentityProviderRequest) {
        return testIdentityProvider(TestIdentityProviderRequest.builder().applyMutation(testIdentityProviderRequest).build());
    }

    /**
     * <p>
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     * <p>
     * No response is returned from this call.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     * <p>
     * No response is returned from this call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Allows you to update parameters for the access specified in the <code>ServerID</code> and <code>ExternalID</code>
     * parameters.
     * </p>
     *
     * @param updateAccessRequest
     * @return A Java Future containing the result of the UpdateAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAccessResponse> updateAccess(UpdateAccessRequest updateAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to update parameters for the access specified in the <code>ServerID</code> and <code>ExternalID</code>
     * parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccessRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAccessRequest#builder()}
     * </p>
     *
     * @param updateAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.UpdateAccessRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAccessResponse> updateAccess(Consumer<UpdateAccessRequest.Builder> updateAccessRequest) {
        return updateAccess(UpdateAccessRequest.builder().applyMutation(updateAccessRequest).build());
    }

    /**
     * <p>
     * Updates some of the parameters for an existing agreement. Provide the <code>AgreementId</code> and the
     * <code>ServerId</code> for the agreement that you want to update, along with the new values for the parameters to
     * update.
     * </p>
     *
     * @param updateAgreementRequest
     * @return A Java Future containing the result of the UpdateAgreement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateAgreement" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAgreementResponse> updateAgreement(UpdateAgreementRequest updateAgreementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates some of the parameters for an existing agreement. Provide the <code>AgreementId</code> and the
     * <code>ServerId</code> for the agreement that you want to update, along with the new values for the parameters to
     * update.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAgreementRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAgreementRequest#builder()}
     * </p>
     *
     * @param updateAgreementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.UpdateAgreementRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateAgreement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateAgreement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateAgreement" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAgreementResponse> updateAgreement(
            Consumer<UpdateAgreementRequest.Builder> updateAgreementRequest) {
        return updateAgreement(UpdateAgreementRequest.builder().applyMutation(updateAgreementRequest).build());
    }

    /**
     * <p>
     * Updates the active and inactive dates for a certificate.
     * </p>
     *
     * @param updateCertificateRequest
     * @return A Java Future containing the result of the UpdateCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateCertificateResponse> updateCertificate(UpdateCertificateRequest updateCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the active and inactive dates for a certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateCertificateRequest#builder()}
     * </p>
     *
     * @param updateCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.UpdateCertificateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateCertificateResponse> updateCertificate(
            Consumer<UpdateCertificateRequest.Builder> updateCertificateRequest) {
        return updateCertificate(UpdateCertificateRequest.builder().applyMutation(updateCertificateRequest).build());
    }

    /**
     * <p>
     * Updates some of the parameters for an existing connector. Provide the <code>ConnectorId</code> for the connector
     * that you want to update, along with the new values for the parameters to update.
     * </p>
     *
     * @param updateConnectorRequest
     * @return A Java Future containing the result of the UpdateConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateConnectorResponse> updateConnector(UpdateConnectorRequest updateConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates some of the parameters for an existing connector. Provide the <code>ConnectorId</code> for the connector
     * that you want to update, along with the new values for the parameters to update.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateConnectorRequest#builder()}
     * </p>
     *
     * @param updateConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.UpdateConnectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateConnector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateConnectorResponse> updateConnector(
            Consumer<UpdateConnectorRequest.Builder> updateConnectorRequest) {
        return updateConnector(UpdateConnectorRequest.builder().applyMutation(updateConnectorRequest).build());
    }

    /**
     * <p>
     * Updates the description for the host key that's specified by the <code>ServerId</code> and <code>HostKeyId</code>
     * parameters.
     * </p>
     *
     * @param updateHostKeyRequest
     * @return A Java Future containing the result of the UpdateHostKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateHostKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateHostKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateHostKeyResponse> updateHostKey(UpdateHostKeyRequest updateHostKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the description for the host key that's specified by the <code>ServerId</code> and <code>HostKeyId</code>
     * parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateHostKeyRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateHostKeyRequest#builder()}
     * </p>
     *
     * @param updateHostKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.UpdateHostKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateHostKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateHostKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateHostKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateHostKeyResponse> updateHostKey(Consumer<UpdateHostKeyRequest.Builder> updateHostKeyRequest) {
        return updateHostKey(UpdateHostKeyRequest.builder().applyMutation(updateHostKeyRequest).build());
    }

    /**
     * <p>
     * Updates some of the parameters for an existing profile. Provide the <code>ProfileId</code> for the profile that
     * you want to update, along with the new values for the parameters to update.
     * </p>
     *
     * @param updateProfileRequest
     * @return A Java Future containing the result of the UpdateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProfileResponse> updateProfile(UpdateProfileRequest updateProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates some of the parameters for an existing profile. Provide the <code>ProfileId</code> for the profile that
     * you want to update, along with the new values for the parameters to update.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProfileRequest#builder()}
     * </p>
     *
     * @param updateProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.UpdateProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateProfileResponse> updateProfile(Consumer<UpdateProfileRequest.Builder> updateProfileRequest) {
        return updateProfile(UpdateProfileRequest.builder().applyMutation(updateProfileRequest).build());
    }

    /**
     * <p>
     * Updates the file transfer protocol-enabled server's properties after that server has been created.
     * </p>
     * <p>
     * The <code>UpdateServer</code> call returns the <code>ServerId</code> of the server you updated.
     * </p>
     *
     * @param updateServerRequest
     * @return A Java Future containing the result of the UpdateServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException This exception is thrown when the <code>UpdateServer</code> is called for a file
     *         transfer protocol-enabled server that has VPC as the endpoint type and the server's
     *         <code>VpcEndpointID</code> is not in the available state.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateServerResponse> updateServer(UpdateServerRequest updateServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the file transfer protocol-enabled server's properties after that server has been created.
     * </p>
     * <p>
     * The <code>UpdateServer</code> call returns the <code>ServerId</code> of the server you updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateServerRequest#builder()}
     * </p>
     *
     * @param updateServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.UpdateServerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException This exception is thrown when the <code>UpdateServer</code> is called for a file
     *         transfer protocol-enabled server that has VPC as the endpoint type and the server's
     *         <code>VpcEndpointID</code> is not in the available state.</li>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>ResourceExistsException The requested resource does not exist, or exists in a region other than the
     *         one specified for the command.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateServerResponse> updateServer(Consumer<UpdateServerRequest.Builder> updateServerRequest) {
        return updateServer(UpdateServerRequest.builder().applyMutation(updateServerRequest).build());
    }

    /**
     * <p>
     * Assigns new properties to a user. Parameters you pass modify any or all of the following: the home directory,
     * role, and policy for the <code>UserName</code> and <code>ServerId</code> you specify.
     * </p>
     * <p>
     * The response returns the <code>ServerId</code> and the <code>UserName</code> for the updated user.
     * </p>
     * <p>
     * In the console, you can select <i>Restricted</i> when you create or update a user. This ensures that the user
     * can't access anything outside of their home directory. The programmatic way to configure this behavior is to
     * update the user. Set their <code>HomeDirectoryType</code> to <code>LOGICAL</code>, and specify
     * <code>HomeDirectoryMappings</code> with <code>Entry</code> as root (<code>/</code>) and <code>Target</code> as
     * their home directory.
     * </p>
     * <p>
     * For example, if the user's home directory is <code>/test/admin-user</code>, the following command updates the
     * user so that their configuration in the console shows the <i>Restricted</i> flag as selected.
     * </p>
     * <p>
     * <code> aws transfer update-user --server-id &lt;server-id&gt; --user-name admin-user --home-directory-type LOGICAL --home-directory-mappings "[{\"Entry\":\"/\", \"Target\":\"/test/admin-user\"}]"</code>
     * </p>
     *
     * @param updateUserRequest
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns new properties to a user. Parameters you pass modify any or all of the following: the home directory,
     * role, and policy for the <code>UserName</code> and <code>ServerId</code> you specify.
     * </p>
     * <p>
     * The response returns the <code>ServerId</code> and the <code>UserName</code> for the updated user.
     * </p>
     * <p>
     * In the console, you can select <i>Restricted</i> when you create or update a user. This ensures that the user
     * can't access anything outside of their home directory. The programmatic way to configure this behavior is to
     * update the user. Set their <code>HomeDirectoryType</code> to <code>LOGICAL</code>, and specify
     * <code>HomeDirectoryMappings</code> with <code>Entry</code> as root (<code>/</code>) and <code>Target</code> as
     * their home directory.
     * </p>
     * <p>
     * For example, if the user's home directory is <code>/test/admin-user</code>, the following command updates the
     * user so that their configuration in the console shows the <i>Restricted</i> flag as selected.
     * </p>
     * <p>
     * <code> aws transfer update-user --server-id &lt;server-id&gt; --user-name admin-user --home-directory-type LOGICAL --home-directory-mappings "[{\"Entry\":\"/\", \"Target\":\"/test/admin-user\"}]"</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateUserRequest#builder()}
     * </p>
     *
     * @param updateUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.transfer.model.UpdateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException This exception is thrown when a resource is not found by the Amazon Web
     *         ServicesTransfer Family service.</li>
     *         <li>InvalidRequestException This exception is thrown when the client submits a malformed request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>InternalServiceErrorException This exception is thrown when an error occurs in the Transfer Family
     *         service.</li>
     *         <li>ServiceUnavailableException The request has failed because the Amazon Web ServicesTransfer Family
     *         service is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TransferException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TransferAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateUserResponse> updateUser(Consumer<UpdateUserRequest.Builder> updateUserRequest) {
        return updateUser(UpdateUserRequest.builder().applyMutation(updateUserRequest).build());
    }

    /**
     * Create an instance of {@link TransferAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link TransferAsyncWaiter}
     */
    default TransferAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default TransferServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link TransferAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TransferAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TransferAsyncClient}.
     */
    static TransferAsyncClientBuilder builder() {
        return new DefaultTransferAsyncClientBuilder();
    }
}
