/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * The mode of authentication for a server. The default value is <code>SERVICE_MANAGED</code>, which allows you to store
 * and access user credentials within the Transfer Family service.
 * </p>
 * <p>
 * Use <code>AWS_DIRECTORY_SERVICE</code> to provide access to Active Directory groups in Directory Service for
 * Microsoft Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services
 * using AD Connector. This option also requires you to provide a Directory ID by using the
 * <code>IdentityProviderDetails</code> parameter.
 * </p>
 * <p>
 * Use the <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The
 * <code>API_GATEWAY</code> setting requires you to provide an Amazon API Gateway endpoint URL to call for
 * authentication by using the <code>IdentityProviderDetails</code> parameter.
 * </p>
 * <p>
 * Use the <code>AWS_LAMBDA</code> value to directly use an Lambda function as your identity provider. If you choose
 * this value, you must specify the ARN for the Lambda function in the <code>Function</code> parameter for the
 * <code>IdentityProviderDetails</code> data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum IdentityProviderType {
    SERVICE_MANAGED("SERVICE_MANAGED"),

    API_GATEWAY("API_GATEWAY"),

    AWS_DIRECTORY_SERVICE("AWS_DIRECTORY_SERVICE"),

    AWS_LAMBDA("AWS_LAMBDA"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IdentityProviderType> VALUE_MAP = EnumUtils.uniqueIndex(IdentityProviderType.class,
            IdentityProviderType::toString);

    private final String value;

    private IdentityProviderType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return IdentityProviderType corresponding to the value
     */
    public static IdentityProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link IdentityProviderType}s
     */
    public static Set<IdentityProviderType> knownValues() {
        Set<IdentityProviderType> knownValues = EnumSet.allOf(IdentityProviderType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
