/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the details for files transferred using an SFTP connector, during a single transfer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorFileTransferResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorFileTransferResult.Builder, ConnectorFileTransferResult> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilePath").getter(getter(ConnectorFileTransferResult::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePath").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusCode").getter(getter(ConnectorFileTransferResult::statusCodeAsString))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureCode").getter(getter(ConnectorFileTransferResult::failureCode))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage").getter(getter(ConnectorFileTransferResult::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD,
            STATUS_CODE_FIELD, FAILURE_CODE_FIELD, FAILURE_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filePath;

    private final String statusCode;

    private final String failureCode;

    private final String failureMessage;

    private ConnectorFileTransferResult(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.statusCode = builder.statusCode;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
    }

    /**
     * <p>
     * The filename and path to where the file was sent to or retrieved from.
     * </p>
     * 
     * @return The filename and path to where the file was sent to or retrieved from.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * The current status for the transfer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link TransferTableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The current status for the transfer.
     * @see TransferTableStatus
     */
    public final TransferTableStatus statusCode() {
        return TransferTableStatus.fromValue(statusCode);
    }

    /**
     * <p>
     * The current status for the transfer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link TransferTableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The current status for the transfer.
     * @see TransferTableStatus
     */
    public final String statusCodeAsString() {
        return statusCode;
    }

    /**
     * <p>
     * For transfers that fail, this parameter contains a code indicating the reason. For example,
     * <code>RETRIEVE_FILE_NOT_FOUND</code>
     * </p>
     * 
     * @return For transfers that fail, this parameter contains a code indicating the reason. For example,
     *         <code>RETRIEVE_FILE_NOT_FOUND</code>
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * For transfers that fail, this parameter describes the reason for the failure.
     * </p>
     * 
     * @return For transfers that fail, this parameter describes the reason for the failure.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorFileTransferResult)) {
            return false;
        }
        ConnectorFileTransferResult other = (ConnectorFileTransferResult) obj;
        return Objects.equals(filePath(), other.filePath()) && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(failureCode(), other.failureCode()) && Objects.equals(failureMessage(), other.failureMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorFileTransferResult").add("FilePath", filePath())
                .add("StatusCode", statusCodeAsString()).add("FailureCode", failureCode())
                .add("FailureMessage", failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "FailureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorFileTransferResult, T> g) {
        return obj -> g.apply((ConnectorFileTransferResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorFileTransferResult> {
        /**
         * <p>
         * The filename and path to where the file was sent to or retrieved from.
         * </p>
         * 
         * @param filePath
         *        The filename and path to where the file was sent to or retrieved from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * The current status for the transfer.
         * </p>
         * 
         * @param statusCode
         *        The current status for the transfer.
         * @see TransferTableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransferTableStatus
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * The current status for the transfer.
         * </p>
         * 
         * @param statusCode
         *        The current status for the transfer.
         * @see TransferTableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransferTableStatus
         */
        Builder statusCode(TransferTableStatus statusCode);

        /**
         * <p>
         * For transfers that fail, this parameter contains a code indicating the reason. For example,
         * <code>RETRIEVE_FILE_NOT_FOUND</code>
         * </p>
         * 
         * @param failureCode
         *        For transfers that fail, this parameter contains a code indicating the reason. For example,
         *        <code>RETRIEVE_FILE_NOT_FOUND</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * For transfers that fail, this parameter describes the reason for the failure.
         * </p>
         * 
         * @param failureMessage
         *        For transfers that fail, this parameter describes the reason for the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);
    }

    static final class BuilderImpl implements Builder {
        private String filePath;

        private String statusCode;

        private String failureCode;

        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorFileTransferResult model) {
            filePath(model.filePath);
            statusCode(model.statusCode);
            failureCode(model.failureCode);
            failureMessage(model.failureMessage);
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(TransferTableStatus statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        @Override
        public ConnectorFileTransferResult build() {
            return new ConnectorFileTransferResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
