/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the <code>WorkflowDetail</code> data type. It is used by actions that trigger a workflow to begin
 * execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowDetails implements SdkPojo, Serializable, ToCopyableBuilder<WorkflowDetails.Builder, WorkflowDetails> {
    private static final SdkField<List<WorkflowDetail>> ON_UPLOAD_FIELD = SdkField
            .<List<WorkflowDetail>> builder(MarshallingType.LIST)
            .memberName("OnUpload")
            .getter(getter(WorkflowDetails::onUpload))
            .setter(setter(Builder::onUpload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnUpload").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<WorkflowDetail>> ON_PARTIAL_UPLOAD_FIELD = SdkField
            .<List<WorkflowDetail>> builder(MarshallingType.LIST)
            .memberName("OnPartialUpload")
            .getter(getter(WorkflowDetails::onPartialUpload))
            .setter(setter(Builder::onPartialUpload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnPartialUpload").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ON_UPLOAD_FIELD,
            ON_PARTIAL_UPLOAD_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<WorkflowDetail> onUpload;

    private final List<WorkflowDetail> onPartialUpload;

    private WorkflowDetails(BuilderImpl builder) {
        this.onUpload = builder.onUpload;
        this.onPartialUpload = builder.onPartialUpload;
    }

    /**
     * For responses, this returns true if the service returned a value for the OnUpload property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOnUpload() {
        return onUpload != null && !(onUpload instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.
     * </p>
     * <p>
     * To remove an associated workflow from a server, you can provide an empty <code>OnUpload</code> object, as in the
     * following example.
     * </p>
     * <p>
     * <code>aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'</code>
     * </p>
     * <note>
     * <p>
     * <code>OnUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOnUpload} method.
     * </p>
     * 
     * @return A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.</p>
     *         <p>
     *         To remove an associated workflow from a server, you can provide an empty <code>OnUpload</code> object, as
     *         in the following example.
     *         </p>
     *         <p>
     *         <code>aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'</code>
     *         </p>
     *         <note>
     *         <p>
     *         <code>OnUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
     *         </p>
     */
    public final List<WorkflowDetail> onUpload() {
        return onUpload;
    }

    /**
     * For responses, this returns true if the service returned a value for the OnPartialUpload property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOnPartialUpload() {
        return onPartialUpload != null && !(onPartialUpload instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A trigger that starts a workflow if a file is only partially uploaded. You can attach a workflow to a server that
     * executes whenever there is a partial upload.
     * </p>
     * <p>
     * A <i>partial upload</i> occurs when a file is open when the session disconnects.
     * </p>
     * <note>
     * <p>
     * <code>OnPartialUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOnPartialUpload} method.
     * </p>
     * 
     * @return A trigger that starts a workflow if a file is only partially uploaded. You can attach a workflow to a
     *         server that executes whenever there is a partial upload.</p>
     *         <p>
     *         A <i>partial upload</i> occurs when a file is open when the session disconnects.
     *         </p>
     *         <note>
     *         <p>
     *         <code>OnPartialUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
     *         </p>
     */
    public final List<WorkflowDetail> onPartialUpload() {
        return onPartialUpload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOnUpload() ? onUpload() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOnPartialUpload() ? onPartialUpload() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowDetails)) {
            return false;
        }
        WorkflowDetails other = (WorkflowDetails) obj;
        return hasOnUpload() == other.hasOnUpload() && Objects.equals(onUpload(), other.onUpload())
                && hasOnPartialUpload() == other.hasOnPartialUpload()
                && Objects.equals(onPartialUpload(), other.onPartialUpload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowDetails").add("OnUpload", hasOnUpload() ? onUpload() : null)
                .add("OnPartialUpload", hasOnPartialUpload() ? onPartialUpload() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OnUpload":
            return Optional.ofNullable(clazz.cast(onUpload()));
        case "OnPartialUpload":
            return Optional.ofNullable(clazz.cast(onPartialUpload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowDetails, T> g) {
        return obj -> g.apply((WorkflowDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowDetails> {
        /**
         * <p>
         * A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.
         * </p>
         * <p>
         * To remove an associated workflow from a server, you can provide an empty <code>OnUpload</code> object, as in
         * the following example.
         * </p>
         * <p>
         * <code>aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'</code>
         * </p>
         * <note>
         * <p>
         * <code>OnUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
         * </p>
         * </note>
         * 
         * @param onUpload
         *        A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.</p>
         *        <p>
         *        To remove an associated workflow from a server, you can provide an empty <code>OnUpload</code> object,
         *        as in the following example.
         *        </p>
         *        <p>
         *        <code>aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'</code>
         *        </p>
         *        <note>
         *        <p>
         *        <code>OnUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onUpload(Collection<WorkflowDetail> onUpload);

        /**
         * <p>
         * A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.
         * </p>
         * <p>
         * To remove an associated workflow from a server, you can provide an empty <code>OnUpload</code> object, as in
         * the following example.
         * </p>
         * <p>
         * <code>aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'</code>
         * </p>
         * <note>
         * <p>
         * <code>OnUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
         * </p>
         * </note>
         * 
         * @param onUpload
         *        A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.</p>
         *        <p>
         *        To remove an associated workflow from a server, you can provide an empty <code>OnUpload</code> object,
         *        as in the following example.
         *        </p>
         *        <p>
         *        <code>aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'</code>
         *        </p>
         *        <note>
         *        <p>
         *        <code>OnUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onUpload(WorkflowDetail... onUpload);

        /**
         * <p>
         * A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.
         * </p>
         * <p>
         * To remove an associated workflow from a server, you can provide an empty <code>OnUpload</code> object, as in
         * the following example.
         * </p>
         * <p>
         * <code>aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'</code>
         * </p>
         * <note>
         * <p>
         * <code>OnUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.WorkflowDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.transfer.model.WorkflowDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.WorkflowDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #onUpload(List<WorkflowDetail>)}.
         * 
         * @param onUpload
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.WorkflowDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onUpload(java.util.Collection<WorkflowDetail>)
         */
        Builder onUpload(Consumer<WorkflowDetail.Builder>... onUpload);

        /**
         * <p>
         * A trigger that starts a workflow if a file is only partially uploaded. You can attach a workflow to a server
         * that executes whenever there is a partial upload.
         * </p>
         * <p>
         * A <i>partial upload</i> occurs when a file is open when the session disconnects.
         * </p>
         * <note>
         * <p>
         * <code>OnPartialUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
         * </p>
         * </note>
         * 
         * @param onPartialUpload
         *        A trigger that starts a workflow if a file is only partially uploaded. You can attach a workflow to a
         *        server that executes whenever there is a partial upload.</p>
         *        <p>
         *        A <i>partial upload</i> occurs when a file is open when the session disconnects.
         *        </p>
         *        <note>
         *        <p>
         *        <code>OnPartialUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPartialUpload(Collection<WorkflowDetail> onPartialUpload);

        /**
         * <p>
         * A trigger that starts a workflow if a file is only partially uploaded. You can attach a workflow to a server
         * that executes whenever there is a partial upload.
         * </p>
         * <p>
         * A <i>partial upload</i> occurs when a file is open when the session disconnects.
         * </p>
         * <note>
         * <p>
         * <code>OnPartialUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
         * </p>
         * </note>
         * 
         * @param onPartialUpload
         *        A trigger that starts a workflow if a file is only partially uploaded. You can attach a workflow to a
         *        server that executes whenever there is a partial upload.</p>
         *        <p>
         *        A <i>partial upload</i> occurs when a file is open when the session disconnects.
         *        </p>
         *        <note>
         *        <p>
         *        <code>OnPartialUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPartialUpload(WorkflowDetail... onPartialUpload);

        /**
         * <p>
         * A trigger that starts a workflow if a file is only partially uploaded. You can attach a workflow to a server
         * that executes whenever there is a partial upload.
         * </p>
         * <p>
         * A <i>partial upload</i> occurs when a file is open when the session disconnects.
         * </p>
         * <note>
         * <p>
         * <code>OnPartialUpload</code> can contain a maximum of one <code>WorkflowDetail</code> object.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.WorkflowDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.transfer.model.WorkflowDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.WorkflowDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #onPartialUpload(List<WorkflowDetail>)}.
         * 
         * @param onPartialUpload
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.WorkflowDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPartialUpload(java.util.Collection<WorkflowDetail>)
         */
        Builder onPartialUpload(Consumer<WorkflowDetail.Builder>... onPartialUpload);
    }

    static final class BuilderImpl implements Builder {
        private List<WorkflowDetail> onUpload = DefaultSdkAutoConstructList.getInstance();

        private List<WorkflowDetail> onPartialUpload = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowDetails model) {
            onUpload(model.onUpload);
            onPartialUpload(model.onPartialUpload);
        }

        public final List<WorkflowDetail.Builder> getOnUpload() {
            List<WorkflowDetail.Builder> result = OnUploadWorkflowDetailsCopier.copyToBuilder(this.onUpload);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOnUpload(Collection<WorkflowDetail.BuilderImpl> onUpload) {
            this.onUpload = OnUploadWorkflowDetailsCopier.copyFromBuilder(onUpload);
        }

        @Override
        public final Builder onUpload(Collection<WorkflowDetail> onUpload) {
            this.onUpload = OnUploadWorkflowDetailsCopier.copy(onUpload);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onUpload(WorkflowDetail... onUpload) {
            onUpload(Arrays.asList(onUpload));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onUpload(Consumer<WorkflowDetail.Builder>... onUpload) {
            onUpload(Stream.of(onUpload).map(c -> WorkflowDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<WorkflowDetail.Builder> getOnPartialUpload() {
            List<WorkflowDetail.Builder> result = OnPartialUploadWorkflowDetailsCopier.copyToBuilder(this.onPartialUpload);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOnPartialUpload(Collection<WorkflowDetail.BuilderImpl> onPartialUpload) {
            this.onPartialUpload = OnPartialUploadWorkflowDetailsCopier.copyFromBuilder(onPartialUpload);
        }

        @Override
        public final Builder onPartialUpload(Collection<WorkflowDetail> onPartialUpload) {
            this.onPartialUpload = OnPartialUploadWorkflowDetailsCopier.copy(onPartialUpload);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPartialUpload(WorkflowDetail... onPartialUpload) {
            onPartialUpload(Arrays.asList(onPartialUpload));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPartialUpload(Consumer<WorkflowDetail.Builder>... onPartialUpload) {
            onPartialUpload(Stream.of(onPartialUpload).map(c -> WorkflowDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public WorkflowDetails build() {
            return new WorkflowDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
